/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.user.model.UMSearchModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class UMSearchModelImpl
extends AMProfileModelBase
implements UMSearchModel {
    protected String serviceName = null;
    protected String searchLocationDN = this.getLocationDN();
    protected ResourceBundle schemaResBundle = null;
    protected List componentList = new ArrayList();
    protected String errorMessage = null;
    protected int errorCode = 0;
    public List requiredAttributes = null;
    public List attributeLabels = null;
    private ServiceSchemaManager entrySpecificMgr = null;

    public UMSearchModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.setSchemaResourceBundle("iPlanetAMEntrySpecificService");
    }

    protected ServiceSchemaManager getEntrySpecificSvcMgr() {
        if (this.entrySpecificMgr == null) {
            try {
                this.entrySpecificMgr = this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMSearchModelImpl.getEntrySpecificSvcMgr", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMSearchModelImpl.getEntrySpecificSvcMgr", (Throwable)sMSException);
            }
        }
        return this.entrySpecificMgr;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getPageTitle() {
        return this.getLocalizedString("search.title");
    }

    public String getSearchButtonLabel() {
        return this.getLocalizedString("search.button");
    }

    public String getSearchLocationDN() {
        return this.searchLocationDN;
    }

    public void setSearchLocationDN(String string) {
        this.searchLocationDN = string == null || string.length() == 0 ? this.locationDN : string;
    }

    public DynamicGUI getComponent(int n) {
        return (DynamicGUI)this.componentList.get(n);
    }

    protected void setServiceName(String string) {
        this.serviceName = string;
    }

    protected boolean isDisplayed(AttributeSchema attributeSchema) {
        if (attributeSchema == null || attributeSchema.getI18NKey() == null || attributeSchema.getI18NKey().length() == 0) {
            return false;
        }
        String string = attributeSchema.getAny();
        return string != null && string.indexOf("filter") != -1;
    }

    protected DynamicGUI createDynamicGUIComponent(AttributeSchema attributeSchema, Set set) {
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        return dynamicGUIGenerator.createDynamicGUI(attributeSchema, this.serviceName, set, this, null);
    }

    public String getSearchScopeLabel() {
        return this.getLocalizedString("searchScope.label");
    }

    public String getScopeLevelOneLabel() {
        return this.getLocalizedString("scopeOne.label");
    }

    public String getScopeLevelOneValue() {
        return "1";
    }

    public String getScopeSubTreeLabel() {
        return this.getLocalizedString("scopeSubTree.label");
    }

    public String getScopeSubTreeValue() {
        return "2";
    }

    public int getSize() {
        return -1;
    }

    public String getAttributeName(int n) {
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return "";
        }
        String string = "";
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        if (attributeSchema != null) {
            string = attributeSchema.getName();
        }
        return string;
    }

    public int getAttributeType(int n) {
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return -1;
        }
        int n2 = AMDisplayTypeConverter.DEFAULT_TYPE;
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        if (attributeSchema != null) {
            n2 = AMDisplayTypeConverter.getDisplayType(attributeSchema);
        }
        return n2;
    }

    public int getAttributeSyntax(int n) {
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return -1;
        }
        int n2 = AMDisplayTypeConverter.DEFAULT_SYNTAX;
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        if (attributeSchema != null) {
            n2 = AMDisplayTypeConverter.getDisplaySyntax(attributeSchema);
        }
        return n2;
    }

    public Set getAttributeValues(int n) {
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return Collections.EMPTY_SET;
        }
        Set set = Collections.EMPTY_SET;
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        if (attributeSchema != null && (set = attributeSchema.getDefaultValues()) == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public String[] getAttributeChoices(int n) {
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return null;
        }
        String[] stringArray = new String[]{""};
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        if (attributeSchema != null) {
            stringArray = attributeSchema.getChoiceValues();
        }
        return stringArray;
    }

    public String getAttributeTrueValue(int n) {
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return "";
        }
        String string = "true";
        return string;
    }

    public String getAttributeFalseValue(int n) {
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return "";
        }
        String string = "false";
        return string;
    }

    public boolean getAttributeRequired(int n) {
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return false;
        }
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        if (attributeSchema == null) {
            return false;
        }
        String string = attributeSchema.getAny();
        if (string == null) {
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("any string is null " + attributeSchema.getName());
            }
            return false;
        }
        return string.indexOf("required") != -1;
    }

    public String getAttributeLabel(int n) {
        if (n >= 0 && n < this.attributeLabels.size()) {
            return (String)this.attributeLabels.get(n);
        }
        return "";
    }

    public int getNumberOfAttributes() {
        return -1;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("search.help");
        if (string.equals("search.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getDynGUIAddToListBtnLabel() {
        return this.getLocalizedString("dynGUIAddToList.button");
    }

    public String getDynGUIRemoveFromListBtnLabel() {
        return this.getLocalizedString("dynGUIRemoveFromList.button");
    }

    public String[] getAttributeChoiceLabels(int n) {
        OptionList optionList = null;
        if (n < 0 || n >= this.requiredAttributes.size()) {
            AMModelBase.debug.warning("row value is out of range: " + n);
            return null;
        }
        String[] stringArray = new String[]{""};
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        if (attributeSchema != null) {
            stringArray = attributeSchema.getChoiceValues();
        }
        if (stringArray == null) {
            optionList = new OptionList(new String[0], new String[0]);
        }
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            String string;
            String string2 = stringArray[n3];
            stringArray2[n3] = string2 == null || string2.length() == 0 ? "" : ((string = attributeSchema.getChoiceValueI18NKey(string2)) != null && string.length() != 0 ? Locale.getString((ResourceBundle)this.schemaResBundle, (String)string, (Debug)AMModelBase.debug) : string2);
            ++n3;
        }
        return stringArray2;
    }

    protected void setSchemaResourceBundle(String string) {
        this.schemaResBundle = null;
        String string2 = null;
        try {
            string2 = this.dpStoreConn.getI18NPropertiesFileName(string);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("Could not get service properties file", (Throwable)aMException);
        }
        if (string2 != null && string2.length() != 0) {
            this.schemaResBundle = AMResBundleCacher.getBundle(string2, this.getUserLocale());
        }
        if (this.schemaResBundle == null) {
            AMModelBase.debug.warning("Falling back to console resource file");
            this.schemaResBundle = this.resBundle;
        }
    }

    public String getEnterSearchCriteriaMessage() {
        return this.getLocalizedString("enterSearchCriteria.message");
    }

    public String getGroupSearchCriteriaMessage() {
        return this.getLocalizedString("groupSearchCriteria.message");
    }
}

