/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.console.user.model.UMRoleServiceConfigModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMRoleServiceConfigModelImpl
extends AMModelBase
implements UMRoleServiceConfigModel {
    private String profileDN;
    private AMRole role;
    private Map serviceNameToLocalizedName = new HashMap();
    private Map serviceNameToDisplayOptions;

    public UMRoleServiceConfigModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public void setProfileDN(String string) {
        this.profileDN = string;
    }

    public String getEnabledLabel() {
        return this.getLocalizedString("enabledService.label");
    }

    public String getDisabledLabel() {
        return this.getLocalizedString("disabledService.label");
    }

    public String getServiceAccessHeader() {
        return this.getLocalizedString("serviceAccess.header");
    }

    public String getServiceAccessHelpMessage() {
        return this.getLocalizedString("serviceAccess.help");
    }

    public String getStatusLabel() {
        return this.getLocalizedString("status.label");
    }

    public String getLocalizedName(String string) {
        return (String)this.serviceNameToLocalizedName.get(string);
    }

    public List getServices() {
        List list = Collections.EMPTY_LIST;
        try {
            Set set;
            this.createRoleHandle();
            if (this.role != null && (set = this.getAvailableServices(this.role)) != null && !set.isEmpty()) {
                set.remove("iPlanetAMWebAgentService");
                list = this.sortByLocalizedName(set);
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("UMRoleServiceConfigModelImpl.getServices", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMRoleServiceConfigModelImpl.getServices", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMRoleServiceConfigModelImpl.getServices", (Throwable)sMSException);
        }
        return list;
    }

    public Map getServiceDisplayOptions() {
        if (this.serviceNameToDisplayOptions == null) {
            this.serviceNameToDisplayOptions = new HashMap();
            AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
            try {
                this.serviceNameToDisplayOptions = aMServiceDisplayModelImpl.getRoleOptions(this.role, this.getAvailableServices(this.role));
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMRoleServiceConfigModelImpl.getServiceDisplayOptions", (Throwable)aMException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("UMRoleServiceConfigModelImpl.getServiceDisplayOptions", (Throwable)sMSException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMRoleServiceConfigModelImpl.getServiceDisplayOptions", (Throwable)sSOException);
            }
        }
        return this.serviceNameToDisplayOptions;
    }

    public void setServiceDisplayOptions(Map map) {
        this.serviceNameToDisplayOptions = map;
    }

    public void modifyServiceVisibilityOptions(Map map) throws AMConsoleException {
        try {
            this.createRoleHandle();
            if (this.role != null) {
                AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
                aMServiceDisplayModelImpl.setRoleOptions(this.role, map);
                this.serviceNameToDisplayOptions = map;
                this.logger.doLog("roleServicesModified.message", this.role.getDN());
            }
        }
        catch (AMException aMException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        catch (SSOException sSOException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("roleServiceConfigurationUpdate.message");
    }

    public String getEditLabel() {
        return this.getLocalizedString("roleEditServiceAttributes.label");
    }

    private List sortByLocalizedName(Set set) {
        Object object;
        Object object2;
        int n = set.size();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(n * 2);
        HashSet<Object> hashSet = new HashSet<Object>(n * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = this.getLocalizedServiceName((String)object2);
            if (object == null || ((String)object).equals(object2)) continue;
            hashSet.add(object);
            hashMap.put(object, object2);
            this.serviceNameToLocalizedName.put(object2, object);
        }
        object2 = new ArrayList(hashSet.size());
        object = AMFormatUtils.sortItemsInSet(hashSet, this.getUserLocale());
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object2.add(hashMap.get(iterator2.next()));
        }
        return object2;
    }

    private void createRoleHandle() {
        if (this.role == null) {
            try {
                AMStoreConnection aMStoreConnection = this.getAdminStoreConnection();
                if (aMStoreConnection != null) {
                    this.role = aMStoreConnection.getRole(this.profileDN);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMRoleServiceConfigModelImpl.createRoleHandle", (Throwable)sSOException);
            }
        }
    }

    private AMStoreConnection getAdminStoreConnection() {
        return (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (SecurityException securityException) {
                    AMModelBase.debug.error("UMRoleServiceConfigModelImpl.createRoleHandle", (Throwable)securityException);
                    return null;
                }
            }
        });
    }
}

