/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.console.user.model.UMRoleNavModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMRoleNavModelImpl
extends UMNavModelImpl
implements UMRoleNavModel {
    private final String CONTAINER_DEFAULT_TEMPLATE_ROLE = "cn=ContainerDefaultTemplateRole,";
    private Set roles = null;
    private AMRole role = null;

    public UMRoleNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectedOption() {
        return "roles";
    }

    public Set getRoles(String string) {
        if (this.roles == null) {
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            aMSearchControl.setSearchScope(1);
            try {
                switch (this.locationType) {
                    case 2: {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.setSearchControlAttributes(this.locationDN, "FilteredRole", 6, aMSearchControl, "roles");
                        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        aMSearchResults = aMOrganization.searchAllRoles(string, aMSearchControl);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.setSearchControlAttributes(this.locationDN, "FilteredRole", 6, aMSearchControl, "roles");
                        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        aMSearchResults = aMOrganizationalUnit.searchAllRoles(string, aMSearchControl);
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMRoleNavModelImpl.getRoles invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMRoleNavModelImpl.getRoles", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMRoleNavModelImpl.getRoles", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            if (aMSearchResults != null) {
                this.roles = this.getSearchResultsSet(aMSearchResults);
                this.resultsMap = aMSearchResults.getResultAttributes();
            }
        }
        if (this.roles == null) {
            this.roles = Collections.EMPTY_SET;
        } else {
            this.roles.remove("cn=ContainerDefaultTemplateRole," + this.getLocationDN());
        }
        return this.roles;
    }

    public boolean deleteRoles(Set set) {
        boolean bl = false;
        if (set != null && (this.locationType == 2 || this.locationType == 3)) {
            try {
                Map map = this.deleteUMObject(6, set, "roleDeleted.message");
                if (!map.isEmpty()) {
                    Iterator iterator = map.keySet().iterator();
                    this.setErrorMessage(this.getLocalizedString("deleteRoleFailed.message"));
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = AMFormatUtils.DNToName(this, string, true);
                        String string3 = (String)map.get(string);
                        this.setErrorMessage(string2 + " - " + string3);
                    }
                } else {
                    bl = true;
                }
            }
            catch (AMConsoleException aMConsoleException) {
                this.setErrorMessage(this.getErrorString(aMConsoleException));
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("roles.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noRoleSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noRoleSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.roles;
    }

    public void setAttrList(Set set) {
        this.roles = set;
    }

    public String getRolesDisplayOffMessage() {
        return this.getLocalizedString("rolesDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMRoleNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }

    public List getSearchReturnAttributes() {
        return this.getSearchReturnAttributes(null, 6, "roles");
    }

    private Set getRoleAttributeNames() {
        Set set = Collections.EMPTY_SET;
        try {
            String string = AdminInterfaceUtils.getNamingAttribute((int)5, (Debug)AMModelBase.debug);
            String string2 = string + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + this.locationDN;
            String string3 = AdminInterfaceUtils.getNamingAttribute((int)6, (Debug)AMModelBase.debug) + "=" + string2.replace(',', '_') + "," + this.locationDN;
            AMRole aMRole = this.dpStoreConn.getRole(string3);
            Map map = aMRole.getAttributes();
            if (map != null && !map.isEmpty()) {
                set = map.keySet();
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMRoleNavModelImpl.getRoleAttributeNames", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("UMRoleNavModelImpl.getRoleAttributeNames", (Throwable)aMException);
        }
        return set;
    }

    protected List getValidatedAttributes(String string, String string2, int n, String string3) {
        List list;
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        if (string != null && string.length() > 0 && (list = this.getObjectDisplayList(string, string3)) != null && !list.isEmpty()) {
            arrayList = new ArrayList(list.size());
            Set set = this.getRoleAttributeNames();
            Set set2 = this.getFilteredRoleAttributeNames();
            int n2 = 0;
            if (set != null && !set.isEmpty()) {
                n2 = set.size();
            }
            if (set2 != null && !set2.isEmpty()) {
                n2 += set2.size();
            }
            if (n2 > 0) {
                HashSet hashSet = new HashSet(n2);
                hashSet.addAll(set);
                hashSet.addAll(set2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (!hashSet.contains(string4) || arrayList.contains(string4)) continue;
                    arrayList.add(string4);
                }
            }
        }
        if (arrayList == null || arrayList.isEmpty()) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)n, (Debug)AMModelBase.debug));
        }
        return arrayList;
    }

    public String getAttributeValue(String string, String string2) {
        String string3 = AdminInterfaceUtils.getNamingAttribute((int)6, (Debug)AMModelBase.debug);
        String string4 = "";
        if (!string2.equals(string3) && this.resultsMap != null && !this.resultsMap.isEmpty()) {
            Map map = (Map)this.resultsMap.get(string);
            if (map != null && !map.isEmpty()) {
                Set set = (Set)map.get(string2);
                if (set == null || set.isEmpty()) {
                    if (this.getLocationType(string) == 8 && this.getFilteredRoleAttributeNames().contains(string2)) {
                        set = this.getFilteredRoleAttributeValues(string);
                        string4 = this.getMultiValue(set);
                    }
                } else {
                    string4 = this.getMultiValue(set);
                }
            }
        } else if (string2.equals(string3)) {
            string4 = string;
        }
        return string4;
    }

    public String getAttributeLocalizedName(String string) {
        return this.getAttributeLocalizedName(string, "FilteredRole");
    }

    public String getAttributeName() {
        return this.getAttributeName("FilteredRole", 6, "roles");
    }

    private Set getFilteredRoleAttributeNames() {
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "FilteredRole");
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            hashSet = new HashSet<String>(set.size());
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string = attributeSchema.getName();
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private AMFilteredRole getFilteredRoleObject(String string) {
        AMFilteredRole aMFilteredRole = null;
        try {
            aMFilteredRole = this.dpStoreConn.getFilteredRole(string);
            if (aMFilteredRole == null || !aMFilteredRole.isExists()) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("UMRoleNavModelImpl.getFilteredRoleObject role does not exists " + string);
                }
                aMFilteredRole = null;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMRoleNavModelImpl.getFilteredRoleObject", (Throwable)sSOException);
        }
        return aMFilteredRole;
    }

    private Set getFilteredRoleAttributeValues(String string) {
        Set set;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMFilteredRole aMFilteredRole = this.getFilteredRoleObject(string);
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (serviceSchemaManager != null && aMFilteredRole != null && (set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "FilteredRole")) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string2 = attributeSchema.getName();
                try {
                    if (string2.equals("filterinfo")) {
                        hashSet = new HashSet<String>(1);
                        hashSet.add(aMFilteredRole.getFilter());
                        continue;
                    }
                    hashSet = aMFilteredRole.getAttribute(string2);
                }
                catch (AMException aMException) {
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning("Could not get value for " + string2, (Throwable)aMException);
                }
                catch (SSOException sSOException) {
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning("Could not get value for " + string2, (Throwable)sSOException);
                }
            }
        }
        return hashSet;
    }

    public String getAttributeValue(String string) {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return AMFormatUtils.DNToName(this, string, true);
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeValue(string, (String)this.searchReturnAttrs.get(n - 1));
    }
}

