/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttributeDisplayImpl;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.console.user.model.UMRoleDisplayProfileModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMRoleDisplayProfileModelImpl
extends AMProfileModelBase
implements UMRoleDisplayProfileModel {
    private String roleDN = null;
    private int roleType = 3;
    private Map mapAttrNameToI18nName = new HashMap();
    private Map roleDisplayOptions = null;
    private String errorMsg = null;

    public UMRoleDisplayProfileModelImpl(HttpServletRequest httpServletRequest, Map map, String string) {
        super(httpServletRequest, map);
        this.roleDN = string;
    }

    public void initRoleDisplayOptions() {
        if (this.roleDN != null) {
            try {
                AMRole aMRole = this.dpStoreConn.getRole(this.roleDN);
                this.roleType = aMRole.getRoleType();
                AMAttributeDisplayImpl aMAttributeDisplayImpl = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
                this.roleDisplayOptions = aMAttributeDisplayImpl.getRoleOptions(this, aMRole, this.getServiceNames());
                if (AMModelBase.debug.messageEnabled()) {
                    AMModelBase.debug.message("initRoleDisplayOptions:roleDisplayOptions " + this.roleDisplayOptions);
                }
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("Couldn't get role display options", (Throwable)aMException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("Couldn't get role display options", (Throwable)sMSException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("Couldn't get role display options", (Throwable)sSOException);
            }
        }
        if (this.roleDisplayOptions == null) {
            this.roleDisplayOptions = new HashMap(1);
        }
    }

    public boolean storeDisplayOptions(Map map) {
        boolean bl = true;
        if (this.roleDN != null) {
            try {
                AMRole aMRole = this.dpStoreConn.getRole(this.roleDN);
                AMAttributeDisplayImpl aMAttributeDisplayImpl = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
                aMAttributeDisplayImpl.setRoleOptions(aMRole, map);
                this.roleDisplayOptions.clear();
                this.roleDisplayOptions.putAll(map);
                this.logger.doLog("roleServiceAttrModified.message", aMRole.getDN());
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("Couldn't store role display options", (Throwable)aMException);
                this.errorMsg = this.getErrorString((Exception)((Object)aMException));
                bl = false;
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("Couldn't store role display options", (Throwable)sSOException);
                this.errorMsg = this.getErrorString((Exception)((Object)sSOException));
                bl = false;
            }
        }
        return bl;
    }

    public String getCloseButtonLabel() {
        return this.getLocalizedString("close.button");
    }

    public String getJumpToLabel() {
        return this.getLocalizedString("roleDisplayProfileJumpTo.label");
    }

    public String getAttributeLabel() {
        return this.getLocalizedString("roleDisplayProfileAttribute.label");
    }

    public String getDisplayAttrLabel() {
        return this.getLocalizedString("roleDisplayProfileDisplay.label");
    }

    public String getReadOnlyAttrLabel() {
        return this.getLocalizedString("readOnly.label");
    }

    public Set getServiceNames() {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        try {
            if (this.roleDN != null && this.roleDN.length() > 0) {
                AMRole aMRole = this.dpStoreConn.getRole(this.roleDN);
                Set set = this.getAvailableServices(aMRole);
                AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
                Set set2 = aMServiceDisplayModelImpl.getDeniedServices(aMRole);
                set.removeAll(set2);
                if (!set2.contains("iPlanetAMUserService")) {
                    set.add("iPlanetAMUserService");
                }
                hashSet = new HashSet<String>(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Set set3 = this.getAttributeNames(string);
                    if (set3 == null || set3.isEmpty()) continue;
                    hashSet.add(string);
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("UMRoleDisplayProfileModelImpl.getServiceNames", (Throwable)aMException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMRoleDisplayProfileModelImpl.getServiceNames", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMRoleDisplayProfileModelImpl.getServiceNames", (Throwable)sSOException);
        }
        return hashSet;
    }

    public Set getAttributeNames(String string) {
        HashSet hashSet = Collections.EMPTY_SET;
        try {
            Set set = Collections.EMPTY_SET;
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            if (this.roleType != 3) {
                set = this.getAttributeNames(serviceSchemaManager, SchemaType.ORGANIZATION);
            }
            Set set2 = this.getAttributeNames(serviceSchemaManager, SchemaType.DYNAMIC);
            Set set3 = this.getAttributeNames(serviceSchemaManager, SchemaType.USER);
            hashSet = new HashSet(set.size() + set2.size() + set3.size());
            hashSet.addAll(set);
            hashSet.addAll(set2);
            hashSet.addAll(set3);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMRoleDisplayProfileModelImpl.getAttributeNames", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMRoleDisplayProfileModelImpl.getAttributeNames", (Throwable)sMSException);
        }
        return hashSet;
    }

    public Set getAttributeNames(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        try {
            Set set;
            Set set2 = serviceSchemaManager.getSchemaTypes();
            if (set2 == null) {
                return hashSet;
            }
            if (!AMAdminUtils.containsSchemaType(set2, schemaType)) {
                return hashSet;
            }
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
            if (serviceSchema != null && (set = serviceSchema.getAttributeSchemaNames()) != null && !set.isEmpty()) {
                hashSet = new HashSet<String>(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
                    if (attributeSchema == null || (string = this.getAttributeLocalizedName(serviceSchemaManager, attributeSchema)) == null || string.length() <= 0) continue;
                    hashSet.add(string2);
                    this.mapAttrNameToI18nName.put(string2, string);
                }
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMRoleDisplayProfileModelImpl.getAttibuteNames", (Throwable)sMSException);
        }
        return hashSet;
    }

    public String getAttrLocalizedName(String string) {
        return (String)this.mapAttrNameToI18nName.get(string);
    }

    public boolean isAttrDisplay(String string, String string2) {
        Set set = this.getDisplayOptions(string, string2);
        if (set.isEmpty()) {
            return false;
        }
        if (set.contains("readOnly")) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning(string2 + " marked readOnly, don't display");
            }
            return false;
        }
        if ((this.isAdministrator() || this.isTopLevelAdministrator()) && (set.contains("adminDisplay") || set.contains("display") || set.contains("userReadOnly"))) {
            return true;
        }
        return set.contains("display") && !set.contains("userReadOnly");
    }

    public boolean isAttrReadOnly(String string, String string2) {
        return !this.isAttrDisplay(string, string2);
    }

    public boolean isFilterAttr(String string, String string2) {
        return true;
    }

    public String getRoleName() {
        return AMFormatUtils.DNToName(this, this.roleDN, true);
    }

    public String getTopLabel() {
        return this.getLocalizedString("roleDisplayProfileTop.label");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    private String getAttributeLocalizedName(ServiceSchemaManager serviceSchemaManager, AttributeSchema attributeSchema) {
        String string = "";
        String string2 = attributeSchema.getI18NKey();
        if (string2 != null && string2.length() > 0) {
            string = this.getL10NAttributeName(serviceSchemaManager, string2);
        }
        return string;
    }

    private Set getDisplayOptions(String string, String string2) {
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getDisplayOptions " + this.roleDisplayOptions);
        }
        if (this.roleDisplayOptions == null || this.roleDisplayOptions.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Map map = (Map)this.roleDisplayOptions.get(string);
        if (map == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)map.get(string2);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateRoleDisplayProfile.message");
    }

    public String getGoButtonLabel() {
        return this.getLocalizedString("roleDisplayProfileGo.button");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("roleDisplayProfile.help");
        if (string.equals("roleDisplayProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

