/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.user.model.UMProfileModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public abstract class UMProfileModelImpl
extends AMProfileModelBase
implements UMProfileModel {
    protected String profileDN = null;
    protected ResourceBundle schemaResBundle = null;
    protected String errorMessage = null;
    private ServiceSchemaManager entrySpecificSvcMgr = null;

    public UMProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getPageTitle() {
        return this.profileDN == null ? "" : AMFormatUtils.DNToName(this, this.profileDN);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getNoAttributesMessage() {
        return this.getLocalizedString("noAttributes.message");
    }

    public String getProfileDN() {
        return this.profileDN;
    }

    public void setProfileDN(String string) {
        this.profileDN = string;
    }

    protected boolean isDisplayed(AttributeSchema attributeSchema) {
        boolean bl = true;
        if (attributeSchema == null || attributeSchema.getI18NKey() == null || attributeSchema.getI18NKey().length() == 0) {
            bl = false;
        }
        return bl;
    }

    protected boolean setAttributes(AMObject aMObject, Map map, String string) {
        AMModelBase.debug.message("Entering UMProfileModelImpl:setAttributes");
        boolean bl = true;
        if (map == null || map.isEmpty()) {
            return bl;
        }
        HashMap<String, Set> hashMap = new HashMap<String, Set>(1);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Set set = (Set)map.get(string2);
            Set set2 = null;
            try {
                set2 = aMObject.getAttribute(string2);
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("Could not get old value for " + string2, (Throwable)aMException);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("Error in SSO Token");
            }
            if (set.equals(set2)) {
                if (!AMModelBase.debug.messageEnabled()) continue;
                AMModelBase.debug.message(string2 + " didn't change, skipping.");
                continue;
            }
            hashMap.clear();
            hashMap.put(string2, set);
            try {
                aMObject.setAttributes(hashMap);
                aMObject.store();
                String string3 = string2 + " " + set2 + "->" + set;
                this.writeFormatLog(string, string3, aMObject.getDN());
            }
            catch (AMException aMException) {
                bl = false;
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("error setting attribute " + string2, (Throwable)aMException);
                }
                this.errorMessage = this.getErrorString((Exception)((Object)aMException));
            }
            catch (SSOException sSOException) {
                bl = false;
                AMModelBase.debug.error("Error in SSO Token");
            }
        }
        return bl;
    }

    protected Set getAttributesToDisplay(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) {
        TreeSet<AttributeSchema> treeSet = Collections.EMPTY_SET;
        ServiceSchema serviceSchema = null;
        try {
            serviceSchema = serviceSchemaManager.getSchema(schemaType);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("error getting schema", (Throwable)sMSException);
        }
        if (serviceSchema == null) {
            return treeSet;
        }
        ServiceSchema serviceSchema2 = null;
        try {
            serviceSchema2 = serviceSchema.getSubSchema(string);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("error getting subschema", (Throwable)sMSException);
        }
        if (serviceSchema2 == null) {
            return treeSet;
        }
        Set set = serviceSchema2.getAttributeSchemaNames();
        if (set != null) {
            Collator collator = Collator.getInstance(this.getUserLocale());
            treeSet = new TreeSet<AttributeSchema>(new AMAttrSchemaComparator(collator));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                AttributeSchema attributeSchema = serviceSchema2.getAttributeSchema(string2);
                if (!this.isDisplayed(attributeSchema)) continue;
                treeSet.add(attributeSchema);
            }
        }
        return treeSet;
    }

    protected ServiceSchemaManager getEntrySpecificSvcSchemaMgr() {
        if (this.entrySpecificSvcMgr == null) {
            try {
                this.entrySpecificSvcMgr = this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMProfileModelImpl.getEntrySpecificSvcSchemaMgr", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("UMProfileModelImpl.getEntrySpecificSvcSchemaMgr", (Throwable)sMSException);
            }
        }
        return this.entrySpecificSvcMgr;
    }
}

