/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMPeopleContainerProfileModel;
import com.iplanet.am.console.user.model.UMProfileModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMPeopleContainerProfileModelImpl
extends UMProfileModelImpl
implements UMPeopleContainerProfileModel {
    private AMPeopleContainer peopleContainer = null;

    public UMPeopleContainerProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        AMModelBase.debug.message("UMPeopleContainerProfileModelImpl.modify");
        boolean bl = false;
        try {
            AMPeopleContainer aMPeopleContainer = this.getAMPeopleContainer();
            if (aMPeopleContainer != null) {
                this.fireBeforeUpdateValuesEvent(5, (AMObject)aMPeopleContainer, map);
                bl = this.setAttributes((AMObject)aMPeopleContainer, map, "peopleContainerChanged.message");
                this.fireAfterUpdateValuesEvent(5, (AMObject)aMPeopleContainer);
            } else if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMPeopleContainerProfileModelImpl.modify: people container does not exists");
                this.errorMessage = this.getLocalizedString("noPeopleContainer.message");
            }
        }
        catch (AMConsoleException aMConsoleException) {
            this.errorMessage = this.getErrorString(aMConsoleException);
        }
        return bl;
    }

    public List getDynamicGUIComponents() {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMPeopleContainer aMPeopleContainer = this.getAMPeopleContainer();
        if (serviceSchemaManager != null && aMPeopleContainer != null) {
            Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "PeopleContainer");
            Map map = this.getPeopleContainerAttributeValues(aMPeopleContainer, set);
            this.fireRetrieveAttributeValuesEvent((AMObject)aMPeopleContainer, 2, 5, "iPlanetAMEntrySpecificService", SchemaType.GLOBAL, map);
            AMAdminUtils.excludeAttributeSchemas(set, map.keySet());
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                Set set2;
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMEntrySpecificService", set2 = (Set)map.get(string = attributeSchema.getName()), this, Setting.ACTION_PEOPLE_CONTAINER);
                if (dynamicGUI == null) continue;
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    private Map getPeopleContainerAttributeValues(AMPeopleContainer aMPeopleContainer, Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            String string = attributeSchema.getName();
            try {
                Set set2 = aMPeopleContainer.getAttribute(string);
                hashMap.put(string, set2);
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("UMPeopleContainerProfileModelImpl.getPeopleContainerAttributeValues: could not get value for " + string, (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("UMPeopleContainerProfileModelImpl.getPeopleContainerAttributeValues", (Throwable)sSOException);
            }
        }
        return hashMap;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updatePeopleContainer.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("peopleContainerProfile.help");
        if (string.equals("peopleContainerProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isPeopleContainerValid() {
        return this.getAMPeopleContainer() != null;
    }

    public String getInvalidPeopleContainerMessage() {
        return this.getLocalizedString("invalidPeopleContainerProfile.message");
    }

    private AMPeopleContainer getAMPeopleContainer() {
        if (this.peopleContainer == null) {
            try {
                this.peopleContainer = this.dpStoreConn.getPeopleContainer(this.profileDN);
                if (!this.peopleContainer.isExists()) {
                    this.peopleContainer = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMPeopleContainerProfileModelImpl.getAMPeopleContainer", (Throwable)sSOException);
                this.peopleContainer = null;
            }
        }
        return this.peopleContainer;
    }
}

