/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.console.user.model.UMOrgUnitNavModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMOrgUnitNavModelImpl
extends UMNavModelImpl
implements UMOrgUnitNavModel {
    private Set orgUnits = null;
    private Map localizedAttrNames = null;

    public UMOrgUnitNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectedOption() {
        return "organizationalunits";
    }

    public Set getOrgUnits(String string) {
        if (this.orgUnits == null) {
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            try {
                switch (this.locationType) {
                    case 2: {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.setSearchControlAttributes(this.locationDN, "OrganizationalUnit", 3, aMSearchControl, "organizationalUnits");
                        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        aMSearchResults = this.getOrgUnits(aMOrganization, string, aMSearchControl);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.setSearchControlAttributes(this.locationDN, "OrganizationalUnit", 3, aMSearchControl, "organizationalUnits");
                        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        aMSearchResults = this.getOrgUnits(aMOrganizationalUnit, string, aMSearchControl);
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMOrgUnitNavModelImpl.getOrgUnits invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMOrgUnitNavModelImpl.getOrgUnits", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMOrgUnitNavModelImpl.getOrgUnits", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            this.orgUnits = this.getSearchResultsSet(aMSearchResults);
            this.resultsMap = aMSearchResults.getResultAttributes();
        }
        return this.orgUnits;
    }

    private AMSearchResults getOrgUnits(AMOrganization aMOrganization, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        aMSearchControl.setSearchScope(1);
        String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)3, (Debug)AMModelBase.debug)};
        aMSearchControl.setSortKeys(stringArray);
        return aMOrganization.searchOrganizationalUnits(string, aMSearchControl);
    }

    private AMSearchResults getOrgUnits(AMOrganizationalUnit aMOrganizationalUnit, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        aMSearchControl.setSearchScope(1);
        String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)3, (Debug)AMModelBase.debug)};
        aMSearchControl.setSortKeys(stringArray);
        return aMOrganizationalUnit.searchSubOrganizationalUnits(string, aMSearchControl);
    }

    public boolean deleteOrgUnits(Set set) {
        boolean bl = false;
        if (set != null) {
            try {
                Map map = this.deleteUMObject(3, set, "orgUnitDeleted.message");
                if (!map.isEmpty()) {
                    Iterator iterator = map.keySet().iterator();
                    this.setErrorMessage(this.getLocalizedString("deleteOrgUnitFailed.message"));
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = AMFormatUtils.DNToName(this, string, false);
                        String string3 = (String)map.get(string);
                        this.setErrorMessage(string2 + " - " + string3);
                    }
                } else {
                    bl = true;
                }
            }
            catch (AMConsoleException aMConsoleException) {
                this.setErrorMessage(this.getErrorString(aMConsoleException));
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("orgunits.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noOrgUnitSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noOrgUnitSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.orgUnits;
    }

    public void setAttrList(Set set) {
        this.orgUnits = set;
    }

    public String getOrgUnitsDisplayOffMessage() {
        return this.getLocalizedString("orgUnitsDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMOrgUnitNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }

    public List getSearchReturnAttributes() {
        return this.getSearchReturnAttributes("OrganizationalUnit", 3, "organizationalUnits");
    }

    public String getAttributeLocalizedName(String string) {
        return this.getAttributeLocalizedName(string, "OrganizationalUnit");
    }

    public String getAttributeName() {
        return this.getAttributeName("OrganizationalUnit", 3, "organizationalUnits");
    }

    public String getAttributeValue(String string) {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return AMFormatUtils.DNToName(this, string, true);
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeValue(string, (String)this.searchReturnAttrs.get(n - 1));
    }
}

