/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMDataModelImpl;
import com.iplanet.am.console.user.model.UMOrgProfileModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMOrgProfileModelImpl
extends UMDataModelImpl
implements UMOrgProfileModel {
    private AMOrganization organization = null;

    public UMOrgProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        AMModelBase.debug.message("UMOrgProfileModelImpl.modify");
        boolean bl = false;
        try {
            AMOrganization aMOrganization = this.getAMOrganization();
            if (aMOrganization != null) {
                AMModelBase.debug.message("UMOrgProfileModelImpl.modify: org exists");
                this.fireBeforeUpdateValuesEvent(2, (AMObject)aMOrganization, map);
                bl = this.setAttributes((AMObject)aMOrganization, map, "orgChanged.message");
                this.fireAfterUpdateValuesEvent(2, (AMObject)aMOrganization);
            } else {
                AMModelBase.debug.message("UMOrgProfileModelImpl.modify: org does not exists");
                this.errorMessage = this.getLocalizedString("noorganization.message");
            }
        }
        catch (AMConsoleException aMConsoleException) {
            this.errorMessage = this.getErrorString(aMConsoleException);
        }
        return bl;
    }

    public List getDynamicGUIComponents() {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMOrganization aMOrganization = this.getAMOrganization();
        if (serviceSchemaManager != null && aMOrganization != null) {
            Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "Organization");
            Map map = this.getOrgAttributeValues(aMOrganization, set);
            this.fireRetrieveAttributeValuesEvent((AMObject)aMOrganization, 2, 2, "iPlanetAMEntrySpecificService", SchemaType.GLOBAL, map);
            AMAdminUtils.excludeAttributeSchemas(set, map.keySet());
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                Set set2;
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMEntrySpecificService", set2 = (Set)map.get(string = attributeSchema.getName()), this, Setting.ACTION_ORGANIZATION);
                if (dynamicGUI == null) continue;
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    private Map getOrgAttributeValues(AMOrganization aMOrganization, Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            String string = attributeSchema.getName();
            try {
                Set set2 = aMOrganization.getAttribute(string);
                hashMap.put(string, set2);
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("Could not get value for " + string, (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMOrgProfileModelImpl.getOrgAttributeValues", (Throwable)sSOException);
            }
        }
        return hashMap;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateOrganization.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("organizationProfile.help");
        if (string.equals("organizationProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isOrganizationExists() {
        return this.getAMOrganization() != null;
    }

    public String getInvalidOrganizationMessage() {
        return this.getLocalizedString("invalidOrganizationProfile.message");
    }

    private AMOrganization getAMOrganization() {
        if (this.organization == null) {
            try {
                this.organization = this.dpStoreConn.getOrganization(this.profileDN);
                if (!this.organization.isExists()) {
                    this.organization = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMOrgProfileModelImpl.getAMOrgganization", (Throwable)sSOException);
                this.organization = null;
            }
        }
        return this.organization;
    }

    public String getDefaultSubView() {
        String string = null;
        Set set = this.getUserSettings(Setting.DEFAULT_ORGANIZATION_PROFILE_VIEW);
        if (set != null && !set.isEmpty()) {
            String string2 = (String)set.iterator().next();
            string = string2.toLowerCase();
        }
        if (string == null) {
            string = "general";
        }
        return string;
    }
}

