/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.console.user.model.UMOrgNavModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMOrgNavModelImpl
extends UMNavModelImpl
implements UMOrgNavModel {
    private Set orgs = null;
    private Map localizedAttrNames = null;
    private AMOrganization org = null;
    private ServiceSchemaManager entrySpecificSvcMgr = null;

    public UMOrgNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectedOption() {
        return "organizations";
    }

    public Set getOrganizations(String string) {
        if (this.orgs == null) {
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            try {
                switch (this.locationType) {
                    case 2: {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.setSearchControlAttributes(this.locationDN, "Organization", 2, aMSearchControl, "organizations");
                        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        aMSearchResults = this.getOrganizations(aMOrganization, string, aMSearchControl);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.setSearchControlAttributes(this.locationDN, "Organization", 2, aMSearchControl, "organizations");
                        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        aMSearchResults = this.getOrganizations(aMOrganizationalUnit, string, aMSearchControl);
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMNavOrgModelImpl.getOrganizations invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMNavOrgModelImpl.getOrganizations", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMNavOrgModelImpl.getOrganizations", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            this.orgs = this.getSearchResultsSet(aMSearchResults);
            this.resultsMap = aMSearchResults.getResultAttributes();
        }
        return this.orgs;
    }

    private AMSearchResults getOrganizations(AMOrganization aMOrganization, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        aMSearchControl.setSearchScope(1);
        String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)2, (Debug)AMModelBase.debug)};
        aMSearchControl.setSortKeys(stringArray);
        return aMOrganization.searchSubOrganizations(string, aMSearchControl);
    }

    private AMSearchResults getOrganizations(AMOrganizationalUnit aMOrganizationalUnit, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        aMSearchControl.setSearchScope(1);
        String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)2, (Debug)AMModelBase.debug)};
        aMSearchControl.setSortKeys(stringArray);
        return aMOrganizationalUnit.searchOrganizations(string, aMSearchControl);
    }

    public boolean deleteOrganizations(Set set) throws AMConsoleException {
        boolean bl = false;
        if (set != null) {
            Map map = this.deleteUMObject(2, set, "orgDeleted.message");
            if (!map.isEmpty()) {
                Iterator iterator = map.keySet().iterator();
                this.setErrorMessage(this.getLocalizedString("deleteOrgFailed.message"));
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = AMFormatUtils.DNToName(this, string, false);
                    String string3 = (String)map.get(string);
                    this.setErrorMessage(string2 + " - " + string3);
                }
            } else {
                bl = true;
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("organizations.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noOrgSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noOrgSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.orgs;
    }

    public void setAttrList(Set set) {
        this.orgs = set;
    }

    public String getOrgsDisplayOffMessage() {
        return this.getLocalizedString("orgsDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMOrgNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }

    protected List getOrgMenu() {
        List list = super.getOrgMenu();
        try {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
            if (AdminInterfaceUtils.inOrganizationalUnit((Debug)AMModelBase.debug, (AMStoreConnection)this.dpStoreConn, (AMObject)aMOrganization)) {
                list.remove(new Integer(14));
                list.remove(new Integer(99));
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMOrgNavModelImpl.getOrgMenu", (Throwable)sSOException);
        }
        return list;
    }

    public List getSearchReturnAttributes() {
        return this.getSearchReturnAttributes("Organization", 2, "organizations");
    }

    public String getAttributeLocalizedName(String string) {
        return this.getAttributeLocalizedName(string, "Organization");
    }

    public String getAttributeName() {
        return this.getAttributeName("Organization", 2, "organizations");
    }

    public String getAttributeValue(String string) {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return AMFormatUtils.DNToName(this, string);
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeValue(string, (String)this.searchReturnAttrs.get(n - 1));
    }
}

