/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMMenuValidator;
import com.iplanet.am.console.base.model.AMMenuValidatorImpl;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMNavModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class UMNavModelImpl
extends AMModelBase
implements UMNavModel {
    protected List errorMessage = new ArrayList(1);
    protected String searchErrorMsg = null;
    protected static Set userMgtMenu = new HashSet(4);
    protected Set values = null;
    protected List searchReturnAttrs = null;
    protected Map resultsMap = null;
    public int errorCode = 0;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMOrgNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMOrgUnitNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMPCNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMGCNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMRoleNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMUserNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMServiceNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMMngGrpNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$policy$PMPolicyNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$policy$PMAdminNavViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMRoleDisplayOptionsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMRolePermissionsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMEntityNavViewBean;

    public UMNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.setShowUsers(!this.isServiceDenied("iPlanetAMUserService"));
    }

    public String getWarningTitle() {
        String string = null;
        string = this.errorCode == 1 ? this.getLocalizedString("sizeLimitExceeded.title") : (this.errorCode == 2 ? this.getLocalizedString("timeLimitExceeded.title") : this.getLocalizedString("warningMessage.title"));
        return string;
    }

    public String getTitleString() {
        return AMFormatUtils.DNToName(this, this.locationDN, this.locationType == 6 || this.locationType == 8);
    }

    public String getTitleHyperlink() {
        return this.isUserMgtEnabled() ? this.locationDN : "";
    }

    public String getShowLabel() {
        return this.getLocalizedString("view.label");
    }

    public String getSearchLabel() {
        return this.getLocalizedString("advancedsearch.label");
    }

    public String getFilterLabel() {
        return this.getLocalizedString("filter.label");
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getContainLabel() {
        return this.getLocalizedString("contains.label");
    }

    public String getNameLabel() {
        return this.getLocalizedString("name.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("properties.label");
    }

    public String getSearchBtnLabel() {
        return this.getLocalizedString("search.button");
    }

    public String getCreateBtnLabel() {
        return this.getLocalizedString("new.button");
    }

    public String getDeleteBtnLabel() {
        return this.getLocalizedString("deleteSelected.button");
    }

    public String getRegisterBtnLabel() {
        return this.getLocalizedString("registerNav.button");
    }

    public String getUnregisterBtnLabel() {
        return this.getLocalizedString("unregister.button");
    }

    public List getShowMenuOptions() throws AMConsoleException {
        List list = Collections.EMPTY_LIST;
        boolean bl = this.locationDN.equalsIgnoreCase(AMSystemConfig.rootSuffix);
        if (bl) {
            list = this.getSuperMenu();
        } else {
            switch (this.locationType) {
                case 2: {
                    list = this.getOrgMenu();
                    break;
                }
                case 3: {
                    list = this.getOrgUnitMenu();
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    list = this.getGroupMenu();
                    break;
                }
                case 6: 
                case 8: {
                    list = this.getRoleMenu();
                    break;
                }
                case 5: {
                    list = this.getPCMenu();
                    break;
                }
                case 4: {
                    list = this.getGCMenu();
                    break;
                }
                default: {
                    if (AMModelBase.debug.warningEnabled()) {
                        AMModelBase.debug.warning("UMNavModelImpl.getShowMenuOptions: Unknown location type - Unable to get menu options");
                    }
                    throw new AMConsoleException(this.getLocalizedString("invalidUserStartLoc.message"));
                }
            }
        }
        if (!this.isUserMgtEnabled()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (userMgtMenu.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        return list;
    }

    public Class getViewBeanTypeClass(String string) {
        Class clazz = null;
        if (string.equals("organizations")) {
            clazz = class$com$iplanet$am$console$user$UMOrgNavViewBean == null ? (class$com$iplanet$am$console$user$UMOrgNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMOrgNavViewBean")) : class$com$iplanet$am$console$user$UMOrgNavViewBean;
        } else if (string.equals("organizationalunits")) {
            clazz = class$com$iplanet$am$console$user$UMOrgUnitNavViewBean == null ? (class$com$iplanet$am$console$user$UMOrgUnitNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMOrgUnitNavViewBean")) : class$com$iplanet$am$console$user$UMOrgUnitNavViewBean;
        } else if (string.equals("peoplecontainers")) {
            clazz = class$com$iplanet$am$console$user$UMPCNavViewBean == null ? (class$com$iplanet$am$console$user$UMPCNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMPCNavViewBean")) : class$com$iplanet$am$console$user$UMPCNavViewBean;
        } else if (string.equals("groupcontainers")) {
            clazz = class$com$iplanet$am$console$user$UMGCNavViewBean == null ? (class$com$iplanet$am$console$user$UMGCNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMGCNavViewBean")) : class$com$iplanet$am$console$user$UMGCNavViewBean;
        } else if (string.equals("roles")) {
            clazz = class$com$iplanet$am$console$user$UMRoleNavViewBean == null ? (class$com$iplanet$am$console$user$UMRoleNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMRoleNavViewBean")) : class$com$iplanet$am$console$user$UMRoleNavViewBean;
        } else if (string.equals("users")) {
            clazz = class$com$iplanet$am$console$user$UMUserNavViewBean == null ? (class$com$iplanet$am$console$user$UMUserNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMUserNavViewBean")) : class$com$iplanet$am$console$user$UMUserNavViewBean;
        } else if (string.equals("services")) {
            clazz = class$com$iplanet$am$console$user$UMServiceNavViewBean == null ? (class$com$iplanet$am$console$user$UMServiceNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMServiceNavViewBean")) : class$com$iplanet$am$console$user$UMServiceNavViewBean;
        } else if (string.equals("groups")) {
            clazz = class$com$iplanet$am$console$user$UMMngGrpNavViewBean == null ? (class$com$iplanet$am$console$user$UMMngGrpNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMMngGrpNavViewBean")) : class$com$iplanet$am$console$user$UMMngGrpNavViewBean;
        } else if (string.equals("policies")) {
            clazz = class$com$iplanet$am$console$policy$PMPolicyNavViewBean == null ? (class$com$iplanet$am$console$policy$PMPolicyNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.policy.PMPolicyNavViewBean")) : class$com$iplanet$am$console$policy$PMPolicyNavViewBean;
        } else if (string.equals("policyadministrator")) {
            clazz = class$com$iplanet$am$console$policy$PMAdminNavViewBean == null ? (class$com$iplanet$am$console$policy$PMAdminNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.policy.PMAdminNavViewBean")) : class$com$iplanet$am$console$policy$PMAdminNavViewBean;
        } else if (string.equals("displayoptions")) {
            clazz = class$com$iplanet$am$console$user$UMRoleDisplayOptionsViewBean == null ? (class$com$iplanet$am$console$user$UMRoleDisplayOptionsViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMRoleDisplayOptionsViewBean")) : class$com$iplanet$am$console$user$UMRoleDisplayOptionsViewBean;
        } else if (string.equals("permissions")) {
            clazz = class$com$iplanet$am$console$user$UMRolePermissionsViewBean == null ? (class$com$iplanet$am$console$user$UMRolePermissionsViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMRolePermissionsViewBean")) : class$com$iplanet$am$console$user$UMRolePermissionsViewBean;
        } else if (string.startsWith("amentity_")) {
            clazz = class$com$iplanet$am$console$user$UMEntityNavViewBean == null ? (class$com$iplanet$am$console$user$UMEntityNavViewBean = UMNavModelImpl.class$("com.iplanet.am.console.user.UMEntityNavViewBean")) : class$com$iplanet$am$console$user$UMEntityNavViewBean;
        }
        return clazz;
    }

    public String getPropertyVBTypeClass() {
        String string = null;
        switch (this.locationType) {
            case 2: {
                string = "com.iplanet.am.console.user.UMOrgBaseViewBean";
                break;
            }
            case 3: {
                string = "com.iplanet.am.console.user.UMOrgUnitBaseViewBean";
                break;
            }
            case 5: {
                string = "com.iplanet.am.console.user.UMPeopleContainerProfileViewBean";
                break;
            }
            case 4: {
                string = "com.iplanet.am.console.user.UMGroupContainerProfileViewBean";
                break;
            }
            case 6: {
                string = "com.iplanet.am.console.user.UMRoleProfileViewBean";
                break;
            }
            case 8: {
                string = "com.iplanet.am.console.user.UMFilteredRoleProfileViewBean";
                break;
            }
            case 1: {
                string = "com.iplanet.am.console.user.UMUserProfileViewBean";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                string = "com.iplanet.am.console.user.UMStaticGroupProfileViewBean";
                break;
            }
            case 11: {
                string = "com.iplanet.am.console.user.UMFilteredGroupProfileViewBean";
            }
        }
        return string;
    }

    protected Map deleteUMObject(int n, Set set, String string) throws AMConsoleException {
        if (set == null || set.isEmpty()) {
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("UMNavModelImpl.deleteUMObject: DN Set null");
            }
            return new HashMap();
        }
        set = this.fireBeforeDeleteObjectsEvent(n, set);
        int n2 = set.size();
        HashMap<String, String> hashMap = new HashMap<String, String>(n2);
        this.errorMessage = new ArrayList(n2);
        HashSet<String> hashSet = new HashSet<String>(n2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            AMObject aMObject;
            block11: {
                aMObject = null;
                string2 = (String)iterator.next();
                try {
                    aMObject = this.getAMObject(string2);
                    if (aMObject == null) {
                        if (!AMModelBase.debug.warningEnabled()) continue;
                        AMModelBase.debug.warning("skipping " + string2 + ", no object found for it.");
                    }
                    break block11;
                }
                catch (AMException aMException) {
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning("skipping " + string2 + ", no object found for it.");
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("token exception", (Throwable)sSOException);
                }
                continue;
            }
            try {
                if (aMObject.isExists()) {
                    aMObject.delete(true);
                    this.logger.doLog(string, string2);
                    hashSet.add(string2);
                    continue;
                }
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("skipping " + string2 + ", doesn't exist in directory");
            }
            catch (AMException aMException) {
                hashMap.put(string2, aMException.getLocalizedMessage());
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("Failed to delete AMObject: " + string2);
                AMModelBase.debug.warning("UMNavModelImpl.deleteOrgs:", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("Failed to delete AMObject: " + string2);
                AMModelBase.debug.warning("UMNavModelImpl.deleteOrgs", (Throwable)sSOException);
            }
        }
        this.fireAfterDeleteObjectsEvent(n, hashSet);
        return hashMap;
    }

    public List getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage.add(string);
    }

    public String getSearchErrorMsg() {
        return this.searchErrorMsg;
    }

    public void setSearchErrorMsg(String string) {
        this.searchErrorMsg = string;
    }

    public void setSearchErrorCode(int n) {
        this.errorCode = n;
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noEntries.message");
    }

    private List getSuperMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("organizations");
        if (this.showOrgUnits()) {
            arrayList.add("organizationalunits");
        }
        if (this.showGroupContainers()) {
            arrayList.add("groupcontainers");
        } else {
            arrayList.add("groups");
        }
        String string = AMSystemConfig.rootSuffix;
        if (string.equalsIgnoreCase(AMSystemConfig.defaultOrg)) {
            if (this.showPeopleContainers()) {
                arrayList.add("peoplecontainers");
            } else if (this.showUsers()) {
                arrayList.add("users");
            }
            arrayList.add("services");
        }
        if (!this.isUserMgtEnabled()) {
            arrayList.add("policyadministrator");
        }
        arrayList.add("roles");
        arrayList.add("policies");
        arrayList.addAll(this.getEntityTypes());
        this.validateNavigationalMenuOptions(arrayList);
        return arrayList;
    }

    private void validateNavigationalMenuOptions(List list) {
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        boolean bl = this.locationDN.equalsIgnoreCase(AMSystemConfig.rootSuffix);
        if (bl) {
            aMMenuValidator.validateRootSuffixMenuOptions(list, this);
        } else {
            aMMenuValidator.validateNavigationalMenuOptions(list, this.locationType, this);
        }
    }

    protected List getOrgMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        arrayList.add("organizations");
        if (this.showOrgUnits()) {
            arrayList.add("organizationalunits");
        }
        if (this.showGroupContainers()) {
            arrayList.add("groupcontainers");
        } else {
            arrayList.add("groups");
        }
        if (this.showPeopleContainers()) {
            arrayList.add("peoplecontainers");
        } else if (this.showUsers()) {
            arrayList.add("users");
        }
        arrayList.add("services");
        arrayList.add("roles");
        if (!this.isUserMgtEnabled()) {
            arrayList.add("policyadministrator");
        }
        try {
            int n = this.getObjectType(this.startDN);
            if (n == 2) {
                arrayList.add("policies");
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMNavModelImpl.getOrgMenu", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMNavModelImpl.getOrgMenu", (Throwable)sSOException);
        }
        arrayList.addAll(this.getEntityTypes());
        this.validateNavigationalMenuOptions(arrayList);
        return arrayList;
    }

    private List getOrgUnitMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(7);
        arrayList.add("organizations");
        if (this.showOrgUnits()) {
            arrayList.add("organizationalunits");
        }
        if (this.showGroupContainers()) {
            arrayList.add("groupcontainers");
        } else {
            arrayList.add("groups");
        }
        if (this.showPeopleContainers()) {
            arrayList.add("peoplecontainers");
        } else if (this.showUsers()) {
            arrayList.add("users");
        }
        arrayList.add("services");
        arrayList.add("roles");
        arrayList.addAll(this.getEntityTypes());
        this.validateNavigationalMenuOptions(arrayList);
        return arrayList;
    }

    protected List getGroupMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("groups");
        this.validateNavigationalMenuOptions(arrayList);
        return arrayList;
    }

    private List getPCMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (this.showPeopleContainers()) {
            arrayList.add("peoplecontainers");
        }
        if (this.showUsers()) {
            arrayList.add("users");
        }
        this.validateNavigationalMenuOptions(arrayList);
        return arrayList;
    }

    private List getGCMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (this.showGroupContainers()) {
            arrayList.add("groupcontainers");
        }
        arrayList.add("groups");
        this.validateNavigationalMenuOptions(arrayList);
        return arrayList;
    }

    protected List getRoleMenu() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        String string2 = AMAdminUtils.getParent(this.locationDN);
        if (!string2.equalsIgnoreCase(string = AMSystemConfig.rootSuffix) || string.equalsIgnoreCase(AMSystemConfig.defaultOrg) && string2.equalsIgnoreCase(string)) {
            arrayList.add("services");
        }
        return arrayList;
    }

    private void setShowUsers(boolean bl) {
        try {
            String string = this.ssoToken.getProperty("iplanet-am-admin-console-show-users");
            if (string == null || string.length() == 0) {
                if (bl) {
                    this.ssoToken.setProperty("iplanet-am-admin-console-show-users", "1");
                } else {
                    this.ssoToken.setProperty("iplanet-am-admin-console-show-users", "0");
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMNavModelImpl.setShowUsers ", (Throwable)sSOException);
        }
    }

    public String getNoPrivilegeTitle() {
        return this.getLocalizedString("noPrivilege.title");
    }

    public String getNoPrivilegeMessage() {
        return this.getLocalizedString("noPrivilege.message");
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("users.label");
    }

    public Set getAttrList() {
        return this.values;
    }

    public void setAttrList(Set set) {
        this.values = set;
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public boolean compareDNs(String string, String string2) {
        DN dN = new DN(string);
        return dN.equals(new DN(string2));
    }

    protected Set getSearchResultsSet(AMSearchResults aMSearchResults) {
        Set set = Collections.EMPTY_SET;
        if (aMSearchResults != null) {
            set = aMSearchResults.getSearchResults();
            this.searchErrorMsg = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
            if (this.searchErrorMsg != null) {
                this.errorCode = aMSearchResults.getErrorCode();
            }
        }
        return set;
    }

    public String getInvalidNavigationObjectMessage() {
        return this.getLocalizedString("invalidNavigationObject.message");
    }

    public boolean isLocationValid() {
        try {
            return this.isCurrentLocationTypeValid() && this.dpStoreConn.isValidEntry(this.locationDN);
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMNavModelImpl.isLocationValid, location=" + this.locationDN, (Throwable)sSOException);
            }
            return false;
        }
    }

    protected boolean isCurrentLocationTypeValid() {
        return false;
    }

    public boolean canViewCurLocationProperties() {
        boolean bl = false;
        switch (this.locationType) {
            case 1: {
                bl = this.canPerform(Setting.ACTION_USER, "viewproperties");
                break;
            }
            case 2: {
                bl = this.canPerform(Setting.ACTION_ORGANIZATION, "viewproperties");
                break;
            }
            case 3: {
                bl = this.canPerform(Setting.ACTION_ORGANIZATIONAL_UNIT, "viewproperties");
                break;
            }
            case 4: {
                bl = this.canPerform(Setting.ACTION_GROUP_CONTAINER, "viewproperties");
                break;
            }
            case 5: {
                bl = this.canPerform(Setting.ACTION_PEOPLE_CONTAINER, "viewproperties");
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                bl = this.canPerform(Setting.ACTION_ROLE, "viewproperties");
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                bl = this.canPerform(Setting.ACTION_GROUP, "viewproperties");
                break;
            }
            case 13: 
            case 15: {
                bl = this.canPerform(Setting.ACTION_SERVICE, "viewproperties");
            }
            case 14: {
                bl = this.canPerform(Setting.ACTION_POLICY, "viewproperties");
                break;
            }
            default: {
                AMModelBase.debug.error("UMNavModelImpl.canViewCurLocationProperties: cannot process this object type, " + Integer.toString(this.locationType));
            }
        }
        return bl;
    }

    public String getAttributeLocalizedName(String string, String string2) {
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        String string3 = string;
        if (serviceSchemaManager != null) {
            try {
                String string4 = AMAdminUtils.getSubSchemaI18NKey(serviceSchemaManager, SchemaType.GLOBAL, string2, string);
                if (string4 == null) {
                    string4 = string;
                }
                string3 = this.getL10NAttributeName(serviceSchemaManager, string4);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMNavModelImpl.getAttributeLocalizedName", (Throwable)sMSException);
            }
        }
        return string3;
    }

    protected Set getObjectAttributeNames(String string, int n) {
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, string);
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            hashSet = new HashSet(set.size() + 1);
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string2 = attributeSchema.getName();
                hashSet.add(string2);
            }
        } else {
            hashSet = new HashSet<String>(1);
        }
        hashSet.add(AdminInterfaceUtils.getNamingAttribute((int)n, (Debug)AMModelBase.debug));
        return hashSet;
    }

    protected void setSearchControlAttributes(String string, String string2, int n, AMSearchControl aMSearchControl, String string3) {
        String string4;
        if (this.searchReturnAttrs == null) {
            string4 = this.getSearchReturnAttribute(string);
            if (string4 == null) {
                this.searchReturnAttrs = new ArrayList(1);
                this.searchReturnAttrs.add(AdminInterfaceUtils.getNamingAttribute((int)n, (Debug)AMModelBase.debug));
            } else {
                this.searchReturnAttrs = this.getValidatedAttributes(string4, string2, n, string3);
            }
        }
        string4 = (String)this.searchReturnAttrs.get(0);
        String[] stringArray = new String[]{string4};
        aMSearchControl.setSortKeys(stringArray);
        aMSearchControl.setReturnAttributes(new HashSet(this.searchReturnAttrs));
    }

    protected List getValidatedAttributes(String string, String string2, int n, String string3) {
        List list;
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        if (string != null && string.length() > 0 && (list = this.getObjectDisplayList(string, string3)) != null && !list.isEmpty()) {
            arrayList = new ArrayList(list.size());
            Set set = this.getObjectAttributeNames(string2, n);
            if (set != null && !set.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (!set.contains(string4) || arrayList.contains(string4)) continue;
                    arrayList.add(string4);
                }
            }
        }
        if (arrayList == null || arrayList.isEmpty()) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)n, (Debug)AMModelBase.debug));
        }
        return arrayList;
    }

    public String getAttributeValue(String string, String string2) {
        Set set;
        Map map;
        String string3 = "";
        if (!(this.resultsMap == null || this.resultsMap.isEmpty() || (map = (Map)this.resultsMap.get(string)) == null || map.isEmpty() || (set = (Set)map.get(string2)) == null || set.isEmpty())) {
            string3 = this.getMultiValue(set);
        }
        return string3;
    }

    public List getSearchReturnAttributes(String string, int n, String string2) {
        if (this.searchReturnAttrs == null) {
            String string3 = this.getSearchReturnAttribute(this.locationDN);
            if (string3 == null) {
                this.searchReturnAttrs = new ArrayList(1);
                this.searchReturnAttrs.add(AdminInterfaceUtils.getNamingAttribute((int)n, (Debug)AMModelBase.debug));
            } else {
                this.searchReturnAttrs = this.getValidatedAttributes(string3, string, n, string2);
            }
        }
        return this.searchReturnAttrs;
    }

    public String getAttributeName(String string, int n, String string2) {
        this.getSearchReturnAttributes(string, n, string2);
        if (this.searchReturnAttrs.isEmpty()) {
            return AdminInterfaceUtils.getNamingAttribute((int)n, (Debug)AMModelBase.debug);
        }
        int n2 = this.searchReturnAttrs.size();
        return (String)this.searchReturnAttrs.get(n2 - 1);
    }

    public List getAttrSearchList() {
        return this.searchReturnAttrs;
    }

    public void setAttrSearchList(List list) {
        this.searchReturnAttrs = list;
    }

    public Map getAttrMap() {
        return this.resultsMap;
    }

    public void setAttrMap(Map map) {
        this.resultsMap = map;
    }

    protected String getMultiValue(Set set) {
        StringBuffer stringBuffer = new StringBuffer(25);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(this.getLocalizedString("multiValuedAttrSeparator") + " ");
                }
                stringBuffer.append((String)iterator.next());
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        userMgtMenu.add("organizations");
        userMgtMenu.add("policies");
        userMgtMenu.add("services");
        userMgtMenu.add("policyadministrator");
    }
}

