/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMMngGrpNavModel;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMMngGrpNavModelImpl
extends UMNavModelImpl
implements UMMngGrpNavModel {
    private Set mngGroups = null;
    private AMGroup group = null;
    private ServiceSchemaManager entrySpecificSvcMgr = null;

    public UMMngGrpNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public void setManagedGroups(Set set) {
        this.mngGroups = set == null || set.isEmpty() ? Collections.EMPTY_SET : set;
    }

    public Set getManagedGroups(String string) {
        if (this.mngGroups != null) {
            return this.mngGroups;
        }
        AMSearchResults aMSearchResults = null;
        AMStaticGroup aMStaticGroup = null;
        Set set = null;
        Iterator iterator = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(1);
        try {
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    this.setSearchControlAttributes(this.locationDN, "Group", 9, aMSearchControl, "groups");
                    this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                    set = aMOrganization.getGroupContainers(1);
                    iterator = set.iterator();
                    if (iterator.hasNext()) {
                        AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer((String)iterator.next());
                        aMSearchResults = aMGroupContainer.searchGroups(string, null, aMSearchControl);
                        break;
                    }
                    aMSearchResults = aMOrganization.searchGroups(string, null, aMSearchControl);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlAttributes(this.locationDN, "Group", 9, aMSearchControl, "groups");
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    set = aMOrganizationalUnit.getGroupContainers(1);
                    iterator = set.iterator();
                    if (iterator.hasNext()) {
                        AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer((String)iterator.next());
                        aMSearchResults = aMGroupContainer.searchGroups(string, null, aMSearchControl);
                        break;
                    }
                    aMSearchResults = aMOrganizationalUnit.searchGroups(string, null, aMSearchControl);
                    break;
                }
                case 4: {
                    AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(this.locationDN);
                    this.setSearchControlAttributes(this.locationDN, "Group", 9, aMSearchControl, "groups");
                    this.setSearchControlLimits((AMObject)this.dpStoreConn.getOrganization(aMGroupContainer.getOrganizationDN()), aMSearchControl);
                    aMSearchResults = aMGroupContainer.searchGroups(string, null, aMSearchControl);
                    break;
                }
                case 9: 
                case 10: {
                    aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    this.setSearchControlAttributes(this.locationDN, "Group", 9, aMSearchControl, "groups");
                    this.setSearchControlLimits((AMObject)this.dpStoreConn.getOrganization(aMStaticGroup.getOrganizationDN()), aMSearchControl);
                    aMSearchResults = aMStaticGroup.searchGroups(string, null, aMSearchControl);
                    break;
                }
                case 11: {
                    aMStaticGroup = this.dpStoreConn.getDynamicGroup(this.locationDN);
                    this.setSearchControlAttributes(this.locationDN, "Group", 9, aMSearchControl, "groups");
                    this.setSearchControlLimits((AMObject)this.dpStoreConn.getOrganization(aMStaticGroup.getOrganizationDN()), aMSearchControl);
                    aMSearchResults = aMStaticGroup.searchGroups(string, null, aMSearchControl);
                    break;
                }
                case 12: {
                    aMStaticGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    this.setSearchControlAttributes(this.locationDN, "Group", 9, aMSearchControl, "groups");
                    this.setSearchControlLimits((AMObject)this.dpStoreConn.getOrganization(aMStaticGroup.getOrganizationDN()), aMSearchControl);
                    aMSearchResults = aMStaticGroup.searchGroups(string, null, aMSearchControl);
                    break;
                }
                default: {
                    if (AMModelBase.debug.warningEnabled()) {
                        AMModelBase.debug.warning("UMMngGrpNavModelImpl.getManagedGroup invalid location " + this.locationType);
                    }
                    break;
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMMngGrpNavModelImpl.getManagedGroup", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMMngGrpNavModelImpl.getManagedGroup", (Throwable)aMException);
            this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
        }
        if (aMSearchResults != null) {
            this.mngGroups = this.removeHiddenGroups(this.getSearchResultsSet(aMSearchResults));
            this.resultsMap = aMSearchResults.getResultAttributes();
        } else {
            this.mngGroups = Collections.EMPTY_SET;
        }
        return this.mngGroups;
    }

    private Set removeHiddenGroups(Set set) {
        if (this.isAdminGroupsEnabled() || this.locationType != 2 && this.locationType != 3 && this.locationType != 4) {
            return set;
        }
        OrderedSet orderedSet = new OrderedSet();
        String string = null;
        String string2 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = AMFormatUtils.DNToName(this, string, false);
            if (string2.equalsIgnoreCase("DomainAdministrators") || string2.equalsIgnoreCase("DomainHelpDeskAdministrators") || string2.equalsIgnoreCase("ServiceAdministrators") || string2.equalsIgnoreCase("ServiceHelpDeskAdministrators")) continue;
            orderedSet.add(string);
        }
        return orderedSet;
    }

    public String getSelectedOption() {
        return "groups";
    }

    public boolean deleteManagedGroups(Set set) {
        boolean bl = false;
        if (set != null) {
            try {
                Map map = this.deleteUMObject(9, set, "groupDeleted.message");
                if (!map.isEmpty()) {
                    Iterator iterator = map.keySet().iterator();
                    this.setErrorMessage(this.getLocalizedString("deleteGroupFailed.message"));
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = AMFormatUtils.DNToName(this, string, false);
                        String string3 = (String)map.get(string);
                        this.setErrorMessage(string2 + " - " + string3);
                    }
                } else {
                    bl = true;
                }
            }
            catch (AMConsoleException aMConsoleException) {
                this.setErrorMessage(this.getErrorString(aMConsoleException));
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public int getObjectType(String string) {
        int n = this.getGroupConfiguration();
        try {
            n = super.getObjectType(string);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMMngGrpNavModelImpl.getObjectType", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMMngGrpNavModelImpl.getObjectType", (Throwable)sSOException);
        }
        return n;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("groups.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noMngGrpSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noMngGrpSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.mngGroups;
    }

    public void setAttrList(Set set) {
        this.setManagedGroups(set);
    }

    public String getGroupsDisplayOffMessage() {
        return this.getLocalizedString("groupsDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMMngGrpNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }

    public List getSearchReturnAttributes() {
        return this.getSearchReturnAttributes("Group", 9, "groups");
    }

    protected List getValidatedAttributes(String string, String string2, int n, String string3) {
        List list;
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        if (string != null && string.length() > 0 && (list = this.getObjectDisplayList(string, string3)) != null && !list.isEmpty()) {
            arrayList = new ArrayList(list.size());
            Set set = this.getObjectAttributeNames(string2, n);
            Set set2 = this.getFilteredGroupAttributeNames();
            int n2 = 0;
            if (set != null && !set.isEmpty()) {
                n2 = set.size();
            }
            if (set2 != null && !set2.isEmpty()) {
                n2 += set2.size();
            }
            if (n2 > 0) {
                HashSet hashSet = new HashSet(n2);
                hashSet.addAll(set);
                hashSet.addAll(set2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (!hashSet.contains(string4) || arrayList.contains(string4)) continue;
                    arrayList.add(string4);
                }
            }
        }
        if (arrayList == null || arrayList.isEmpty()) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)n, (Debug)AMModelBase.debug));
        }
        return arrayList;
    }

    public String getAttributeValue(String string, String string2) {
        Map map;
        String string3 = "";
        if (this.resultsMap != null && !this.resultsMap.isEmpty() && (map = (Map)this.resultsMap.get(string)) != null && !map.isEmpty()) {
            Set set = (Set)map.get(string2);
            if (set == null || set.isEmpty()) {
                if (this.getLocationType(string) == 11 && this.getFilteredGroupAttributeNames().contains(string2)) {
                    set = this.getFilteredGroupAttributeValues(string);
                    string3 = this.getMultiValue(set);
                }
            } else {
                string3 = this.getMultiValue(set);
            }
        }
        return string3;
    }

    public String getAttributeLocalizedName(String string) {
        return this.getAttributeLocalizedName(string, "Group");
    }

    private Set getFilteredGroupAttributeNames() {
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "DynamicGroup");
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            hashSet = new HashSet<String>(set.size());
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string = attributeSchema.getName();
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private AMDynamicGroup getFilteredGroupObject(String string) {
        AMDynamicGroup aMDynamicGroup = null;
        try {
            aMDynamicGroup = this.dpStoreConn.getDynamicGroup(string);
            if (aMDynamicGroup == null || !aMDynamicGroup.isExists()) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("UMRoleNavModelImpl.getFilteredGroupObject group does not exists " + string);
                }
                aMDynamicGroup = null;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMRoleNavModelImpl.getFilteredGroupObject", (Throwable)sSOException);
        }
        return aMDynamicGroup;
    }

    private Set getFilteredGroupAttributeValues(String string) {
        Set set;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMDynamicGroup aMDynamicGroup = this.getFilteredGroupObject(string);
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (serviceSchemaManager != null && aMDynamicGroup != null && (set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "DynamicGroup")) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string2 = attributeSchema.getName();
                try {
                    if (string2.equals("filterinfo")) {
                        hashSet = new HashSet<String>(1);
                        hashSet.add(aMDynamicGroup.getFilter());
                        continue;
                    }
                    hashSet = aMDynamicGroup.getAttribute(string2);
                }
                catch (AMException aMException) {
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning("Could not get value for " + string2, (Throwable)aMException);
                }
                catch (SSOException sSOException) {
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning("Could not get value for " + string2, (Throwable)sSOException);
                }
            }
        }
        return hashSet;
    }

    public String getAttributeName() {
        return this.getAttributeName("Group", 9, "groups");
    }

    public String getAttributeValue(String string) {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return AMFormatUtils.DNToName(this, string);
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeValue(string, (String)this.searchReturnAttrs.get(n - 1));
    }
}

