/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMDataModelImpl;
import com.iplanet.am.console.user.model.UMGroupMemberEntry;
import com.iplanet.am.console.user.model.UMGroupMembersModel;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class UMGroupMembersModelImpl
extends UMDataModelImpl
implements UMGroupMembersModel {
    private AMGroup amGroup = this.getAMGroup(this.locationDN);
    private int searchErrorCode = 0;

    public UMGroupMembersModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getMembersTableHeader() {
        return this.getLocalizedString("members.header");
    }

    public String getActionLabel() {
        return this.getLocalizedString("action.label");
    }

    public String getAvailableActionsLabel() {
        return this.getLocalizedString("groupMembershipActions.label");
    }

    public String getCreateGroupActionLabel() {
        return this.getLocalizedString("groupCreateGroupAction.label");
    }

    public String getCreateUserActionLabel() {
        return this.getLocalizedString("groupCreateUserAction.label");
    }

    public String getAddGroupActionLabel() {
        return this.getLocalizedString("groupAddGroupAction.label");
    }

    public String getAddUserActionLabel() {
        return this.getLocalizedString("groupAddUserAction.label");
    }

    public String getDeleteMembersActionLabel() {
        return this.getLocalizedString("groupDeleteMembersAction.label");
    }

    public String getRemoveMembersActionLabel() {
        return this.getLocalizedString("groupRemoveMembersAction.label");
    }

    public String getMembershipTableNameHeader() {
        return this.getLocalizedString("groupMemberName.label");
    }

    public String getMembershipTableUserIDHeader() {
        return this.getLocalizedString("groupMemberUserID.label");
    }

    public String getNoEntriesMessage() {
        return this.getLocalizedString("noEntries.message");
    }

    public String getEditLabel() {
        return this.getLocalizedString("edit.label");
    }

    public String getNoEntriesSelectedForDeletionMessage() {
        return this.getLocalizedString("noGroupMemberSelectedForDeletion.message");
    }

    public String getNoEntriesSelectedForRemovalMessage() {
        return this.getLocalizedString("noGroupMemberSelectedForRemoval.message");
    }

    private void searchUsersInGroup(String string, List list) throws AMException, SSOException {
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(1);
        HashSet<String> hashSet = new HashSet<String>(2);
        hashSet.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        aMSearchControl.setReturnAttributes(hashSet);
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.getUserOrganization());
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        String string2 = this.getSearchFilter(aMOrganization.getDN(), string);
        AMSearchResults aMSearchResults = this.amGroup.searchUsers(aMSearchControl, string2);
        this.searchErrorCode = aMSearchResults.getErrorCode();
        Set set = aMSearchResults.getSearchResults();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                UMGroupMemberEntry uMGroupMemberEntry = this.getUserMemberEntry(string3, string);
                if (uMGroupMemberEntry == null) continue;
                list.add(uMGroupMemberEntry);
            }
        }
    }

    private String getSearchFilter(String string, String string2) throws SSOException {
        String string3 = this.getUserSearchKey(string);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("(").append(string3).append("=").append(string2).append(")");
        return stringBuffer.toString();
    }

    private String getUserSearchKey(String string) {
        String string2 = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate(string);
            if (aMTemplate != null) {
                string2 = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-search-key");
                if (AMModelBase.debug.messageEnabled()) {
                    AMModelBase.debug.message("UMGroupMembersModelImpl.getUserSearchKey():obtained from org template " + string2);
                }
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string2 = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-search-key");
                    if (AMModelBase.debug.messageEnabled()) {
                        AMModelBase.debug.message("UMGroupMembersModelImpl.getUserSearchKey:obtained from schema " + string2);
                    }
                }
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getUserSearchKey", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getUserSearchKey", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getUserSearchKey", (Throwable)aMException);
        }
        if (string2 == null) {
            string2 = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        }
        return string2;
    }

    public List getMembers(String string) throws AMConsoleException {
        ArrayList<UMGroupMemberEntry> arrayList = Collections.EMPTY_LIST;
        if (this.amGroup != null) {
            arrayList = new ArrayList<UMGroupMemberEntry>();
            try {
                this.searchUsersInGroup(string, arrayList);
                Set set = this.amGroup.getNestedGroupDNs();
                if (set != null && !set.isEmpty()) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        UMGroupMemberEntry uMGroupMemberEntry = this.getGroupMemberEntry(string2, string);
                        if (uMGroupMemberEntry == null) continue;
                        arrayList.add(uMGroupMemberEntry);
                    }
                }
                Collections.sort(arrayList, new UMGroupMemberEntry(this.getUserLocale()));
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.getMembers", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.getMembers", (Throwable)aMException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
        }
        return arrayList;
    }

    private UMGroupMemberEntry getUserMemberEntry(String string, String string2) {
        UMGroupMemberEntry uMGroupMemberEntry = null;
        try {
            AMUser aMUser = this.dpStoreConn.getUser(string);
            if (aMUser != null && aMUser.isExists()) {
                String string3 = AMAdminUtils.getFirstElement(aMUser.getAttribute("cn"));
                String string4 = AMFormatUtils.DNToName(this, string);
                uMGroupMemberEntry = new UMGroupMemberEntry(string, string3, 1, string4);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getUserMemberEntry", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getUserMemberEntry", (Throwable)aMException);
        }
        return uMGroupMemberEntry;
    }

    private UMGroupMemberEntry getGroupMemberEntry(String string, String string2) {
        UMGroupMemberEntry uMGroupMemberEntry = null;
        AMGroup aMGroup = this.getAMGroup(string);
        try {
            String string3;
            if (aMGroup != null && aMGroup.isExists() && DisplayUtils.wildcardMatch((String)(string3 = AMFormatUtils.DNToName(this, string)), (String)string2)) {
                uMGroupMemberEntry = new UMGroupMemberEntry(string, string3, 9, "");
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getGroupMemberEntry", (Throwable)sSOException);
        }
        return uMGroupMemberEntry;
    }

    private AMGroup getAMGroup(String string) {
        AMGroup aMGroup = null;
        int n = this.getLocationType(string);
        switch (n) {
            case 11: {
                aMGroup = this.getDynamicGroup(string);
                break;
            }
            case 12: {
                aMGroup = this.getAssignableDynamicGroup(string);
                break;
            }
            case 9: 
            case 10: {
                aMGroup = this.getStaticGroup(string);
            }
        }
        return aMGroup;
    }

    private AMGroup getDynamicGroup(String string) {
        AMDynamicGroup aMDynamicGroup = null;
        try {
            aMDynamicGroup = this.dpStoreConn.getDynamicGroup(string);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getDynamicGroup", (Throwable)sSOException);
        }
        return aMDynamicGroup;
    }

    private AMGroup getAssignableDynamicGroup(String string) {
        AMAssignableDynamicGroup aMAssignableDynamicGroup = null;
        try {
            aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(string);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAssignableDynamicGroup", (Throwable)sSOException);
        }
        return aMAssignableDynamicGroup;
    }

    private AMGroup getStaticGroup(String string) {
        AMStaticGroup aMStaticGroup = null;
        try {
            aMStaticGroup = this.dpStoreConn.getStaticGroup(string);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getStaticGroup", (Throwable)sSOException);
        }
        return aMStaticGroup;
    }

    public void removeUsers(Set set) throws AMConsoleException {
        if (set != null && !set.isEmpty()) {
            try {
                switch (this.locationType) {
                    case 9: 
                    case 10: {
                        AMStaticGroup aMStaticGroup = (AMStaticGroup)this.getAMObject(this.locationDN);
                        aMStaticGroup.removeUsers(set);
                        this.writeLog("removedUserFromGroup.message", aMStaticGroup.getDN(), set);
                    }
                    case 12: {
                        AMStaticGroup aMStaticGroup = (AMAssignableDynamicGroup)this.getAMObject(this.locationDN);
                        aMStaticGroup.removeUsers(set);
                        this.writeLog("removedUserFromGroup.message", aMStaticGroup.getDN(), set);
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.removeUsers", (Throwable)sSOException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.removeUsers", (Throwable)aMException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
        }
    }

    public void removeNestedGroups(Set set) throws AMConsoleException {
        if (set != null && !set.isEmpty()) {
            try {
                if (this.amGroup != null) {
                    this.amGroup.removeNestedGroups(set);
                    this.writeLog("removedNestedGroupFromGroup.message", this.amGroup.getDN(), set);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.removeNestedGroups", (Throwable)sSOException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.removeNestedGroups", (Throwable)aMException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
        }
    }

    public void deleteUsers(Set set) throws AMConsoleException {
        if (set != null && !set.isEmpty()) {
            try {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    AMUser aMUser = this.getAMUserForDeletion(string);
                    if (aMUser == null) continue;
                    aMUser.delete(true);
                    this.logger.doLog("userDeleted.message", string);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.deleteUsers", (Throwable)sSOException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.deleteUsers", (Throwable)aMException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
        }
    }

    private AMUser getAMUserForDeletion(String string) {
        AMUser aMUser = null;
        try {
            aMUser = (AMUser)this.getAMObject(string);
            if (aMUser == null || !aMUser.isExists()) {
                aMUser = null;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAMUserForDeletion", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAMUserForDeletion", (Throwable)aMException);
        }
        return aMUser;
    }

    private AMGroup getAMGroupForDeletion(String string) {
        AMGroup aMGroup = null;
        try {
            aMGroup = (AMGroup)this.getAMObject(string);
            if (aMGroup == null || !aMGroup.isExists()) {
                aMGroup = null;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAMGroupForDeletion", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMGroupMembersModelImpl.getAMGroupForDeletion", (Throwable)aMException);
        }
        return aMGroup;
    }

    public void deleteNestedGroups(Set set) throws AMConsoleException {
        if (set != null && !set.isEmpty()) {
            try {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    AMGroup aMGroup = this.getAMGroupForDeletion(string);
                    if (aMGroup == null) continue;
                    aMGroup.delete(true);
                    this.logger.doLog("groupDeleted.message", string);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.deleteUsers", (Throwable)sSOException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMGroupMembersModelImpl.deleteUsers", (Throwable)aMException);
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
        }
    }

    public boolean isDynamicGroup() {
        return this.locationType == 11;
    }

    private void writeLog(String string, String string2, Set set) {
        if (this.logger.isEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(this.getLocalizedString(string)).append(" " + string2).append(":" + set);
            this.logger.doLog(stringBuffer.toString());
        }
    }

    public String getNoPrivilegeToDeleteUsersMessage() {
        return this.getLocalizedString("noPrivilegeToDeleteUsers.message");
    }

    public String getNoPrivilegeToDeleteGroupsMessage() {
        return this.getLocalizedString("noPrivilegeToDeleteGroups.message");
    }

    public String getSearchErrorMessage() {
        String string = null;
        switch (this.searchErrorCode) {
            case 1: {
                string = this.getLocalizedString("sizeLimitExceeded.message");
                break;
            }
            case 2: {
                string = this.getLocalizedString("timeLimitExceeded.message");
            }
        }
        return string;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("filteredGroupUsers.help");
        if (string.equals("filteredGroupUsers.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean canManageGroup(String string) {
        Set set = this.getTopLevelContainers();
        boolean bl = false;
        if (set != null && !set.isEmpty()) {
            DN dN = new DN(string);
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && !bl) {
                DN dN2 = new DN((String)iterator.next());
                bl = dN.isDescendantOf(dN2);
            }
        }
        return bl;
    }
}

