/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMGroupContainerProfileModel;
import com.iplanet.am.console.user.model.UMProfileModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMGroupContainerProfileModelImpl
extends UMProfileModelImpl
implements UMGroupContainerProfileModel {
    private AMGroupContainer groupContainer = null;

    public UMGroupContainerProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        AMModelBase.debug.message("UMGroupContainerProfileModelImpl.modify");
        boolean bl = false;
        try {
            AMGroupContainer aMGroupContainer = this.getAMGroupContainer();
            if (aMGroupContainer != null) {
                this.fireBeforeUpdateValuesEvent(4, (AMObject)aMGroupContainer, map);
                bl = this.setAttributes((AMObject)aMGroupContainer, map, "groupContainerChanged.message");
                this.fireAfterUpdateValuesEvent(4, (AMObject)aMGroupContainer);
            } else if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMGroupContainerProfileModelImpl.modify: group container does not exists");
                this.errorMessage = this.getLocalizedString("noGroupContainer.message");
            }
        }
        catch (AMConsoleException aMConsoleException) {
            this.errorMessage = this.getErrorString(aMConsoleException);
        }
        return bl;
    }

    public List getDynamicGUIComponents() {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMGroupContainer aMGroupContainer = this.getAMGroupContainer();
        if (serviceSchemaManager != null && aMGroupContainer != null) {
            Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "GroupContainer");
            Map map = this.getGroupContainerAttributeValues(aMGroupContainer, set);
            this.fireRetrieveAttributeValuesEvent((AMObject)aMGroupContainer, 2, 4, "iPlanetAMEntrySpecificService", SchemaType.GLOBAL, map);
            AMAdminUtils.excludeAttributeSchemas(set, map.keySet());
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                Set set2;
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMEntrySpecificService", set2 = (Set)map.get(string = attributeSchema.getName()), this, Setting.ACTION_GROUP_CONTAINER);
                if (dynamicGUI == null) continue;
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    private Map getGroupContainerAttributeValues(AMGroupContainer aMGroupContainer, Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            String string = attributeSchema.getName();
            try {
                Set set2 = aMGroupContainer.getAttribute(string);
                if (set2 == null) {
                    set2 = Collections.EMPTY_SET;
                }
                hashMap.put(string, set2);
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("UMGroupContainerProfileModelImpl.getGroupContainerAttributeValues: could not get value for " + string, (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("UMGroupContainerProfileModelImpl.getGroupContainerAttributeValues", (Throwable)sSOException);
            }
        }
        return hashMap;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateGroupContainer.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("groupContainerProfile.help");
        if (string.equals("groupContainerProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isGroupContainerValid() {
        return this.getAMGroupContainer() != null;
    }

    public String getInvalidGroupContainerMessage() {
        return this.getLocalizedString("invalidGroupContainerProfile.message");
    }

    private AMGroupContainer getAMGroupContainer() {
        if (this.groupContainer == null) {
            try {
                this.groupContainer = this.dpStoreConn.getGroupContainer(this.profileDN);
                if (!this.groupContainer.isExists()) {
                    this.groupContainer = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMGroupContainerProfileModelImpl.getAMGroupContainer", (Throwable)sSOException);
                this.groupContainer = null;
            }
        }
        return this.groupContainer;
    }
}

