/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMDataModelImpl;
import com.iplanet.am.console.user.model.UMFilteredGroupProfileModel;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMFilteredGroupProfileModelImpl
extends UMDataModelImpl
implements UMFilteredGroupProfileModel {
    private AMDynamicGroup groupObject = null;

    public UMFilteredGroupProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        if (map == null || map.isEmpty()) {
            return true;
        }
        boolean bl = false;
        try {
            AMDynamicGroup aMDynamicGroup = this.getAMDynamicGroup();
            if (aMDynamicGroup != null) {
                ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
                Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "DynamicGroup");
                if (set != null && !set.isEmpty()) {
                    try {
                        this.fireBeforeUpdateValuesEvent(11, (AMObject)aMDynamicGroup, map);
                        Set set2 = (Set)map.remove("filterinfo");
                        if (set2 == null || set2.isEmpty()) {
                            throw new AMConsoleException(this.getLocalizedString("cannotRemoveFilter.message"));
                        }
                        String string = (String)set2.iterator().next();
                        aMDynamicGroup.setFilter(string);
                        this.logger.doLog("groupFilterModified.message", aMDynamicGroup.getDN());
                        this.setAttributes((AMObject)aMDynamicGroup, map, "attribute.change");
                        this.fireAfterUpdateValuesEvent(11, (AMObject)aMDynamicGroup);
                        bl = true;
                    }
                    catch (AMConsoleException aMConsoleException) {
                        this.errorMessage = this.getErrorString(aMConsoleException);
                    }
                }
            } else {
                this.errorMessage = this.getLocalizedString("nogroup.message");
            }
        }
        catch (AMException aMException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("Could not set the filter for " + this.profileDN, (Throwable)aMException);
            }
            this.errorMessage = this.getErrorString((Exception)((Object)aMException));
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMFilteredGroupProfileModelImpl.modify", (Throwable)sSOException);
        }
        return bl;
    }

    public List getDynamicGUIComponents() {
        Set set;
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMDynamicGroup aMDynamicGroup = this.getAMDynamicGroup();
        if (serviceSchemaManager != null && aMDynamicGroup != null && (set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "DynamicGroup")) != null && !set.isEmpty()) {
            Map map = this.getGroupAttributeValues(aMDynamicGroup, set);
            this.fireRetrieveAttributeValuesEvent((AMObject)aMDynamicGroup, 2, 11, "iPlanetAMEntrySpecificService", SchemaType.GLOBAL, map);
            AMAdminUtils.excludeAttributeSchemas(set, map.keySet());
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                Set set2;
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMEntrySpecificService", set2 = (Set)map.get(string = attributeSchema.getName()), this, Setting.ACTION_GROUP);
                if (dynamicGUI == null) continue;
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    private Map getGroupAttributeValues(AMDynamicGroup aMDynamicGroup, Set set) {
        HashMap hashMap = new HashMap(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            String string = attributeSchema.getName();
            try {
                HashSet<String> hashSet = null;
                if (string.equals("filterinfo")) {
                    hashSet = new HashSet<String>(1);
                    hashSet.add(aMDynamicGroup.getFilter());
                } else {
                    hashSet = aMDynamicGroup.getAttribute(string);
                }
                hashMap.put(string, hashSet);
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("Could not get value for " + string, (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.warningEnabled()) continue;
                AMModelBase.debug.warning("Could not get value for " + string, (Throwable)sSOException);
            }
        }
        return hashMap;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateGroup.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("filteredGroupProfile.help");
        if (string.equals("filteredGroupProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    private AMDynamicGroup getAMDynamicGroup() {
        if (this.groupObject == null) {
            try {
                this.groupObject = this.dpStoreConn.getDynamicGroup(this.profileDN);
                if (!this.groupObject.isExists()) {
                    this.groupObject = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMFilteredGroupProfileModelImpl.getAMDynamicGroup", (Throwable)sSOException);
            }
        }
        return this.groupObject;
    }

    public boolean isGroupExists() {
        return this.getAMDynamicGroup() != null;
    }

    public String getInvalidGroupMessage() {
        return this.getLocalizedString("invalidGroupProfile.message");
    }
}

