/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMEntityNavModel;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMEntityNavModelImpl
extends UMNavModelImpl
implements UMEntityNavModel {
    private Set entities = null;
    private String viewType = null;
    private String serviceName = null;
    private static final String DELETE_ENTITY_FAILED_DESC = "delete-entity-failed-description";
    private static final String NO_ENTITY_SELECT_TITLE = "no-entity-select-title";
    private static final String NO_ENTITY_SELECT_DESC = "no-entity-select-description";
    private static final String ENTITY_DISPLAY_OFF_DESC = "entity-display-off-description";

    public UMEntityNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectedOption() {
        return this.viewType;
    }

    public Set getEntities(String string) {
        if (this.entities == null) {
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            try {
                switch (this.locationType) {
                    case 2: {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        aMSearchResults = this.getEntities(aMOrganization, string, aMSearchControl);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        aMSearchResults = this.getEntities(aMOrganizationalUnit, string, aMSearchControl);
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMEntityNavModelImpl.getEntities invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMEntityNavModelImpl.getEntities", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMEntityNavModelImpl.getEntities", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            this.entities = aMSearchResults != null ? this.getSearchResultsSet(aMSearchResults) : Collections.EMPTY_SET;
        }
        return this.entities;
    }

    private AMSearchResults getEntities(AMOrganization aMOrganization, String string, AMSearchControl aMSearchControl) throws SSOException, AMException {
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        aMSearchControl.setSearchScope(1);
        Map map = this.getEntityTypesMap();
        AMEntityType aMEntityType = (AMEntityType)map.get(this.viewType);
        int n = aMEntityType.getType();
        String[] stringArray = new String[1];
        stringArray[0] = AMStoreConnection.getNamingAttribute((int)n);
        String[] stringArray2 = stringArray;
        aMSearchControl.setSortKeys(stringArray2);
        return aMOrganization.searchEntities(n, string, new HashMap(), aMSearchControl);
    }

    private AMSearchResults getEntities(AMOrganizationalUnit aMOrganizationalUnit, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
        aMSearchControl.setSearchScope(1);
        Map map = this.getEntityTypesMap();
        AMEntityType aMEntityType = (AMEntityType)map.get(this.viewType);
        String[] stringArray = new String[1];
        stringArray[0] = AMStoreConnection.getNamingAttribute((int)aMEntityType.getType());
        String[] stringArray2 = stringArray;
        aMSearchControl.setSortKeys(stringArray2);
        return aMOrganizationalUnit.searchEntities(string, null, aMEntityType.getSearchTemplate(), aMSearchControl);
    }

    public boolean deleteEntities(Set set) throws AMConsoleException {
        boolean bl = false;
        if (set != null) {
            Map map = this.deleteEntities(set, "entitiesDeleted.message");
            if (!map.isEmpty()) {
                Object[] objectArray = new String[]{this.getL10NAttributeName(this.serviceName, DELETE_ENTITY_FAILED_DESC)};
                this.setErrorMessage(MessageFormat.format(this.getLocalizedString("deleteEntityFailed.message"), objectArray));
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = AMFormatUtils.DNToName(this, string, false);
                    String string3 = (String)map.get(string);
                    this.setErrorMessage(string2 + " - " + string3);
                }
            } else {
                bl = true;
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("entities.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        Object[] objectArray = new String[]{this.getL10NAttributeName(this.serviceName, NO_ENTITY_SELECT_TITLE)};
        return MessageFormat.format(this.getLocalizedString("noEntitySelectForDeletion.title"), objectArray);
    }

    public String getNoEntrySelectedForDelMessage() {
        Object[] objectArray = new String[]{this.getL10NAttributeName(this.serviceName, NO_ENTITY_SELECT_DESC)};
        return MessageFormat.format(this.getLocalizedString("noEntitySelectForDeletion.message"), objectArray);
    }

    public Set getAttrList() {
        return this.entities;
    }

    public void setAttrList(Set set) {
        this.entities = set;
    }

    public String getEntityDisplayOffMessage() {
        Object[] objectArray = new String[]{this.getL10NAttributeName(this.serviceName, ENTITY_DISPLAY_OFF_DESC)};
        return MessageFormat.format(this.getLocalizedString("entitiesDisplayOff.message"), objectArray);
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMEntityNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }

    protected Map deleteEntities(Set set, String string) throws AMConsoleException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (set != null && !set.isEmpty()) {
            int n = set.size();
            this.errorMessage = new ArrayList(n);
            HashSet<String> hashSet = new HashSet<String>(n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMEntity aMEntity;
                String string2;
                block8: {
                    string2 = (String)iterator.next();
                    aMEntity = null;
                    try {
                        aMEntity = this.dpStoreConn.getEntity(string2);
                        if (aMEntity == null || !aMEntity.isExists()) {
                            if (!AMModelBase.debug.warningEnabled()) continue;
                            AMModelBase.debug.warning("skipping " + string2 + ", no object found for it.");
                        }
                        break block8;
                    }
                    catch (SSOException sSOException) {
                        AMModelBase.debug.warning("UMEntityNavModelImpl.deleteEntities", (Throwable)sSOException);
                    }
                    continue;
                }
                try {
                    aMEntity.delete(true);
                    String string3 = this.getL10NAttributeName(this.serviceName, "log-entity-name");
                    this.writeFormatLog(string, string3, string2);
                    hashSet.add(string2);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMEntityNavModelImpl.deleteEntities", (Throwable)aMException);
                    hashMap.put(string2, aMException.getLocalizedMessage());
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("UMEntityNavModelImpl.deleteEntities", (Throwable)sSOException);
                    hashMap.put(string2, sSOException.getLocalizedMessage());
                }
            }
        }
        return hashMap;
    }

    public void setValues(String string) {
        this.viewType = string;
        Map map = this.getEntityTypesMap();
        AMEntityType aMEntityType = (AMEntityType)map.get(this.viewType);
        this.serviceName = aMEntityType.getServiceName();
    }
}

