/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMMenuValidator;
import com.iplanet.am.console.base.model.AMMenuValidatorImpl;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.user.model.UMDataModel;
import com.iplanet.am.console.user.model.UMProfileModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMDataModelImpl
extends UMProfileModelImpl
implements UMDataModel {
    public UMDataModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getShowLabel() {
        return this.getLocalizedString("view.label");
    }

    public List getShowMenuOptions() {
        List list = Collections.EMPTY_LIST;
        if (this.profileDN == null) {
            this.profileDN = this.startDN;
        }
        int n = -1;
        try {
            n = this.getObjectType(this.profileDN);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMDataModelImpl.getShowMenuOptions", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMDataModelImpl.getShowMenuOptions", (Throwable)sSOException);
        }
        switch (n) {
            case 2: {
                list = this.getOrganizationMenu();
                break;
            }
            case 3: {
                list = this.getOrganizationalUnitMenu();
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                list = this.getGroupMenu();
                break;
            }
            case 6: 
            case 8: {
                list = this.getRoleMenu();
                break;
            }
            default: {
                AMModelBase.debug.error("UMDataModelImpl.getShowMenuOptions: Unknown location type - Unable to get menu options");
            }
        }
        return list;
    }

    public Class getViewBeanTypeClass(String string) {
        return AMAdminUtils.getProfileViewBeanClass(this, this.profileDN, string);
    }

    private List getOrganizationMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("general");
        arrayList.add("displayoptions");
        arrayList.add("permissions");
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        this.removeHiddenOptions(aMMenuValidator.getOrganizationProfileMenuOptions(this), arrayList);
        return arrayList;
    }

    private List getOrganizationalUnitMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("general");
        arrayList.add("displayoptions");
        arrayList.add("permissions");
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        this.removeHiddenOptions(aMMenuValidator.getOrganizationalUnitProfileMenuOptions(this), arrayList);
        return arrayList;
    }

    protected List getGroupMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("general");
        if (this.showUsers()) {
            arrayList.add("members");
        }
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        this.removeHiddenOptions(aMMenuValidator.getGroupProfileMenuOptions(this), arrayList);
        return arrayList;
    }

    protected List getRoleMenu() {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        arrayList.add("general");
        if (this.showUsers()) {
            arrayList.add("users");
        }
        if (!(string2 = AMAdminUtils.getParent(this.locationDN)).equalsIgnoreCase(string = AMSystemConfig.rootSuffix) || string.equalsIgnoreCase(AMSystemConfig.defaultOrg) && string2.equalsIgnoreCase(string)) {
            arrayList.add("services");
        }
        arrayList.add("displayoptions");
        arrayList.add("permissions");
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        this.removeHiddenOptions(aMMenuValidator.getRoleProfileMenuOptions(this), arrayList);
        return arrayList;
    }

    private void removeHiddenOptions(Set set, List list) {
        if (set != null) {
            if (!set.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (set.contains(iterator.next())) continue;
                    iterator.remove();
                }
            } else {
                list.clear();
            }
        }
    }
}

