/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMCreateSvcTemplateModel;
import com.iplanet.am.console.user.model.UMUserModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMCreateSvcTemplateModelImpl
extends UMUserModelImpl
implements UMCreateSvcTemplateModel {
    private String propsUrl = null;

    public UMCreateSvcTemplateModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getCreateTemplateTitle() {
        return this.getLocalizedString("createTemplate.title");
    }

    public String getCreateTemplateMessage() {
        return this.getLocalizedString("createTemplate.message");
    }

    public String getNoTemplateMessage() {
        return this.getLocalizedString("noTemplate.message");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public String getPropertiesUrl() {
        return this.propsUrl;
    }

    public void createServiceTemplate(String string) throws AMConsoleException {
        AMObject aMObject = this.getCurrentObj();
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            Set set = AMAdminUtils.getUserManagementSchemaTypes(serviceSchemaManager, this.locationType);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SchemaType schemaType = (SchemaType)iterator.next();
                if (schemaType == null) continue;
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
                if (this.propsUrl == null || this.propsUrl.length() == 0) {
                    this.propsUrl = this.getPropsUrl(serviceSchema);
                }
                Map map = serviceSchema.getAttributeDefaults();
                int n = 301;
                if (schemaType.equals((Object)SchemaType.ORGANIZATION)) {
                    n = 302;
                    if (string.equals("iPlanetAMAuthService") && map != null) {
                        this.setUserContainerAttribute(map);
                    }
                }
                this.fireBeforeCreateObjectEvent(13, aMObject, "", map);
                AMTemplate aMTemplate = null;
                aMTemplate = n == 301 ? aMObject.createTemplate(n, string, map, 0) : aMObject.createTemplate(n, string, map);
                this.fireAfterCreateObjectEvent((AMObject)aMTemplate);
                this.writeFormatLog("template.created", string, this.locationDN);
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMCreateSvcTemplateModelImpl.createServiceTemplate", (Throwable)sMSException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMCreateSvcTemplateModelImpl.createServiceTemplate", (Throwable)sSOException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMCreateSvcTemplateModelImpl.createServiceTemplate", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
    }

    private String getPropsUrl(ServiceSchema serviceSchema) {
        return serviceSchema.getPropertiesViewBeanURL();
    }

    private AMObject getCurrentObj() throws AMConsoleException {
        AMOrganization aMOrganization = null;
        try {
            int n = this.getObjectType(this.locationDN);
            switch (n) {
                case 2: {
                    aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    break;
                }
                case 3: {
                    aMOrganization = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    aMOrganization = this.dpStoreConn.getRole(this.locationDN);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("createTemplateInvalidType.message"));
                }
            }
        }
        catch (AMException aMException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMCreateSvcTemplateModelImpl.getCurrentObj, ", (Throwable)aMException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMCreateSvcTemplateModelImpl.getCurrentObj, ", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        return aMOrganization;
    }

    private void setUserContainerAttribute(Map map) {
        AMOrganizationalUnit aMOrganizationalUnit;
        Set set = (Set)map.get("iplanet-am-auth-user-container");
        String string = null;
        String string2 = null;
        if (set != null && !set.isEmpty() && (aMOrganizationalUnit = set.iterator()).hasNext() && this.isPeopleContainer(string = (String)aMOrganizationalUnit.next())) {
            string2 = string;
        }
        if (string2 == null && this.isPeopleContainer(string = string + "," + this.locationDN)) {
            string2 = string;
        }
        if (string2 == null) {
            try {
                if (this.locationType == 2) {
                    aMOrganizationalUnit = this.dpStoreConn.getOrganization(this.locationDN);
                    set = aMOrganizationalUnit.getPeopleContainers(1);
                } else if (this.locationType == 3) {
                    aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    set = aMOrganizationalUnit.getPeopleContainers(1);
                }
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("UMCreateSvcTemplateModelImpl.setUserContainerAttribute: cant get set of people containers, using the default people container.");
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMCreateSvcTemplateModelImpl.setUserContainerAttribute", (Throwable)sSOException);
            }
            if (set != null && !set.isEmpty() && (aMOrganizationalUnit = set.iterator()).hasNext()) {
                string2 = (String)aMOrganizationalUnit.next();
            }
        }
        if (string2 == null || string2.length() == 0) {
            string2 = AdminInterfaceUtils.getNamingAttribute((int)5, (Debug)AMModelBase.debug) + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + this.locationDN;
        }
        aMOrganizationalUnit = new HashSet(1);
        aMOrganizationalUnit.add(string2);
        map.put("iplanet-am-auth-user-container", aMOrganizationalUnit);
    }

    public String getCreatePageTitle() {
        return this.canCreateTemplate() ? this.getLocalizedString("createTemplatePage.title") : this.getLocalizedString("templatePage.title");
    }

    public boolean isLocationRole() {
        return this.locationType == 6 || this.locationType == 8;
    }

    public String getSvcTypeLocalizedName(String string) {
        return this.getLocalizedServiceName(string);
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createServiceTemplate.help");
        if (string.equals("createServiceTemplate.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean canCreateTemplate() {
        boolean bl = false;
        bl = this.isLocationRole() ? this.canPerform(Setting.ACTION_SERVICE, "modifyproperties") : this.canPerform(Setting.ACTION_SERVICE, "fullaccessobject");
        return bl;
    }
}

