/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.user.model.UMCreateEntityModel;
import com.iplanet.am.console.user.model.UMCreateModelImpl;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMCreateEntityModelImpl
extends UMCreateModelImpl
implements UMCreateEntityModel {
    private String serviceName = null;
    private String viewName = null;
    private static final String CREATE_ENTITY_DESC = "create-entity-description";
    private static final String CREATE_ENTITY_FAILED_TITLE = "create-entity-failed-title";

    public UMCreateEntityModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getTitle() {
        Object[] objectArray = new String[]{this.getL10NAttributeName(this.serviceName, CREATE_ENTITY_DESC)};
        return MessageFormat.format(this.getLocalizedString("createEntity.title"), objectArray);
    }

    public String getErrorTitle() {
        Object[] objectArray = new String[]{this.getL10NAttributeName(this.serviceName, CREATE_ENTITY_FAILED_TITLE)};
        return MessageFormat.format(this.getLocalizedString("createEntityEntryFailed.title"), objectArray);
    }

    public List getRequiredAttributes() {
        if (this.requiredAttributes == null) {
            this.buildRequiredAttributeList();
        }
        return this.requiredAttributes;
    }

    public int getNumRequiredAttributes() {
        if (this.requiredAttributes == null) {
            this.buildRequiredAttributeList();
        }
        return this.requiredAttributes.size();
    }

    private void buildRequiredAttributeList() {
        this.requiredAttributes = Collections.EMPTY_LIST;
        try {
            ServiceSchema serviceSchema;
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(this.serviceName);
            if (serviceSchemaManager != null && (serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER)) != null) {
                Set set = serviceSchema.getAttributeSchemas();
                this.requiredAttributes = AMFormatUtils.sortAttrSchema(this.retainAttributeSchemasWithI18nKeys(set), this.getUserLocale());
                this.getMapAttributeValues();
                this.getAttributeLabels(serviceSchemaManager);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMCreateEntityModelImpl.buildRequiredAttributeList", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMCreateEntityModelImpl.buildRequiredAttributeList", (Throwable)sMSException);
        }
    }

    private void getAttributeLabels(ServiceSchemaManager serviceSchemaManager) {
        this.attributeLabels = new ArrayList(this.requiredAttributes.size());
        Iterator iterator = this.requiredAttributes.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            this.attributeLabels.add(this.getL10NAttributeName(serviceSchemaManager, attributeSchema.getI18NKey()));
        }
    }

    private void getMapAttributeValues() {
        if (this.mapAttributeValues == null) {
            this.mapAttributeValues = new HashMap(this.requiredAttributes.size() * 2);
            Iterator iterator = this.requiredAttributes.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                this.mapAttributeValues.put(attributeSchema.getName(), this.getAttributeValues(attributeSchema));
            }
        }
    }

    public boolean createEntity(Map map) {
        boolean bl = false;
        if (map == null || map.isEmpty()) {
            AMModelBase.debug.error("UMCreateEntityModelImp.createEntity map of attribute name to attribute values is null or is empty.");
            this.errorMessage = this.getLocalizedString("createFailure.message");
        } else {
            this.mapAttributeValues = new HashMap(map.size() * 2);
            this.mapAttributeValues.putAll(map);
            String string = (String)map.remove("entryName");
            if (string == null || string.length() == 0) {
                this.errorMessage = this.getLocalizedString("createFailure.message");
            } else {
                int n = this.getLocationType();
                try {
                    if (n == 2) {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.createEntity(aMOrganization, string, map);
                        bl = true;
                    } else if (n == 3) {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.createEntity(aMOrganizationalUnit, string, map);
                        bl = true;
                    }
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMCreateEntityModelImpl.createEntity", (Throwable)aMException);
                    this.errorMessage = this.getErrorString((Exception)((Object)aMException));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("UMCreateEntityModelImpl.createEntity", (Throwable)sSOException);
                    this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
                }
            }
        }
        return bl;
    }

    private void createEntity(AMOrganization aMOrganization, String string, Map map) throws SSOException, AMException {
        HashMap<String, Map> hashMap = new HashMap<String, Map>(2);
        hashMap.put(string, map);
        Map map2 = this.getEntityTypesMap();
        AMEntityType aMEntityType = (AMEntityType)map2.get(this.viewName);
        Set set = aMOrganization.createEntities(aMEntityType.getType(), hashMap);
        AMEntity aMEntity = (AMEntity)set.iterator().next();
        this.entryDN = aMEntity.getDN();
        String string2 = this.getL10NAttributeName(this.serviceName, "log-entity-name");
        this.writeFormatLog("entityCreated.message", string2, this.entryDN);
    }

    private AMEntity createEntity(AMOrganizationalUnit aMOrganizationalUnit, String string, Map map) throws SSOException, AMException {
        HashMap<String, Map> hashMap = new HashMap<String, Map>(2);
        hashMap.put(string, map);
        Map map2 = this.getEntityTypesMap();
        AMEntityType aMEntityType = (AMEntityType)map2.get(this.viewName);
        Set set = aMOrganizationalUnit.createEntities(aMEntityType.getName(), hashMap);
        AMEntity aMEntity = (AMEntity)set.iterator().next();
        this.entryDN = aMEntity.getDN();
        this.logger.doLog("entityCreated.message", this.entryDN);
        return aMEntity;
    }

    public DynamicGUI getDynamicGUI(int n) {
        AttributeSchema attributeSchema = (AttributeSchema)this.requiredAttributes.get(n);
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        return dynamicGUIGenerator.createDynamicGUI(attributeSchema, this.serviceName, (Set)this.mapAttributeValues.get(attributeSchema.getName()), this, null);
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createEntity.help");
        if (string.equals("createEntity.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public void setValues(String string) {
        this.viewName = string;
        Map map = this.getEntityTypesMap();
        AMEntityType aMEntityType = (AMEntityType)map.get(this.viewName);
        this.serviceName = aMEntityType.getServiceName();
    }
}

