/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMChangeUserPasswordModel;
import com.iplanet.am.console.user.model.UMUserModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class UMChangeUserPasswordModelImpl
extends UMUserModelImpl
implements UMChangeUserPasswordModel {
    public UMChangeUserPasswordModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getTitle() {
        Object[] objectArray = new String[]{AMFormatUtils.DNToName(this, this.curUserDN)};
        return MessageFormat.format(this.getLocalizedString("changePassword.title"), objectArray);
    }

    public String getPasswordLabel() {
        return this.getLocalizedString("password.label");
    }

    public String getOldValueLabel() {
        return this.getLocalizedString("oldPassword.label");
    }

    public String getPasswordConfirmLabel() {
        return this.getLocalizedString("confirmPassword.label");
    }

    public String getPasswordsDontMatch() {
        return this.getLocalizedString("passwordMatch.error");
    }

    public String getBlankValueMessage() {
        return this.getLocalizedString("blankValue.error");
    }

    public String getMissingOldValue() {
        return this.getLocalizedString("missingOldValue.error");
    }

    public String getWrongPasswordMessage() {
        return this.getLocalizedString("wrongPassword.error");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("changePasswordError.title");
    }

    public String getExistingPasswordMessage() {
        return this.getLocalizedString("existingPassword.msg");
    }

    public String getNewPasswordMessage() {
        return this.getLocalizedString("newPassword.msg");
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("passwordChanged.message");
    }

    public String getSuccessTitle() {
        return this.getLocalizedString("passwordChanged.title");
    }

    public void changePassword(String string) throws AMConsoleException {
        try {
            AMUser aMUser = this.getCurrentUser();
            aMUser.setStringAttribute("userpassword", string);
            aMUser.store();
        }
        catch (AMException aMException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        catch (SSOException sSOException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
    }

    public String getConfirmLabel() {
        return this.getLocalizedString("passwordConfirm.label");
    }

    public boolean validatePassword(String string) {
        boolean bl = true;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(this.curUserDN), string);
        }
        catch (Exception exception) {
            bl = false;
            AMModelBase.debug.error("invalid credentials", (Throwable)exception);
        }
        return bl;
    }
}

