/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;

abstract class Settings {
    static SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    static AMStoreConnection storeConnection = Settings.getAdminStoreConnection();
    static Debug debug = Debug.getInstance((String)"amConsole");
    protected Map settings;

    Settings() {
    }

    Map getSettings() {
        return this.settings;
    }

    void init() {
        Set set = this.getSettingValues();
        if (set != null) {
            this.settings = Setting.parseSettingValues(set);
        }
    }

    protected abstract Set getSettingValues();

    private static AMStoreConnection getAdminStoreConnection() {
        AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (SecurityException securityException) {
                    debug.error("GlobalSettings.init", (Throwable)securityException);
                    return null;
                }
            }
        });
        return aMStoreConnection;
    }
}

