/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.settings.ActionValueSettingResolver;
import com.iplanet.am.console.settings.BooleanValueSettingResolver;
import com.iplanet.am.console.settings.MultiValuesSettingResolver;
import com.iplanet.am.console.settings.SettingRegistry;
import com.iplanet.am.console.settings.SettingResolver;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Setting {
    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_SINGLE_STRING = 1;
    public static final int TYPE_MULTIPLE_STRING = 2;
    private static final String I18N_KEY_PREFIX = "setting-i18nKey-";
    static Debug debug = Debug.getInstance((String)"amConsole");
    private String name;
    private String amConfigName;
    private int type;
    private String[] validValues;
    private String[] defaultValues;
    private Setting defaultViewSetting;
    private SettingResolver settingResolver;
    public static final Setting ROOT_NAVIGATION_MENU = new Setting("rootnavmenu", null, 2, MultiValuesSettingResolver.getInstance());
    public static final Setting ORGANIZATION_NAVIGATION_MENU = new Setting("organizationnavmenu", null, 2, MultiValuesSettingResolver.getInstance());
    public static final Setting ORGANIZATIONAL_UNIT_NAVIGATION_MENU;
    public static final Setting GROUP_CONTAINER_NAVIGATION_MENU;
    public static final Setting PEOPLE_CONTAINER_NAVIGATION_MENU;
    public static final Setting ROLE_NAVIGATION_MENU;
    public static final Setting GROUP_NAVIGATION_MENU;
    public static final Setting FEDERATION_NAVIGATION_MENU;
    public static final Setting ORGANIZATION_PROFILE_MENU;
    public static final Setting ORGANIZATIONAL_UNIT_PROFILE_MENU;
    public static final Setting DEFAULT_ORGANIZATION_PROFILE_VIEW;
    public static final Setting DEFAULT_ORGANIZATIONAL_UNIT_PROFILE_VIEW;
    public static final Setting USER_PROFILE_MENU;
    public static final Setting DEFAULT_USER_PROFILE_VIEW;
    public static final Setting GROUP_PROFILE_MENU;
    public static final Setting DEFAULT_GROUP_PROFILE_VIEW;
    public static final Setting ROLE_PROFILE_MENU;
    public static final Setting DEFAULT_ROLE_PROFILE_VIEW;
    public static final Setting POLICY_PROFILE_MENU;
    public static final Setting DEFAULT_POLICY_PROFILE_VIEW;
    public static final Setting ENTITY_DESCRIPTOR_PROFILE_MENU;
    public static final Setting DEFAULT_ENTITY_DESCRIPTOR_PROFILE_VIEW;
    public static final Setting USER_PROFILE_TITLE;
    public static final Setting DISABLE_INITIAL_SEARCH_IN_NAV_VIEW;
    public static final Setting GENERATE_USER_CN;
    public static final Setting AUTO_SELECT_NAVIGATION_ITEMS;
    public static final Setting ACTION_ORGANIZATION;
    public static final Setting ACTION_ORGANIZATIONAL_UNIT;
    public static final Setting ACTION_GROUP_CONTAINER;
    public static final Setting ACTION_PEOPLE_CONTAINER;
    public static final Setting ACTION_USER;
    public static final Setting ACTION_ROLE;
    public static final Setting ACTION_GROUP;
    public static final Setting ACTION_SERVICE;
    public static final Setting ACTION_POLICY;
    public static final Setting ACTION_ENTITY;

    Setting(String string, String string2, int n, SettingResolver settingResolver) {
        this.name = string;
        this.amConfigName = string2;
        this.type = n;
        SettingRegistry settingRegistry = SettingRegistry.getInstance();
        this.settingResolver = settingResolver;
        settingRegistry.registerSetting(this);
    }

    void setValidValues(String[] stringArray) {
        this.validValues = stringArray;
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public void setDefaultValues(String[] stringArray) {
        this.defaultValues = stringArray;
    }

    public String[] getDefaultValues() {
        return this.defaultValues;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public void setDefaultViewSetting(Setting setting) {
        this.defaultViewSetting = setting;
    }

    public Setting getDefaultViewSetting() {
        return this.defaultViewSetting;
    }

    public Set unions(Set set, Set set2) {
        Set set3 = Collections.EMPTY_SET;
        if (this.settingResolver != null) {
            set3 = this.settingResolver.unions(set, set2);
        } else {
            debug.error("Setting.unions: cannot union this settings, " + this.name);
        }
        return set3;
    }

    public Set intersects(Set set, Set set2) {
        Set set3 = Collections.EMPTY_SET;
        if (this.settingResolver != null) {
            set3 = this.settingResolver.intersects(set, set2);
        } else {
            debug.error("Setting.intersects: cannot intersect this settings, " + this.name);
        }
        return set3;
    }

    public String getI18nKey() {
        return I18N_KEY_PREFIX + this.name;
    }

    static Set getValuesFromAMConfigProperties() {
        SettingRegistry settingRegistry = SettingRegistry.getInstance();
        Collection collection = settingRegistry.getSettings();
        HashSet<String> hashSet = new HashSet<String>(collection.size() * 2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            Setting setting = (Setting)iterator.next();
            if (setting.amConfigName == null || (string = SystemProperties.get((String)setting.amConfigName)) == null || string.length() <= 0) continue;
            hashSet.add(setting.name + "=" + string);
        }
        return hashSet;
    }

    static Set formatSettingValues(Map map) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (!map.isEmpty()) {
            hashSet = new HashSet<String>(map.size() * 2);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = Setting.formatSettingValues((Set)map.get(string));
                if (string2.length() <= 0) continue;
                hashSet.add(string + "=" + string2);
            }
        }
        return hashSet;
    }

    private static String formatSettingValues(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        if (set != null && !set.isEmpty()) {
            boolean bl = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((String)iterator.next());
                bl = true;
            }
        }
        return stringBuffer.toString();
    }

    static Map parseSettingValues(Set set) {
        HashMap<String, Set> hashMap = Collections.EMPTY_MAP;
        if (!set.isEmpty()) {
            hashMap = new HashMap<String, Set>(set.size() * 2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = string.indexOf(61);
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    string2 = string2.trim().toLowerCase();
                    hashMap.put(string2, Setting.parseSettingValues(string3.trim()));
                    continue;
                }
                debug.error("Setting.parseSettingValues: incorrect format " + string);
            }
        }
        return hashMap;
    }

    static Set parseSettingValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        HashSet<String> hashSet = new HashSet<String>(stringTokenizer.countTokens() * 2);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
        return hashSet;
    }

    public static String getLocalizedOptionName(String string, AMModel aMModel) {
        return aMModel.getLocalizedString("show" + string + ".label");
    }

    public static String getLocalizedHelp(String string, AMModel aMModel) {
        return aMModel.getLocalizedString("show" + string + ".help");
    }

    static {
        String[] stringArray = new String[]{"organizations", "organizationalunits", "groupcontainers", "peoplecontainers", "roles", "groups", "users", "services", "policies", "policyadministrator", "optionentities"};
        ROOT_NAVIGATION_MENU.setValidValues(stringArray);
        ORGANIZATION_NAVIGATION_MENU.setValidValues(stringArray);
        ORGANIZATIONAL_UNIT_NAVIGATION_MENU = new Setting("organizationalunitnavmenu", null, 2, MultiValuesSettingResolver.getInstance());
        stringArray = new String[]{"organizations", "organizationalunits", "groupcontainers", "peoplecontainers", "roles", "groups", "users", "services", "optionentities"};
        ORGANIZATIONAL_UNIT_NAVIGATION_MENU.setValidValues(stringArray);
        GROUP_CONTAINER_NAVIGATION_MENU = new Setting("groupcontainernavmenu", null, 2, MultiValuesSettingResolver.getInstance());
        stringArray = new String[]{"groupcontainers", "groups"};
        GROUP_CONTAINER_NAVIGATION_MENU.setValidValues(stringArray);
        PEOPLE_CONTAINER_NAVIGATION_MENU = new Setting("peoplecontainernavmenu", null, 2, MultiValuesSettingResolver.getInstance());
        stringArray = new String[]{"peoplecontainers", "users"};
        PEOPLE_CONTAINER_NAVIGATION_MENU.setValidValues(stringArray);
        ROLE_NAVIGATION_MENU = new Setting("rolenavmenu", null, 2, MultiValuesSettingResolver.getInstance());
        GROUP_NAVIGATION_MENU = new Setting("groupnavmenu", null, 2, MultiValuesSettingResolver.getInstance());
        FEDERATION_NAVIGATION_MENU = new Setting("federationnavmenu", null, 2, MultiValuesSettingResolver.getInstance());
        stringArray = new String[]{"authenticationdomains", "entities"};
        FEDERATION_NAVIGATION_MENU.setValidValues(stringArray);
        ORGANIZATION_PROFILE_MENU = new Setting("organizationprofilemenu", null, 2, MultiValuesSettingResolver.getInstance());
        ORGANIZATIONAL_UNIT_PROFILE_MENU = new Setting("organizationalunitprofilemenu", null, 2, MultiValuesSettingResolver.getInstance());
        DEFAULT_ORGANIZATION_PROFILE_VIEW = new Setting("defaultorganizationview", null, 1, null);
        DEFAULT_ORGANIZATIONAL_UNIT_PROFILE_VIEW = new Setting("defaultorganizationalunitview", null, 1, null);
        stringArray = new String[]{"general", "displayoptions", "permissions"};
        String[] stringArray2 = new String[]{"general"};
        DEFAULT_ORGANIZATION_PROFILE_VIEW.setValidValues(stringArray);
        DEFAULT_ORGANIZATION_PROFILE_VIEW.setDefaultValues(stringArray2);
        DEFAULT_ORGANIZATIONAL_UNIT_PROFILE_VIEW.setValidValues(stringArray);
        DEFAULT_ORGANIZATIONAL_UNIT_PROFILE_VIEW.setDefaultValues(stringArray2);
        ORGANIZATION_PROFILE_MENU.setValidValues(stringArray);
        ORGANIZATION_PROFILE_MENU.setDefaultViewSetting(DEFAULT_ORGANIZATION_PROFILE_VIEW);
        ORGANIZATIONAL_UNIT_PROFILE_MENU.setValidValues(stringArray);
        ORGANIZATIONAL_UNIT_PROFILE_MENU.setDefaultViewSetting(DEFAULT_ORGANIZATIONAL_UNIT_PROFILE_VIEW);
        USER_PROFILE_MENU = new Setting("userprofilemenu", null, 2, MultiValuesSettingResolver.getInstance());
        DEFAULT_USER_PROFILE_VIEW = new Setting("defaultuserview", null, 1, null);
        stringArray = new String[]{"roles", "groups", "services", "[user_assignable_services]", "resourceoffering"};
        stringArray2 = new String[]{"iPlanetAMUserService".toLowerCase()};
        DEFAULT_USER_PROFILE_VIEW.setValidValues(stringArray);
        DEFAULT_USER_PROFILE_VIEW.setDefaultValues(stringArray2);
        USER_PROFILE_MENU.setValidValues(stringArray);
        USER_PROFILE_MENU.setDefaultViewSetting(DEFAULT_USER_PROFILE_VIEW);
        GROUP_PROFILE_MENU = new Setting("groupprofilemenu", null, 2, MultiValuesSettingResolver.getInstance());
        DEFAULT_GROUP_PROFILE_VIEW = new Setting("defaultgroupview", null, 1, null);
        stringArray = new String[]{"general", "members"};
        stringArray2 = new String[]{"members"};
        DEFAULT_GROUP_PROFILE_VIEW.setValidValues(stringArray);
        DEFAULT_GROUP_PROFILE_VIEW.setDefaultValues(stringArray2);
        GROUP_PROFILE_MENU.setValidValues(stringArray);
        GROUP_PROFILE_MENU.setDefaultViewSetting(DEFAULT_GROUP_PROFILE_VIEW);
        ROLE_PROFILE_MENU = new Setting("roleprofilemenu", null, 2, MultiValuesSettingResolver.getInstance());
        DEFAULT_ROLE_PROFILE_VIEW = new Setting("defaultroleview", null, 1, null);
        stringArray = new String[]{"general", "users", "services", "displayoptions", "permissions"};
        stringArray2 = new String[]{"users"};
        DEFAULT_ROLE_PROFILE_VIEW.setValidValues(stringArray);
        DEFAULT_ROLE_PROFILE_VIEW.setDefaultValues(stringArray2);
        ROLE_PROFILE_MENU.setValidValues(stringArray);
        ROLE_PROFILE_MENU.setDefaultViewSetting(DEFAULT_ROLE_PROFILE_VIEW);
        POLICY_PROFILE_MENU = new Setting("policyprofilemenu", null, 2, MultiValuesSettingResolver.getInstance());
        DEFAULT_POLICY_PROFILE_VIEW = new Setting("defaultpolicyview", null, 1, null);
        stringArray = new String[]{"general", "rules", "referrals", "subjects", "conditions"};
        stringArray2 = new String[]{"rules"};
        DEFAULT_POLICY_PROFILE_VIEW.setValidValues(stringArray);
        DEFAULT_POLICY_PROFILE_VIEW.setDefaultValues(stringArray2);
        POLICY_PROFILE_MENU.setValidValues(stringArray);
        POLICY_PROFILE_MENU.setDefaultViewSetting(DEFAULT_POLICY_PROFILE_VIEW);
        ENTITY_DESCRIPTOR_PROFILE_MENU = new Setting("entitydescriptorprofilemenu", null, 2, MultiValuesSettingResolver.getInstance());
        DEFAULT_ENTITY_DESCRIPTOR_PROFILE_VIEW = new Setting("defaultentitydescriptorview", null, 1, null);
        stringArray = new String[]{"general", "affiliates", "identityprovider", "serviceprovider"};
        stringArray2 = new String[]{"general"};
        DEFAULT_ENTITY_DESCRIPTOR_PROFILE_VIEW.setValidValues(stringArray);
        DEFAULT_ENTITY_DESCRIPTOR_PROFILE_VIEW.setDefaultValues(stringArray2);
        ENTITY_DESCRIPTOR_PROFILE_MENU.setValidValues(stringArray);
        ENTITY_DESCRIPTOR_PROFILE_MENU.setDefaultViewSetting(DEFAULT_ENTITY_DESCRIPTOR_PROFILE_VIEW);
        USER_PROFILE_TITLE = new Setting("userattributenameforprofiletitle", null, 1, null);
        stringArray = new String[]{"[user_service_attribute_name]"};
        stringArray2 = new String[]{"uid"};
        USER_PROFILE_TITLE.setValidValues(stringArray);
        USER_PROFILE_TITLE.setDefaultValues(stringArray2);
        DISABLE_INITIAL_SEARCH_IN_NAV_VIEW = new Setting("disableinitialsearch", "com.iplanet.am.console.display.off", 2, MultiValuesSettingResolver.getInstance());
        stringArray = new String[]{"users", "organizations", "organizationalunits", "peoplecontainers", "groupcontainers", "roles", "groups", "optionentities", "policies"};
        stringArray2 = new String[]{""};
        DISABLE_INITIAL_SEARCH_IN_NAV_VIEW.setValidValues(stringArray);
        DISABLE_INITIAL_SEARCH_IN_NAV_VIEW.setDefaultValues(stringArray2);
        GENERATE_USER_CN = new Setting("generateusercn", "com.iplanet.am.console.set.cn", 0, BooleanValueSettingResolver.getInstance());
        AUTO_SELECT_NAVIGATION_ITEMS = new Setting("autoselect", "com.iplanet.am.console.autoSelect", 0, BooleanValueSettingResolver.getInstance());
        stringArray = new String[]{"true"};
        AUTO_SELECT_NAVIGATION_ITEMS.setDefaultValues(stringArray);
        ACTION_ORGANIZATION = new Setting("actionorganizationproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_ORGANIZATIONAL_UNIT = new Setting("actionorganizationalunitproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_GROUP_CONTAINER = new Setting("actiongroupcontainerproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_PEOPLE_CONTAINER = new Setting("actionpeoplecontainerproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_USER = new Setting("actionuserproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_ROLE = new Setting("actionroleproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_GROUP = new Setting("actiongroupproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_SERVICE = new Setting("actionserviceproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_POLICY = new Setting("actionpolicyproperties", null, 1, ActionValueSettingResolver.getInstance());
        ACTION_ENTITY = new Setting("actionentityproperties", null, 1, ActionValueSettingResolver.getInstance());
        stringArray = new String[]{"noaccessobject", "viewproperties", "modifyproperties", "deleteobject", "fullaccessobject"};
        stringArray2 = new String[]{"fullaccessobject"};
        ACTION_ORGANIZATION.setValidValues(stringArray);
        ACTION_ORGANIZATION.setDefaultValues(stringArray2);
        ACTION_ORGANIZATIONAL_UNIT.setValidValues(stringArray);
        ACTION_ORGANIZATIONAL_UNIT.setDefaultValues(stringArray2);
        ACTION_GROUP_CONTAINER.setValidValues(stringArray);
        ACTION_GROUP_CONTAINER.setDefaultValues(stringArray2);
        ACTION_PEOPLE_CONTAINER.setValidValues(stringArray);
        ACTION_PEOPLE_CONTAINER.setDefaultValues(stringArray2);
        ACTION_USER.setValidValues(stringArray);
        ACTION_USER.setDefaultValues(stringArray2);
        ACTION_ROLE.setValidValues(stringArray);
        ACTION_ROLE.setDefaultValues(stringArray2);
        ACTION_GROUP.setValidValues(stringArray);
        ACTION_GROUP.setDefaultValues(stringArray2);
        ACTION_SERVICE.setValidValues(stringArray);
        ACTION_SERVICE.setDefaultValues(stringArray2);
        ACTION_POLICY.setValidValues(stringArray);
        ACTION_POLICY.setDefaultValues(stringArray2);
        ACTION_ENTITY.setValidValues(stringArray);
        ACTION_ENTITY.setDefaultValues(stringArray2);
    }
}

