/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.settings;

import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.settings.Settings;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ServiceAttributeSettings
extends Settings {
    static final String ROLE_SERVICE_ANY_OPTIONS = "iplanet-am-role-any-options";
    static final String SERVICE_ATTR_NAME_SEPARATOR = "#";
    static final String ATTR_NAME_ANY_OPTION_SEPARATOR = ",";
    static final String ANY_OPTION_SEPARATOR = "|";
    private String roleDN;
    private AMRole role;
    private AMStoreConnection storeConn;

    ServiceAttributeSettings(AMStoreConnection aMStoreConnection) {
        this.storeConn = aMStoreConnection;
    }

    ServiceAttributeSettings(String string) {
        this.storeConn = Settings.storeConnection;
        this.roleDN = string;
        this.settings = this.getServiceAttributeSettings();
    }

    protected Set getSettingValues() {
        return Collections.EMPTY_SET;
    }

    private Map getServiceAttributeSettings() {
        Map map = null;
        this.createRoleHandler();
        if (this.role != null) {
            try {
                Set set = this.role.getAttribute(ROLE_SERVICE_ANY_OPTIONS);
                if (set != null && !set.isEmpty()) {
                    map = this.parseSettingValues(set);
                }
            }
            catch (AMException aMException) {
                Settings.debug.warning("ServiceAttributeSettngs.getServiceAttributeSettings", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                Settings.debug.warning("ServiceAttributeSettngs.getServiceAttributeSettings", (Throwable)sSOException);
            }
        }
        return map;
    }

    public static Map getSettings(String string) {
        ServiceAttributeSettings serviceAttributeSettings = new ServiceAttributeSettings(string);
        return serviceAttributeSettings.settings;
    }

    public static void setSettings(AMStoreConnection aMStoreConnection, AMModel aMModel, String string, Map map) throws AMException, SSOException {
        ServiceAttributeSettings serviceAttributeSettings = new ServiceAttributeSettings(aMStoreConnection);
        serviceAttributeSettings.roleDN = string;
        serviceAttributeSettings.setSettings(map);
    }

    private void setSettings(Map map) throws AMException, SSOException {
        this.createRoleHandler();
        if (this.role != null) {
            HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
            hashMap.put(ROLE_SERVICE_ANY_OPTIONS, this.formatSettingValues(map));
            this.role.setAttributes(hashMap);
            this.role.store();
        }
    }

    private Set formatSettingValues(Map map) {
        Set set = Collections.EMPTY_SET;
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map2 = (Map)map.get(string);
                if (map2 == null || map2.isEmpty()) continue;
                set.add(this.formatSettingValues(string, map2));
            }
        }
        return set;
    }

    private String formatSettingValues(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer(200);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Set set = (Set)map.get(string2);
            stringBuffer.append(string).append(SERVICE_ATTR_NAME_SEPARATOR).append(string2);
            if (set == null || set.isEmpty()) continue;
            boolean bl = false;
            stringBuffer.append(ATTR_NAME_ANY_OPTION_SEPARATOR);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                if (bl) {
                    stringBuffer.append(ANY_OPTION_SEPARATOR);
                }
                stringBuffer.append((String)iterator2.next());
            }
        }
        return stringBuffer.toString();
    }

    private AMRole createRoleHandler() {
        if (this.role == null) {
            try {
                this.role = this.storeConn.getRole(this.roleDN);
            }
            catch (SSOException sSOException) {
                Settings.debug.error("error getting role for " + this.roleDN, (Throwable)sSOException);
            }
        }
        return this.role;
    }

    private Map parseSettingValues(Set set) {
        HashMap<String, HashMap<String, Set>> hashMap = new HashMap<String, HashMap<String, Set>>();
        Map map = this.parseAttributeValue(set);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set2 = (Set)entry.getValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string, SERVICE_ATTR_NAME_SEPARATOR);
            if (stringTokenizer.countTokens() != 2) continue;
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            HashMap<String, Set> hashMap2 = (HashMap<String, Set>)hashMap.get(string2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, Set>();
            }
            hashMap2.put(string3, set2);
            hashMap.put(string2, hashMap2);
        }
        return hashMap;
    }

    private Map parseAttributeValue(Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), ATTR_NAME_ANY_OPTION_SEPARATOR);
            int n = stringTokenizer.countTokens();
            if (n <= 0) continue;
            String string = stringTokenizer.nextToken();
            Set set2 = Collections.EMPTY_SET;
            if (stringTokenizer.hasMoreTokens()) {
                set2 = ServiceAttributeSettings.getDisplayOptions(stringTokenizer.nextToken());
            }
            hashMap.put(string, set2);
        }
        return hashMap;
    }

    public static Map getDefaultValuesFromAttributeSchemas(String string) {
        HashMap hashMap = Collections.EMPTY_MAP;
        ServiceSchemaManager serviceSchemaManager = ServiceAttributeSettings.getServiceSchemaManager(string);
        if (serviceSchemaManager != null) {
            try {
                Set set = ServiceAttributeSettings.getDisplaySchemaTypes(serviceSchemaManager);
                if (set != null && !set.isEmpty()) {
                    hashMap = new HashMap();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SchemaType schemaType = (SchemaType)iterator.next();
                        ServiceAttributeSettings.getServiceAttributeDisplayOptions(serviceSchemaManager, schemaType, hashMap);
                    }
                }
            }
            catch (SMSException sMSException) {
                Settings.debug.error("ServiceAttributeSettings.getDefaultValuesFromAttributeSchemas", (Throwable)sMSException);
            }
        }
        return hashMap;
    }

    private static Set getDisplaySchemaTypes(ServiceSchemaManager serviceSchemaManager) throws SMSException {
        Set set = serviceSchemaManager.getSchemaTypes();
        if (set != null) {
            set.remove(SchemaType.GLOBAL);
            set.remove(SchemaType.POLICY);
        } else {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    private static void getServiceAttributeDisplayOptions(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, Map map) throws SMSException {
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        Set set = serviceSchema.getAttributeSchemaNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set set2;
            String string = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
            if (attributeSchema == null || (set2 = ServiceAttributeSettings.getDisplayOptions(attributeSchema, schemaType)).isEmpty()) continue;
            HashSet hashSet = (HashSet)map.get(string);
            if (hashSet == null) {
                hashSet = new HashSet();
                map.put(string, hashSet);
            }
            hashSet.addAll(set2);
        }
    }

    private static Set getDisplayOptions(AttributeSchema attributeSchema, SchemaType schemaType) {
        String string;
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (attributeSchema != null && (string = attributeSchema.getI18NKey()) != null && string.length() > 0) {
            String string2 = attributeSchema.getAny();
            if (string2 != null) {
                hashSet = ServiceAttributeSettings.getDisplayOptions(string2);
            } else if (!schemaType.equals((Object)SchemaType.USER)) {
                hashSet = new HashSet<String>(2);
                hashSet.add("display");
            }
        }
        return hashSet;
    }

    private static Set getDisplayOptions(String string) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ANY_OPTION_SEPARATOR);
            hashSet = new HashSet<String>(stringTokenizer.countTokens() * 2);
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        return hashSet;
    }

    private static ServiceSchemaManager getServiceSchemaManager(String string) {
        ServiceSchemaManager serviceSchemaManager = null;
        try {
            serviceSchemaManager = new ServiceSchemaManager(string, Settings.adminSSOToken);
        }
        catch (SSOException sSOException) {
            Settings.debug.error("ServiceAttributeSettings.getServiceSchemaManager", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            Settings.debug.error("ServiceAttributeSettings.getServiceSchemaManager", (Throwable)sMSException);
        }
        return serviceSchemaManager;
    }

    public static Map aggregrateSettings(Map map, Map map2) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map3 = (Map)map.get(string);
            Map map4 = (Map)map2.get(string);
            HashMap<String, Map> hashMap2 = new HashMap<String, Map>();
            if (map3 != null && !map3.isEmpty()) {
                if (map4 != null && !map4.isEmpty()) {
                    hashMap2.put(string, ServiceAttributeSettings.aggregrateOptionSettings(map3, map4));
                    continue;
                }
                hashMap2.put(string, map3);
                continue;
            }
            if (map4 == null || map4.isEmpty()) continue;
            hashMap2.put(string, map4);
        }
        return hashMap;
    }

    private static Map aggregrateOptionSettings(Map map, Map map2) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashSet hashSet = new HashSet();
            Set set = (Set)map.get(string);
            Set set2 = (Set)map2.get(string);
            if (set != null && !set.isEmpty()) {
                if (set2 != null && !set2.isEmpty()) {
                    hashSet.addAll(set);
                    hashSet.addAll(set2);
                } else {
                    hashSet.addAll(set);
                }
            } else if (set2 != null && !set2.isEmpty()) {
                hashSet.addAll(set2);
            }
            hashMap.put(string, hashSet);
        }
        return hashMap;
    }
}

