/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.session.model;

import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.session.model.SMProfileModelImpl;
import com.iplanet.am.console.session.model.SMSessionData;
import com.iplanet.am.util.Debug;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SMSessionCache
implements Serializable {
    private static final int CACHE_SESSION_PAGES = 10;
    private static Debug debug = AMModelBase.debug;
    private int numberOfSessions;
    private int totalPages;
    private int startPage;
    private int endPage;
    private int pageSize;
    private int curPage;
    private String searchErrorMessage;
    private List pages = new ArrayList(10);

    public SMSessionCache(int n, int n2, Collection collection, String string, SMProfileModelImpl sMProfileModelImpl) {
        this.pageSize = n2;
        this.curPage = Math.max(0, n);
        this.searchErrorMessage = string;
        Map map = this.retainSessionsWithUserID(collection, sMProfileModelImpl);
        this.cacheSessions(map, sMProfileModelImpl);
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.curPage;
    }

    public void setCurrentPage(int n) {
        this.curPage = n;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public String getErrorMessage() {
        return this.searchErrorMessage;
    }

    public int getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public List getPage(int n) {
        List list = null;
        if (n < this.totalPages && (n -= this.startPage) > -1 && n < this.pages.size()) {
            list = (List)this.pages.get(n);
        }
        return list;
    }

    private void cacheSessions(Map map, SMProfileModelImpl sMProfileModelImpl) {
        this.numberOfSessions = map.size();
        this.totalPages = this.numberOfSessions / this.pageSize;
        if (this.numberOfSessions % this.pageSize != 0) {
            ++this.totalPages;
        }
        this.curPage = this.curPage > this.totalPages ? this.totalPages : this.curPage;
        this.startPage = Math.max(0, this.curPage - 10);
        this.endPage = Math.min(this.totalPages, this.curPage + 10);
        int n = this.startPage * this.pageSize;
        int n2 = this.endPage * this.pageSize;
        List list = AMFormatUtils.sortKeyInMap(map, sMProfileModelImpl.getUserLocale());
        ArrayList arrayList = null;
        int n3 = 0;
        while (n3 < this.numberOfSessions && n3 < n2) {
            if (n3 >= n) {
                if (n3 % this.pageSize == 0) {
                    arrayList = new ArrayList(this.pageSize);
                    this.pages.add(arrayList);
                }
                arrayList.add(map.get(list.get(n3)));
            }
            ++n3;
        }
    }

    private Map retainSessionsWithUserID(Collection collection, SMProfileModelImpl sMProfileModelImpl) {
        HashMap<String, SMSessionData> hashMap = new HashMap<String, SMSessionData>(collection.size() * 2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            try {
                String string = session.getProperty("UserId");
                if (string == null) continue;
                string = AMFormatUtils.DNToName(sMProfileModelImpl, string, false);
                String string2 = session.getID().toString();
                SMSessionData sMSessionData = new SMSessionData();
                sMSessionData.setUserId(string);
                sMSessionData.setId(string2);
                sMSessionData.setTimeRemain(session.getTimeLeft() / 60L);
                sMSessionData.setMaxSessionTime(session.getMaxSessionTime());
                sMSessionData.setIdleTime(session.getIdleTime() / 60L);
                sMSessionData.setMaxIdleTime(session.getMaxIdleTime());
                hashMap.put(string + string2, sMSessionData);
            }
            catch (SessionException sessionException) {
                debug.message("SMSessionCache.retainSessionsWithUserID", (Throwable)sessionException);
            }
        }
        return hashMap;
    }
}

