/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.session.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.session.model.SMProfileModel;
import com.iplanet.am.console.session.model.SMSessionCache;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SMProfileModelImpl
extends AMProfileModelBase
implements SMProfileModel {
    static final String USER_ID = "UserId";
    private String serverName = null;
    private boolean validSession = true;
    private SMSessionCache sessionCache;

    public SMProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getUserIdLabel() {
        return this.getLocalizedString("userId.label");
    }

    public String getTimeLeftLabel() {
        return this.getLocalizedString("timeLeft.label");
    }

    public String getMaxSessionTimeLabel() {
        return this.getLocalizedString("maxSessionTime.label");
    }

    public String getIdleTimeLabel() {
        return this.getLocalizedString("idleTime.label");
    }

    public String getMaxIdleTimeLabel() {
        return this.getLocalizedString("maxIdleTime.label");
    }

    public String getInvalidateBtnLabel() {
        return this.getLocalizedString("invalidate.button");
    }

    public String getNumValidSessionsLabel() {
        return this.getLocalizedString("numValidSessions.label");
    }

    public String getTopOfListLabel() {
        return this.getLocalizedString("topList.label");
    }

    public String getBottomOfListLabel() {
        return this.getLocalizedString("bottomList.label");
    }

    public String getFilterBtnLabel() {
        return this.getLocalizedString("filter.button");
    }

    public String getTableCaptionLabel() {
        return this.getLocalizedString("userTableCaption.header");
    }

    public String getTerminateErrorMessage() {
        return this.getLocalizedString("deleteFailed.message");
    }

    public String getAlertTitle() {
        return this.getLocalizedString("alertMessage.title");
    }

    public void setProfileServerName(String string) {
        this.serverName = string;
    }

    public int getValidSessionCnt() {
        return this.sessionCache != null ? this.sessionCache.getNumberOfSessions() : 0;
    }

    private void initSessionsList(String string, int n) throws AMConsoleException {
        string = string.toLowerCase();
        try {
            Session session = Session.getSession((SessionID)new SessionID(this.ssoToken.getTokenID().toString()));
            AMSearchResults aMSearchResults = session.getValidSessions(this.serverName, string);
            Hashtable hashtable = (Hashtable)aMSearchResults.getResultAttributes();
            String string2 = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
            this.sessionCache = new SMSessionCache(n, this.getGlobalPageSize(), hashtable.values(), string2, this);
        }
        catch (SessionException sessionException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sessionException)));
        }
    }

    private Session getCurrentSession() throws AMConsoleException {
        Session session = null;
        try {
            session = Session.getSession((SessionID)new SessionID(this.ssoToken.getTokenID().toString()));
        }
        catch (SessionException sessionException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sessionException)));
        }
        return session;
    }

    private Map getValidSessions(Session session) throws AMConsoleException {
        HashMap<String, Session> hashMap = Collections.EMPTY_MAP;
        try {
            AMSearchResults aMSearchResults = session.getValidSessions(this.serverName, "*");
            Hashtable hashtable = (Hashtable)aMSearchResults.getResultAttributes();
            if (hashtable != null && !hashtable.isEmpty()) {
                hashMap = new HashMap<String, Session>(hashtable.size());
                Iterator iterator = hashtable.values().iterator();
                while (iterator.hasNext()) {
                    Session session2 = (Session)iterator.next();
                    if (session2 == null) continue;
                    hashMap.put(session2.getID().toString(), session2);
                }
            }
        }
        catch (SessionException sessionException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sessionException)));
        }
        return hashMap;
    }

    public List invalidateSessions(List list) throws AMConsoleException {
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        if (list != null && !list.isEmpty()) {
            Session session = this.getCurrentSession();
            Map map = this.getValidSessions(session);
            list.retainAll(map.keySet());
            if (!list.isEmpty()) {
                String string = null;
                try {
                    string = session.getProperty("SessionHandle");
                }
                catch (SessionException sessionException) {
                    throw new AMConsoleException(this.getErrorString((Exception)((Object)sessionException)));
                }
                arrayList = new ArrayList<String>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Session session2 = (Session)map.get(string2);
                    boolean bl = false;
                    try {
                        bl = string.equals(session2.getProperty("SessionHandle"));
                    }
                    catch (SessionException sessionException) {
                        throw new AMConsoleException(this.getErrorString((Exception)((Object)sessionException)));
                    }
                    if (bl) {
                        this.validSession = false;
                        continue;
                    }
                    if (this.destroySession(session, session2)) continue;
                    try {
                        String string3 = session2.getProperty(USER_ID);
                        arrayList.add(AMFormatUtils.DNToName(this, string3, false));
                    }
                    catch (SessionException sessionException) {
                        AMModelBase.debug.error("SMProfileModelImpl.invalidateSessions", (Throwable)sessionException);
                    }
                }
            }
            if (!this.validSession) {
                this.destroySession(session, session);
            }
        }
        return arrayList;
    }

    private boolean destroySession(Session session, Session session2) {
        boolean bl;
        block3: {
            bl = false;
            boolean bl2 = this.isSessionsEquals(session, session2);
            try {
                String string = session2.getProperty(USER_ID);
                session.destroySession(session2);
                if (!bl2) {
                    this.logger.doLog("destroyedSession.message", string);
                }
                bl = true;
            }
            catch (SessionException sessionException) {
                if (!AMModelBase.debug.warningEnabled()) break block3;
                AMModelBase.debug.warning("SMProfileModelImpl.destroySession", (Throwable)sessionException);
            }
        }
        return bl;
    }

    public String getLogoutURL() {
        return AMSystemConfig.serverURL + AMSystemConfig.serverDeploymentURI + "/UI/Logout";
    }

    public boolean isSessionValid() {
        return this.validSession;
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noSessionEntries.message");
    }

    public String getNoSessionSelectedForInvalidationTitle() {
        return this.getLocalizedString("noSesssionSelectedForInvalidation.title");
    }

    public String getNoSessionSelectedForInvalidationMessage() {
        return this.getLocalizedString("noSesssionSelectedForInvalidation.message");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("sessionData.help");
        if (string.equals("userProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    private boolean isSessionsEquals(Session session, Session session2) {
        boolean bl = false;
        try {
            String string = session.getProperty("SessionHandle");
            bl = string.equals(session2.getProperty("SessionHandle"));
        }
        catch (SessionException sessionException) {
            AMModelBase.debug.error("Could not determined if the sessions are same ", (Throwable)sessionException);
        }
        return bl;
    }

    public SMSessionCache getSessionCache(String string, int n) throws AMConsoleException {
        if (this.sessionCache == null) {
            this.initSessionsList(string, n);
        } else if (this.sessionCache.getPage(n) == null) {
            this.sessionCache = null;
            this.initSessionsList(string, n);
        }
        return this.sessionCache;
    }

    public void setSessionCache(SMSessionCache sMSessionCache) {
        this.sessionCache = sMSessionCache;
    }
}

