/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.session.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.session.model.SMHomeModel;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SMHomeModelImpl
extends AMModelBase
implements SMHomeModel {
    public static final String SERVICE_NAME = "iPlanetAMPlatformService";
    public static final String SERVER_LIST = "iplanet-am-platform-server-list";
    private static String delimiter = "|";
    private Set serverNames = null;

    public SMHomeModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
    }

    public String getNameLabel() {
        return this.getLocalizedString("serverName.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("properties.label");
    }

    public Set getServerNames() {
        if (this.serverNames == null || this.serverNames.isEmpty()) {
            try {
                Map map;
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(SERVICE_NAME);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
                if (serviceSchema != null && (map = serviceSchema.getAttributeDefaults()) != null && map.size() > 0) {
                    this.serverNames = (Set)map.get(SERVER_LIST);
                    this.serverNames = this.parseServerNames(this.serverNames);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("SMHomeModelImpl.getServerNames", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("SMHomeModelImpl.getServerNames", (Throwable)sMSException);
            }
        }
        return this.serverNames;
    }

    public boolean hasServerNames() {
        Set set = this.getServerNames();
        return set != null && !set.isEmpty();
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noServerEntries.message");
    }

    public String getPageTitle() {
        return this.getLocalizedString("sessionPageTitle");
    }

    private Set parseServerNames(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(delimiter);
            if (n != -1) {
                String string2 = string.substring(0, n);
                hashSet.add(string2);
                continue;
            }
            AMModelBase.debug.error("This server entry is not proper, ignoring:" + string);
        }
        return hashSet;
    }
}

