/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.service.model.SMSubConfigModelBase;
import com.iplanet.am.console.service.model.SMSubConfigProfileModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class SMSubConfigProfileModelImpl
extends SMSubConfigModelBase
implements SMSubConfigProfileModel {
    private Map mapAttrValues;
    private SortedSet attributeSchemas;

    public SMSubConfigProfileModelImpl(HttpServletRequest httpServletRequest, Map map, String string, String string2) {
        super(httpServletRequest, map, string, string2);
        this.getAttributeSchemas();
    }

    public String getSubConfigTitle() {
        return this.getLocalizedString("subConfiguration.title");
    }

    public String getNoInstancesMessage() {
        return this.getLocalizedString("noSubConfigurations.message");
    }

    public String getCreateSubConfigButtonLabel() {
        return this.getLocalizedString("createSubConfig.button");
    }

    public String getDeleteSubConfigButtonLabel() {
        return this.getLocalizedString("deleteSubConfig.button");
    }

    public String getSubConfigurationTableHeader() {
        String string = null;
        int n = 0;
        if (this.globalSubConfigurations != null && !this.globalSubConfigurations.isEmpty()) {
            n = this.globalSubConfigurations.size();
        }
        if (n == 1) {
            string = this.getLocalizedString("subConfigTableWithOneInstance.header");
        } else {
            Object[] objectArray = new String[]{Integer.toString(n)};
            string = MessageFormat.format(this.getLocalizedString("subConfigTable.header"), objectArray);
        }
        return string;
    }

    public List getGlobalSubConfigurations() {
        return this.globalSubConfigurations != null ? this.globalSubConfigurations : Collections.EMPTY_LIST;
    }

    public List getSubConfigurationHierarchyIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.curConfigID, "/");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append("/").append(string);
            arrayList.add(stringBuffer.toString());
        }
        arrayList.add(0, "/");
        return arrayList;
    }

    public String getEditSubConfigLabel() {
        return this.getLocalizedString("editSubConfig.label");
    }

    public String getSelectSubConfigForDeletionErrorMessage() {
        return this.getLocalizedString("selectSubConfigForDeletionError.message");
    }

    public void deleteSubConfigurations(Set set) throws AMConsoleException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.parentConfig.removeSubConfig(string);
                Object[] objectArray = new String[]{string, this.serviceName};
                this.writeFormatLog("subConfigurationDeleted.message", objectArray);
                this.getSubConfigurations();
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMSubConfigProfileModelImpl.deleteSubConfigurations", (Throwable)sSOException);
            throw new AMConsoleException(sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("SMSubConfigProfileModelImpl.deleteSubConfigurations", (Throwable)sMSException);
            throw new AMConsoleException(sMSException);
        }
    }

    private void getAttributeSchemas() {
        Set set = this.curSchema.getAttributeSchemas();
        if (set != null && !set.isEmpty()) {
            Collator collator = Collator.getInstance(this.getUserLocale());
            this.attributeSchemas = new TreeSet(new AMAttrSchemaComparator(collator));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string = attributeSchema.getI18NKey();
                if (string == null || string.trim().length() <= 0) continue;
                this.attributeSchemas.add(attributeSchema);
            }
        }
    }

    public List getDynamicGUIs() {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        if (this.attributeSchemas != null && !this.attributeSchemas.isEmpty()) {
            if (this.mapAttrValues == null) {
                this.mapAttrValues = this.parentConfig.getAttributes();
            }
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(this.attributeSchemas.size());
            Iterator iterator = this.attributeSchemas.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                Set set = this.mapAttrValues != null ? (Set)this.mapAttrValues.get(attributeSchema.getName()) : Collections.EMPTY_SET;
                arrayList.add(dynamicGUIGenerator.createDynamicGUI(attributeSchema, this.serviceName, set, false, this, Setting.ACTION_SERVICE));
            }
        }
        return arrayList;
    }

    public String getGlobalAttributeLabel() {
        return this.getLocalizedString("globalSvcAttr.label");
    }

    public void modifyAttributes(Map map) throws AMConsoleException {
        try {
            this.mapAttrValues = map;
            this.parentConfig.setAttributes(map);
            Object[] objectArray = new String[]{this.serviceName, this.curConfigID};
            this.writeFormatLog("subConfigurationModified.message", objectArray);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMSubConfigProfileModelImpl.modifyAttributes", (Throwable)sSOException);
            throw new AMConsoleException(sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("SMSubConfigProfileModelImpl.modifyAttributes", (Throwable)sMSException);
            throw new AMConsoleException(sMSException);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSubConfigurationID() {
        return this.curConfigID;
    }

    public boolean hasAttributes() {
        return this.attributeSchemas != null && !this.attributeSchemas.isEmpty();
    }

    public String getNoSubConfigurationAttributesMessage() {
        return this.getLocalizedString("noSubConfigAttribute.message");
    }
}

