/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.service.model.SMSubConfig;
import com.iplanet.am.console.service.model.SMSubConfigComparator;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class SMSubConfigModelBase
extends AMProfileModelBase {
    protected static final String SUBCONFIG_ID_DELIMITER = "/";
    private String localizedServiceName;
    protected ResourceBundle resourceBundle;
    protected String serviceName;
    protected String curConfigID;
    protected ServiceSchema curSchema;
    protected ServiceSchema globalSchema;
    protected ServiceConfig parentConfig;
    protected String errorMessage;
    protected Set supportedGlobalSubSchemas;
    protected Set singleInstanceGlobalSubSchemas;
    protected Set creatableGlobalSubSchemas;
    protected Map mapServiceSchemaNameToL10NName;
    protected List globalSubConfigurations;

    protected SMSubConfigModelBase(HttpServletRequest httpServletRequest, Map map, String string, String string2) {
        super(httpServletRequest, map);
        this.serviceName = string;
        this.curConfigID = string2;
        this.getServiceSchema(string2);
        this.setResourceBundle();
    }

    private void setResourceBundle() {
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(this.serviceName);
            String string = serviceSchemaManager.getI18NFileName();
            this.resourceBundle = AMResBundleCacher.getBundle(string, this.getUserLocale());
            this.localizedServiceName = Locale.getString((ResourceBundle)this.resourceBundle, (String)this.globalSchema.getI18NKey(), (Debug)AMModelBase.debug);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMSubConfigModelBase.getServiceSchema", (Throwable)sSOException);
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("SMSubConfigModelBase.getServiceSchema", (Throwable)sMSException);
            this.errorMessage = this.getErrorString((Exception)((Object)sMSException));
        }
    }

    private void getServiceSchema(String string) {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(this.serviceName, this.ssoToken);
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(this.serviceName);
            this.globalSchema = serviceSchemaManager.getGlobalSchema();
            if (this.globalSchema != null) {
                this.curSchema = this.globalSchema;
                this.parentConfig = serviceConfig;
                if (!string.equals(SUBCONFIG_ID_DELIMITER)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, SUBCONFIG_ID_DELIMITER);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        this.parentConfig = this.parentConfig.getSubConfig(SMSSchema.unescapeName((String)string2));
                        this.curSchema = this.curSchema.getSubSchema(this.parentConfig.getSchemaID());
                    }
                }
                this.getSupportedGlobalSubSchema();
                if (!this.getGlobalSubSchema().isEmpty()) {
                    this.creatableGlobalSubSchemas = new HashSet();
                    this.creatableGlobalSubSchemas.addAll(this.supportedGlobalSubSchemas);
                    this.getSubConfigurations();
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMSubConfigModelBase.getServiceSchema", (Throwable)sSOException);
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("SMSubConfigModelBase.getServiceSchema", (Throwable)sMSException);
            this.errorMessage = this.getErrorString((Exception)((Object)sMSException));
        }
    }

    private void getSupportedGlobalSubSchema() {
        try {
            this.supportedGlobalSubSchemas = this.curSchema.getSubSchemaNames();
            if (this.supportedGlobalSubSchemas != null && !this.supportedGlobalSubSchemas.isEmpty()) {
                this.mapServiceSchemaNameToL10NName = new HashMap();
                this.singleInstanceGlobalSubSchemas = new HashSet();
                Iterator iterator = this.supportedGlobalSubSchemas.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ServiceSchema serviceSchema = this.curSchema.getSubSchema(string);
                    String string2 = serviceSchema.getI18NKey();
                    if (string2 == null || string2.trim().length() == 0) {
                        iterator.remove();
                        continue;
                    }
                    this.mapServiceSchemaNameToL10NName.put(string, Locale.getString((ResourceBundle)this.resourceBundle, (String)string2, (Debug)AMModelBase.debug));
                    if (serviceSchema.supportsMultipleConfigurations()) continue;
                    this.singleInstanceGlobalSubSchemas.add(string);
                }
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("SMSubConfigModelBase.getSupportedGlobalSubSchema", (Throwable)sMSException);
        }
    }

    protected void getSubConfigurations() {
        try {
            Set set = this.parentConfig.getSubConfigNames();
            if (set != null && !set.isEmpty()) {
                Collator collator = Collator.getInstance(this.getUserLocale());
                TreeSet<SMSubConfig> treeSet = new TreeSet<SMSubConfig>(new SMSubConfigComparator(collator));
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ServiceConfig serviceConfig = this.parentConfig.getSubConfig(string);
                    String string2 = serviceConfig.getSchemaID();
                    if (!this.supportedGlobalSubSchemas.contains(string2)) continue;
                    String string3 = (String)this.mapServiceSchemaNameToL10NName.get(string2);
                    treeSet.add(new SMSubConfig(serviceConfig.getComponentName(), string, string3));
                    if (!this.singleInstanceGlobalSubSchemas.contains(string2)) continue;
                    this.creatableGlobalSubSchemas.remove(string2);
                }
                if (!treeSet.isEmpty()) {
                    this.globalSubConfigurations = new ArrayList(treeSet.size());
                    this.globalSubConfigurations.addAll(treeSet);
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMSubConfigModelBase.getSubConfigurations", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("SMSubConfigModelBase.getSubConfigurations", (Throwable)sMSException);
        }
    }

    public String getCreateInstanceNameLabel() {
        return this.getLocalizedString("createSubConfigInstanceName.label");
    }

    public String getDisplayServiceName() {
        return this.localizedServiceName;
    }

    public String getInstanceNameLabel() {
        return this.getLocalizedString("subConfigName.label");
    }

    public String getInstanceTypeLabel() {
        return this.getLocalizedString("subConfigType.label");
    }

    public String getInstanceActionLabel() {
        return this.getLocalizedString("subConfigAction.label");
    }

    public Set getGlobalSubSchema() {
        return this.supportedGlobalSubSchemas != null ? this.supportedGlobalSubSchemas : Collections.EMPTY_SET;
    }

    public boolean canCreateNewGlobalSubConfigurations() {
        return this.creatableGlobalSubSchemas != null && !this.creatableGlobalSubSchemas.isEmpty();
    }
}

