/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMIndentedListModelImpl;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.service.model.SMNavModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class SMNavModelImpl
extends AMIndentedListModelImpl
implements SMNavModel {
    private static String DEFAULT_VIEWBEAN_URL = AMSystemConfig.deploymentURI + "/service/SMData";
    private Map propsUrlMap = new HashMap(10);

    public SMNavModelImpl(HttpServletRequest httpServletRequest, String string, Map map) {
        super(httpServletRequest, string, map);
    }

    public void process() {
        Set set = this.getHierarchy();
        try {
            Set set2 = this.dpStoreConn.getServiceNames();
            if (set2 != null && !set2.isEmpty()) {
                Map map = this.buildLocalizedLookup(set, set2);
                this.process(set, set2, map);
            } else {
                AMModelBase.debug.error("SMNavModelImpl.process Unable to fetch services");
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("SMNavModelImpl.process", (Throwable)aMException);
        }
    }

    protected Set getHierarchy() {
        Set set = Collections.EMPTY_SET;
        try {
            set = this.dpStoreConn.getServiceHierarchy();
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("SMNavModelImpl.getHierarchy: Hierarchy list = " + set.size());
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("SMNavModelImpl.getHierarchy", (Throwable)aMException);
        }
        return set;
    }

    protected Map buildLocalizedLookup(Set set, Set set2) {
        ResourceBundle resourceBundle = AMResBundleCacher.getBundle("amAdminModuleMsgs", this.getUserLocale());
        HashMap hashMap = new HashMap(5);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = this.processHierarchyString(string, set2, resourceBundle);
            if (map.isEmpty()) {
                iterator.remove();
                continue;
            }
            hashMap.putAll(map);
        }
        if (AMModelBase.debug.messageEnabled()) {
            this.debugMessage("SMNavModel.buildLocalizedLookup: " + set2);
        }
        return hashMap;
    }

    private Map processHierarchyString(String string, Set set, ResourceBundle resourceBundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            stringArray[n2] = stringTokenizer.nextToken();
            --n2;
        }
        ResourceBundle resourceBundle2 = resourceBundle;
        int n3 = 0;
        while (n3 < n) {
            String string2;
            String string3;
            String string4 = string3 = stringArray[n3];
            if (set.contains(string3)) {
                string2 = this.getPropertiesUrl(string3);
                if (string2.length() > 0) {
                    this.propsUrlMap.put(string3, string2);
                }
                String string5 = null;
                try {
                    string5 = this.dpStoreConn.getI18NPropertiesFileName(string3);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.error("SMNavModelImpl.processHierarchyString :", (Throwable)aMException);
                }
                if (string5 != null && string5.length() > 0) {
                    ServiceSchema serviceSchema;
                    resourceBundle2 = AMResBundleCacher.getBundle(string5, this.getUserLocale());
                    if (resourceBundle2 == null) {
                        resourceBundle2 = resourceBundle;
                    }
                    if ((serviceSchema = this.getSchema(string3)) != null && ((string4 = serviceSchema.getI18NKey()) == null || string4.length() <= 0)) {
                        string4 = string3;
                    }
                } else {
                    resourceBundle2 = resourceBundle;
                    AMModelBase.debug.error("SMNavModelImpl.processHierarchyString :No property file avialable  for " + string3 + "service. Using default resource bundle");
                }
            }
            string2 = Locale.getString((ResourceBundle)resourceBundle2, (String)string4, (Debug)AMModelBase.debug, (ResourceBundle)resourceBundle);
            hashMap.put(string3, string2);
            ++n3;
        }
        return hashMap;
    }

    private ServiceSchema getSchema(String string) {
        ServiceSchema serviceSchema = null;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            Set set = serviceSchemaManager.getSchemaTypes();
            Iterator iterator = set.iterator();
            SchemaType schemaType = (SchemaType)iterator.next();
            serviceSchema = serviceSchemaManager.getSchema(schemaType);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMNavModelImpl.getSchema", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("SMNavModelImpl.getSchema", (Throwable)sMSException);
        }
        return serviceSchema;
    }

    private String getPropertiesUrl(String string) {
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getting properties viewbean url for " + string);
        }
        String string2 = null;
        try {
            string2 = this.dpStoreConn.getPropertiesViewBeanURL(string);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("SMNavModelImpl.getPropertiesUrl", (Throwable)aMException);
        }
        if (string2 == null || string2.length() == 0) {
            AMModelBase.debug.message("properties viewbean url is not set, using default");
            string2 = DEFAULT_VIEWBEAN_URL;
        } else {
            int n;
            if (string2.startsWith("/") && (n = AMSystemConfig.deploymentURI.lastIndexOf("/")) > 0) {
                string2 = AMSystemConfig.deploymentURI.substring(0, n) + string2;
            }
            if (!this.validPropertyURL(string2)) {
                string2 = DEFAULT_VIEWBEAN_URL;
            }
        }
        return string2;
    }

    private boolean validPropertyURL(String string) {
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("validating properties viewbean url " + string);
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("com.iplanet.am.console.");
        int n = -1;
        if (string.startsWith(AMSystemConfig.deploymentURI)) {
            n = AMSystemConfig.deploymentURI.length();
        } else if (string.startsWith("..")) {
            n = 2;
        }
        if (n > 0) {
            stringBuffer.append(string.substring(n + 1).replace('/', '.')).append("ViewBean");
            try {
                Class<?> clazz = Class.forName(stringBuffer.toString());
                AMModelBase.debug.message("found matching class, url is ok");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (AMModelBase.debug.messageEnabled()) {
                    AMModelBase.debug.message("could not find matching class: " + stringBuffer + "\nfalling back to " + DEFAULT_VIEWBEAN_URL);
                }
                bl = false;
            }
        }
        return bl;
    }

    public String getSvcNameLabel() {
        return this.getLocalizedString("SMSvcName.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("properties.label");
    }

    public String getPropsViewBeanURL(String string) {
        String string2 = "";
        if (string != null && string.length() > 0 && (string2 = (String)this.propsUrlMap.get(string)) == null) {
            string2 = "";
        }
        return string2;
    }

    public String getPageTitle() {
        return this.getLocalizedString("servicePageTitle");
    }
}

