/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.service.model.SMDescriptionData;
import com.iplanet.am.console.service.model.SMDiscoEntryData;
import com.iplanet.am.console.service.model.SMDiscoEntryModel;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.DescriptionType;
import com.sun.identity.liberty.ws.disco.jaxb.DirectiveType;
import com.sun.identity.liberty.ws.disco.jaxb.OptionsType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.disco.jaxb11.ObjectFactory;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;

public class SMDiscoEntryModelImpl
extends AMProfileModelBase
implements SMDiscoEntryModel {
    private static com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory discoFac = DiscoUtils.getDiscoFactory();
    private static ObjectFactory disco11Fac = DiscoUtils.getDisco11Factory();
    private static com.sun.identity.liberty.ws.disco.plugins.jaxb.ObjectFactory entryFac = DiscoUtils.getDiscoEntryFactory();
    private String entryId = null;
    private List directivesList = Collections.EMPTY_LIST;

    public SMDiscoEntryModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public void deleteDescriptions(List list, SMDiscoEntryData sMDiscoEntryData) {
        if (list != null && !list.isEmpty() && sMDiscoEntryData != null) {
            int n = list.size();
            List list2 = sMDiscoEntryData.getDescriptionData();
            if (list2 != null && !list2.isEmpty()) {
                int n2 = 0;
                while (n2 < n) {
                    String string = (String)list.get(n2);
                    int n3 = 0;
                    while (n3 < list2.size()) {
                        SMDescriptionData sMDescriptionData = (SMDescriptionData)list2.get(n3);
                        List list3 = sMDescriptionData.getSecurityMechId();
                        if (list3.contains(string)) {
                            list2.remove(n3);
                            break;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
        } else {
            AMModelBase.debug.warning("nothing to delete");
        }
    }

    public void setSMDescriptionDataHandler(SMDiscoEntryData sMDiscoEntryData, int n) {
        if (sMDiscoEntryData == null) {
            AMModelBase.debug.warning("disco entry data object is null");
            return;
        }
        List list = sMDiscoEntryData.getDescriptionData();
        SMDescriptionData sMDescriptionData = (SMDescriptionData)list.get(n);
        sMDescriptionData.setNewEntry(false);
        sMDiscoEntryData.setSMDescriptionDataHandler(sMDescriptionData);
    }

    public void createDiscoEntry(SMDiscoEntryData sMDiscoEntryData, boolean bl) throws AMConsoleException {
        try {
            DiscoEntryElement discoEntryElement;
            String string;
            ResourceOfferingType resourceOfferingType = discoFac.createResourceOfferingType();
            ResourceIDType resourceIDType = discoFac.createResourceIDType();
            if (bl) {
                string = sMDiscoEntryData.getResourceIdAttribute();
                if (string != null && string.length() > 0) {
                    resourceIDType.setId(string);
                }
                resourceIDType.setValue(sMDiscoEntryData.getResourceIdValue());
                resourceOfferingType.setEntryID(sMDiscoEntryData.getEntryId());
            } else {
                resourceIDType.setValue("");
            }
            string = this.createServiceInstanceEntry(sMDiscoEntryData);
            List list = string.getDescription();
            resourceOfferingType.setServiceInstance((ServiceInstanceType)string);
            resourceOfferingType.setResourceID(resourceIDType);
            String string2 = sMDiscoEntryData.getAbstract();
            if (string2 != null && string2.length() > 0) {
                resourceOfferingType.setAbstract(string2);
            }
            if (!sMDiscoEntryData.isNoOption()) {
                discoEntryElement = this.createOptionsEntry(sMDiscoEntryData);
                resourceOfferingType.setOptions((OptionsType)discoEntryElement);
            }
            discoEntryElement = entryFac.createDiscoEntryElement();
            discoEntryElement.setResourceOffering(resourceOfferingType);
            this.createDirectivesEntry(sMDiscoEntryData, discoEntryElement, list);
            String string3 = this.convertDiscoEntryToXmlStr(discoEntryElement);
            if (string3 == null || string3.length() == 0) {
                AMModelBase.debug.warning("No disco string was created.");
                throw new AMConsoleException(this.getLocalizedString("discoEntryFailed.message"));
            }
            sMDiscoEntryData.setDiscoStr(string3);
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("createDiscoEntry str = " + string3);
            }
        }
        catch (JAXBException jAXBException) {
            AMModelBase.debug.warning("SMDiscoEntryModelImpl.createDiscoEntry", (Throwable)jAXBException);
            Throwable throwable = jAXBException.getLinkedException();
            String string = jAXBException.toString();
            if (throwable != null) {
                string = throwable.getMessage();
            }
            throw new AMConsoleException(string);
        }
    }

    private OptionsType createOptionsEntry(SMDiscoEntryData sMDiscoEntryData) throws JAXBException {
        OptionsType optionsType = discoFac.createOptionsType();
        List list = sMDiscoEntryData.getOptions();
        if (list != null && !list.isEmpty()) {
            optionsType.getOption().addAll(list);
        }
        return optionsType;
    }

    public DescriptionType createDescriptionEntry(SMDescriptionData sMDescriptionData) throws JAXBException {
        DescriptionType descriptionType = discoFac.createDescriptionType();
        descriptionType.setId(sMDescriptionData.getDescriptionID());
        List list = sMDescriptionData.getSecurityMechId();
        if (list != null && !list.isEmpty()) {
            descriptionType.getSecurityMechID().addAll(list);
        }
        if (sMDescriptionData.isBriefSoapHttp()) {
            String string = sMDescriptionData.getSoapAction();
            if (string != null && string.length() > 0) {
                descriptionType.setSoapAction(string);
            }
            descriptionType.setEndpoint(sMDescriptionData.getEndPointUrl());
        } else {
            QName qName = new QName(sMDescriptionData.getServiceNameReferenceNameSpace(), sMDescriptionData.getServiceNameReferenceLocalPart());
            descriptionType.setServiceNameRef(qName);
            descriptionType.setWsdlURI(sMDescriptionData.getWSDLURI());
        }
        return descriptionType;
    }

    public ServiceInstanceType createServiceInstanceEntry(SMDiscoEntryData sMDiscoEntryData) throws JAXBException {
        ServiceInstanceType serviceInstanceType = discoFac.createServiceInstanceType();
        serviceInstanceType.setProviderID(sMDiscoEntryData.getProviderId());
        serviceInstanceType.setServiceType(sMDiscoEntryData.getServiceType());
        List list = sMDiscoEntryData.getDescriptionData();
        List list2 = serviceInstanceType.getDescription();
        DescriptionType descriptionType = null;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            descriptionType = this.createDescriptionEntry((SMDescriptionData)list.get(n2));
            list2.add(descriptionType);
            ++n2;
        }
        return serviceInstanceType;
    }

    public String getTableCaptionLabel() {
        return this.getLocalizedString("descriptionTableCaption.header");
    }

    public boolean hasDescription(SMDiscoEntryData sMDiscoEntryData) {
        if (sMDiscoEntryData != null) {
            return sMDiscoEntryData.hasDescription();
        }
        return false;
    }

    public List getDirectives() {
        Set set;
        if ((this.directivesList == null || this.directivesList.isEmpty()) && (set = DiscoServiceManager.getSupportedDirectives()) != null && !set.isEmpty()) {
            this.directivesList = new ArrayList(set);
        }
        return this.directivesList;
    }

    public DescriptionType getDescriptionType(String string, List list) {
        DescriptionType descriptionType = null;
        boolean bl = false;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            List list2;
            descriptionType = (DescriptionType)list.get(n2);
            if (descriptionType != null && (list2 = descriptionType.getSecurityMechID()).contains(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl ? descriptionType : null;
    }

    public String getEditLabel() {
        return this.getLocalizedString("discoveryServiceEdit.label");
    }

    private void createDirectivesEntry(SMDiscoEntryData sMDiscoEntryData, DiscoEntryElement discoEntryElement, List list) throws JAXBException, AMConsoleException {
        Map map = sMDiscoEntryData.getDirectives();
        if (map != null && !map.isEmpty()) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AuthenticateRequesterElement authenticateRequesterElement;
                String string = (String)iterator.next();
                List list2 = (List)map.get(string);
                if (string.equals("AuthenticateRequester")) {
                    authenticateRequesterElement = discoFac.createAuthenticateRequesterElement();
                    this.createDirectiveEntry(discoEntryElement, (DirectiveType)authenticateRequesterElement, list2, list);
                    continue;
                }
                if (string.equals("EncryptResourceID")) {
                    authenticateRequesterElement = discoFac.createEncryptResourceIDElement();
                    this.createDirectiveEntry(discoEntryElement, (DirectiveType)authenticateRequesterElement, list2, list);
                    continue;
                }
                if (string.equals("AuthenticateSessionContext")) {
                    authenticateRequesterElement = discoFac.createAuthenticateSessionContextElement();
                    this.createDirectiveEntry(discoEntryElement, (DirectiveType)authenticateRequesterElement, list2, list);
                    continue;
                }
                if (string.equals("AuthorizeRequester")) {
                    authenticateRequesterElement = discoFac.createAuthorizeRequesterElement();
                    this.createDirectiveEntry(discoEntryElement, (DirectiveType)authenticateRequesterElement, list2, list);
                    continue;
                }
                if (string.equals("GenerateBearerToken")) {
                    authenticateRequesterElement = disco11Fac.createGenerateBearerTokenElement();
                    this.createDirectiveEntry(discoEntryElement, (DirectiveType)authenticateRequesterElement, list2, list);
                    continue;
                }
                if (string.equals("SendSingleLogOut")) {
                    authenticateRequesterElement = disco11Fac.createSendSingleLogOutElement();
                    this.createDirectiveEntry(discoEntryElement, (DirectiveType)authenticateRequesterElement, list2, list);
                    continue;
                }
                AMModelBase.debug.error("not supported directive  " + string);
            }
        }
    }

    private String convertDiscoEntryToXmlStr(DiscoEntryElement discoEntryElement) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((String)Utils.getJAXBPackages());
        Marshaller marshaller = jAXBContext.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)discoEntryElement, (Writer)stringWriter);
        return stringWriter.getBuffer().toString();
    }

    private void createDirectiveEntry(DiscoEntryElement discoEntryElement, DirectiveType directiveType, List list, List list2) throws AMConsoleException {
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                DescriptionType descriptionType = this.getDescriptionType(string, list2);
                if (descriptionType == null) {
                    throw new AMConsoleException(this.getLocalizedString("invalidDescIdRefs.message"));
                }
                directiveType.getDescriptionIDRefs().add(descriptionType);
            }
        }
        discoEntryElement.getAny().add(directiveType);
    }

    public String getResourceIdAttributeLabel() {
        return this.getLocalizedString("resourceIdAttribute.label");
    }

    public String getResourceIdValueLabel() {
        return this.getLocalizedString("resourceIdValue.label");
    }

    public String getServiceTypeLabel() {
        return this.getLocalizedString("discoServiceEntryServiceType.label");
    }

    public String getProviderIdLabel() {
        return this.getLocalizedString("providerID.label");
    }

    public String getServiceInstanceLabel() {
        return this.getLocalizedString("serviceInstance.label");
    }

    public String getDescriptionLabel() {
        return this.getLocalizedString("serviceDescription.label");
    }

    public String getOKButtonLabel() {
        return this.getLocalizedString("ok.button");
    }

    public String getResourceOfferingTitle(boolean bl) {
        if (bl) {
            return this.getLocalizedString("newResourceOffering.title");
        }
        return this.getLocalizedString("editResourceOffering.title");
    }

    public String getSecurityIdLabel() {
        return this.getLocalizedString("securityId.label");
    }

    public String getNewBtnLabel() {
        return this.getLocalizedString("new.button");
    }

    public String getDeleteBtnLabel() {
        return this.getLocalizedString("delete.button");
    }

    public String getAbstractLabel() {
        return this.getLocalizedString("abstract.label");
    }

    public String getNoDescriptionEntryMessage() {
        return this.getLocalizedString("noDescriptionEntry.message");
    }

    public String getNoOptionsLabel() {
        return this.getLocalizedString("noOptions.label");
    }

    public String getDescriptionIdRefsLabel() {
        return this.getLocalizedString("descIdRefs.label");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getMissingFieldsMessage() {
        return this.getLocalizedString("missingAttributes.message");
    }

    public String getEntryID() {
        if (this.entryId == null) {
            this.entryId = SAMLUtilsCommon.generateID();
        }
        return this.entryId;
    }

    public void setEntryID(String string) {
        this.entryId = string;
    }

    public boolean hasDirective() {
        List list = this.getDirectives();
        return list != null && !list.isEmpty();
    }

    public String getAbstractHelpLabel() {
        return this.getLocalizedString("abstractHelp.label");
    }

    public String getServiceTypeHelpLabel() {
        return this.getLocalizedString("serviceTypeHelp.label");
    }

    public String getProviderIdHelpLabel() {
        return this.getLocalizedString("providerIdHelp.label");
    }

    public String getResourceOfferingOptionsLabel() {
        return this.getLocalizedString("resourceOfferingOptions.label");
    }

    public String getOptionsLabel() {
        return this.getLocalizedString("options.label");
    }

    public String getDirectivesHeaderLabel() {
        return this.getLocalizedString("directivesHeader.label");
    }

    public String getDirectivesLabel() {
        return this.getLocalizedString("directives.label");
    }

    public String getAddBtnLabel() {
        return this.getLocalizedString("add.button");
    }

    public String getRemoveBtnLabel() {
        return this.getLocalizedString("remove.button");
    }

    public String getNoDescriptionSelectedForDeletionTitle() {
        return this.getLocalizedString("noDescriptionSelectedForDeletion.title");
    }

    public String getNoDescriptionSelectedForDeletionMessage() {
        return this.getLocalizedString("noDescriptionSelectedForDeletion.message");
    }

    public String getDescriptionHelpLabel() {
        return this.getLocalizedString("discoServiceEntryDescription.help");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("discoServiceEntry.help");
        if (string.equals("discoServiceEntry.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

