/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.service.model.SMDescriptionData;
import com.iplanet.am.console.service.model.SMDescriptionModel;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.ISValidUtils;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SMDescriptionModelImpl
extends AMProfileModelBase
implements SMDescriptionModel {
    private static final String SERVICE_NAME = "sunIdentityServerDiscoveryService";
    private static final String MECH_IDS = "sunIdentityServerDiscoSupportedAuthnMechs";
    private String descID = null;
    private int type = 0;
    private Set securityMechIds = null;

    public SMDescriptionModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getDescriptionID() {
        if (this.descID == null) {
            this.descID = SAMLUtilsCommon.generateID();
        }
        return this.descID;
    }

    public void setDescriptionID(String string) {
        this.descID = string;
    }

    public String getDescriptionHeader() {
        return this.getLocalizedString("descriptionHeader.label");
    }

    public String getSecurityMechanismIDLabel() {
        return this.getLocalizedString("securityMechID.label");
    }

    public String getWsdlReferenceLabel() {
        return this.getLocalizedString("wsdlRef.label");
    }

    public String getWsdlHelpLabel() {
        return this.getLocalizedString("wsdlRefHelp.label");
    }

    public String getWsdlUriLabel() {
        return this.getLocalizedString("wsdlUri.label");
    }

    public String getServiceNameReferenceNameSpaceLabel() {
        return this.getLocalizedString("serviceNameRefNameSpace.label");
    }

    public String getServiceNameReferenceLocalPartLabel() {
        return this.getLocalizedString("serviceNameRefLocalPart.label");
    }

    public String getSoapHttpDescriptionLabel() {
        return this.getLocalizedString("soapHttpDesc.label");
    }

    public String getSoapHttpHelpLabel() {
        return this.getLocalizedString("soapHttpDescHelp.label");
    }

    public String getEndPointLabel() {
        return this.getLocalizedString("endPoint.label");
    }

    public String getSoapActionLabel() {
        return this.getLocalizedString("soapAction.label");
    }

    public String getSelectedLabel() {
        return this.getLocalizedString("securityMechIDSelected.label");
    }

    public String getAvailableLabel() {
        return this.getLocalizedString("securityMechIDAvailable.label");
    }

    public String getAddButtonLabel() {
        return this.getLocalizedString("selectableListAdd.button");
    }

    public String getAddAllButtonLabel() {
        return this.getLocalizedString("selectableListAddAll.button");
    }

    public String getRemoveButtonLabel() {
        return this.getLocalizedString("selectableListRemove.button");
    }

    public String getRemoveAllButtonLabel() {
        return this.getLocalizedString("selectableListRemoveAll.button");
    }

    public String getMoveUpButtonLabel() {
        return this.getLocalizedString("selectableListMoveUp.button");
    }

    public String getMoveDownButtonLabel() {
        return this.getLocalizedString("selectableListMoveDown.button");
    }

    public List getAvailableSecurityIds(List list) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        Set set = this.getSecurityMechanisms();
        if (set != null && !set.isEmpty()) {
            arrayList = new ArrayList(set);
            if (list != null && !list.isEmpty()) {
                ArrayList arrayList2 = new ArrayList(arrayList.size());
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    SMDescriptionData sMDescriptionData = (SMDescriptionData)list.get(n2);
                    List list2 = sMDescriptionData.getSecurityMechId();
                    if (list2 != null && !list2.isEmpty()) {
                        arrayList2.addAll(list2);
                    }
                    ++n2;
                }
                arrayList.removeAll(arrayList2);
            }
        }
        return arrayList;
    }

    public String getMissingFieldsMessage() {
        return this.getLocalizedString("missingAttributes.message");
    }

    public String getDescriptionTitle(boolean bl) {
        if (bl) {
            return this.getLocalizedString("newDescription.title");
        }
        return this.getLocalizedString("editDescription.title");
    }

    public void setEntryType(int n) {
        this.type = n;
    }

    private Set getSecurityMechanisms() {
        if (this.type == 0) {
            return DiscoServiceManager.getSupportedAuthenticationMechanisms();
        }
        return this.getAllSecurityMechIds();
    }

    private Set getAllSecurityMechIds() {
        if (this.securityMechIds == null || this.securityMechIds.isEmpty()) {
            try {
                String[] stringArray;
                AttributeSchema attributeSchema;
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(SERVICE_NAME);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
                if (serviceSchema != null && (attributeSchema = serviceSchema.getAttributeSchema(MECH_IDS)) != null && (stringArray = attributeSchema.getChoiceValues()) != null && stringArray.length > 0) {
                    this.securityMechIds = new HashSet(stringArray.length);
                    int n = 0;
                    while (n < stringArray.length) {
                        this.securityMechIds.add(stringArray[n]);
                        ++n;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("SMDescriptionModelImpl.getAllSecurityMechIds", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("SMDescriptionModelImpl.getAllSecurityMechIds", (Throwable)sMSException);
            }
        }
        return this.securityMechIds;
    }

    public boolean isValidQName(String string) {
        return ISValidUtils.isValidQName((String)string);
    }

    public String getInvalidLocalPartMessage() {
        return this.getLocalizedString("invalidLocalPart.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("discoveryServiceDescription.help");
        if (string.equals("discoveryServiceDescription.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

