/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.service.model.SMCreateSubConfigModel;
import com.iplanet.am.console.service.model.SMSubConfigModelBase;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class SMCreateSubConfigModelImpl
extends SMSubConfigModelBase
implements SMCreateSubConfigModel {
    private String subSchemaName;
    private List attrSchemas;
    private Map mapAttrValues;

    public SMCreateSubConfigModelImpl(HttpServletRequest httpServletRequest, Map map, String string, String string2, String string3) {
        super(httpServletRequest, map, string, string2);
        this.subSchemaName = string3;
        this.setAttrSchemas();
    }

    private void setAttrSchemas() {
        try {
            ServiceSchema serviceSchema = this.curSchema.getSubSchema(this.subSchemaName);
            Set set = serviceSchema.getAttributeSchemas();
            if (set != null && !set.isEmpty()) {
                Collator collator = Collator.getInstance(this.getUserLocale());
                TreeSet<AttributeSchema> treeSet = new TreeSet<AttributeSchema>(new AMAttrSchemaComparator(collator));
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string;
                    AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                    AttributeSchema.UIType uIType = attributeSchema.getUIType();
                    if (uIType != null && (uIType.equals((Object)AttributeSchema.UIType.LINK) || uIType.equals((Object)AttributeSchema.UIType.BUTTON)) || (string = attributeSchema.getI18NKey()) == null || string.trim().length() <= 0) continue;
                    treeSet.add(attributeSchema);
                }
                this.attrSchemas = new ArrayList(treeSet);
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("SMCreateSubConfigModelImpl.setAttrSchemas", (Throwable)sMSException);
        }
    }

    public void createSubConfiguration(String string, Map map) throws AMConsoleException {
        this.mapAttrValues = map;
        if (string == null || string.trim().length() == 0) {
            throw new AMConsoleException(this.getLocalizedString("missingSubConfigName.message"));
        }
        try {
            this.parentConfig.addSubConfig(string, this.subSchemaName, 0, map);
            Object[] objectArray = new String[]{string, this.serviceName};
            this.writeFormatLog("subConfigurationCreated.message", objectArray);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMCreateSubConfigModelImpl.createSubConfiguration", (Throwable)sSOException);
            throw new AMConsoleException(sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("SMCreateSubConfigModelImpl.createSubConfiguration", (Throwable)sMSException);
            throw new AMConsoleException(sMSException);
        }
    }

    public List getSubSchemaDynamicGUI() {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        if (this.attrSchemas != null && !this.attrSchemas.isEmpty()) {
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(this.attrSchemas.size());
            Iterator iterator = this.attrSchemas.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                Set set = this.mapAttrValues != null ? (Set)this.mapAttrValues.get(attributeSchema.getName()) : attributeSchema.getDefaultValues();
                arrayList.add(dynamicGUIGenerator.createDynamicGUI(attributeSchema, this.serviceName, set, false, this));
            }
        }
        return arrayList;
    }

    public boolean hasMoreThanOneSchema() {
        return this.creatableGlobalSubSchemas != null && this.creatableGlobalSubSchemas.size() > 1;
    }

    public String getTitle() {
        return this.creatableGlobalSubSchemas == null || this.creatableGlobalSubSchemas.size() < 2 ? this.getLocalizedString("createSubConfig.title") : this.getLocalizedString("createSubConfigWizardStep2.title");
    }

    public String getSubTitle() {
        return this.getLocalizedString("createSubConfigWizard2.secondarytitle");
    }

    public String getGlobalLabel() {
        return this.getLocalizedString("globalSvcAttr.label");
    }

    public boolean hasAttributes() {
        return this.attrSchemas != null && !this.attrSchemas.isEmpty();
    }
}

