/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMNameValueModelImpl;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.service.model.SMCharsetMappingModel;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class SMCharsetMappingModelImpl
extends AMNameValueModelImpl
implements SMCharsetMappingModel {
    private ResourceBundle svcResBundle = null;

    public SMCharsetMappingModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getKeyLabel() {
        return this.getServiceLocalizedString("locale.label");
    }

    public String getValueLabel() {
        return this.getServiceLocalizedString("charset.label");
    }

    public String getMissingLocaleMessage() {
        return this.getServiceLocalizedString("missingLocale.message");
    }

    public String getAddButtonLabel() {
        return this.getServiceLocalizedString("addCharset.button");
    }

    public String getMissingCharsetMessage() {
        return this.getServiceLocalizedString("missingCharset.message");
    }

    private String getServiceLocalizedString(String string) {
        ResourceBundle resourceBundle = this.getServiceResourceBundle();
        return Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)AMModelBase.debug);
    }

    private ResourceBundle getServiceResourceBundle() {
        if (this.svcResBundle != null) {
            return this.svcResBundle;
        }
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetG11NSettings");
            String string = serviceSchemaManager.getI18NFileName();
            if (string != null) {
                this.svcResBundle = AMResBundleCacher.getBundle(string, this.getUserLocale());
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("SMCharsetMappingModelImpl.getServiceResourceBundle", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("SMCharsetMappingModelImpl.getServiceResourceBundle", (Throwable)sMSException);
        }
        if (this.svcResBundle == null) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("SMCharsetMappingModelImpl.getServiceResourceBundle: use Console default resource bundle");
            }
            this.svcResBundle = this.resBundle;
        }
        return this.svcResBundle;
    }
}

