/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.service.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.service.model.MAPConstants;
import com.iplanet.am.console.service.model.MAPCreateDeviceModel;
import com.iplanet.am.console.service.model.MAPModelBase;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.sun.identity.sm.AttributeSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MAPCreateDeviceModelImpl
extends MAPModelBase
implements MAPCreateDeviceModel,
MAPConstants {
    private String cloneClientType;
    private String cloneDeviceName;

    public MAPCreateDeviceModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getDeviceCreationTitle() {
        return this.getLocalizedString("mapCreateClientDevice.title");
    }

    public String getCloneDeviceTitle() {
        return this.getLocalizedString("mapCloneClientDevice.title");
    }

    public String getStyleLabel() {
        return this.getLocalizedString("mapStyle.label");
    }

    public String getClientTypeLabel() {
        return this.getLocalizedString("mapClientType.label");
    }

    public String getDeviceNameLabel() {
        return this.getLocalizedString("mapDevice.label");
    }

    public String getCloneDeviceButtonLabel() {
        return this.getLocalizedString("mapCloneDevice.button");
    }

    public String getMissingClientTypeMessage() {
        return this.getLocalizedString("mapMissingClientType.message");
    }

    public String getMissingDeviceNameMessage() {
        return this.getLocalizedString("mapMissingDeviceName.message");
    }

    public Set getStyles(String string) {
        Set set = Collections.EMPTY_SET;
        DefaultClientTypesManager defaultClientTypesManager = this.getClientTypesManager();
        if (defaultClientTypesManager != null && (set = defaultClientTypesManager.getStyles(string)) == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public void createDevice() throws AMConsoleException {
        String string = AMAdminUtils.getFirstElement((Set)this.attributeValues.get("clientType"));
        if (this.getClientCapDataIntInstance().isClientPresent(string)) {
            throw new AMConsoleException(this.getLocalizedString("mapClientExist.message") + ": " + string);
        }
        if (!MAPModelBase.isClientTypeValid(string)) {
            throw new AMConsoleException(this.getLocalizedString("mapInvalidClientType.message"));
        }
        try {
            DefaultClientTypesManager defaultClientTypesManager = this.getClientTypesManager();
            defaultClientTypesManager.addClientExternal(this.ssoToken, this.attributeValues);
        }
        catch (AMClientCapException aMClientCapException) {
            AMModelBase.debug.warning("MAPCreateDeviceModelImpl.createDevice", (Throwable)aMClientCapException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMClientCapException)));
        }
    }

    public List getRequiredAttributeComponents() {
        List list = Collections.EMPTY_LIST;
        Set set = this.getRequiredAttributeSchemas();
        if (set != null && !set.isEmpty()) {
            this.getAttributeValuesInternal(set);
            List list2 = AMFormatUtils.sortAttrSchema(set, this.getUserLocale());
            list = this.getRequiredAttributeComponents(list2);
        }
        return list;
    }

    private Set getRequiredAttributeSchemas() {
        Set set;
        Set set2 = null;
        AMClientCapData aMClientCapData = this.getClientCapDataExtInstance();
        if (aMClientCapData != null && (set = AMClientCapData.getSchemaElements()) != null && !set.isEmpty()) {
            set2 = this.getAttributeSchemas(set);
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string = attributeSchema.getAny();
                if (string != null && string.indexOf("required") != -1) continue;
                iterator.remove();
            }
        }
        if (set2 == null) {
            set2 = Collections.EMPTY_SET;
        }
        return set2;
    }

    private List getRequiredAttributeComponents(List list) {
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        ArrayList<DynamicGUI> arrayList = new ArrayList<DynamicGUI>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, this.getMAPServiceName(), (Set)this.attributeValues.get(attributeSchema.getName()), this, null);
            arrayList.add(dynamicGUI);
        }
        return arrayList;
    }

    private void getAttributeValuesInternal(Set set) {
        if (this.attributeValues == null) {
            this.attributeValues = new HashMap(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                HashSet<String> hashSet;
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string = attributeSchema.getName();
                if (string.equals("parentId")) {
                    hashSet = new HashSet<String>(1);
                    hashSet.add(this.getAssociatedStyleName());
                    this.attributeValues.put(string, hashSet);
                    continue;
                }
                if (string.equals("clientType")) {
                    hashSet = new HashSet(1);
                    hashSet.add(MAPModelBase.canonicalize(this.getAssociatedClientType()));
                    this.attributeValues.put(string, hashSet);
                    continue;
                }
                if (string.equals("userAgent")) {
                    hashSet = new HashSet(1);
                    hashSet.add(this.getAssociatedClientType());
                    this.attributeValues.put(string, hashSet);
                    continue;
                }
                this.attributeValues.put(attributeSchema.getName(), attributeSchema.getDefaultValues());
            }
        }
    }

    public void setCloneClientType(String string) {
        this.cloneClientType = string;
    }

    public void setCloneDeviceName(String string) {
        this.cloneDeviceName = string;
    }

    public String getCloneClientType() {
        if (this.cloneClientType == null) {
            this.cloneClientType = this.getLocalizedString("mapCloneClient.prefix") + this.getAssociatedClientType();
        }
        return this.cloneClientType;
    }

    public String getCloneDeviceName() {
        if (this.cloneDeviceName == null) {
            this.cloneDeviceName = this.getLocalizedString("mapCloneClient.name") + " " + this.getCloningUserAgent();
        }
        return this.cloneDeviceName;
    }

    private String getCloningUserAgent() {
        Set set;
        String string = "";
        Map map = this.getCloningProperties();
        if (map != null && (set = (Set)map.get("userAgent")) != null && !set.isEmpty()) {
            string = (String)set.iterator().next();
        }
        return string;
    }

    private Map getCloningProperties() {
        AMClientCapData aMClientCapData = this.getClientCapDataIntInstance();
        Map map = aMClientCapData.getProperties(this.getAssociatedClientType());
        AMClientCapData aMClientCapData2 = this.getClientCapDataExtInstance();
        Map map2 = aMClientCapData2.getProperties(this.getAssociatedClientType());
        Map map3 = this.mergeMap(map, map2);
        return map3;
    }

    private Map mergeMap(Map map, Map map2) {
        Map map3 = null;
        if (map != null) {
            map3 = new HashMap(map);
        }
        if (map2 != null) {
            if (map3 != null) {
                map3.putAll(map2);
            } else {
                map3 = map2;
            }
        }
        return map3;
    }

    public void cloneDevice() throws AMConsoleException {
        Map map = this.getCloningProperties();
        if (map == null) {
            throw new AMConsoleException(this.getLocalizedString("mapCloneFailed.message"));
        }
        if (this.getClientCapDataIntInstance().isClientPresent(this.cloneClientType)) {
            throw new AMConsoleException(this.getLocalizedString("mapClientExist.message") + ": " + this.cloneClientType);
        }
        if (!MAPModelBase.isClientTypeValid(this.cloneClientType)) {
            throw new AMConsoleException(this.getLocalizedString("mapInvalidClientType.message"));
        }
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(this.cloneClientType);
        map.put("clientType", hashSet);
        hashSet = new HashSet(1);
        hashSet.add(this.cloneDeviceName);
        map.put("userAgent", hashSet);
        try {
            DefaultClientTypesManager defaultClientTypesManager = this.getClientTypesManager();
            defaultClientTypesManager.addClientExternal(this.ssoToken, map);
        }
        catch (AMClientCapException aMClientCapException) {
            AMModelBase.debug.warning("MAPCreateDeviceModelImpl.cloneDevice", (Throwable)aMClientCapException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMClientCapException)));
        }
    }
}

