/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.policy.model.PMProfileModelBase;
import com.iplanet.am.console.policy.model.PMProfileSubjectsModel;
import com.iplanet.sso.SSOException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PMProfileSubjectsModelImpl
extends PMProfileModelBase
implements PMProfileSubjectsModel {
    private int subjectView = 4;
    private SubjectTypeManager subjectTypeMgr = null;
    private Subject cachedSubject = null;
    protected String searchError = null;

    public PMProfileSubjectsModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectLabel() {
        return this.getLocalizedString("subjectSelect.label");
    }

    public String getSubjectNameLabel() {
        return this.getLocalizedString("subjectName.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("subjectProperties.label");
    }

    public String getDeleteSelectedSubjectBtnLabel() {
        return this.getLocalizedString("deleteSubject.button");
    }

    public String getAddSubjectBtnLabel() {
        return this.getLocalizedString("addSubject.button");
    }

    public String getNoSearchResultMessage() {
        return this.getLocalizedString("subjectNoSearchResult.message");
    }

    public String getNoSubjectsMessage() {
        return this.getLocalizedString("noSubjects.message");
    }

    public String getSubjectTypeLabel() {
        return this.getLocalizedString("subjectType.label");
    }

    public String getHasNoSubjectValueMessage() {
        return this.getLocalizedString("hasNoSubjectValue.message");
    }

    public String getMissingSubjectNameMessage() {
        return this.getLocalizedString("missingSubjectName.message");
    }

    public String getMissingSubjectValueMessage() {
        return this.getLocalizedString("missingSubjectValue.message");
    }

    public String getAddSubjectTitle(String string) {
        return this.getLocalizedString("newSubjectStep" + string + ".title");
    }

    public Set getSubjectTypeNames() throws AMConsoleException {
        Set set = Collections.EMPTY_SET;
        try {
            SubjectTypeManager subjectTypeManager = this.getSubjectTypeMgr();
            if (subjectTypeManager != null) {
                set = subjectTypeManager.getSelectedSubjectTypeNames();
                set.remove("AMIdentitySubject");
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectTypeNames", (Throwable)sSOException);
        }
        catch (PolicyException policyException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
        }
        return set;
    }

    public Set getSubjectNames() {
        return this.getSubjectNames(null);
    }

    public Set getSubjectNames(String string) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (string == null || !string.equals("AMIdentitySubject")) {
            Set set;
            SubjectTypeManager subjectTypeManager = null;
            try {
                subjectTypeManager = this.getSubjectTypeMgr();
            }
            catch (AMConsoleException aMConsoleException) {
                AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectNames", (Throwable)aMConsoleException);
            }
            if (this.policy != null && subjectTypeManager != null && (set = this.policy.getSubjectNames()) != null && set.size() > 0) {
                hashSet = new HashSet<String>(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    try {
                        Subject subject = this.policy.getSubject(string2);
                        if (string != null && !subjectTypeManager.getSubjectTypeName(subject).equals(string)) continue;
                        hashSet.add(string2);
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectNames", (Throwable)nameNotFoundException);
                    }
                }
            }
        }
        return hashSet;
    }

    public String getSubjectTypeLocalizedName(String string) {
        String string2 = string;
        try {
            SubjectTypeManager subjectTypeManager = this.getSubjectTypeMgr();
            if (subjectTypeManager != null) {
                string2 = subjectTypeManager.getDisplayName(string);
            }
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectTypeLocalizedName", (Throwable)aMConsoleException);
        }
        return string2;
    }

    public boolean hasSubjects() {
        boolean bl = false;
        SubjectTypeManager subjectTypeManager = null;
        try {
            subjectTypeManager = this.getSubjectTypeMgr();
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.hasSubjects", (Throwable)aMConsoleException);
        }
        if (this.policy != null && subjectTypeManager != null) {
            Set set = this.policy.getSubjectNames();
            bl = set != null && set.size() > 0;
        }
        return bl;
    }

    public boolean hasSubjects(String string) {
        Set set = this.getSubjectNames(string);
        return !set.isEmpty();
    }

    public String getSubjectTypeName(String string) {
        String string2 = "";
        try {
            SubjectTypeManager subjectTypeManager = this.getSubjectTypeMgr();
            if (subjectTypeManager != null) {
                Subject subject = this.policy.getSubject(string);
                string2 = subjectTypeManager.getSubjectTypeName(subject);
            }
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectTypeName", (Throwable)aMConsoleException);
        }
        catch (NameNotFoundException nameNotFoundException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectTypeName", (Throwable)nameNotFoundException);
        }
        return string2;
    }

    public void deleteSubjects(Set set) {
        if (this.policy != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getSubjectTypeName(string);
                this.policy.removeSubject(string);
                this.markPolicyModified();
                this.addLoggingMsgData(string2, string, "subjectDeleted.message", null, 2, null);
            }
        }
    }

    public int getSubjectDisplayType(String string) {
        int n = 0;
        try {
            Subject subject = this.getSubjectObj(string);
            if (subject != null) {
                Syntax syntax = subject.getValueSyntax(this.ssoToken);
                n = AMDisplayTypeConverter.getDisplayType(syntax);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectDisplayType", (Throwable)sSOException);
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectDisplayType", (Throwable)aMConsoleException);
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectDisplayType", (Throwable)policyException);
        }
        return n;
    }

    public String getLocalizedSubjectValueLabel() {
        return this.getLocalizedString("subjectValues.label");
    }

    public String getSearchErrorMsg() {
        return this.searchError;
    }

    public Set getPossibleValues(String string) throws AMConsoleException {
        return this.getPossibleValues(string, "*");
    }

    public Set getPossibleValues(String string, String string2) throws AMConsoleException {
        this.searchError = null;
        Set set = null;
        try {
            ValidValues validValues;
            Subject subject = this.getSubjectObj(string);
            if (subject != null && (validValues = subject.getValidValues(this.ssoToken, string2)) != null) {
                set = validValues.getSearchResults();
                int n = validValues.getErrorCode();
                if (n == 1) {
                    this.searchError = this.getLocalizedString("sizeLimitExceeded.message");
                } else if (n == 2) {
                    this.searchError = this.getLocalizedString("timeLimitExceeded.message");
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getPossibleValues", (Throwable)sSOException);
            String string3 = this.getLocalizedString("cannotGetSubjects.message");
            Object[] objectArray = new String[]{this.getErrorString((Exception)((Object)sSOException))};
            throw new AMConsoleException(MessageFormat.format(string3, objectArray));
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getPossibleValues", (Throwable)policyException);
            String string4 = this.getLocalizedString("cannotGetSubjects.message");
            Object[] objectArray = new String[]{this.getErrorString((Exception)((Object)policyException))};
            throw new AMConsoleException(MessageFormat.format(string4, objectArray));
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public String getDisplayNameForValue(String string, String string2) {
        String string3 = string2;
        try {
            Subject subject = this.getSubjectObj(string);
            if (subject != null) {
                string3 = subject.getDisplayNameForValue(string2, this.getUserLocale());
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getDisplayNameForValue", (Throwable)nameNotFoundException);
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getDisplayNameForValue", (Throwable)aMConsoleException);
        }
        return string3;
    }

    public void addSubject(String string, String string2, Set set, boolean bl) throws AMConsoleException {
        if (this.policy != null) {
            try {
                Subject subject = this.getSubjectObj(string);
                if (subject != null) {
                    Syntax syntax = subject.getValueSyntax(this.ssoToken);
                    if (!syntax.equals((Object)Syntax.CONSTANT)) {
                        subject.setValues(set);
                    }
                    this.policy.addSubject(string2, subject, bl);
                    this.markPolicyModified();
                    this.addLoggingMsgData(string, string2, "subjectCreated.message", "subjectUpdated.message", 0, null);
                }
            }
            catch (InvalidNameException invalidNameException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)invalidNameException)));
            }
            catch (NameAlreadyExistsException nameAlreadyExistsException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)nameAlreadyExistsException)));
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (PolicyException policyException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
            }
        }
    }

    public void replaceSubject(String string, String string2, String string3, Set set, boolean bl) throws AMConsoleException {
        if (this.policy != null) {
            this.deleteAddSubject(string, string2, string3, set, bl);
            this.addLoggingMsgData(string, string3, "subjectNameUpdated.message", null, 1, string2);
        }
    }

    private void deleteAddSubject(String string, String string2, String string3, Set set, boolean bl) throws AMConsoleException {
        Subject subject = this.policy.removeSubject(string2);
        try {
            this.addSubject(string, string3, set, bl);
        }
        catch (AMConsoleException aMConsoleException) {
            try {
                this.policy.addSubject(string2, subject);
            }
            catch (NameAlreadyExistsException nameAlreadyExistsException) {
                AMModelBase.debug.warning("PMProfileSubjectsModelImpl.deleteAddSubject", (Throwable)nameAlreadyExistsException);
            }
            catch (InvalidNameException invalidNameException) {
                AMModelBase.debug.warning("PMProfileSubjectsModelImpl.deleteAddSubject", (Throwable)invalidNameException);
            }
            throw aMConsoleException;
        }
    }

    public Set getSubjectValues(String string) {
        Set set = null;
        if (this.policy != null) {
            try {
                Subject subject = this.policy.getSubject(string);
                if (subject != null) {
                    set = subject.getValues();
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectValues", (Throwable)nameNotFoundException);
            }
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public boolean canAddSubject(String string) throws AMConsoleException {
        boolean bl = false;
        try {
            Subject subject;
            SubjectTypeManager subjectTypeManager = this.getSubjectTypeMgr();
            if (subjectTypeManager != null && (subject = this.getSubjectObj(string)) != null) {
                Syntax syntax = subject.getValueSyntax(this.ssoToken);
                bl = !syntax.equals((Object)Syntax.NONE);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getSubjectTypeNames", (Throwable)sSOException);
        }
        catch (PolicyException policyException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
        }
        return bl;
    }

    public String getViewBeanURL(String string) {
        String string2 = null;
        try {
            Subject subject;
            SubjectTypeManager subjectTypeManager = this.getSubjectTypeMgr();
            if (subjectTypeManager != null && (subject = this.getSubjectObj(string)) != null) {
                string2 = subjectTypeManager.getViewBeanURL(subject);
            }
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.getViewBeanURL", (Throwable)aMConsoleException);
        }
        return string2;
    }

    public String getNoSubjectTitle() {
        return this.getLocalizedString("noSubject.title");
    }

    public String getNoSubjectMessage() {
        return this.getLocalizedString("noSubject.message");
    }

    private SubjectTypeManager getSubjectTypeMgr() throws AMConsoleException {
        PolicyManager policyManager;
        if (this.subjectTypeMgr == null && (policyManager = this.getPolicyManager()) != null) {
            this.subjectTypeMgr = policyManager.getSubjectTypeManager();
        }
        return this.subjectTypeMgr;
    }

    protected Subject getSubjectObj(String string) throws AMConsoleException {
        if (this.cachedSubject == null) {
            try {
                SubjectTypeManager subjectTypeManager = this.getSubjectTypeMgr();
                if (subjectTypeManager != null) {
                    this.cachedSubject = subjectTypeManager.getSubject(string);
                }
            }
            catch (PolicyException policyException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
            }
        }
        return this.cachedSubject;
    }

    public String getEditSubjectLabel() {
        return this.getLocalizedString("editSubject.label");
    }

    public String getCannotCreateSubjectMsg() {
        return this.getLocalizedString("cannotCreateSubject.message");
    }

    public String getNoSubjectSelectedForDeletionTitle() {
        return this.getLocalizedString("noSubjectSelectedForDeletion.title");
    }

    public String getNoSubjectSelectedForDeletionMessage() {
        return this.getLocalizedString("noSubjectSelectedForDeletion.message");
    }

    public String getNoSubjectForCreationTitle() {
        return this.getLocalizedString("noSubjectTypeForCreation.title");
    }

    public String getNoSubjectForCreationMessage() {
        return this.getLocalizedString("noSubjectTypeForCreation.message");
    }

    public String getExclusiveLabel() {
        return this.getLocalizedString("subjectExclusive.label");
    }

    public boolean isSubjectExclusive(String string) {
        try {
            return this.policy != null && this.policy.isSubjectExclusive(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            AMModelBase.debug.warning("PMProfileSubjectsModelImpl.isSubjectExclusive", (Throwable)nameNotFoundException);
            return false;
        }
    }

    public void setSubjectView(int n) {
        this.subjectView = n;
    }

    public String getHelpAnchorTag() {
        String string = null;
        switch (this.subjectView) {
            case 1: {
                string = this.getLocalizedString("policyProfileAddSubject.help");
                break;
            }
            case 2: {
                string = this.getLocalizedString("policyProfileEditSubject.help");
                break;
            }
            case 3: {
                string = this.getLocalizedString("policyProfilePromptSubject.help");
                break;
            }
            default: {
                string = this.getLocalizedString("policyProfileSubjects.help");
            }
        }
        if (string.endsWith(".help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getAddSubjectsAssignedMessage() {
        return this.getLocalizedString("allSubjectsAssigned.message");
    }

    public int getNumberOfSubjects() {
        Set set = null;
        if (this.policy != null) {
            set = this.policy.getSubjectNames();
        }
        return set != null ? set.size() : 0;
    }

    public String getWizardInformation(String string) {
        return this.getLocalizedString("subjectWizardStep" + string + ".message");
    }
}

