/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.policy.model.PMProfileModelBase;
import com.iplanet.am.console.policy.model.PMProfileRulesModel;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PMProfileRulesModelImpl
extends PMProfileModelBase
implements PMProfileRulesModel {
    private int ruleView = 3;
    private ServiceTypeManager svcTypeMgr = null;
    private Set rules = null;
    private Map mapSvcTypeNameToActions = null;
    private Map mapSvcTypeNameToResBundle = null;
    private Map mapSvcNameToManagedResource = new HashMap();

    public PMProfileRulesModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public Set getServiceTypeNames() {
        Set set;
        block7: {
            set = null;
            try {
                ServiceTypeManager serviceTypeManager = this.getServiceTypeMgr();
                set = serviceTypeManager.getServiceTypeNames();
                if (set == null) {
                    set = Collections.EMPTY_SET;
                }
            }
            catch (SSOException sSOException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("PMProfileRulesPeer.getServiceTypeNames", (Throwable)sSOException);
                }
            }
            catch (NoPermissionException noPermissionException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("PMProfileRulesPeer.getServiceTypeNames", (Throwable)noPermissionException);
                }
            }
            catch (AMConsoleException aMConsoleException) {
                if (!AMModelBase.debug.warningEnabled()) break block7;
                AMModelBase.debug.warning("PMProfileRulesPeer.getServiceTypeNames", (Throwable)aMConsoleException);
            }
        }
        return set;
    }

    public String getSvcTypeLocalizedName(String string) {
        return this.getLocalizedServiceName(string);
    }

    public String getNoRulesMessage() {
        return this.getLocalizedString("noRules.message");
    }

    public String getDeleteSelectedRuleBtnLabel() {
        return this.getLocalizedString("deleteSelectedRule.button");
    }

    public String getAddRuleBtnLabel() {
        return this.getLocalizedString("addRule.button");
    }

    public boolean hasRules() {
        Set set = this.getRules();
        return set != null && set.size() > 0;
    }

    public String getSelectLabel() {
        return this.getLocalizedString("ruleSelect.label");
    }

    public String getRuleNameLabel() {
        return this.getLocalizedString("ruleName.label");
    }

    public String getResourcePrefixLabel() {
        return this.getLocalizedString("ruleResourcePrefix.label");
    }

    public String getResourceLabel() {
        return this.getLocalizedString("ruleResource.label");
    }

    public String getServiceLabel() {
        return this.getLocalizedString("serviceType.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("ruleProperties.label");
    }

    public Set getRuleNames() {
        Set set = Collections.EMPTY_SET;
        if (this.policy != null) {
            set = this.policy.getRuleNames();
        }
        return set;
    }

    public Set getSelectedActions(String string) {
        Map map;
        HashSet hashSet = Collections.EMPTY_SET;
        Rule rule = this.getRule(string);
        if (rule != null && (map = rule.getActionValues()) != null && !map.isEmpty()) {
            hashSet = new HashSet(map.size());
            hashSet.addAll(map.keySet());
        }
        return hashSet;
    }

    public String getResourceName(String string) {
        String string2 = "";
        Rule rule = this.getRule(string);
        if (rule != null) {
            string2 = rule.getResourceName();
        }
        return string2;
    }

    public String getServiceTypeName(String string) {
        String string2 = "";
        Rule rule = this.getRule(string);
        if (rule != null) {
            string2 = rule.getServiceTypeName();
        }
        return string2;
    }

    public Map getActionValues(String string) {
        Map<String, Set> map = new HashMap();
        Rule rule = this.getRule(string);
        if (rule != null) {
            boolean bl = rule.getResourceName() != null;
            String string2 = rule.getServiceTypeName();
            map = this.getDefaultActionValues(string2, bl);
            Map map2 = rule.getActionValues();
            if (map2 != null && !map2.isEmpty()) {
                Iterator iterator = map2.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    Set set = (Set)map2.get(string3);
                    if (set == null) continue;
                    map.put(string3, set);
                }
            }
        }
        return map;
    }

    public Map getDefaultActionValues(String string, boolean bl) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        Map map = this.getSvcTypeNameToActionsMap();
        Set set = (Set)map.get(string);
        if (set != null && set.size() > 0) {
            hashMap = new HashMap(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ActionSchema actionSchema = (ActionSchema)iterator.next();
                if (actionSchema.requiresResourceName() != bl) continue;
                Set set2 = actionSchema.getDefaultValues();
                if (set2 != null) {
                    hashMap.put(actionSchema.getName(), set2);
                    continue;
                }
                hashMap.put(actionSchema.getName(), Collections.EMPTY_SET);
            }
        }
        return hashMap;
    }

    public Set getRuleNames(String string, boolean bl) {
        Set set = this.getRules();
        HashSet<String> hashSet = new HashSet<String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            String string2 = rule.getServiceTypeName();
            if (!string2.equals(string)) continue;
            String string3 = rule.getResourceName();
            if (string3 != null && string3.length() == 0) {
                string3 = null;
            }
            if ((string3 != null || bl) && (string3 == null || !bl)) continue;
            hashSet.add(rule.getName());
        }
        return hashSet;
    }

    public void deleteRules(Set set) throws AMConsoleException {
        if (this.policy != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getServiceTypeName(string);
                this.policy.removeRule(string);
                this.markPolicyModified();
                this.addLoggingMsgData(string2, string, "ruleDeleted.message", null, 2, null);
            }
            this.rules = null;
            this.getRules();
        }
    }

    public boolean canCreateRuleWithAndWithoutRes(String string) {
        return this.canCreateRuleWithRes(string) && this.canCreateRuleWithoutRes(string);
    }

    public boolean canCreateRuleWithRes(String string) {
        boolean bl = false;
        Set set = this.getActionNamesWithResName(string);
        if (!set.isEmpty()) {
            List list;
            bl = this.canCreateNewResource(string) ? true : (list = this.getManagedResources(string)).size() > 0;
        }
        return bl;
    }

    public boolean canCreateRuleWithoutRes(String string) {
        Set set;
        boolean bl = false;
        Set set2 = this.getActionNamesWithoutResName(string);
        if (!set2.isEmpty() && (set = this.getRuleNames(string, false)).size() == 0) {
            List list;
            bl = this.isRootSuffix() ? true : (list = this.getManagedResources(string)).size() > 0;
        }
        return bl;
    }

    public Set getActionNames(String string, boolean bl) {
        Set set = null;
        set = bl ? this.getActionNamesWithResName(string) : this.getActionNamesWithoutResName(string);
        return set;
    }

    public Set getActionNamesWithResName(String string) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        Map map = this.getSvcTypeNameToActionsMap();
        Set set = (Set)map.get(string);
        if (set != null && set.size() > 0) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ActionSchema actionSchema = (ActionSchema)iterator.next();
                if (actionSchema == null || !this.isActionSchemaSupported(actionSchema) || !actionSchema.requiresResourceName()) continue;
                hashSet.add(actionSchema.getName());
            }
        }
        return hashSet;
    }

    public Set getActionNamesWithoutResName(String string) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        Map map = this.getSvcTypeNameToActionsMap();
        Set set = (Set)map.get(string);
        if (set != null && !set.isEmpty()) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ActionSchema actionSchema = (ActionSchema)iterator.next();
                if (actionSchema.requiresResourceName()) continue;
                hashSet.add(actionSchema.getName());
            }
        }
        return hashSet;
    }

    public boolean canCreateNewResource(String string) {
        boolean bl = false;
        try {
            ResourceManager resourceManager;
            PolicyManager policyManager = this.getPolicyManager();
            if (policyManager != null && (resourceManager = policyManager.getResourceManager()) != null) {
                try {
                    bl = resourceManager.canCreateNewResource(string);
                }
                catch (PolicyException policyException) {
                    AMModelBase.debug.warning("PMProfileRulesPeer.canCreateNewResource", (Throwable)policyException);
                }
            }
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileRulesModelImpl.canCreateNewResource", (Throwable)aMConsoleException);
        }
        return bl;
    }

    public List getManagedResources(String string) {
        List list = (List)this.mapSvcNameToManagedResource.get(string);
        if (list == null) {
            list = Collections.EMPTY_LIST;
            try {
                ResourceManager resourceManager;
                Set set;
                PolicyManager policyManager = this.getPolicyManager();
                if (policyManager != null && (set = (resourceManager = policyManager.getResourceManager()).getManagedResourceNames(string)) != null && !set.isEmpty()) {
                    list = AMFormatUtils.sortItemsInSet(set, this.getUserLocale());
                }
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMProfileRulesModelImpl.getManagedResources", (Throwable)policyException);
            }
            catch (AMConsoleException aMConsoleException) {
                AMModelBase.debug.warning("PMProfileRulesModelImpl.getManagedResources", (Throwable)aMConsoleException);
            }
            this.mapSvcNameToManagedResource.put(string, list);
        }
        return list;
    }

    public String getAddRuleTitle(String string) {
        return this.getLocalizedString("newRuleStep" + string + ".title");
    }

    public String getSvcTypelabel() {
        return this.getLocalizedString("serviceType.label");
    }

    public String getResourceNameTitle() {
        return this.getLocalizedString("resourceName.title");
    }

    public String getResourceNameLabel() {
        return this.getLocalizedString("resourceName.label");
    }

    public String getActionValuesTitle() {
        return this.getLocalizedString("actionValues.title");
    }

    public String getActionValuesHelp() {
        return this.getLocalizedString("actionValues.help");
    }

    public String getActionValuesSelectLabel() {
        return this.getLocalizedString("actionValuesSelect.label");
    }

    public String getActionValuesActionLabel() {
        return this.getLocalizedString("actionValuesAction.label");
    }

    public String getActionValuesValueLabel() {
        return this.getLocalizedString("actionValuesValue.label");
    }

    public String getActionLocalizedName(String string, String string2) {
        String string3 = string2;
        ActionSchema actionSchema = this.getActionSchema(string, string2);
        if (actionSchema != null) {
            ResourceBundle resourceBundle = (ResourceBundle)this.mapSvcTypeNameToResBundle.get(string);
            string3 = actionSchema.getI18NKey();
            string3 = Locale.getString((ResourceBundle)resourceBundle, (String)string3, (Debug)AMModelBase.debug);
        }
        return string3;
    }

    public DynamicGUI getDynamicGUI(String string, String string2, Set set) {
        DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
        ActionSchema actionSchema = this.getActionSchema(string, string2);
        ResourceBundle resourceBundle = (ResourceBundle)this.mapSvcTypeNameToResBundle.get(string);
        return dynamicGUIGenerator.createDynamicGUI(actionSchema, resourceBundle, set, (AMModel)this);
    }

    public String getMissingRuleNameMessage() {
        return this.getLocalizedString("missingRuleName.message");
    }

    public String getMissingResourceNameMessage() {
        return this.getLocalizedString("missingResourceName.message");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public void addRuleWithRes(String string, String string2, String string3, Map map, boolean bl) throws AMConsoleException {
        try {
            Rule rule = new Rule(string2, string, string3, map);
            this.addRule(rule);
            if (bl) {
                this.addLoggingMsgData(string, string2, "ruleCreated.message", "ruleUpdated.message", 0, null);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)nameNotFoundException)));
        }
        catch (InvalidNameException invalidNameException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)invalidNameException)));
        }
    }

    public void addRuleWithoutRes(String string, String string2, Map map, boolean bl) throws AMConsoleException {
        try {
            Rule rule = new Rule(string2, string, null, map);
            this.addRule(rule);
            if (bl) {
                this.addLoggingMsgData(string, string2, "ruleCreated.message", "ruleUpdated.message", 0, null);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)nameNotFoundException)));
        }
        catch (InvalidNameException invalidNameException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)invalidNameException)));
        }
    }

    public void replaceRuleWithRes(String string, String string2, String string3, String string4, Map map) throws AMConsoleException {
        if (this.policy != null) {
            Rule rule = this.policy.removeRule(string2);
            try {
                this.addRuleWithRes(string, string3, string4, map, false);
                if (string2.equals(string3)) {
                    this.addLoggingMsgData(string, string2, "ruleUpdated.message", null, 1, null);
                } else {
                    this.addLoggingMsgData(string, string3, "ruleNameUpdated.message", null, 1, string2);
                }
                this.markPolicyModified();
            }
            catch (AMConsoleException aMConsoleException) {
                try {
                    this.policy.addRule(rule);
                }
                catch (PolicyException policyException) {
                    AMModelBase.debug.warning("PMProfileRulesModelImpl.replaceRuleWithRes", (Throwable)policyException);
                }
                throw aMConsoleException;
            }
        }
    }

    public void replaceRuleWithoutRes(String string, String string2, String string3, Map map) throws AMConsoleException {
        if (this.policy != null) {
            this.policy.removeRule(string2);
            this.addRuleWithoutRes(string, string3, map, false);
            if (string2.equals(string3)) {
                this.addLoggingMsgData(string, string2, "ruleUpdated.message", null, 1, null);
            } else {
                this.addLoggingMsgData(string, string3, "ruleNameUpdated.message", null, 1, string2);
            }
        }
    }

    public void addRule(Rule rule) throws AMConsoleException {
        if (this.policy != null) {
            try {
                this.policy.addRule(rule);
                this.markPolicyModified();
            }
            catch (NameAlreadyExistsException nameAlreadyExistsException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)nameAlreadyExistsException)));
            }
            catch (InvalidNameException invalidNameException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)invalidNameException)));
            }
        }
    }

    protected ServiceTypeManager getServiceTypeMgr() throws AMConsoleException {
        if (this.svcTypeMgr == null) {
            try {
                this.svcTypeMgr = new ServiceTypeManager(this.ssoToken);
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
        return this.svcTypeMgr;
    }

    private Set getRules() {
        if (this.policy != null && this.rules == null) {
            Set set = this.policy.getRuleNames();
            if (set != null && !set.isEmpty()) {
                this.rules = new HashSet(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    try {
                        this.rules.add(this.policy.getRule(string));
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        if (!AMModelBase.debug.warningEnabled()) continue;
                        AMModelBase.debug.warning("PMProfileRulesModelImpl.getRules", (Throwable)nameNotFoundException);
                    }
                }
            } else {
                this.rules = Collections.EMPTY_SET;
            }
        }
        return this.rules;
    }

    protected Map getSvcTypeNameToActionsMap() {
        block5: {
            if (this.mapSvcTypeNameToActions == null) {
                try {
                    ServiceTypeManager serviceTypeManager = this.getServiceTypeMgr();
                    Set set = this.getServiceTypeNames();
                    this.mapSvcTypeNameToActions = new HashMap(set.size());
                    this.mapSvcTypeNameToResBundle = new HashMap(set.size());
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        ResourceBundle resourceBundle;
                        String string = (String)iterator.next();
                        ServiceType serviceType = this.getServiceType(serviceTypeManager, string);
                        if (serviceType == null || (resourceBundle = this.getResourceBundle(serviceType, this.getUserLocale())) == null) continue;
                        this.mapSvcTypeNameToResBundle.put(string, resourceBundle);
                        Set set2 = this.getActionSchemas(serviceType);
                        if (set2 == null || set2.size() <= 0) continue;
                        this.mapSvcTypeNameToActions.put(string, set2);
                    }
                }
                catch (AMConsoleException aMConsoleException) {
                    if (!AMModelBase.debug.warningEnabled()) break block5;
                    AMModelBase.debug.warning("PMProfileRulesModelImpl.getSvcTypeNameToActionsMap", (Throwable)aMConsoleException);
                }
            }
        }
        if (this.mapSvcTypeNameToActions == null) {
            this.mapSvcTypeNameToActions = new HashMap();
            this.mapSvcTypeNameToResBundle = new HashMap();
        }
        return this.mapSvcTypeNameToActions;
    }

    private Set getActionSchemas(ServiceType serviceType) {
        HashSet<ActionSchema> hashSet = null;
        Set set = serviceType.getActionNames();
        if (set != null && !set.isEmpty()) {
            hashSet = new HashSet<ActionSchema>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ActionSchema actionSchema = this.getActionSchema(serviceType, string);
                if (actionSchema == null || !this.isActionSchemaSupported(actionSchema)) continue;
                hashSet.add(actionSchema);
            }
        }
        return hashSet;
    }

    private ServiceType getServiceType(ServiceTypeManager serviceTypeManager, String string) throws AMConsoleException {
        ServiceType serviceType = null;
        try {
            serviceType = serviceTypeManager.getServiceType(string);
        }
        catch (SSOException sSOException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)nameNotFoundException)));
        }
        return serviceType;
    }

    private ActionSchema getActionSchema(ServiceType serviceType, String string) {
        ActionSchema actionSchema;
        block2: {
            actionSchema = null;
            try {
                actionSchema = serviceType.getActionSchema(string);
            }
            catch (InvalidNameException invalidNameException) {
                if (!AMModelBase.debug.warningEnabled()) break block2;
                AMModelBase.debug.warning("PMProfileRulesModelImpl.getActionSchema", (Throwable)invalidNameException);
            }
        }
        return actionSchema;
    }

    private ResourceBundle getResourceBundle(ServiceType serviceType, java.util.Locale locale) {
        ResourceBundle resourceBundle = null;
        String string = serviceType.getI18NPropertiesFileName();
        if (string != null && string.length() > 0) {
            resourceBundle = AMResBundleCacher.getBundle(string, locale);
        }
        return resourceBundle;
    }

    private ActionSchema getActionSchema(String string, String string2) {
        ActionSchema actionSchema = null;
        Map map = this.getSvcTypeNameToActionsMap();
        Set set = (Set)map.get(string);
        if (set != null && set.size() > 0) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && actionSchema == null) {
                ActionSchema actionSchema2 = (ActionSchema)iterator.next();
                if (!actionSchema2.getName().equals(string2)) continue;
                actionSchema = actionSchema2;
            }
        }
        return actionSchema;
    }

    public Rule getRule(String string) {
        Rule rule = null;
        Set set = this.getRules();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && rule == null) {
            Rule rule2 = (Rule)iterator.next();
            if (!rule2.getName().equals(string)) continue;
            rule = rule2;
        }
        return rule;
    }

    public String getSelectActionValuesMessage() {
        return this.getLocalizedString("missingActionValues.message");
    }

    public String getEditRuleLabel() {
        return this.getLocalizedString("editRule.label");
    }

    public String getNoRuleSelectedForDeletionTitle() {
        return this.getLocalizedString("noRuleSelectedForDeletion.title");
    }

    public String getNoRuleSelectedForDeletionMessage() {
        return this.getLocalizedString("noRuleSelectedForDeletion.message");
    }

    public String getWithResLabel() {
        return this.getLocalizedString("withRes.label");
    }

    public String getWithoutResLabel() {
        return this.getLocalizedString("withoutRes.label");
    }

    public void setRuleView(int n) {
        this.ruleView = n;
    }

    public String getHelpAnchorTag() {
        String string = null;
        switch (this.ruleView) {
            case 1: {
                string = this.getLocalizedString("policyAddRule.help");
                break;
            }
            case 2: {
                string = this.getLocalizedString("policyEditRule.help");
                break;
            }
            default: {
                string = this.getLocalizedString("policyProfileRules.help");
            }
        }
        if (string.endsWith(".help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    private boolean isActionSchemaSupported(ActionSchema actionSchema) {
        int n = AMDisplayTypeConverter.getDisplaySyntax(actionSchema);
        return n != 6 && n != 7;
    }

    public int getNumberOfRules() {
        Set set = this.getRules();
        return set != null ? set.size() : 0;
    }

    public String getWizardInformation(String string) {
        return this.getLocalizedString("ruleWizardStep" + string + ".message");
    }
}

