/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.policy.model.PMProfileModelBase;
import com.iplanet.am.console.policy.model.PMProfileReferralsModel;
import com.iplanet.sso.SSOException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Referral;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PMProfileReferralsModelImpl
extends PMProfileModelBase
implements PMProfileReferralsModel {
    private int referralView = 3;
    private ReferralTypeManager referralTypeMgr = null;
    private Map cachedReferrals = new HashMap(10);
    private String searchError = null;

    public PMProfileReferralsModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectLabel() {
        return this.getLocalizedString("referralSelect.label");
    }

    public String getReferralNameLabel() {
        return this.getLocalizedString("referralName.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("referralProperties.label");
    }

    public String getDeleteSelectedReferralBtnLabel() {
        return this.getLocalizedString("deleteReferral.button");
    }

    public String getAddReferralBtnLabel() {
        return this.getLocalizedString("addReferral.button");
    }

    public String getNoReferralsMessage() {
        return this.getLocalizedString("noReferrals.message");
    }

    public String getReferralTypeLabel() {
        return this.getLocalizedString("referralType.label");
    }

    public String getHasNoReferralValueMessage() {
        return this.getLocalizedString("noReferralUnderReferralType.message");
    }

    public String getMissingReferralNameMessage() {
        return this.getLocalizedString("missingReferralName.message");
    }

    public String getAddReferralTitle() {
        return this.getLocalizedString("addReferral.title");
    }

    public Set getReferralTypeNames() {
        Set set;
        block7: {
            set = Collections.EMPTY_SET;
            try {
                ReferralTypeManager referralTypeManager = this.getReferralTypeMgr();
                if (referralTypeManager != null) {
                    set = referralTypeManager.getSelectedReferralTypeNames();
                }
            }
            catch (SSOException sSOException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("PMProfileReferralsPeer.getReferralTypeNames", (Throwable)sSOException);
                }
            }
            catch (AMConsoleException aMConsoleException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("PMProfileReferralsPeer.getReferralTypeNames", (Throwable)aMConsoleException);
                }
            }
            catch (PolicyException policyException) {
                if (!AMModelBase.debug.warningEnabled()) break block7;
                AMModelBase.debug.warning("PMProfileReferralsPeer.getReferralTypeNames", (Throwable)policyException);
            }
        }
        return set;
    }

    public Set getReferralNames() {
        return this.getReferralNames(null);
    }

    public Set getReferralNames(String string) {
        Set set;
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (this.policy != null && (set = this.policy.getReferralNames()) != null && set.size() > 0) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                try {
                    Referral referral = this.policy.getReferral(string2);
                    if (string != null && !referral.getReferralTypeName().equals(string)) continue;
                    hashSet.add(string2);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    AMModelBase.debug.warning("PMProfileReferralsModelImpl.hasReferrals", (Throwable)nameNotFoundException);
                }
            }
        }
        return hashSet;
    }

    public String getReferralTypeLocalizedName(String string) {
        String string2;
        block2: {
            string2 = string;
            try {
                ReferralTypeManager referralTypeManager = this.getReferralTypeMgr();
                string2 = referralTypeManager.getDisplayName(string);
            }
            catch (AMConsoleException aMConsoleException) {
                if (!AMModelBase.debug.warningEnabled()) break block2;
                AMModelBase.debug.warning("PMProfileReferralsModelImpl.getReferralTypeLocalizedName", (Throwable)aMConsoleException);
            }
        }
        return string2;
    }

    public boolean hasReferrals() {
        boolean bl = false;
        ReferralTypeManager referralTypeManager = null;
        try {
            referralTypeManager = this.getReferralTypeMgr();
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileReferralsModelImpl.hasReferrals", (Throwable)aMConsoleException);
        }
        if (this.policy != null && referralTypeManager != null) {
            Set set = this.policy.getReferralNames();
            bl = set != null && set.size() > 0;
        }
        return bl;
    }

    public boolean hasReferrals(String string) {
        Set set = this.getReferralNames(string);
        return !set.isEmpty();
    }

    public String getReferralTypeName(String string) {
        String string2;
        block3: {
            string2 = "";
            if (this.policy != null) {
                try {
                    Referral referral = this.policy.getReferral(string);
                    string2 = referral.getReferralTypeName();
                }
                catch (NameNotFoundException nameNotFoundException) {
                    if (!AMModelBase.debug.warningEnabled()) break block3;
                    AMModelBase.debug.warning("PMProfileReferralsModelImpl.getReferralTypeName", (Throwable)nameNotFoundException);
                }
            }
        }
        return string2;
    }

    public void deleteReferrals(Set set) {
        if (this.policy != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getReferralTypeName(string);
                this.policy.removeReferral(string);
                this.markPolicyModified();
                this.addLoggingMsgData(string2, string, "referralDeleted.message", null, 2, null);
            }
        }
    }

    public int getReferralDisplayType(String string) {
        int n = 0;
        try {
            Referral referral = this.getReferralObj(string);
            if (referral != null) {
                Syntax syntax = referral.getValueSyntax(this.ssoToken);
                n = AMDisplayTypeConverter.getDisplayType(syntax);
            }
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("PMProfileReferralsModelImpl.getReferralDisplayType", (Throwable)sSOException);
            }
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.warning("PMProfileReferralsModelImpl.getReferralDisplayType", (Throwable)policyException);
        }
        return n;
    }

    public String getLocalizedReferralValueLabel() {
        return this.getLocalizedString("referralValues.label");
    }

    public String getSearchErrorMsg() {
        return this.searchError;
    }

    public Set getPossibleValues(String string, String string2) throws AMConsoleException {
        if (string2 == null || string2.length() == 0) {
            string2 = "*";
        }
        Set set = null;
        try {
            ValidValues validValues;
            Referral referral = this.getReferralObj(string);
            if (referral != null && (validValues = referral.getValidValues(this.ssoToken, string2)) != null) {
                set = validValues.getSearchResults();
                int n = validValues.getErrorCode();
                if (n == 1) {
                    this.searchError = this.getLocalizedString("sizeLimitExceeded1.message");
                } else if (n == 2) {
                    this.searchError = this.getLocalizedString("timeLimitExceeded1.message");
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileReferralsModelImpl.getPossibleValues", (Throwable)sSOException);
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.warning("PMProfileReferralsModelImpl.getPossibleValues", (Throwable)policyException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public String getDisplayNameForValue(String string, String string2) {
        String string3 = string2;
        Referral referral = this.getReferralObj(string);
        if (referral != null) {
            try {
                string3 = referral.getDisplayNameForValue(string2, this.getUserLocale());
            }
            catch (NameNotFoundException nameNotFoundException) {
                AMModelBase.debug.warning("PMProfileReferralsModelImpl.getDisplayNameForValue", (Throwable)nameNotFoundException);
            }
        }
        return string3;
    }

    public void addReferral(String string, String string2, Set set) throws AMConsoleException {
        if (this.policy != null) {
            try {
                Referral referral = this.getReferralObj(string);
                if (referral != null) {
                    Syntax syntax = referral.getValueSyntax(this.ssoToken);
                    if (!syntax.equals((Object)Syntax.CONSTANT)) {
                        referral.setValues(set);
                    }
                    this.policy.addReferral(string2, referral);
                    this.markPolicyModified();
                    this.addLoggingMsgData(string, string2, "referralCreated.message", "referralUpdated.message", 0, null);
                }
            }
            catch (InvalidNameException invalidNameException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)invalidNameException)));
            }
            catch (NameAlreadyExistsException nameAlreadyExistsException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)nameAlreadyExistsException)));
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (PolicyException policyException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
            }
        }
    }

    public void replaceReferral(String string, String string2, String string3, Set set) throws AMConsoleException {
        if (this.policy != null) {
            try {
                if (string3.equals(string2)) {
                    Referral referral = this.policy.getReferral(string2);
                    if (referral != null) {
                        referral.setValues(set);
                        this.markPolicyModified();
                        this.addLoggingMsgData(string, string2, "referralUpdated.message", null, 1, null);
                    }
                } else {
                    this.deleteAddReferral(string, string2, string3, set);
                    this.addLoggingMsgData(string, string3, "referralNameUpdated.message", null, 1, string2);
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)nameNotFoundException)));
            }
            catch (InvalidNameException invalidNameException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)invalidNameException)));
            }
        }
    }

    private void deleteAddReferral(String string, String string2, String string3, Set set) throws AMConsoleException {
        Referral referral = this.policy.removeReferral(string2);
        try {
            this.addReferral(string, string3, set);
        }
        catch (AMConsoleException aMConsoleException) {
            try {
                this.policy.addReferral(string2, referral);
            }
            catch (NameAlreadyExistsException nameAlreadyExistsException) {
                AMModelBase.debug.warning("PMProfileReferralsModelImpl.deleteAddReferral", (Throwable)nameAlreadyExistsException);
            }
            catch (InvalidNameException invalidNameException) {
                AMModelBase.debug.warning("PMProfileReferralsModelImpl.deleteAddReferral", (Throwable)invalidNameException);
            }
            throw aMConsoleException;
        }
    }

    public Set getReferralValues(String string) {
        Set set = Collections.EMPTY_SET;
        if (this.policy != null) {
            try {
                Referral referral = this.policy.getReferral(string);
                if (referral != null) {
                    set = referral.getValues();
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                AMModelBase.debug.warning("PMProfileReferralsModelImpl.getReferralValues", (Throwable)nameNotFoundException);
            }
        }
        return set;
    }

    public boolean canAddReferral(String string) {
        boolean bl = false;
        try {
            Referral referral;
            ReferralTypeManager referralTypeManager = this.getReferralTypeMgr();
            if (referralTypeManager != null && (referral = this.getReferralObj(string)) != null) {
                Syntax syntax = referral.getValueSyntax(this.ssoToken);
                bl = !syntax.equals((Object)Syntax.NONE);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileReferralsPeer.canAddReferral", (Throwable)sSOException);
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileReferralsPeer.canAddReferral", (Throwable)aMConsoleException);
        }
        catch (PolicyException policyException) {
            AMModelBase.debug.warning("PMProfileReferralsPeer.canAddReferral", (Throwable)policyException);
        }
        return bl;
    }

    public String getViewBeanURL(String string) {
        String string2 = null;
        try {
            Referral referral;
            ReferralTypeManager referralTypeManager = this.getReferralTypeMgr();
            if (referralTypeManager != null && (referral = this.getReferralObj(string)) != null) {
                string2 = referralTypeManager.getViewBeanURL(referral);
            }
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileReferralsModelImpl.getViewBeanURL", (Throwable)aMConsoleException);
        }
        return string2;
    }

    public String getNoReferralTitle() {
        return this.getLocalizedString("noReferral.title");
    }

    public String getNoReferralMessage() {
        return this.getLocalizedString("noReferral.message");
    }

    private ReferralTypeManager getReferralTypeMgr() throws AMConsoleException {
        PolicyManager policyManager;
        if (this.referralTypeMgr == null && (policyManager = this.getPolicyManager()) != null) {
            this.referralTypeMgr = policyManager.getReferralTypeManager();
        }
        return this.referralTypeMgr;
    }

    protected Referral getReferralObj(String string) {
        Referral referral = (Referral)this.cachedReferrals.get(string);
        if (referral == null) {
            try {
                ReferralTypeManager referralTypeManager = this.getReferralTypeMgr();
                if (referralTypeManager != null) {
                    referral = referralTypeManager.getReferral(string);
                    this.cachedReferrals.put(string, referral);
                }
            }
            catch (AMConsoleException aMConsoleException) {
                AMModelBase.debug.warning("PMProfileReferralsModelImpl.getReferralObj", (Throwable)aMConsoleException);
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMProfileReferralsModelImpl.getReferralObj", (Throwable)policyException);
            }
        }
        return referral;
    }

    public String getEditReferralLabel() {
        return this.getLocalizedString("editReferral.label");
    }

    public String getCannotCreateReferralMsg() {
        return this.getLocalizedString("cannotCreateReferral.message");
    }

    public String getNoReferralSelectedForDeletionTitle() {
        return this.getLocalizedString("noReferralSelectedForDeletion.title");
    }

    public String getNoReferralSelectedForDeletionMessage() {
        return this.getLocalizedString("noReferralSelectedForDeletion.message");
    }

    public String getFilterLabel() {
        return this.getLocalizedString("filter.label");
    }

    public String getFilterBtnLabel() {
        return this.getLocalizedString("filter.button");
    }

    public String getNoReferralForCreationTitle() {
        return this.getLocalizedString("noReferralTypeForCreation.title");
    }

    public String getNoReferralForCreationMessage() {
        return this.getLocalizedString("noReferralTypeForCreation.message");
    }

    public String getNoPossibleReferralsMessage() {
        return this.getLocalizedString("noPossibleReferrals.message");
    }

    public void setReferralView(int n) {
        this.referralView = n;
    }

    public String getHelpAnchorTag() {
        String string = null;
        switch (this.referralView) {
            case 1: {
                string = this.getLocalizedString("policyAddReferral.help");
                break;
            }
            case 2: {
                string = this.getLocalizedString("policyEditReferral.help");
                break;
            }
            default: {
                string = this.getLocalizedString("policyProfileReferral.help");
            }
        }
        if (string.endsWith(".help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public int getNumberOfReferrals() {
        Set set = this.policy.getReferralNames();
        return set != null ? set.size() : 0;
    }
}

