/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.policy.model.PMProfileConditionsModel;
import com.iplanet.am.console.policy.model.PMProfileModelBase;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.policy.ConditionTypeManager;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;

public class PMProfileConditionsModelImpl
extends PMProfileModelBase
implements PMProfileConditionsModel {
    private static final String SESSION_PROPERTY_CONDITION = "SessionPropertyCondition";
    private int conditionView = 5;
    private String startIPAddr = null;
    private String endIPAddr = null;
    private String dnsName = null;
    private ConditionTypeManager conditionTypeMgr = null;
    private Condition cachedCondition = null;

    public PMProfileConditionsModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getNameLabel() {
        return this.getLocalizedString("name.label");
    }

    public String getAuthLevelLabel() {
        return this.getLocalizedString("authLevel.label");
    }

    public String getAuthSchemeLabel() {
        return this.getLocalizedString("authScheme.label");
    }

    public String getStartIPAddrLabel() {
        return this.getLocalizedString("startIPAddr.label");
    }

    public String getEndIPAddrLabel() {
        return this.getLocalizedString("endIPAddr.label");
    }

    public String getDNSNameLabel() {
        return this.getLocalizedString("dnsName.label");
    }

    public String getDNSHeaderLabel() {
        return this.getLocalizedString("dnsHeader.label");
    }

    public String getIPAddressHeader() {
        return this.getLocalizedString("ipAddressHeader.label");
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("properties.label");
    }

    public String getNoConditionEntryMessage() {
        return this.getLocalizedString("noConditionEntry.message");
    }

    public String getInvalidAuthLevelMsg() {
        return this.getLocalizedString("invalidAuthLevel.message");
    }

    public String getTitleString() {
        return this.getLocalizedString("addCondition.title");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public String getServiceStatusLabel() {
        return this.getLocalizedString("serviceStatus.label");
    }

    public String getServiceStatusValueLabel() {
        return this.getLocalizedString("serviceStatusValue.label");
    }

    public String getLocalizedConditionType(String string) {
        String string2;
        block3: {
            string2 = string;
            try {
                ConditionTypeManager conditionTypeManager = this.getConditionTypeManager();
                if (conditionTypeManager != null) {
                    string2 = conditionTypeManager.getDisplayName(string);
                }
            }
            catch (AMConsoleException aMConsoleException) {
                if (!AMModelBase.debug.warningEnabled()) break block3;
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getLocalizedConditionType", (Throwable)aMConsoleException);
            }
        }
        return string2;
    }

    public String getViewBeanURL(String string) {
        String string2;
        block3: {
            string2 = null;
            try {
                Condition condition;
                ConditionTypeManager conditionTypeManager = this.getConditionTypeManager();
                if (conditionTypeManager != null && (condition = this.getCondition(string)) != null) {
                    string2 = conditionTypeManager.getViewBeanURL(condition);
                }
            }
            catch (AMConsoleException aMConsoleException) {
                if (!AMModelBase.debug.warningEnabled()) break block3;
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getViewBeanURL", (Throwable)aMConsoleException);
            }
        }
        return string2;
    }

    public int getSyntax(String string, String string2) {
        int n = 0;
        Condition condition = this.getCondition(string);
        if (condition != null) {
            Syntax syntax = condition.getPropertySyntax(string2);
            n = AMDisplayTypeConverter.getDisplayType(syntax);
        }
        return n;
    }

    public Set getPossibleValues(String string, String string2) {
        Set set = null;
        Condition condition = this.getCondition(string);
        if (condition != null) {
            try {
                set = condition.getValidValues(string2);
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getPossibleValues", (Throwable)policyException);
            }
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public String getPropertyLabel(String string, String string2) {
        String string3 = null;
        Condition condition = this.getCondition(string);
        if (condition != null) {
            try {
                string3 = condition.getDisplayName(string2, this.getUserLocale());
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getPossibleValues", (Throwable)policyException);
            }
        }
        return string3 != null ? string3 : string2;
    }

    public List getPropertyNames(String string) {
        List list = null;
        Condition condition = this.getCondition(string);
        if (condition != null) {
            list = condition.getPropertyNames();
        }
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public String getDeleteSelectedLabel() {
        return this.getLocalizedString("deletedSelected.button");
    }

    public String getConditionTypeLabel() {
        return this.getLocalizedString("conditionType.label");
    }

    public String getStartIPAddr() {
        return this.startIPAddr;
    }

    public String getEndIPAddr() {
        return this.endIPAddr;
    }

    public String getDNSName() {
        return this.dnsName;
    }

    public String getMissingConditionNameMessage() {
        return this.getLocalizedString("missingConditionName.message");
    }

    public String getMissingAuthLevelMessage() {
        return this.getLocalizedString("missingAuthLevel.message");
    }

    public String getMissingAuthSchemeMessage() {
        return this.getLocalizedString("missingAuthScheme.message");
    }

    public String getInvalidStartIPAddrMessage() {
        return this.getLocalizedString("invalidStartIPAddr.message");
    }

    public String getInvalidEndIPAddrMessage() {
        return this.getLocalizedString("invalidEndIPAddr.message");
    }

    public String getInvalidDNSNameMessage() {
        return this.getLocalizedString("invalidDNSName.message");
    }

    public String getMissingIPMessage() {
        return this.getLocalizedString("missingIP.message");
    }

    protected Condition getCondition(String string) {
        if (this.cachedCondition == null) {
            try {
                ConditionTypeManager conditionTypeManager = this.getConditionTypeManager();
                if (conditionTypeManager != null) {
                    this.cachedCondition = conditionTypeManager.getCondition(string);
                }
            }
            catch (AMConsoleException aMConsoleException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getCondition", (Throwable)aMConsoleException);
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getCondition", (Throwable)policyException);
            }
        }
        return this.cachedCondition;
    }

    public void addAuthLevelCondition(String string, String string2, String string3) throws AMConsoleException {
        HashMap hashMap = new HashMap();
        this.addEntryToMap(hashMap, string2, "AuthLevel");
        this.addCondition(string, hashMap, string3);
    }

    public void addAuthSchemeCondition(String string, Set set, String string2) throws AMConsoleException {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
        hashMap.put("AuthScheme", set);
        this.addCondition(string, hashMap, string2);
    }

    public void replaceAuthLevelCondition(String string, String string2, String string3, String string4) throws AMConsoleException {
        HashMap hashMap = new HashMap();
        this.addEntryToMap(hashMap, string3, "AuthLevel");
        this.replaceCondition(string, string2, hashMap, string4);
    }

    public void replaceAuthSchemeCondition(String string, String string2, Set set, String string3) throws AMConsoleException {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
        hashMap.put("AuthScheme", set);
        this.replaceCondition(string, string2, hashMap, string3);
    }

    public void replaceIPCondition(String string, String string2, String string3, String string4, String string5, String string6) throws AMConsoleException {
        HashMap hashMap = new HashMap();
        this.addEntryToMap(hashMap, string3, "StartIp");
        this.addEntryToMap(hashMap, string4, "EndIp");
        this.addEntryToMap(hashMap, string5, "DnsName");
        this.replaceCondition(string, string2, hashMap, string6);
    }

    protected void addEntryToMap(Map map, String string, String string2) {
        if (string != null && string.length() > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            map.put(string2, hashSet);
        }
    }

    public void addIPCondition(String string, String string2, String string3, String string4, String string5) throws AMConsoleException {
        HashMap hashMap = new HashMap(4);
        this.addEntryToMap(hashMap, string2, "StartIp");
        this.addEntryToMap(hashMap, string3, "EndIp");
        this.addEntryToMap(hashMap, string4, "DnsName");
        this.addCondition(string, hashMap, string5);
    }

    public String getNoConditionTitle() {
        return this.getLocalizedString("noCondition.title");
    }

    public String getNoConditionMessage() {
        return this.getLocalizedString("noCondition.message");
    }

    public void replaceCondition(String string, String string2, Map map, String string3) throws AMConsoleException {
        if (this.policy != null) {
            try {
                Condition condition;
                ConditionTypeManager conditionTypeManager = this.getConditionTypeManager();
                if (conditionTypeManager != null && (condition = conditionTypeManager.getCondition(string3)) != null) {
                    if (map != null) {
                        condition.setProperties(map);
                    }
                    if (string.equals(string2)) {
                        this.policy.replaceCondition(string, condition);
                        this.markPolicyModified();
                        this.addLoggingMsgData(string3, string, "conditionUpdated.message", null, 1, null);
                    } else {
                        this.deleteAddCondition(string3, string, string2, map);
                        this.addLoggingMsgData(string3, string2, "conditionNameUpdated.message", null, 1, string);
                    }
                }
            }
            catch (PolicyException policyException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
            }
        }
    }

    private void deleteAddCondition(String string, String string2, String string3, Map map) throws AMConsoleException {
        Condition condition = this.policy.removeCondition(string2);
        try {
            this.addCondition(string3, map, string);
        }
        catch (AMConsoleException aMConsoleException) {
            try {
                this.policy.addCondition(string2, condition);
            }
            catch (NameAlreadyExistsException nameAlreadyExistsException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.deleteAddCondition", (Throwable)nameAlreadyExistsException);
            }
            catch (InvalidNameException invalidNameException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.deleteAddCondition", (Throwable)invalidNameException);
            }
            throw aMConsoleException;
        }
    }

    public void addCondition(String string, Map map, String string2) throws AMConsoleException {
        if (this.policy != null) {
            try {
                Condition condition;
                ConditionTypeManager conditionTypeManager = this.getConditionTypeManager();
                if (conditionTypeManager != null && (condition = conditionTypeManager.getCondition(string2)) != null) {
                    if (map != null) {
                        condition.setProperties(map);
                    }
                    this.policy.addCondition(string, condition);
                    this.markPolicyModified();
                    this.addLoggingMsgData(string2, string, "conditionCreated.message", "conditionUpdated.message", 0, null);
                }
            }
            catch (PolicyException policyException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)policyException)));
            }
        }
    }

    public String getAuthLevelValue(String string, String string2) {
        String string3 = null;
        Map map = this.getProperties(string);
        if (map != null) {
            string3 = AMAdminUtils.getFirstElement((Set)map.get("AuthLevel"));
        }
        return string3 != null ? string3 : "";
    }

    public Set getAuthSchemeValues(String string, String string2) {
        Set set = null;
        Map map = this.getProperties(string);
        if (map != null) {
            set = (Set)map.get("AuthScheme");
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public void setIPValues(String string) {
        Map map = this.getProperties(string);
        if (map != null) {
            this.startIPAddr = AMAdminUtils.getFirstElement((Set)map.get("StartIp"));
            this.endIPAddr = AMAdminUtils.getFirstElement((Set)map.get("EndIp"));
            this.dnsName = AMAdminUtils.getFirstElement((Set)map.get("DnsName"));
        }
    }

    public Map getProperties(String string) {
        Map map = null;
        if (this.policy != null) {
            try {
                Condition condition = this.policy.getCondition(string);
                if (condition != null) {
                    map = condition.getProperties();
                }
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getProperties", (Throwable)policyException);
            }
        }
        return map != null ? map : Collections.EMPTY_MAP;
    }

    private ConditionTypeManager getConditionTypeManager() throws AMConsoleException {
        PolicyManager policyManager;
        if (this.conditionTypeMgr == null && (policyManager = this.getPolicyManager()) != null) {
            this.conditionTypeMgr = policyManager.getConditionTypeManager();
        }
        return this.conditionTypeMgr;
    }

    public Set getConditionNames() {
        Set set;
        HashSet<String> hashSet = Collections.EMPTY_SET;
        ConditionTypeManager conditionTypeManager = null;
        try {
            conditionTypeManager = this.getConditionTypeManager();
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getConditionNames", (Throwable)aMConsoleException);
        }
        if (this.policy != null && conditionTypeManager != null && (set = this.policy.getConditionNames()) != null && !set.isEmpty()) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getConditionType(string);
                if (string2.equals(SESSION_PROPERTY_CONDITION)) continue;
                hashSet.add(string);
            }
        }
        return hashSet != null ? hashSet : Collections.EMPTY_SET;
    }

    public String getConditionType(String string) {
        String string2 = null;
        ConditionTypeManager conditionTypeManager = null;
        try {
            conditionTypeManager = this.getConditionTypeManager();
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getConditionType", (Throwable)aMConsoleException);
        }
        if (conditionTypeManager != null) {
            try {
                Condition condition = this.policy.getCondition(string);
                if (condition != null) {
                    string2 = conditionTypeManager.getConditionTypeName(condition);
                }
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getConditionName", (Throwable)policyException);
            }
        }
        return string2 != null ? string2 : "";
    }

    public boolean hasConditions(String string) {
        boolean bl = false;
        if (!string.equals(SESSION_PROPERTY_CONDITION)) {
            Set set;
            ConditionTypeManager conditionTypeManager = null;
            try {
                conditionTypeManager = this.getConditionTypeManager();
            }
            catch (AMConsoleException aMConsoleException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.hasConditions", (Throwable)aMConsoleException);
            }
            if (this.policy != null && conditionTypeManager != null && (set = this.policy.getConditionNames()) != null && set.size() > 0) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    try {
                        Condition condition = this.policy.getCondition(string2);
                        String string3 = conditionTypeManager.getConditionTypeName(condition);
                        if (!string3.equals(string)) continue;
                        return true;
                    }
                    catch (PolicyException policyException) {
                        AMModelBase.debug.warning("PMProfileConditionsModelImpl.hasConditions", (Throwable)policyException);
                    }
                }
            }
        }
        return bl;
    }

    public boolean hasConditions() {
        Set set = this.getConditionNames();
        return set != null && !set.isEmpty();
    }

    public Set getConditionTypeNames() {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        ConditionTypeManager conditionTypeManager = null;
        try {
            conditionTypeManager = this.getConditionTypeManager();
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.hasConditions", (Throwable)aMConsoleException);
        }
        if (conditionTypeManager != null) {
            try {
                Set set = conditionTypeManager.getSelectedConditionTypeNames();
                if (set != null && !set.isEmpty()) {
                    hashSet = new HashSet<String>(set.size() * 2);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (string.equals(SESSION_PROPERTY_CONDITION)) continue;
                        hashSet.add(string);
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getConditionTypeNames", (Throwable)sSOException);
            }
            catch (PolicyException policyException) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getConditionTypeNames", (Throwable)policyException);
            }
        }
        return hashSet;
    }

    public void deleteConditions(Set set) {
        if (this.policy != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getConditionTypeName(string);
                this.policy.removeCondition(string);
                this.markPolicyModified();
                this.addLoggingMsgData(string2, string, "conditionDeleted.message", null, 2, null);
            }
        }
    }

    public void addServiceStatusCondition(String string, String string2) throws AMConsoleException {
        this.addCondition(string, null, string2);
    }

    public void replaceServiceStatusCondition(String string, String string2, String string3) throws AMConsoleException {
        this.replaceCondition(string, string2, null, string3);
    }

    public String getEditConditionLabel() {
        return this.getLocalizedString("editCondition.label");
    }

    public Map getAuthSchemes() {
        Map map = Collections.EMPTY_MAP;
        Set set = this.getAuthSchemeNames();
        if (!set.isEmpty()) {
            map = this.localizedAuthModulesName(set);
        }
        return map;
    }

    public String getAuthSchemeLocalizedName(String string) {
        String string2 = string;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAuthService");
            String string3 = serviceSchemaManager.getI18NFileName();
            if (string3 != null) {
                ResourceBundle resourceBundle = AMResBundleCacher.getBundle(string3, this.getUserLocale());
                string2 = Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)AMModelBase.debug);
            } else if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getAuthSchemeLocalizedName: iPlanetAMAuthService does not have a properties file");
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getAuthSchemeLocalizedName", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getAuthSchemeLocalizedName", (Throwable)sMSException);
        }
        return string2;
    }

    private Set getAuthSchemeNames() {
        Set set = Collections.EMPTY_SET;
        try {
            PolicyManager policyManager = this.getPolicyManager();
            if (policyManager != null) {
                String string = policyManager.getOrganizationName();
                AuthContext authContext = new AuthContext(string);
                set = authContext.getModuleInstanceNames();
            }
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMAuthSchemeConditionModelImpl.getAuthSchemes", (Throwable)aMConsoleException);
        }
        catch (LoginException loginException) {
            AMModelBase.debug.warning("PMAuthSchemeConditionModelImpl.getAuthSchemes", (Throwable)loginException);
        }
        return set;
    }

    private Map localizedAuthModulesName(Set set) {
        String string;
        Object object;
        HashMap<String, String> hashMap = null;
        try {
            object = this.getServiceSchemaManager("iPlanetAMAuthService");
            string = object.getI18NFileName();
            if (string != null) {
                hashMap = new HashMap(set.size() * 2);
                ResourceBundle resourceBundle = AMResBundleCacher.getBundle(string, this.getUserLocale());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    String string3 = Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)AMModelBase.debug);
                    hashMap.put(string2, string3);
                }
            } else if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.localizedAuthModulesName: iPlanetAMAuthService does not have a properties file");
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.localizedAuthModulesName", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.localizedAuthModulesName", (Throwable)sMSException);
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, String>(set.size() * 2);
            object = set.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                hashMap.put(string, string);
            }
        }
        return hashMap;
    }

    public String getNoAuthSchemeTitle() {
        return this.getLocalizedString("noAuthScheme.title");
    }

    public String getNoAuthSchemeMessage() {
        return this.getLocalizedString("noAuthScheme.message");
    }

    public String getAuthSchemeNoLongerExistTitle() {
        return this.getLocalizedString("authNoLongerExist.title");
    }

    public String getAuthSchemeNoLongerExistMessage(String string) {
        String string2 = this.getLocalizedString("authNoLongerExist.message");
        int n = string2.indexOf("{0}");
        if (n != -1) {
            string2 = string2.substring(0, n) + string + string2.substring(n + 3);
        }
        return string2;
    }

    public String getNoConditionSelectedForDeletionTitle() {
        return this.getLocalizedString("noConditionSelectedForDeletion.title");
    }

    public String getNoConditionSelectedForDeletionMessage() {
        return this.getLocalizedString("noConditionSelectedForDeletion.message");
    }

    public String getAuthServiceLabel() {
        return this.getLocalizedString("authService.label");
    }

    public String getNoAuthServiceLabel() {
        return this.getLocalizedString("noAuthService.label");
    }

    public String getLabelForAuthLevelTable() {
        return this.getLocalizedString("tableOfAuthLevel.label");
    }

    public Map getAvailAuthLevels() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6 = Collections.EMPTY_MAP;
        try {
            object5 = this.getAuthSchemeNames();
            if (object5 != null && !object5.isEmpty()) {
                object4 = this.dpStoreConn.getOrganization(this.locationDN);
                object6 = new HashMap(object5.size());
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object = this.getAuthLevel((AMOrganization)object4, AMAuthConfigUtils.getModuleServiceName((String)object2), (String)object2);
                    if (object == null) continue;
                    object6.put(object2, object);
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getAvailAuthLevels", (Throwable)sSOException);
        }
        if (!object6.isEmpty()) {
            object5 = new HashMap(object6.size() * 2);
            object4 = object6.keySet();
            object3 = this.localizedAuthModulesName((Set)object4);
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                object5.put(object3.get(object), object6.get(object));
            }
            object6 = object5;
        }
        return object6;
    }

    private Integer getAuthLevel(AMOrganization aMOrganization, String string, String string2) {
        Integer n = null;
        try {
            String string3;
            Map map;
            Set set;
            AMTemplate aMTemplate = aMOrganization.getTemplate(string, 302);
            if (aMTemplate == null) {
                string = AMAuthConfigUtils.getNewModuleServiceName((String)string2);
                aMTemplate = aMOrganization.getTemplate(string, 302);
            }
            if ((set = (Set)(map = aMTemplate.getAttributes()).get(AMAuthConfigUtils.getAuthLevelAttribute((Map)map, (String)string2))) != null && !set.isEmpty() && (string3 = (String)set.iterator().next()) != null && string3.length() > 0) {
                try {
                    n = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    AMModelBase.debug.warning("PMProfileConditionsModelImpl.getAuthLevel", (Throwable)numberFormatException);
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getAuthLevel", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getAuthLevel", (Throwable)sSOException);
        }
        return n;
    }

    public String getAddConditionTitle(String string) {
        return this.getLocalizedString("newConditionStep" + string + ".title");
    }

    public String getNoConditionForCreationTitle() {
        return this.getLocalizedString("noConditionTypeForCreation.title");
    }

    public String getNoConditionForCreationMessage() {
        return this.getLocalizedString("noConditionTypeForCreation.message");
    }

    public String getAddConditionBtnLabel() {
        return this.getLocalizedString("addCondition.button");
    }

    public String getConditionNameLabel() {
        return this.getLocalizedString("conditionName.label");
    }

    public String getConditionTypeName(String string) {
        String string2 = "";
        try {
            Condition condition;
            ConditionTypeManager conditionTypeManager = this.getConditionTypeManager();
            if (conditionTypeManager != null && (condition = this.policy.getCondition(string)) != null) {
                return conditionTypeManager.getConditionTypeName(condition);
            }
        }
        catch (AMConsoleException aMConsoleException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getConditionTypeName", (Throwable)aMConsoleException);
        }
        catch (NameNotFoundException nameNotFoundException) {
            AMModelBase.debug.warning("PMProfileConditionsModelImpl.getConditionTypeName", (Throwable)nameNotFoundException);
        }
        return string2;
    }

    public void setConditionView(int n) {
        this.conditionView = n;
    }

    public String getHelpAnchorTag() {
        String string = null;
        switch (this.conditionView) {
            case 3: {
                string = this.getLocalizedString("policyProfileAuthLevelCondition.help");
                break;
            }
            case 4: {
                string = this.getLocalizedString("policyProfileAuthSchemeCondition.help");
                break;
            }
            case 1: {
                string = this.getLocalizedString("policyProfileTimeCondition.help");
                break;
            }
            case 2: {
                string = this.getLocalizedString("policyProfileIPAddressCondition.help");
                break;
            }
            case 6: {
                string = this.getLocalizedString("policyProfileAddCondition.help");
                break;
            }
            case 7: {
                string = this.getLocalizedString("policyProfileEditCondition.help");
                break;
            }
            case 8: {
                string = this.getLocalizedString("policyProfilePromptCondition.help");
                break;
            }
            default: {
                string = this.getLocalizedString("policyProfileConditions.help");
            }
        }
        if (string.endsWith(".help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getRequiredMessage() {
        return this.getLocalizedString("missingAttributes.message");
    }

    public String getLocalizedValue(String string, String string2) {
        String string3;
        block2: {
            string3 = string2;
            Condition condition = this.getCondition(string);
            try {
                string3 = condition.getDisplayName(string2, this.getUserLocale());
            }
            catch (PolicyException policyException) {
                if (!AMModelBase.debug.warningEnabled()) break block2;
                AMModelBase.debug.warning("PMProfileConditionsModelImpl.getLocalizedValue Could not get localized value for key " + string2, (Throwable)policyException);
            }
        }
        return string3;
    }

    public int getNumberOfConditions() {
        Set set = this.getConditionNames();
        return set != null ? set.size() : 0;
    }

    public String getWizardInformation(String string) {
        String string2 = this.getLocalizedString("conditionWizardStep" + string + ".message");
        if (string.equals("2")) {
            switch (this.conditionView) {
                case 3: {
                    string2 = this.getLocalizedString("authLevelWizard.message");
                    break;
                }
                case 4: {
                    string2 = this.getLocalizedString("authSchemeWizard.message");
                    break;
                }
                case 1: {
                    string2 = this.getLocalizedString("timeConditionWizard.message");
                    break;
                }
                case 2: {
                    string2 = this.getLocalizedString("ipAddressWizard.message");
                    break;
                }
                case 6: {
                    string2 = this.getLocalizedString("addConditionWizard.message");
                }
            }
        }
        return string2;
    }
}

