/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.policy.model.PMCachedPolicy;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import sun.misc.BASE64Encoder;

public class PMPolicyCacher
implements SSOTokenListener {
    private Map mapTokenIDs = new HashMap(100);
    private static PMPolicyCacher instance = null;
    private static BASE64Encoder encoder = new BASE64Encoder();
    private static Random random = new Random();
    private Debug debug = AMModelBase.debug;

    private PMPolicyCacher() {
    }

    public static PMPolicyCacher getInstance() {
        if (instance == null) {
            instance = new PMPolicyCacher();
        }
        return instance;
    }

    public String cachePolicy(SSOToken sSOToken, PMCachedPolicy pMCachedPolicy) {
        String string = "";
        if (pMCachedPolicy != null) {
            try {
                String string2 = sSOToken.getTokenID().toString();
                Map map = this.mapTokenIDs;
                synchronized (map) {
                    HashMap<String, PMCachedPolicy> hashMap = (HashMap<String, PMCachedPolicy>)this.mapTokenIDs.get(string2);
                    if (hashMap == null) {
                        hashMap = new HashMap<String, PMCachedPolicy>(10);
                        sSOToken.addSSOTokenListener((SSOTokenListener)this);
                    }
                    string = PMPolicyCacher.getRandomString();
                    hashMap.put(string, pMCachedPolicy);
                    this.mapTokenIDs.put(string2, hashMap);
                }
            }
            catch (SSOException sSOException) {
                this.debug.warning("PMPolicyCacher.cachePolicy", (Throwable)sSOException);
                string = "";
            }
        }
        return string;
    }

    public void clearCachedPolicy(SSOToken sSOToken, String string) {
        if (string != null && string.length() > 0) {
            String string2 = sSOToken.getTokenID().toString();
            Map map = this.mapTokenIDs;
            synchronized (map) {
                Map map2 = (Map)this.mapTokenIDs.get(string2);
                if (map2 != null) {
                    map2.remove(string);
                }
            }
        }
    }

    public void setPolicy(SSOToken sSOToken, String string, PMCachedPolicy pMCachedPolicy) {
        if (pMCachedPolicy != null) {
            try {
                String string2 = sSOToken.getTokenID().toString();
                Map map = this.mapTokenIDs;
                synchronized (map) {
                    HashMap<String, PMCachedPolicy> hashMap = (HashMap<String, PMCachedPolicy>)this.mapTokenIDs.get(string2);
                    if (hashMap == null) {
                        hashMap = new HashMap<String, PMCachedPolicy>(10);
                        sSOToken.addSSOTokenListener((SSOTokenListener)this);
                    }
                    hashMap.put(string, pMCachedPolicy);
                    this.mapTokenIDs.put(string2, hashMap);
                }
            }
            catch (SSOException sSOException) {
                this.debug.warning("PMPolicyCacher.replacePolicy", (Throwable)sSOException);
            }
        }
    }

    public PMCachedPolicy getPolicy(SSOToken sSOToken, String string) {
        PMCachedPolicy pMCachedPolicy = null;
        String string2 = sSOToken.getTokenID().toString();
        Map map = (Map)this.mapTokenIDs.get(string2);
        if (map != null) {
            pMCachedPolicy = (PMCachedPolicy)map.get(string);
        }
        return pMCachedPolicy;
    }

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        try {
            int n = sSOTokenEvent.getType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    SSOToken sSOToken = sSOTokenEvent.getToken();
                    this.clearAllPolicies(sSOToken.getTokenID());
                }
            }
        }
        catch (SSOException sSOException) {
            this.debug.warning("PMPolicyCacher.ssoTokenChanged", (Throwable)sSOException);
        }
    }

    protected void clearAllPolicies(SSOTokenID sSOTokenID) {
        boolean bl = false;
        String string = sSOTokenID.toString();
        Map map = this.mapTokenIDs;
        synchronized (map) {
            bl = this.mapTokenIDs.remove(string) != null;
        }
        if (bl && this.debug.messageEnabled()) {
            this.debug.message("PMPolicyCacher.clearAllPolicies," + string);
        }
    }

    private static String getRandomString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        byte[] byArray = new byte[5];
        random.nextBytes(byArray);
        stringBuffer.append(System.currentTimeMillis());
        stringBuffer.append(encoder.encode(byArray));
        return stringBuffer.toString();
    }
}

