/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.policy.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.policy.model.PMHomeViewModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class PMHomeViewModelImpl
extends AMModelBase
implements PMHomeViewModel {
    public PMHomeViewModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public List getMenuEntries() {
        List list = Collections.EMPTY_LIST;
        switch (this.locationType) {
            case 2: {
                list = this.getOrgMenu();
                break;
            }
            case 3: {
                list = this.getOrgUnitMenu();
                break;
            }
            default: {
                AMModelBase.debug.error("PMNavViewModelBase.getMenuEntries invalid location type");
            }
        }
        return list;
    }

    private List getOrgMenu() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (AMSystemConfig.rootSuffix.equalsIgnoreCase(this.locationDN)) {
            arrayList.add(new Integer(2));
            if (!AMSystemConfig.iPlanetCompliantDIT && this.showOrgUnits()) {
                arrayList.add(new Integer(3));
            }
        } else if (!AMSystemConfig.iPlanetCompliantDIT) {
            arrayList.add(new Integer(2));
            if (this.showOrgUnits()) {
                arrayList.add(new Integer(3));
            }
        }
        arrayList.add(new Integer(14));
        return arrayList;
    }

    private List getOrgUnitMenu() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!AMSystemConfig.iPlanetCompliantDIT) {
            arrayList.add(new Integer(2));
            if (this.showOrgUnits()) {
                arrayList.add(new Integer(3));
            }
        }
        arrayList.add(new Integer(14));
        return arrayList;
    }

    public String getMenuEntryLocalizedName(int n) {
        return this.getLocalizedStringForLocType(n);
    }

    public boolean validateLocationDN() {
        boolean bl = true;
        if (this.locationType != 2 && this.locationType != 3) {
            try {
                AMObject aMObject = this.getAMObject(this.locationDN);
                if (aMObject != null) {
                    this.setLocationDN(aMObject.getOrganizationDN());
                    bl = false;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("PMHomeViewModelImpl.validateLocationDN", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("PMHomeViewModelImpl.validateLocationDN", (Throwable)aMException);
            }
        }
        return bl;
    }
}

