/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.federation.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.federation.model.FSEntityModel;
import com.iplanet.am.console.federation.model.FSNavModelImpl;
import com.iplanet.am.console.settings.Setting;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSEntityDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSEntityModelImpl
extends FSNavModelImpl
implements FSEntityModel {
    private Set entities = null;
    private FSAllianceManager manager;

    public FSEntityModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getEntityHeaderLabel() {
        return this.getLocalizedString("entityDescriptors.label");
    }

    public String getNoEntitySelectedForDelTitle() {
        return this.getLocalizedString("noEntitySelectedForDeletion.title");
    }

    public String getNoEntitySelectedForDelMessage() {
        return this.getLocalizedString("noEntitySelectedForDeletion.message");
    }

    public String getSelectedOption() {
        return "entities";
    }

    public boolean hasEntities(String string) {
        this.entities = this.getEntities(string);
        return this.entities != null && !this.entities.isEmpty();
    }

    public Set getEntityList() {
        return this.entities == null ? Collections.EMPTY_SET : this.entities;
    }

    public int getEntityCount() {
        if (this.entities == null) {
            return 0;
        }
        return this.entities.size();
    }

    public Set getEntities() {
        Set set = null;
        try {
            set = new FSAllianceManager(this.ssoToken).getAllEntityIds();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public Set getEntities(String string) {
        Set set = null;
        try {
            this.manager = new FSAllianceManager(this.ssoToken);
            if (this.manager != null) {
                set = this.manager.getAllEntityIds(string);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public boolean deleteEntities(Set set) {
        boolean bl = false;
        try {
            if (set != null && !set.isEmpty()) {
                new FSAllianceManager(this.ssoToken).deleteEntity(set);
                String string = this.getLocalizedString("entityDescriptorDeleted.message");
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = new String[]{(String)iterator.next()};
                    this.logger.doLog(MessageFormat.format(string, objectArray));
                }
                bl = true;
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
        return bl;
    }

    public List getEntityDisplayList(List list, int n, int n2) {
        ArrayList<Object> arrayList = Collections.EMPTY_LIST;
        if (list != null && !list.isEmpty()) {
            int n3 = n;
            Object[] objectArray = list.toArray();
            int n4 = objectArray.length;
            int n5 = n4 - n2;
            if (n3 > n5) {
                n3 = n5;
            }
            arrayList = new ArrayList<Object>(n3);
            int n6 = n2;
            while (n6 < n3 + n2) {
                arrayList.add(objectArray[n6]);
                ++n6;
            }
        }
        return arrayList;
    }

    public boolean isProviderAffiliated(String string) {
        boolean bl = false;
        FSEntityDescriptor fSEntityDescriptor = this.getFSEntityDescriptor(string);
        if (fSEntityDescriptor != null) {
            bl = fSEntityDescriptor.getType().equalsIgnoreCase("urn:liberty:iff:affiliate");
        }
        return bl;
    }

    private FSEntityDescriptor getFSEntityDescriptor(String string) {
        FSEntityDescriptor fSEntityDescriptor = null;
        try {
            FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
            fSEntityDescriptor = fSAllianceManager.getEntity(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            AMModelBase.debug.warning("FSEntityModelImpl.getFSEntityDescriptor", (Throwable)fSAllianceManagementException);
        }
        return fSEntityDescriptor;
    }

    public String getDefaultSubView() {
        String string = null;
        Set set = this.getUserSettings(Setting.DEFAULT_ENTITY_DESCRIPTOR_PROFILE_VIEW);
        if (set != null && !set.isEmpty()) {
            string = (String)set.iterator().next();
        }
        if (string == null || string.length() == 0) {
            string = "general";
        }
        return string;
    }

    public String getNameLabel() {
        return this.getLocalizedString("af.entityId.label");
    }
}

