/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.federation.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.federation.model.FSContactPersonEntry;
import com.iplanet.am.console.federation.model.FSCreateProviderWizardModel;
import com.iplanet.am.console.federation.model.FSProviderProfileModelImpl;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSEntityDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSCreateProviderWizardModelImpl
extends AMProfileModelBase
implements FSCreateProviderWizardModel {
    private FSAllianceManager allianceManager;
    private String entityId;

    public FSCreateProviderWizardModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
        this.entityId = httpServletRequest.getParameter("AffiliateID");
        if (this.entityId == null || this.entityId.length() == 0) {
            this.entityId = (String)map.get("AffiliateID");
        }
    }

    private FSAllianceManager getAllianceManager() throws FSAllianceManagementException {
        if (this.allianceManager == null) {
            this.allianceManager = new FSAllianceManager(this.ssoToken);
        }
        return this.allianceManager;
    }

    public String getRequiredFieldLabel() {
        return this.getLocalizedString("required.label");
    }

    public String getCreateProviderTitle(int n) {
        return this.getLocalizedString("af.createProviderPage" + n + ".title");
    }

    public String getCreateProviderSubTitle(int n) {
        return this.getLocalizedString("af.createProviderPage" + n + ".subtitle");
    }

    public String getLabel(String string) {
        return this.getLocalizedString(string);
    }

    public Map getProviderTypePossibleValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("hostedProvider.label"), "true");
        hashMap.put(this.getLocalizedString("remoteProvider.label"), "false");
        return hashMap;
    }

    public Map getProtocolSupportEnumPossibleValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("enumType.zero"), "urn:liberty:iff:2002-12");
        hashMap.put(this.getLocalizedString("enumType.one"), "urn:liberty:iff:2003-08");
        return hashMap;
    }

    public Map getFedTerminateProtocolTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/fedterm-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/fedterm-sp-http");
        return hashMap;
    }

    public Map getPossibleEncryptionMethods() {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        hashMap.put(this.getLocalizedString("noEncryptionMethod.option"), "");
        hashMap.put("AES", "AES");
        hashMap.put("DES", "DES");
        hashMap.put("DESede", "DESede");
        return hashMap;
    }

    public Map getLogoutProtocolTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/slo-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/slo-sp-http");
        return hashMap;
    }

    public Map getNameRegistrationProfileTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("protocolType.soap"), "http://projectliberty.org/profiles/rni-sp-soap");
        hashMap.put(this.getLocalizedString("protocolType.httpRedirect"), "http://projectliberty.org/profiles/rni-sp-http");
        return hashMap;
    }

    public Map getTerminationTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(this.getLocalizedString("termType.zero"), "http://projectliberty.org/profiles/rel-term-soap");
        return hashMap;
    }

    public Map getAllAuthenticationDomains() {
        HashMap<String, String> hashMap = Collections.EMPTY_MAP;
        try {
            FSAllianceManager fSAllianceManager = this.getAllianceManager();
            Set set = fSAllianceManager.getAllCirclesOfTrust();
            if (set != null && !set.isEmpty()) {
                hashMap = new HashMap<String, String>(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashMap.put(string, string);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            AMModelBase.debug.error("FSCreateProviderWizardModelImpl.getAllAuthenticationDomains", (Throwable)fSAllianceManagementException);
        }
        return hashMap;
    }

    public Map getAuthenticationTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("authType.local"), "local");
        hashMap.put(this.getLocalizedString("authType.remote"), "remote");
        return hashMap;
    }

    public Map getAuthnFedProfiles() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put(this.getLocalizedString("authnFedProfile.browserArtifact"), "http://projectliberty.org/profiles/brws-art");
        hashMap.put(this.getLocalizedString("authnFedProfile.browserPost"), "http://projectliberty.org/profiles/brws-post");
        hashMap.put(this.getLocalizedString("authnFedProfile.lecp"), "http://projectliberty.org/profiles/lecp");
        return hashMap;
    }

    public Map getNameIdPolicies() {
        HashMap<String, String> hashMap = new HashMap<String, String>(6);
        hashMap.put(this.getLocalizedString("nameIdPolicy.none"), "none");
        hashMap.put(this.getLocalizedString("nameIdPolicy.onetime"), "onetime");
        hashMap.put(this.getLocalizedString("nameIdPolicy.federated"), "federated");
        return hashMap;
    }

    public Map getAutnContextRefNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>(20);
        hashMap.put(this.getLocalizedString("authncontext.MobileContract"), "http://www.projectliberty.org/schemas/authctx/classes/MobileContract");
        hashMap.put(this.getLocalizedString("authncontext.MobileDigitalID"), "http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID");
        hashMap.put(this.getLocalizedString("authncontext.MobileUnregistered"), "http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered");
        hashMap.put(this.getLocalizedString("authncontext.Password"), "http://www.projectliberty.org/schemas/authctx/classes/Password");
        hashMap.put(this.getLocalizedString("authncontext.Password-ProtectedTransport"), "http://www.projectliberty.org/schemas/authctx/classes/PasswordProtectedTransport");
        hashMap.put(this.getLocalizedString("authncontext.Previous-Session"), "http://www.projectliberty.org/schemas/authctx/classes/Previous-Session");
        hashMap.put(this.getLocalizedString("authncontext.Smartcard"), "http://www.projectliberty.org/schemas/authctx/classes/Smartcard");
        hashMap.put(this.getLocalizedString("authncontext.Smartcard-PKI"), "http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI");
        hashMap.put(this.getLocalizedString("authncontext.Software-PKI"), "http://www.projectliberty.org/schemas/authctx/classes/Software-PKI");
        hashMap.put(this.getLocalizedString("authncontext.Time-Sync-Token"), "http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token");
        return hashMap;
    }

    public String getInvalidDateMessage() {
        return this.getLocalizedString("invalidDate.message");
    }

    public String getNonURLMessage() {
        return this.getLocalizedString("nonURL.message");
    }

    public String getNonIntegerMessage() {
        return this.getLocalizedString("nonInteger.message");
    }

    public String getMissingAttributeMessage() {
        return this.getLocalizedString("missingAttributeValue");
    }

    public String getCommunicationURLTitle() {
        return this.getLocalizedString("communicationUrls.label");
    }

    public String getCommunicationProfileTitle() {
        return this.getLocalizedString("profiles.label");
    }

    public String getServiceProviderTitle() {
        return this.getLocalizedString("af.sp-tab.label");
    }

    public String getIdentityServerConfigTitle() {
        return this.getLocalizedString("af.ISConfig-tab.label");
    }

    public String getSAMLTitle() {
        return this.getLocalizedString("sc.SAMLAttributes.label");
    }

    public String getProxyTitle() {
        return this.getLocalizedString("sc.ProxyAttributes.label");
    }

    public String getOrganizationTitle() {
        return this.getLocalizedString("af.organization.label");
    }

    public String getAuthenticationDomainsTitle() {
        return this.getLocalizedString("af.authenticationDomain-tab.label");
    }

    public String getAuthenticationDomainsHelp() {
        return this.getLocalizedString("af.authenticationDomain-tab.help");
    }

    public String getContactPersonsTitle() {
        return this.getLocalizedString("af.providercontactPerson.label");
    }

    public String getContactPersonNameLabel() {
        return this.getLocalizedString("contactPersonName.label");
    }

    public String getContactPersonCompanyLabel() {
        return this.getLocalizedString("contactPersonCompany.label");
    }

    public String getContactPersonEmailsLabel() {
        return this.getLocalizedString("contactPersonEmail.label");
    }

    public String getContactPersonPhonesLabel() {
        return this.getLocalizedString("contactPersonPhone.label");
    }

    public String getContactPersonContactTypeLabel() {
        return this.getLocalizedString("contactPersonType.label");
    }

    public String getContactPersonLastNameLabel() {
        return this.getLocalizedString("contactPersonLastName.label");
    }

    public String getContactPersonFirstNameLabel() {
        return this.getLocalizedString("contactPersonFirstName.label");
    }

    public String getContactPersonPrincipalIdLabel() {
        return this.getLocalizedString("contactPersonLibertyPrinId.label");
    }

    public String getHasNoContactPersonMessage() {
        return this.getLocalizedString("noContactPersons.message");
    }

    public String getContactPersonEditLabel() {
        return this.getLocalizedString("af.edit.label");
    }

    public String getContactPersonActionLabel() {
        return this.getLocalizedString("contactPersonActions.label");
    }

    public String getAddContactPersonTitle() {
        return this.getLocalizedString("newContactPerson.title");
    }

    public Map getPossibleContactTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        hashMap.put(this.getLocalizedString("contactType.tech"), "technical");
        hashMap.put(this.getLocalizedString("contactType.admin"), "administrative");
        hashMap.put(this.getLocalizedString("contactType.bill"), "billing");
        hashMap.put(this.getLocalizedString("contactType.other"), "other");
        return hashMap;
    }

    public String getNoContactPersonSelectedForDeletionTitle() {
        return this.getLocalizedString("noContactPersonSelectedForDeletion.title");
    }

    public String getNoContactPersonSelectedForDeletionMessage() {
        return this.getLocalizedString("noContactPersonSelectedForDeletion.message");
    }

    public String getContactPersonHeader() {
        return this.getLocalizedString("contactPersons.header");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public void createProvider(String string, Map map) throws AMConsoleException {
        try {
            FSAllianceManager fSAllianceManager = this.getAllianceManager();
            FSProviderDescriptor fSProviderDescriptor = this.createProviderDescriptor(string, map);
            FSEntityDescriptor fSEntityDescriptor = this.allianceManager.getEntity(this.entityId);
            if (string.equals("idp")) {
                fSEntityDescriptor.addIDPDescriptor(fSProviderDescriptor);
            } else {
                fSEntityDescriptor.addSPDescriptor(fSProviderDescriptor);
            }
            fSAllianceManager.modifyEntity(fSEntityDescriptor);
            String string2 = fSProviderDescriptor.getProviderUniqueID();
            Object[] objectArray = new String[]{string2};
            this.logger.doLog(MessageFormat.format(this.getLocalizedString("entityProviderCreated.message"), objectArray));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
    }

    private FSProviderDescriptor createProviderDescriptor(String string, Map map) throws AMConsoleException {
        String string2 = string.equals("idp") ? "IDP" : "SP";
        FSProviderDescriptor fSProviderDescriptor = this.createProviderDescriptor(map, string2);
        fSProviderDescriptor.setOrganization(this.createOrganization(map));
        fSProviderDescriptor.setListOfCOTs(this.getSetValue(map, "authenticationDomains"));
        this.setCommunicationURLs(string2, fSProviderDescriptor, map);
        this.setCommunicationProfile(fSProviderDescriptor, map);
        if (string2.equals("SP")) {
            this.setServiceProviderAttributes(fSProviderDescriptor, map);
        }
        if (this.getBooleanValue(map, "isLocal")) {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = (FSHostedProviderDescriptor)fSProviderDescriptor;
            fSHostedProviderDescriptor.setLocalConfiguration(this.createLocalConfigDescriptor(map));
            fSProviderDescriptor.setGenerateBootstrappingResourceOffering(this.getBooleanValue(map, "genDiscBootstrap"));
        }
        if (string2.equals("SP") || !this.getBooleanValue(map, "isLocal")) {
            this.setProxyConfig(fSProviderDescriptor, map);
        }
        this.addContactPersons(fSProviderDescriptor, map);
        return fSProviderDescriptor;
    }

    private void setProxyConfig(FSProviderDescriptor fSProviderDescriptor, Map map) throws AMConsoleException {
        try {
            fSProviderDescriptor.setProxyEnabled(this.getBooleanValue(map, "proxyEnabled"));
            fSProviderDescriptor.setProxyIDPs(this.getSetValue(map, "proxyIDPs"));
            fSProviderDescriptor.setProxyCount(this.getStringValue(map, "proxyCount"));
            fSProviderDescriptor.setIntroductionForProxy(this.getBooleanValue(map, "introductionProxyEnabled"));
            fSProviderDescriptor.setProxyEnabled(this.getBooleanValue(map, "introductionProxyEnabled"));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(fSAllianceManagementException);
        }
    }

    private void addContactPersons(FSProviderDescriptor fSProviderDescriptor, Map map) throws AMConsoleException {
        List list = (List)map.get("contactPersonList");
        if (list != null && !list.isEmpty()) {
            ArrayList<FSContactPerson> arrayList = new ArrayList<FSContactPerson>(list.size());
            int n = 1;
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSContactPersonEntry fSContactPersonEntry = (FSContactPersonEntry)iterator.next();
                    FSContactPerson fSContactPerson = new FSContactPerson("ContactPerson" + n);
                    ++n;
                    fSContactPerson.setGivenName(fSContactPersonEntry.firstName);
                    fSContactPerson.setSurName(fSContactPersonEntry.lastName);
                    fSContactPerson.setCompany(fSContactPersonEntry.company);
                    fSContactPerson.setLibertyPrincipalIdentifier(fSContactPersonEntry.principalId);
                    fSContactPerson.setContactType(fSContactPersonEntry.contactType);
                    fSContactPerson.setEmailAddress(fSContactPersonEntry.emails);
                    fSContactPerson.setTelephoneNumber(fSContactPersonEntry.phones);
                    arrayList.add(fSContactPerson);
                }
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            }
            fSProviderDescriptor.setContactPerson(arrayList);
        }
    }

    private FSProviderDescriptor createProviderDescriptor(Map map, String string) throws AMConsoleException {
        Object object = null;
        try {
            String string2 = this.entityId;
            object = this.getBooleanValue(map, "isLocal") ? new FSHostedProviderDescriptor(string2, "active", string) : new FSProviderDescriptor(string2, "active", string);
            object.setProviderName(this.getStringValue(map, "description"));
            object.setValidUntil(this.getStringValue(map, "validUntil"));
            object.setCacheDuration(this.getStringValue(map, "cachingDuration"));
            object.setProtocolSuppEnum(this.getStringValue(map, "protocolSupportEnum"));
            object.setSigningKeyAlias(this.getStringValue(map, "signingKeyInfo"));
            object.setEncryptionKeyAlias(this.getStringValue(map, "encryptionKeyInfo"));
            object.setEncryptionKeySize(this.getStringValue(map, "keySize"));
            object.setEncryptionKeyMethod(this.getStringValue(map, "encryptionMethod"));
            object.setNameIdMapBind(this.getSetValue(map, "serverNameIdMapping"));
            object.setAdditionalMetaLocation(this.getSetValue(map, "additionMetaLocations"));
            object.setNameIdentifierEncryption(this.getBooleanValue(map, "enableNameIdentifierEncryption"));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
        return object;
    }

    private FSOrganization createOrganization(Map map) throws AMConsoleException {
        FSOrganization fSOrganization = null;
        try {
            Set set = this.getSetValue(map, "orgNames");
            Set set2 = this.getSetValue(map, "orgDisplayNames");
            Set set3 = this.getSetValue(map, "orgURLs");
            if (!(set.isEmpty() && set2.isEmpty() && set3.isEmpty())) {
                String string = "Organization1";
                fSOrganization = new FSOrganization(string);
                fSOrganization.setOrgName(set);
                fSOrganization.setOrgDisplayName(set2);
                fSOrganization.setOrgURL(set3);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
        return fSOrganization;
    }

    private void setCommunicationURLs(String string, FSProviderDescriptor fSProviderDescriptor, Map map) throws AMConsoleException {
        try {
            fSProviderDescriptor.setSOAPEndPoint(this.getStringValue(map, "soapEndPointURL"));
            if (string.equals("IDP")) {
                fSProviderDescriptor.setSSOServiceURL(this.getStringValue(map, "singleLoginServiceURL"));
            }
            fSProviderDescriptor.setSLOServiceURL(this.getStringValue(map, "singleLogoutServiceURL"));
            fSProviderDescriptor.setSLOServiceReturnURL(this.getStringValue(map, "singleLogoutReturnURL"));
            fSProviderDescriptor.setFederationTerminationServiceURL(this.getStringValue(map, "fedTerminationServiceURL"));
            fSProviderDescriptor.setFederationTerminationServiceReturnURL(this.getStringValue(map, "fedTerminationReturnURL"));
            fSProviderDescriptor.setNameRegistrationURL(this.getStringValue(map, "nameRegistrationServiceURL"));
            fSProviderDescriptor.setNameRegistrationReturnURL(this.getStringValue(map, "nameRegistrationReturnURL"));
            fSProviderDescriptor.setAuthnServiceURL(this.getStringValue(map, "authServiceURL"));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
    }

    private void setCommunicationProfile(FSProviderDescriptor fSProviderDescriptor, Map map) throws AMConsoleException {
        try {
            fSProviderDescriptor.setFederationTerminationProtocolProfile(this.getSetValue(map, "fedTerminationProfile"));
            fSProviderDescriptor.setSLOProtocolProfile(this.getStringValue(map, "singleLogoutProfile"));
            fSProviderDescriptor.setNameRegistrationProfile(this.getStringValue(map, "nameRegistrationProfile"));
            fSProviderDescriptor.setSingleSignOnProtocolProfile(this.getStringValue(map, "singleSignOnProfile"));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
    }

    private void setServiceProviderAttributes(FSProviderDescriptor fSProviderDescriptor, Map map) throws AMConsoleException {
        try {
            fSProviderDescriptor.setAssertionConsumerServiceURL(this.getStringValue(map, "assertConsumerURL"));
            fSProviderDescriptor.setNameRegistrationIndicator(this.getBooleanValue(map, "nameRegistrationAfterFed"));
            fSProviderDescriptor.setAuthnRequestSigned(this.getBooleanValue(map, "signAuthenticationRequest"));
            fSProviderDescriptor.setAssertionConsumerServiceURLId(this.getStringValue(map, "assertConsumerServiceURLId"));
            fSProviderDescriptor.setAssertionConsumerServiceURLIsDefault(this.getBooleanValue(map, "defaultAssertConsumerServiceURL"));
            fSProviderDescriptor.setNameIDPolicy(this.getStringValue(map, "nameIDPolicy"));
            fSProviderDescriptor.setAffiliationFederation(this.getBooleanValue(map, "enableAffiliationFederation"));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
    }

    private FSLocalConfigurationDescriptor createLocalConfigDescriptor(Map map) throws AMConsoleException {
        String string = this.getStringValue(map, "providerURL");
        String string2 = this.getStringValue(map, "alias");
        try {
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = new FSLocalConfigurationDescriptor(string, string2);
            fSLocalConfigurationDescriptor.setAuthnfedProfile(this.getStringValue(map, "singleSignOnProfile"));
            fSLocalConfigurationDescriptor.setForceAuthentication(this.getBooleanValue(map, "forceAuthenticationAtIDP"));
            fSLocalConfigurationDescriptor.setIsPassive(this.getBooleanValue(map, "reqIDPPassive"));
            fSLocalConfigurationDescriptor.setLibertyVersionURI(this.getStringValue(map, "libertyVersionURI"));
            fSLocalConfigurationDescriptor.setNameIdentifierImpl(this.getStringValue(map, "nameIdentitifierImpl"));
            fSLocalConfigurationDescriptor.setProviderAuthType(this.getStringValue(map, "authenticationType"));
            fSLocalConfigurationDescriptor.setAssociatedOrgDN(this.getStringValue(map, "organizationDN"));
            fSLocalConfigurationDescriptor.setProviderHomePageURL(this.getStringValue(map, "providerHomepageURL"));
            fSLocalConfigurationDescriptor.setProviderCommonLoginPageURL(this.getStringValue(map, "singleSignonFailureRedirectURL"));
            fSLocalConfigurationDescriptor.setDefaultAuthenticationContext(this.getStringValue(map, "defaultAuthContext"));
            fSLocalConfigurationDescriptor.setAssertionInterval(this.getStringValue(map, "assertionInterval"));
            fSLocalConfigurationDescriptor.setCleanupInterval(this.getStringValue(map, "cleanupInterval"));
            fSLocalConfigurationDescriptor.setArtifactTimeout(this.getStringValue(map, "artifactTimeout"));
            fSLocalConfigurationDescriptor.setAssertionLimit(this.getStringValue(map, "assertionLimit"));
            fSLocalConfigurationDescriptor.setAssertionIssuer(this.getStringValue(map, "assertionIssuer"));
            return fSLocalConfigurationDescriptor;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new AMConsoleException(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
    }

    private boolean getBooleanValue(Map map, String string) {
        return this.getStringValue(map, string).equals("true");
    }

    private Set getSetValue(Map map, String string) {
        Set set = (Set)map.get(string);
        return set != null ? set : Collections.EMPTY_SET;
    }

    private String getStringValue(Map map, String string) {
        String string2 = null;
        Set set = (Set)map.get(string);
        if (set != null && !set.isEmpty()) {
            string2 = (String)set.iterator().next();
        }
        return string2 != null ? string2 : "";
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("createProvider.help");
        if (string.equals("createProvider.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public Map getContactTypes() {
        return FSProviderProfileModelImpl.getContactTypes(this);
    }
}

