/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.federation.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.federation.model.FSAffiGrpProfileModel;
import com.iplanet.am.console.federation.model.FSProfileModelImpl;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class FSAffiGrpProfileModelImpl
extends FSProfileModelImpl
implements FSAffiGrpProfileModel {
    private FSCircleOfTrustDescriptor affiGrp = null;

    public FSAffiGrpProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getTitle() {
        if (this.profileDN == null) {
            return "";
        }
        return this.profileDN;
    }

    public String getNameLabel() {
        return this.getLocalizedString("ag.name.label");
    }

    public String getDescriptionLabel() {
        return this.getLocalizedString("ag.description.label");
    }

    public String getStatusLabel() {
        return this.getLocalizedString("ag.status.label");
    }

    public String getReaderServiceURLLabel() {
        return this.getLocalizedString("ag.readerServiceUrl.label");
    }

    public String getReaderServiceURLHelp() {
        return this.getLocalizedString("ag.readerServiceUrl.help");
    }

    public String getWriterServiceURLLabel() {
        return this.getLocalizedString("ag.writerServiceUrl.label");
    }

    public String getWriterServiceURLHelp() {
        return this.getLocalizedString("ag.writerServiceUrl.help");
    }

    public String getSaveButtonLabel() {
        return this.getLocalizedString("save.button");
    }

    public String getResetButtonLabel() {
        return this.getLocalizedString("reset.button");
    }

    public Map getStatusTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(this.getLocalizedString("statusType.active"), "active");
        hashMap.put(this.getLocalizedString("statusType.inactive"), "inactive");
        return hashMap;
    }

    private void getAffinityGroupDescriptor() {
        block3: {
            if (this.affiGrp == null) {
                try {
                    FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
                    this.affiGrp = fSAllianceManager.getCircleOfTrust(this.profileDN);
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    if (!this.warningEnabled()) break block3;
                    this.debugWarning("error in getAffinityGroupDescriptor" + this.profileDN, (Exception)((Object)fSAllianceManagementException));
                }
            }
        }
    }

    public String getNameValue() {
        String string = null;
        this.getAffinityGroupDescriptor();
        string = this.affiGrp.getCircleOfTrustName();
        return string == null ? "" : string;
    }

    public String getStatusValue() {
        String string = null;
        this.getAffinityGroupDescriptor();
        string = this.affiGrp.getCircleOfTrustStatus();
        return string == null ? "" : string;
    }

    public String getDescriptionValue() {
        String string = null;
        this.getAffinityGroupDescriptor();
        string = this.affiGrp.getCircleOfTrustDescription();
        return string == null ? "" : string;
    }

    public String getReaderServiceURLValue() {
        String string = null;
        this.getAffinityGroupDescriptor();
        string = this.affiGrp.getReaderServiceURL();
        return string == null ? "" : string;
    }

    public String getWriterServiceURLValue() {
        String string = null;
        this.getAffinityGroupDescriptor();
        string = this.affiGrp.getWriterServiceURL();
        return string == null ? "" : string;
    }

    public boolean modifyAffinityGroup(FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor) {
        boolean bl = false;
        try {
            FSAllianceManager fSAllianceManager = new FSAllianceManager(this.ssoToken);
            fSAllianceManager.modifyCircleOfTrust(fSCircleOfTrustDescriptor);
            Object[] objectArray = new String[]{fSCircleOfTrustDescriptor.getCircleOfTrustName()};
            this.logger.doLog(MessageFormat.format(this.getLocalizedString("authenticationDomainModified.message"), objectArray));
            bl = true;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            AMModelBase.debug.warning("FSAffiGrpProfileModelImpl.modifyAffinityGroup", (Throwable)fSAllianceManagementException);
            this.errorMessage = this.getErrorString((Exception)((Object)fSAllianceManagementException));
        }
        return bl;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("authenticationDomainProfile.help");
        if (string.equals("authenticationDomainProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isDomainExists() {
        this.getAffinityGroupDescriptor();
        return this.affiGrp != null;
    }

    public String getInvalidDomainMessage() {
        return this.getLocalizedString("invalidAuthenticationDomain.message");
    }
}

