/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.federation.model;

import com.iplanet.am.console.federation.model.FSAffiGrpModel;
import com.iplanet.am.console.federation.model.FSNavModelImpl;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSAffiGrpModelImpl
extends FSNavModelImpl
implements FSAffiGrpModel {
    public FSAffiGrpModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noAuthDomainSelectedForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noAuthDomainSelectedForDeletion.message");
    }

    public String getSelectedOption() {
        return "authenticationdomains";
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("authenticationDomains.header");
    }

    public Set getAffinityGroups() {
        try {
            return new FSAllianceManager(this.ssoToken).getAllCirclesOfTrust();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            return null;
        }
    }

    public boolean hasAffiGroups(String string) {
        this.values = this.getAffinityGroups(string);
        if (this.values != null) {
            return !this.values.isEmpty();
        }
        return false;
    }

    public int getAffiGrpCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    public Set getAffinityGroups(String string) {
        try {
            this.values = new FSAllianceManager(this.ssoToken).getAllCirclesOfTrust(string);
            return this.values;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (this.warningEnabled()) {
                this.debugWarning("Error in getting FSAllianceManager", (Exception)((Object)fSAllianceManagementException));
            }
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
            return null;
        }
    }

    public boolean deleteAffinityGroups(Set set) {
        boolean bl = false;
        try {
            if (set != null && !set.isEmpty()) {
                new FSAllianceManager(this.ssoToken).deleteCirclesOfTrust(set);
                String string = this.getLocalizedString("authenticationDomainDeleted.message");
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = new String[]{(String)iterator.next()};
                    this.logger.doLog(MessageFormat.format(string, objectArray));
                }
            }
            bl = true;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debugWarning("FSAffiGrpModelImpl.deleteAffinityGroups", (Exception)((Object)fSAllianceManagementException));
            this.setErrorMessage(this.getErrorString((Exception)((Object)fSAllianceManagementException)));
        }
        return bl;
    }

    public List getAffiGrpDisplayList(List list, int n, int n2) {
        ArrayList<Object> arrayList = Collections.EMPTY_LIST;
        if (list != null && !list.isEmpty()) {
            int n3 = n;
            Object[] objectArray = list.toArray();
            int n4 = objectArray.length;
            int n5 = n4 - n2;
            if (n3 > n5) {
                n3 = n5;
            }
            arrayList = new ArrayList<Object>(n3);
            int n6 = n2;
            while (n6 < n3 + n2) {
                arrayList.add(objectArray[n6]);
                ++n6;
            }
        }
        return arrayList;
    }
}

