/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.StringConstants;
import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.Constants;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.sm.AttributeSchema;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class DynamicGUIGenerator
implements AMAdminConstants,
StringConstants,
Constants {
    private static final String HELP_SUFFIX = ".help";
    private static Debug debug = AMModelBase.debug;
    private static DynamicGUIGenerator instance = new DynamicGUIGenerator();

    private DynamicGUIGenerator() {
    }

    public static DynamicGUIGenerator getInstance() {
        return instance;
    }

    public DynamicGUI createDynamicGUI(AttributeSchema attributeSchema, String string, Set set, AMModel aMModel) {
        return this.createDynamicGUI(attributeSchema, string, set, false, null, null, null, aMModel, null);
    }

    public DynamicGUI createDynamicGUI(AttributeSchema attributeSchema, String string, Set set, AMModel aMModel, Setting setting) {
        return this.createDynamicGUI(attributeSchema, string, set, false, null, null, null, aMModel, setting);
    }

    public DynamicGUI createDynamicGUI(AttributeSchema attributeSchema, String string, Set set, boolean bl, AMModel aMModel) {
        return this.createDynamicGUI(attributeSchema, string, set, bl, null, null, null, aMModel, null);
    }

    public DynamicGUI createDynamicGUI(AttributeSchema attributeSchema, String string, Set set, boolean bl, AMModel aMModel, Setting setting) {
        return this.createDynamicGUI(attributeSchema, string, set, bl, null, null, null, aMModel, setting);
    }

    public DynamicGUI createDynamicGUI(AttributeSchema attributeSchema, String string, Set set, boolean bl, String string2, List list, List list2, AMModel aMModel) {
        return this.createDynamicGUI(attributeSchema, string, set, bl, string2, list, list2, aMModel, null);
    }

    public DynamicGUI createDynamicGUI(AttributeSchema attributeSchema, String string, Set set, boolean bl, String string2, List list, List list2, AMModel aMModel, Setting setting) {
        DynamicGUI dynamicGUI = null;
        ResourceBundle resourceBundle = aMModel.getSchemaResourceBundle(string);
        String string3 = attributeSchema.getName();
        String string4 = this.getAttributeLabel(resourceBundle, attributeSchema);
        String string5 = this.getAttributeHelp(resourceBundle, attributeSchema);
        boolean bl2 = this.isAttributeRequired(attributeSchema);
        int n = AMDisplayTypeConverter.getDisplaySyntax(attributeSchema);
        int n2 = AMDisplayTypeConverter.getDisplayType(attributeSchema);
        if (n == 6 || n == 7) {
            dynamicGUI = this.createLinkBtnDynamicGUI(attributeSchema, string, string3, string4, bl2, n2, n, aMModel);
        } else if (n2 == 0) {
            dynamicGUI = n == 0 ? this.createBoolDynamicGUI(string3, string4, bl2, n2, n, set) : (n == 5 ? this.createRadioDynamicGUI(attributeSchema, string3, string4, bl2, n2, n, set, resourceBundle, aMModel) : new DynamicGUI(string3, string4, bl2, n2, n, set));
            if (n == 2 || n == 9) {
                this.setPwdMessages(dynamicGUI, aMModel);
            }
        } else {
            dynamicGUI = n2 == 1 || n2 == 2 ? this.createChoiceDynamicGUI(attributeSchema, string, string3, string4, bl2, n2, n, set, aMModel) : (n2 == 3 ? this.createListDynamicGUI(string3, string4, bl2, n2, n, set, aMModel) : new DynamicGUI(string3, string4, bl2, n2, n, set));
        }
        if (bl2) {
            dynamicGUI.setRequiredMessage(aMModel.getLocalizedString("missingAttributes.message"));
        }
        if (bl || setting != null && !aMModel.canPerform(setting, "modifyproperties")) {
            dynamicGUI.setReadOnly(true);
        }
        if (string2 != null && list2 != null && !list2.isEmpty() && list != null && !list.isEmpty()) {
            dynamicGUI.setStatusValue(string2);
            dynamicGUI.setStatusOptions(this.getStatusOptions(list, list2));
        }
        dynamicGUI.setInlineHelp(string5);
        this.setLabelColumnWidth(dynamicGUI, aMModel);
        return dynamicGUI;
    }

    private void setLabelColumnWidth(DynamicGUI dynamicGUI, AMModel aMModel) {
        try {
            dynamicGUI.setLabelColumnWidth(Integer.parseInt(aMModel.getAttrNameWidth()));
        }
        catch (NumberFormatException numberFormatException) {
            debug.error("DynamicGUIGenerator.createDynamicGUI", (Throwable)numberFormatException);
            dynamicGUI.setLabelColumnWidth(10);
        }
    }

    private String getAttributeLabel(ResourceBundle resourceBundle, AttributeSchema attributeSchema) {
        String string = attributeSchema.getI18NKey();
        return Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
    }

    private String getAttributeHelp(ResourceBundle resourceBundle, AttributeSchema attributeSchema) {
        String string = attributeSchema.getI18NKey() + HELP_SUFFIX;
        String string2 = Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
        return string2.equals(string) ? "" : string2;
    }

    private String getAttributeHelp(ResourceBundle resourceBundle, ActionSchema actionSchema) {
        String string = actionSchema.getI18NKey() + HELP_SUFFIX;
        String string2 = Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
        return string2.equals(string) ? "" : string2;
    }

    private boolean isAttributeRequired(AttributeSchema attributeSchema) {
        String string = attributeSchema.getAny();
        return string != null && string.indexOf("required") != -1;
    }

    private DynamicGUI createRadioDynamicGUI(AttributeSchema attributeSchema, String string, String string2, boolean bl, int n, int n2, Set set, ResourceBundle resourceBundle, AMModel aMModel) {
        DynamicGUI dynamicGUI = new DynamicGUI(string, string2, bl, n, n2, set);
        Map map = this.getAttrRadioValue(attributeSchema, resourceBundle, aMModel);
        if (map.size() > 0) {
            OptionList optionList = new OptionList();
            List list = AMFormatUtils.sortMapByValue(map, aMModel.getUserLocale());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                optionList.add(string3, (String)map.get(string3));
            }
            dynamicGUI.setOptions(optionList);
        }
        return dynamicGUI;
    }

    private DynamicGUI createBoolDynamicGUI(String string, String string2, boolean bl, int n, int n2, Set set) {
        String string3 = "false";
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            string3 = (String)iterator.next();
        }
        return new DynamicGUI(string, string2, bl, n, n2, "true", "false", string3);
    }

    private DynamicGUI createLinkBtnDynamicGUI(AttributeSchema attributeSchema, String string, String string2, String string3, boolean bl, int n, int n2, AMModel aMModel) {
        String string4 = attributeSchema.getPropertiesViewBeanURL();
        DynamicGUI dynamicGUI = new DynamicGUI(string2, string3, bl, n, n2, string4);
        if (n2 == 6) {
            dynamicGUI.setLinkTypeText(this.getDynGUIBtnLinkLabel(attributeSchema, string, ".link", aMModel));
        } else {
            dynamicGUI.setButtonTypeText(this.getDynGUIBtnLinkLabel(attributeSchema, string, ".button", aMModel));
        }
        return dynamicGUI;
    }

    private DynamicGUI createChoiceDynamicGUI(AttributeSchema attributeSchema, String string, String string2, String string3, boolean bl, int n, int n2, Set set, AMModel aMModel) {
        ArrayList arrayList = new ArrayList(10);
        ArrayList arrayList2 = new ArrayList(10);
        this.getAttrChoices(attributeSchema, arrayList, arrayList2, string, aMModel);
        OptionList optionList = new OptionList();
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            optionList.add((String)arrayList.get(n4), (String)arrayList2.get(n4));
            ++n4;
        }
        return new DynamicGUI(string2, string3, bl, n, n2, set, optionList);
    }

    private DynamicGUI createListDynamicGUI(String string, String string2, boolean bl, int n, int n2, Set set, AMModel aMModel) {
        DynamicGUI dynamicGUI = new DynamicGUI(string, string2, bl, n, n2, set);
        this.setListLabels(dynamicGUI, aMModel);
        return dynamicGUI;
    }

    private Map getAttrRadioValue(AttributeSchema attributeSchema, ResourceBundle resourceBundle, AMModel aMModel) {
        Map map = null;
        AttributeSchema.Syntax syntax = attributeSchema.getSyntax();
        map = syntax == AttributeSchema.Syntax.BOOLEAN ? this.getAttrRadioBoolValue(attributeSchema, resourceBundle) : this.getAttrRadioOptionValue(attributeSchema, resourceBundle, aMModel);
        return map;
    }

    private Map getAttrRadioBoolValue(AttributeSchema attributeSchema, ResourceBundle resourceBundle) {
        String string;
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        String string3 = attributeSchema.getTrueValue();
        String string4 = attributeSchema.getFalseValue();
        if (string3 == null) {
            string3 = "true";
            hashMap.put(string3, string3);
        } else {
            string2 = attributeSchema.getTrueValueI18NKey();
            if (string2 != null && (string = Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)debug)) != null && string.length() > 0) {
                hashMap.put(string, string3);
            }
        }
        if (string4 == null) {
            string4 = "false";
            hashMap.put(string4, string4);
        } else {
            string2 = attributeSchema.getFalseValueI18NKey();
            if (string2 != null && (string = Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)debug)) != null && string.length() > 0) {
                hashMap.put(string, string4);
            }
        }
        return hashMap;
    }

    private String getCurrentOrganization(AMModel aMModel) {
        String string = aMModel.getLocationDN();
        try {
            AMStoreConnection aMStoreConnection;
            AMObject aMObject;
            int n = aMModel.getObjectType(string);
            if ((n != 2 || n != 3) && (aMObject = AMAdminUtils.getAMObject((AMModelBase)aMModel, string, aMStoreConnection = AMAdminUtils.getStoreConnAsAdmin())) != null) {
                string = aMObject.getOrganizationDN();
            }
        }
        catch (AMException aMException) {
            debug.error("DynamicGUIGenerator.getCurrentOrganization:", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.error("DynamicGUIGenerator.getCurrentOrganization:", (Throwable)sSOException);
        }
        return string;
    }

    private Map getAttrRadioOptionValue(AttributeSchema attributeSchema, ResourceBundle resourceBundle, AMModel aMModel) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("organization_name", this.getCurrentOrganization(aMModel));
        String[] stringArray = attributeSchema.getChoiceValues(hashMap);
        HashMap<String, String> hashMap2 = null;
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            hashMap2 = new HashMap(n);
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = attributeSchema.getChoiceValueI18NKey(string);
                if (string2 != null && string2.length() > 0) {
                    hashMap2.put(Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)debug), string);
                } else {
                    hashMap2.put(string, string);
                }
                ++n2;
            }
        } else {
            hashMap2 = new HashMap<String, String>(0);
        }
        return hashMap2;
    }

    private void getAttrChoices(AttributeSchema attributeSchema, List list, List list2, String string, AMModel aMModel) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("organization_name", this.getCurrentOrganization(aMModel));
        String[] stringArray = attributeSchema.getChoiceValues(hashMap);
        if (stringArray != null) {
            Object object;
            Object object2;
            int n = stringArray.length;
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>(n + 1);
            HashMap<Object, String> hashMap3 = new HashMap<Object, String>(n + 1);
            if (attributeSchema.getName().equals("inetuserstatus")) {
                hashMap2.put("", "");
                hashMap3.put("", "");
            }
            int n2 = 0;
            while (n2 < n) {
                object2 = stringArray[n2];
                if (object2 != null && ((String)object2).length() > 0) {
                    object = attributeSchema.getChoiceValueI18NKey((String)object2);
                    if (object != null && ((String)object).length() != 0) {
                        hashMap2.put(object, object2);
                        hashMap3.put(object, aMModel.getL10NAttributeName(string, (String)object));
                    } else {
                        object = ((String)object2).replace(' ', '_');
                        hashMap2.put(object, object2);
                        hashMap3.put(object, Locale.getString((ResourceBundle)aMModel.getResourceBundle(), (String)object, (Debug)debug));
                    }
                } else {
                    hashMap2.put("", "");
                    hashMap3.put("", "");
                }
                ++n2;
            }
            object2 = new ArrayList(hashMap2.keySet());
            object = Collator.getInstance(aMModel.getUserLocale());
            Collections.sort(object2, object);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                list2.add((String)hashMap2.get(string2));
                list.add((String)hashMap3.get(string2));
            }
        }
    }

    private String getDynGUIBtnLinkLabel(AttributeSchema attributeSchema, String string, String string2, AMModel aMModel) {
        String string3 = null;
        String string4 = attributeSchema.getI18NKey();
        if (string4 != null && string4.length() > 0) {
            string4 = string4 + string2;
            string3 = aMModel.getL10NAttributeName(string, string4);
        } else {
            string3 = string4;
        }
        return string3 != null ? string3 : "";
    }

    private OptionList getStatusOptions(List list, List list2) {
        OptionList optionList = new OptionList();
        int n = list.size();
        if (n == list2.size()) {
            int n2 = 0;
            while (n2 < n) {
                optionList.add((String)list.get(n2), (String)list2.get(n2));
                ++n2;
            }
        }
        return optionList;
    }

    public DynamicGUI createDynamicGUI(ActionSchema actionSchema, ResourceBundle resourceBundle, Set set, AMModel aMModel) {
        DynamicGUI dynamicGUI = null;
        String string = actionSchema.getName();
        String string2 = this.getAttributeLabel(resourceBundle, actionSchema);
        String string3 = this.getAttributeHelp(resourceBundle, actionSchema);
        int n = AMDisplayTypeConverter.getDisplaySyntax(actionSchema);
        int n2 = AMDisplayTypeConverter.getDisplayType(actionSchema);
        if (n2 == 0) {
            if (n == 0) {
                dynamicGUI = this.createBoolDynamicGUI(actionSchema, string, string2, n2, n, set);
            } else if (n != 6 && n != 7) {
                dynamicGUI = n == 5 ? this.createRadioDynamicGUI(actionSchema, string, string2, n2, n, set, resourceBundle, aMModel) : new DynamicGUI(string, string2, false, n2, n, set);
            }
            if (n == 2 || n == 9) {
                this.setPwdMessages(dynamicGUI, aMModel);
            }
        } else {
            dynamicGUI = n2 == 1 || n2 == 2 ? this.createChoiceDynamicGUI(actionSchema, string, string2, n2, n, set, resourceBundle, aMModel) : (n2 == 3 ? this.createListDynamicGUI(string, string2, n2, n, set, aMModel) : new DynamicGUI(string, string2, false, n2, n, set));
        }
        if (dynamicGUI != null) {
            dynamicGUI.setInlineHelp(string3);
            this.setLabelColumnWidth(dynamicGUI, aMModel);
        }
        return dynamicGUI;
    }

    private String getAttributeLabel(ResourceBundle resourceBundle, ActionSchema actionSchema) {
        String string = actionSchema.getI18NKey();
        return Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
    }

    private DynamicGUI createBoolDynamicGUI(ActionSchema actionSchema, String string, String string2, int n, int n2, Set set) {
        String string3;
        String string4 = actionSchema.getTrueValue();
        if (string4 == null || string4.length() == 0) {
            string4 = "true";
        }
        if ((string3 = actionSchema.getFalseValue()) == null || string3.length() == 0) {
            string3 = "false";
        }
        String string5 = string3;
        if (set != null && set.size() > 0) {
            string5 = (String)set.iterator().next();
        }
        return new DynamicGUI(string, string2, false, n, n2, "true", "false", string5);
    }

    private DynamicGUI createRadioDynamicGUI(ActionSchema actionSchema, String string, String string2, int n, int n2, Set set, ResourceBundle resourceBundle, AMModel aMModel) {
        DynamicGUI dynamicGUI = new DynamicGUI(string, string2, false, n, n2, set);
        Map map = null;
        AttributeSchema.UIType uIType = actionSchema.getUIType();
        AttributeSchema.Syntax syntax = actionSchema.getSyntax();
        if (uIType != null && uIType == AttributeSchema.UIType.RADIO) {
            map = syntax == AttributeSchema.Syntax.BOOLEAN ? this.getAttrRadioBooleanValue(actionSchema, resourceBundle) : this.getAttrRadioValue(actionSchema, resourceBundle);
        }
        if (map.size() > 0) {
            OptionList optionList = new OptionList();
            List list = AMFormatUtils.sortKeyInMap(map, aMModel.getUserLocale());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)map.get(string3);
                optionList.add(string3, string4);
            }
            dynamicGUI.setOptions(optionList);
        }
        return dynamicGUI;
    }

    private Map getAttrRadioBooleanValue(ActionSchema actionSchema, ResourceBundle resourceBundle) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        String string2 = actionSchema.getTrueValue();
        String string3 = actionSchema.getFalseValue();
        if (string2 == null) {
            string2 = "true";
        }
        if (string3 == null) {
            string3 = "false";
        }
        String string4 = actionSchema.getTrueValueI18NKey();
        String string5 = actionSchema.getFalseValueI18NKey();
        if (string4 != null) {
            string = Locale.getString((ResourceBundle)resourceBundle, (String)string4, (Debug)debug);
            if (string == null || string.length() == 0) {
                hashMap.put(string2, string2);
            } else {
                hashMap.put(string, string2);
            }
        } else {
            hashMap.put(string2, string2);
        }
        if (string5 != null) {
            string = Locale.getString((ResourceBundle)resourceBundle, (String)string5, (Debug)debug);
            if (string == null || string.length() == 0) {
                hashMap.put(string3, string3);
            } else {
                hashMap.put(string, string3);
            }
        } else {
            hashMap.put(string3, string3);
        }
        return hashMap;
    }

    private Map getAttrRadioValue(ActionSchema actionSchema, ResourceBundle resourceBundle) {
        HashMap<String, String> hashMap = null;
        String[] stringArray = actionSchema.getChoiceValues();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            hashMap = new HashMap(n);
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = actionSchema.getChoiceValueI18NKey(string);
                if (string2 != null && string2.length() > 0) {
                    hashMap.put(Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)debug), string);
                }
                ++n2;
            }
        } else {
            hashMap = new HashMap<String, String>(0);
        }
        return hashMap;
    }

    private DynamicGUI createChoiceDynamicGUI(ActionSchema actionSchema, String string, String string2, int n, int n2, Set set, ResourceBundle resourceBundle, AMModel aMModel) {
        ArrayList arrayList = new ArrayList(10);
        ArrayList arrayList2 = new ArrayList(10);
        this.getAttrChoices(actionSchema, arrayList, arrayList2, resourceBundle, aMModel);
        OptionList optionList = new OptionList();
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            optionList.add((String)arrayList.get(n4), (String)arrayList2.get(n4));
            ++n4;
        }
        return new DynamicGUI(string, string2, false, n, n2, set, optionList);
    }

    private void getAttrChoices(ActionSchema actionSchema, List list, List list2, ResourceBundle resourceBundle, AMModel aMModel) {
        Set set = actionSchema.getActionValues();
        if (set != null && !set.isEmpty()) {
            Object object;
            Object object2;
            int n = set.size();
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(n);
            HashMap<Object, String> hashMap2 = new HashMap<Object, String>(n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                if (object2 == null || ((String)object2).length() <= 0 || (object = actionSchema.getActionValueI18NKey((String)object2)) == null || ((String)object).length() == 0) continue;
                hashMap.put(object, object2);
                hashMap2.put(object, Locale.getString((ResourceBundle)resourceBundle, (String)object, (Debug)debug));
            }
            object2 = new ArrayList(hashMap.keySet());
            object = Collator.getInstance(aMModel.getUserLocale());
            Collections.sort(object2, object);
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                list2.add((String)hashMap.get(string));
                list.add((String)hashMap2.get(string));
            }
        }
    }

    private DynamicGUI createListDynamicGUI(String string, String string2, int n, int n2, Set set, AMModel aMModel) {
        DynamicGUI dynamicGUI = new DynamicGUI(string, string2, false, n, n2, set);
        this.setListLabels(dynamicGUI, aMModel);
        return dynamicGUI;
    }

    private void setListLabels(DynamicGUI dynamicGUI, AMModel aMModel) {
        dynamicGUI.setAddButtonStr(aMModel.getLocalizedString("dynGUIAddToList.button"));
        dynamicGUI.setAddEllipseButtonStr(aMModel.getLocalizedString("dynGUIAddToListEllipse.button"));
        dynamicGUI.setEditEllipseButtonStr(aMModel.getLocalizedString("dynGUIEditListEllipse.button"));
        dynamicGUI.setCopyEllipseButtonStr(aMModel.getLocalizedString("dynGUICopyListEllipse.button"));
        dynamicGUI.setRemoveButtonStr(aMModel.getLocalizedString("dynGUIRemoveFromList.button"));
    }

    private void setPwdMessages(DynamicGUI dynamicGUI, AMModel aMModel) {
        dynamicGUI.setPasswordMessage(aMModel.getLocalizedString("passwordMismatch.message"));
        dynamicGUI.setConfirmPwdLabel(aMModel.getLocalizedString("dynGUIConfirmPassword.label"));
    }
}

