/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMServiceDisplayModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AMServiceDisplayModelImpl
implements AMServiceDisplayModel {
    private AMStoreConnection amStoreConn = null;
    private static final String SERVICE_OPTIONS_SEPARATOR = "#";

    public AMServiceDisplayModelImpl(AMStoreConnection aMStoreConnection) {
        this.amStoreConn = aMStoreConnection;
    }

    public Map getRoleOptions(AMRole aMRole, Set set) throws AMException, SSOException {
        Map map = null;
        Set set2 = aMRole.getAttribute("iplanet-am-role-service-options");
        map = set2 == null || set2.isEmpty() ? this.getDefaultServiceOptions(set) : this.getOptionsFromRoleAttribute(set2);
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("AMAttributeDisplayImpl.getRoleOptions " + map);
        }
        return map;
    }

    public void setRoleOptions(AMRole aMRole, Map map) throws AMException, SSOException {
        Set set = this.mapOptionsToSet(map);
        HashMap<String, Set> hashMap = new HashMap<String, Set>(1);
        hashMap.put("iplanet-am-role-service-options", set);
        aMRole.setAttributes(hashMap);
        aMRole.store();
    }

    public Set getDeniedServices(AMRole aMRole) throws AMException, SSOException {
        Set set = aMRole.getAttribute("iplanet-am-role-service-options");
        if (set == null || set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>(set.size() * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, SERVICE_OPTIONS_SEPARATOR);
            if (stringTokenizer.countTokens() != 1) continue;
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    public Set getDeniedServices(AMUser aMUser) throws AMException, SSOException {
        Map map = this.getUserServiceOptions(aMUser);
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getDeniedServices:aggregatedOptions " + map);
        }
        HashSet<String> hashSet = new HashSet<String>(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set != null && !set.isEmpty()) continue;
            hashSet.add(string);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getDeniedServices: " + hashSet);
        }
        return hashSet;
    }

    private Set mapOptionsToSet(Map map) {
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(string).append(SERVICE_OPTIONS_SEPARATOR);
            if (set != null && (iterator2 = set.iterator()).hasNext()) {
                stringBuffer.append((String)iterator2.next());
            }
            hashSet.add(stringBuffer.toString());
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("mapOptionsToSet options : " + hashSet);
        }
        return hashSet;
    }

    private Map getUserServiceOptions(AMUser aMUser) throws AMException, SSOException {
        HashMap hashMap = null;
        Set set = aMUser.getRoleDNs();
        AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (SecurityException securityException) {
                    AMModelBase.debug.error("AMServiceDisplayModelImpl.getUserServiceOptions", (Throwable)securityException);
                    return null;
                }
            }
        });
        if (aMStoreConnection != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMRole aMRole = aMStoreConnection.getRole(string);
                Set set2 = aMRole.getAttribute("iplanet-am-role-service-options");
                if (set2 == null || set2.isEmpty()) continue;
                Map map = this.getOptionsFromRoleAttribute(set2);
                if (hashMap == null) {
                    hashMap = new HashMap(map.size());
                    hashMap.putAll(map);
                    continue;
                }
                hashMap.putAll(this.getAggregatedOptions(hashMap, map));
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("getUserServiceOptions: " + hashMap);
            }
        }
        return hashMap;
    }

    private Map getDefaultServiceOptions(Set set) throws AMException, SSOException {
        HashMap hashMap = new HashMap(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add("display");
            hashMap.put(string, hashSet);
        }
        return hashMap;
    }

    private Map getAggregatedOptions(Map map, Map map2) {
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("currentOptions: " + map);
            AMModelBase.debug.message("newOptions: " + map2);
        }
        HashMap<String, Set> hashMap = new HashMap<String, Set>(map);
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)map2.get(string);
            Set set2 = (Set)map.get(string);
            if (set2 == null || set2.isEmpty() || set == null || set.isEmpty()) {
                hashMap.put(string, Collections.EMPTY_SET);
                continue;
            }
            hashMap.put(string, set);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getAggregatedOptions: " + hashMap);
        }
        return hashMap;
    }

    private Map getOptionsFromRoleAttribute(Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, SERVICE_OPTIONS_SEPARATOR);
            int n = stringTokenizer.countTokens();
            if (n < 1) continue;
            String string2 = stringTokenizer.nextToken();
            if (n == 1) {
                hashMap.put(string2, Collections.EMPTY_SET);
                continue;
            }
            if (n != 2) continue;
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(stringTokenizer.nextToken());
            hashMap.put(string2, hashSet);
        }
        return hashMap;
    }
}

