/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMQuickSearchModel;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AMQuickSearchModelImpl
extends AMModelBase
implements AMQuickSearchModel {
    private static Setting[] navigationMenuSettings = new Setting[]{Setting.ROOT_NAVIGATION_MENU, Setting.ORGANIZATION_NAVIGATION_MENU, Setting.ORGANIZATIONAL_UNIT_NAVIGATION_MENU, Setting.GROUP_CONTAINER_NAVIGATION_MENU, Setting.PEOPLE_CONTAINER_NAVIGATION_MENU, Setting.ROLE_NAVIGATION_MENU, Setting.GROUP_NAVIGATION_MENU};
    private static Map mapSettingToAMObjectType = new HashMap();
    private static Map mapSettingToAction = new HashMap();
    private String searchErrorMsg = null;

    public AMQuickSearchModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getHTMLPageTitle() {
        Object[] objectArray = new String[]{this.getQuickSearchTitle(), this.getLocalizedString("console.title")};
        return MessageFormat.format(this.getLocalizedString("quickSearchTitle.format"), objectArray);
    }

    public String getQuickSearchTitle() {
        return this.getLocalizedString("quickSearch.title");
    }

    public String getPathTitle() {
        return this.getLocalizedString("quickSearchPath.label");
    }

    public String getQuickSearchLabel() {
        return this.getLocalizedString("quickSearch.label");
    }

    public String getInlineHelpString() {
        return this.getLocalizedString("quickSearchInlineHelp.label");
    }

    public String getQuickSearchTopDownBtnLabel() {
        return this.getLocalizedString("quickSearchTopDown.button");
    }

    public String getQuickSearchDownBtnLabel() {
        return this.getLocalizedString("quickSearchDown.button");
    }

    public List getSearchTypes() throws AMConsoleException {
        List list = Collections.EMPTY_LIST;
        int n = this.getStartLocType();
        if (n != -1) {
            switch (n) {
                case 2: 
                case 3: {
                    list = this.getOrgSearchTypes();
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    list = this.getGroupSearchTypes();
                    break;
                }
                case 5: {
                    list = this.getUserSearchTypes();
                    break;
                }
                case 6: 
                case 8: {
                    list = this.getRoleSearchTypes();
                }
            }
        }
        this.removeHiddenMenus(list);
        return list;
    }

    public String getSearchResultsLabel() {
        return this.getLocalizedString("searchResults.label");
    }

    public String getSearchTypeLabel(String string) {
        String string2 = "";
        String string3 = this.getLocalizedString("name.label");
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 2: {
                    string2 = this.getLocalizedString("organizations.label");
                    break;
                }
                case 3: {
                    string2 = this.getLocalizedString("orgunits.label");
                    break;
                }
                case 4: {
                    string2 = this.getLocalizedString("groupcontainers.label");
                    break;
                }
                case 9: {
                    string2 = this.getLocalizedString("groups.label");
                    break;
                }
                case 5: {
                    string2 = this.getLocalizedString("containers.label");
                    break;
                }
                case 1: {
                    string2 = this.getLocalizedString("users.label");
                    string3 = this.getL10NAttributeName("iPlanetAMUserService", SchemaType.USER, this.getUserSearchAttribute(this.getStartDN()));
                    break;
                }
                case 6: {
                    string2 = this.getLocalizedString("roles.label");
                    break;
                }
                case 14: {
                    string2 = this.getLocalizedString("policies.label");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMHeaderViewModelImpl.getSearchTypeLabel", (Throwable)numberFormatException);
        }
        Object[] objectArray = new String[]{string2, string3};
        return MessageFormat.format(this.getLocalizedString("searchCriteria.label"), objectArray);
    }

    private int getStartLocType() {
        int n = -1;
        try {
            n = this.getObjectType(this.startDN);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getStartLocType", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("AMHeaderViewModelImpl.getStartLocType", (Throwable)aMException);
        }
        return n;
    }

    private List getOrgSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(6);
        if (this.isUserMgtEnabled()) {
            arrayList.add(Integer.toString(2));
            if (this.showOrgUnits()) {
                arrayList.add(Integer.toString(3));
            }
            if (this.showGroupContainers()) {
                arrayList.add(Integer.toString(4));
            }
            arrayList.add(Integer.toString(9));
            if (this.showPeopleContainers()) {
                arrayList.add(Integer.toString(5));
            }
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
            arrayList.add(Integer.toString(6));
        }
        return arrayList;
    }

    private List getGroupSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (this.isUserMgtEnabled()) {
            if (this.showGroupContainers()) {
                arrayList.add(Integer.toString(4));
            }
            arrayList.add(Integer.toString(9));
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
        }
        return arrayList;
    }

    private List getUserSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (this.isUserMgtEnabled()) {
            if (this.showPeopleContainers()) {
                arrayList.add(Integer.toString(5));
            }
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
        }
        return arrayList;
    }

    private List getRoleSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (this.isUserMgtEnabled()) {
            arrayList.add(Integer.toString(1));
        }
        return arrayList;
    }

    public String getStartLocLabel() {
        Object[] objectArray = new String[]{AMFormatUtils.DNToName(this, this.getStartDN())};
        return MessageFormat.format(this.getLocalizedString("quickSearchStartLocDN.label"), objectArray);
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noEntries.message");
    }

    public boolean isRoleType(String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            bl = n == 6 || n == 8;
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMQuickSearchModelImpl.isRoleType", (Throwable)numberFormatException);
        }
        return bl;
    }

    public boolean isUserOrGroupType(String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            bl = n == 1;
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMQuickSearchModelImpl.isUserOrGroupType", (Throwable)numberFormatException);
        }
        return bl;
    }

    public String getRoleDisplayName(String string) {
        return AMFormatUtils.DNToName(this, string, true);
    }

    public Set searchForObjects(String string, String string2, Map map) throws AMConsoleException {
        Set set = Collections.EMPTY_SET;
        if (string2 == null || string2.length() == 0) {
            string2 = "*";
        }
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 2: {
                    set = this.searchOrganizations(string2, map);
                    break;
                }
                case 3: {
                    set = this.searchOrganizationUnits(string2, map);
                    break;
                }
                case 4: {
                    set = this.searchGroupContainers(string2, map);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    set = this.searchGroups(string2, map);
                    break;
                }
                case 6: 
                case 8: {
                    set = this.searchRoles(string2, map);
                    break;
                }
                case 5: {
                    set = this.searchPeopleContainers(string2, map);
                    break;
                }
                case 1: {
                    set = this.searchUsers(string2, map);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMQuickSearchModelImpl.searchForObjects", (Throwable)numberFormatException);
        }
        return set;
    }

    protected Set searchOrganizations(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    aMSearchResults = this.searchOrganizationsUnderOrg(aMSearchControl, string);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchOrganizations(string, aMSearchControl);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchOrganizations", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchOrganizations", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, false);
    }

    private AMSearchResults searchOrganizationsUnderOrg(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        HashSet hashSet;
        Set set;
        AMSearchResults aMSearchResults = null;
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        boolean bl = false;
        boolean bl2 = false;
        if (this.isRootSuffix()) {
            set = this.getUserSettings(Setting.ROOT_NAVIGATION_MENU);
            boolean bl3 = bl = set != null && !set.contains("organizations");
            if (!bl) {
                hashSet = this.getUserSettings(Setting.ORGANIZATION_NAVIGATION_MENU);
                boolean bl4 = bl2 = hashSet != null && !hashSet.contains("organizations");
            }
        }
        if (bl) {
            set = aMOrganization.getSubOrganizations(1);
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                int n = 0;
                int n2 = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    AMOrganization aMOrganization2 = this.dpStoreConn.getOrganization(string2);
                    AMSearchResults aMSearchResults2 = aMOrganization2.searchSubOrganizations(string, aMSearchControl);
                    if (aMSearchResults2 == null) continue;
                    n = aMSearchResults2.getErrorCode();
                    hashSet.addAll(aMSearchResults2.getSearchResults());
                    hashSet.remove(string2);
                    hashMap.putAll(aMSearchResults2.getResultAttributes());
                    n2 += aMSearchResults2.getTotalResultCount();
                }
                aMSearchResults = new AMSearchResults(n2, hashSet, n, hashMap);
            }
        } else {
            if (bl2) {
                aMSearchControl.setSearchScope(1);
            }
            aMSearchResults = aMOrganization.searchSubOrganizations(string, aMSearchControl);
        }
        return aMSearchResults;
    }

    protected Set searchOrganizationUnits(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    aMSearchResults = this.searchOrganizationalUnitsUnderOrg(aMSearchControl, string);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchSubOrganizationalUnits(string, aMSearchControl);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchOrganizationUnits", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchOrganizationUnits", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, false);
    }

    private AMSearchResults searchOrganizationalUnitsUnderOrg(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        Set set;
        Set set2;
        AMSearchResults aMSearchResults = null;
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.isRootSuffix()) {
            set2 = this.getUserSettings(Setting.ROOT_NAVIGATION_MENU);
            boolean bl4 = bl = set2 != null && !set2.contains("organizationalunits");
            if (!bl) {
                set = this.getUserSettings(Setting.ORGANIZATION_NAVIGATION_MENU);
                bl2 = set != null && !set.contains("organizationalunits");
            }
        }
        boolean bl5 = bl3 = (set2 = this.getUserSettings(Setting.ORGANIZATIONAL_UNIT_NAVIGATION_MENU)) != null && set2.contains("organizationalunits");
        if (bl) {
            if (!bl3) {
                aMSearchControl.setSearchScope(1);
            }
            if ((set = aMOrganization.getSubOrganizations(1)) != null && !set.isEmpty()) {
                HashSet hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                int n = 0;
                int n2 = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    AMOrganization aMOrganization2 = this.dpStoreConn.getOrganization(string2);
                    AMSearchResults aMSearchResults2 = aMOrganization2.searchOrganizationalUnits(string, aMSearchControl);
                    if (aMSearchResults2 == null) continue;
                    n = aMSearchResults2.getErrorCode();
                    hashSet.addAll(aMSearchResults2.getSearchResults());
                    hashMap.putAll(aMSearchResults2.getResultAttributes());
                    n2 += aMSearchResults2.getTotalResultCount();
                }
                aMSearchResults = new AMSearchResults(n2, hashSet, n, hashMap);
            }
        } else if (bl2) {
            aMSearchControl.setSearchScope(1);
            set = aMOrganization.searchOrganizationalUnits(string, aMSearchControl);
            if (set != null) {
                HashSet hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                hashSet.addAll(set.getSearchResults());
                int n = set.getErrorCode();
                int n3 = set.getTotalResultCount();
                if (bl3) {
                    Iterator iterator = set.getSearchResults().iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string3);
                        Set set3 = aMOrganizationalUnit.searchSubOrganizationalUnits(string, 2);
                        hashSet.addAll(set3);
                        n3 += set3.size();
                    }
                }
                aMSearchResults = new AMSearchResults(n3, hashSet, n, hashMap);
            }
        } else {
            aMSearchResults = aMOrganization.searchOrganizationalUnits(string, aMSearchControl);
        }
        return aMSearchResults;
    }

    protected Set searchGroupContainers(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    aMSearchResults = this.searchGroupContainersUnderOrg(aMSearchControl, string);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchGroupContainers(string, null, aMSearchControl);
                    break;
                }
                case 4: {
                    AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMGroupContainer, aMSearchControl);
                    aMSearchResults = aMGroupContainer.searchSubGroupContainers(string, null, aMSearchControl);
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroupContainer", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroupContainer", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, false);
    }

    private AMSearchResults searchGroupContainersUnderOrg(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        HashSet hashSet;
        Set set;
        AMSearchResults aMSearchResults = null;
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        boolean bl = false;
        boolean bl2 = false;
        if (this.isRootSuffix()) {
            set = this.getUserSettings(Setting.ROOT_NAVIGATION_MENU);
            boolean bl3 = bl = set != null && !set.contains("groupcontainers");
            if (!bl) {
                hashSet = this.getUserSettings(Setting.ORGANIZATION_NAVIGATION_MENU);
                boolean bl4 = bl2 = hashSet != null && !hashSet.contains("groupcontainers");
            }
        }
        if (bl) {
            set = aMOrganization.getSubOrganizations(1);
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                int n = 0;
                int n2 = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    AMOrganization aMOrganization2 = this.dpStoreConn.getOrganization(string2);
                    AMSearchResults aMSearchResults2 = aMOrganization2.searchGroupContainers(string, null, aMSearchControl);
                    if (aMSearchResults2 == null) continue;
                    n = aMSearchResults2.getErrorCode();
                    hashSet.addAll(aMSearchResults2.getSearchResults());
                    hashMap.putAll(aMSearchResults2.getResultAttributes());
                    n2 += aMSearchResults2.getTotalResultCount();
                }
                aMSearchResults = new AMSearchResults(n2, hashSet, n, hashMap);
            }
        } else {
            if (bl2) {
                aMSearchControl.setSearchScope(1);
            }
            aMSearchResults = aMOrganization.searchGroupContainers(string, null, aMSearchControl);
        }
        return aMSearchResults;
    }

    protected Set searchPeopleContainers(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    aMSearchResults = this.searchPeopleContainersUnderOrg(aMSearchControl, string);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchPeopleContainers(string, null, aMSearchControl);
                    break;
                }
                case 5: {
                    AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMPeopleContainer, aMSearchControl);
                    Set set = aMPeopleContainer.searchSubPeopleContainers(string, 2);
                    return this.processResults(set, map);
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchPeopleContainer", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchPeopleContainer", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, false);
    }

    private AMSearchResults searchPeopleContainersUnderOrg(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        Set set;
        Set set2;
        AMSearchResults aMSearchResults = null;
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.isRootSuffix()) {
            set2 = this.getUserSettings(Setting.ROOT_NAVIGATION_MENU);
            boolean bl4 = bl = set2 != null && !set2.contains("peoplecontainers");
            if (!bl) {
                set = this.getUserSettings(Setting.ORGANIZATION_NAVIGATION_MENU);
                bl2 = set != null && !set.contains("peoplecontainers");
            }
        }
        boolean bl5 = bl3 = (set2 = this.getUserSettings(Setting.PEOPLE_CONTAINER_NAVIGATION_MENU)) != null && set2.contains("peoplecontainers");
        if (bl) {
            if (!bl3) {
                aMSearchControl.setSearchScope(1);
            }
            if ((set = aMOrganization.getSubOrganizations(1)) != null && !set.isEmpty()) {
                HashSet hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                int n = 0;
                int n2 = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    AMOrganization aMOrganization2 = this.dpStoreConn.getOrganization(string2);
                    AMSearchResults aMSearchResults2 = aMOrganization2.searchPeopleContainers(string, null, aMSearchControl);
                    if (aMSearchResults2 == null) continue;
                    n = aMSearchResults2.getErrorCode();
                    hashSet.addAll(aMSearchResults2.getSearchResults());
                    hashMap.putAll(aMSearchResults2.getResultAttributes());
                    n2 += aMSearchResults2.getTotalResultCount();
                }
                aMSearchResults = new AMSearchResults(n2, hashSet, n, hashMap);
            }
        } else if (bl2) {
            aMSearchControl.setSearchScope(1);
            set = aMOrganization.searchPeopleContainers(string, null, aMSearchControl);
            if (set != null) {
                HashSet hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                hashSet.addAll(set.getSearchResults());
                int n = set.getErrorCode();
                int n3 = set.getTotalResultCount();
                if (bl3) {
                    Iterator iterator = set.getSearchResults().iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(string3);
                        Set set3 = aMPeopleContainer.searchSubPeopleContainers(string, 2);
                        hashSet.addAll(set3);
                        n3 += set3.size();
                    }
                }
                aMSearchResults = new AMSearchResults(n3, hashSet, n, hashMap);
            }
        } else {
            aMSearchResults = aMOrganization.searchPeopleContainers(string, null, aMSearchControl);
        }
        return aMSearchResults;
    }

    protected Set searchRoles(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        try {
            switch (this.locationType) {
                case 2: {
                    aMSearchResults = this.searchRolesUnderOrg(aMSearchControl, string);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchAllRoles(string, aMSearchControl);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchRoles", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchRoles", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, false, true);
    }

    private AMSearchResults searchRolesUnderOrg(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        HashSet hashSet;
        Set set;
        AMSearchResults aMSearchResults = null;
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        boolean bl = false;
        boolean bl2 = false;
        if (this.isRootSuffix()) {
            set = this.getUserSettings(Setting.ROOT_NAVIGATION_MENU);
            boolean bl3 = bl = set != null && !set.contains("roles");
            if (!bl) {
                hashSet = this.getUserSettings(Setting.ORGANIZATION_NAVIGATION_MENU);
                boolean bl4 = bl2 = hashSet != null && !hashSet.contains("roles");
            }
        }
        if (bl) {
            set = aMOrganization.getSubOrganizations(1);
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                int n = 0;
                int n2 = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    AMOrganization aMOrganization2 = this.dpStoreConn.getOrganization(string2);
                    AMSearchResults aMSearchResults2 = aMOrganization2.searchAllRoles(string, aMSearchControl);
                    if (aMSearchResults2 == null) continue;
                    n = aMSearchResults2.getErrorCode();
                    hashSet.addAll(aMSearchResults2.getSearchResults());
                    hashMap.putAll(aMSearchResults2.getResultAttributes());
                    n2 += aMSearchResults2.getTotalResultCount();
                }
                aMSearchResults = new AMSearchResults(n2, hashSet, n, hashMap);
            }
        } else {
            if (bl2) {
                aMSearchControl.setSearchScope(1);
            }
            aMSearchResults = aMOrganization.searchAllRoles(string, aMSearchControl);
        }
        return aMSearchResults;
    }

    protected Set searchUsers(String string, Map map) throws AMConsoleException {
        this.searchErrorMsg = null;
        AMSearchResults aMSearchResults = null;
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(2);
        int n = this.locationType;
        String string2 = this.locationDN;
        while (n != 2 && n != 3) {
            string2 = AMAdminUtils.getParent(string2);
            n = this.getLocationType(string2);
        }
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(this.getUserSearchAttribute(string2));
        aMSearchControl.setReturnAttributes(hashSet);
        try {
            switch (this.locationType) {
                case 2: {
                    aMSearchResults = this.searchUsersUnderOrg(aMSearchControl, string);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                    aMSearchResults = aMOrganizationalUnit.searchUsers(aMSearchControl, this.getSearchFilter(this.locationDN, string));
                    break;
                }
                case 5: {
                    aMSearchResults = this.getUsersUnderPC(aMSearchControl, string);
                    break;
                }
                case 6: 
                case 8: {
                    aMSearchResults = this.getUsersUnderRole(aMSearchControl, string);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    aMSearchResults = this.getUsersUnderGroup(aMSearchControl, string);
                    break;
                }
                default: {
                    throw new AMConsoleException(this.getLocalizedString("invalidObjectType.message"));
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchUsers", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchUsers", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return this.processResults(aMSearchResults, map, true, false);
    }

    private AMSearchResults searchUsersUnderOrg(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        HashSet hashSet;
        Set set;
        AMSearchResults aMSearchResults = null;
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        String string2 = this.getSearchFilter(this.locationDN, string);
        boolean bl = false;
        boolean bl2 = false;
        if (this.isRootSuffix()) {
            set = this.getUserSettings(Setting.ROOT_NAVIGATION_MENU);
            boolean bl3 = bl = set != null && !set.contains("users");
            if (!bl) {
                hashSet = this.getUserSettings(Setting.ORGANIZATION_NAVIGATION_MENU);
                boolean bl4 = bl2 = hashSet != null && !hashSet.contains("users");
            }
        }
        if (bl) {
            set = aMOrganization.getSubOrganizations(1);
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                int n = 0;
                int n2 = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    AMOrganization aMOrganization2 = this.dpStoreConn.getOrganization(string3);
                    AMSearchResults aMSearchResults2 = aMOrganization2.searchUsers(aMSearchControl, string2);
                    if (aMSearchResults2 == null) continue;
                    n = aMSearchResults2.getErrorCode();
                    hashSet.addAll(aMSearchResults2.getSearchResults());
                    hashMap.putAll(aMSearchResults2.getResultAttributes());
                    n2 += aMSearchResults2.getTotalResultCount();
                }
                aMSearchResults = new AMSearchResults(n2, hashSet, n, hashMap);
            }
        } else if (bl2) {
            set = aMOrganization.getPeopleContainers(1);
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet();
                HashMap hashMap = new HashMap();
                int n = 0;
                int n3 = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(string4);
                    AMSearchResults aMSearchResults3 = aMPeopleContainer.searchUsers(aMSearchControl, string2);
                    if (aMSearchResults3 == null) continue;
                    n = aMSearchResults3.getErrorCode();
                    hashSet.addAll(aMSearchResults3.getSearchResults());
                    hashMap.putAll(aMSearchResults3.getResultAttributes());
                    n3 += aMSearchResults3.getTotalResultCount();
                }
                aMSearchResults = new AMSearchResults(n3, hashSet, n, hashMap);
            }
        } else {
            aMSearchResults = aMOrganization.searchUsers(aMSearchControl, string2);
        }
        return aMSearchResults;
    }

    private AMSearchResults getUsersUnderPC(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(this.locationDN);
        String string2 = aMPeopleContainer.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        } else {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
        }
        return aMPeopleContainer.searchUsers(aMSearchControl, this.getSearchFilter(string2, string));
    }

    private AMSearchResults getUsersUnderRole(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        AMRole aMRole = (AMRole)this.getAMObject(this.locationDN);
        String string2 = aMRole.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        } else {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
        }
        return aMRole.searchUsers(aMSearchControl, this.getSearchFilter(string2, string));
    }

    private AMSearchResults getUsersUnderGroup(AMSearchControl aMSearchControl, String string) throws SSOException, AMException {
        Object object;
        AMGroup aMGroup = (AMGroup)this.getAMObject(this.locationDN);
        String string2 = aMGroup.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            object = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)object, aMSearchControl);
        } else {
            object = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)object, aMSearchControl);
        }
        object = this.getSearchFilter(string2, string);
        AMSearchResults aMSearchResults = aMGroup.searchUsers(aMSearchControl, (String)object);
        Set set = aMGroup.getGroupDNs(2);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                AMGroup aMGroup2 = (AMGroup)this.getAMObject(string3);
                AMSearchResults aMSearchResults2 = aMGroup2.searchUsers(aMSearchControl, (String)object);
                aMSearchResults = this.mergeResults(aMSearchResults, aMSearchResults2);
            }
        }
        return aMSearchResults;
    }

    private AMSearchResults mergeResults(AMSearchResults aMSearchResults, AMSearchResults aMSearchResults2) {
        int n = aMSearchResults.getTotalResultCount() + aMSearchResults2.getTotalResultCount();
        HashSet hashSet = new HashSet();
        hashSet.addAll(aMSearchResults.getSearchResults());
        hashSet.addAll(aMSearchResults2.getSearchResults());
        int n2 = aMSearchResults2.getErrorCode() != 0 ? aMSearchResults2.getErrorCode() : aMSearchResults.getErrorCode();
        HashMap hashMap = new HashMap();
        hashMap.putAll(aMSearchResults.getResultAttributes());
        hashMap.putAll(aMSearchResults2.getResultAttributes());
        return new AMSearchResults(n, hashSet, n2, hashMap);
    }

    private String getSearchFilter(String string, String string2) throws SSOException {
        String string3 = this.getUserSearchAttribute(string);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("(").append(string3).append("=").append(string2).append(")");
        return stringBuffer.toString();
    }

    private String getUserSearchAttribute(String string) {
        String string2 = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate(string);
            if (aMTemplate != null) {
                string2 = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-search-key");
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string2 = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-search-key");
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.getUserSearchAttribute", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.getUserSearchAttribute", (Throwable)aMException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.getUserSearchAttribute", (Throwable)sMSException);
        }
        if (string2 == null) {
            string2 = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        }
        return string2;
    }

    protected Set searchGroups(String string, Map map) throws AMConsoleException {
        Object object;
        Object object2;
        Set set = Collections.EMPTY_SET;
        AMStaticGroup aMStaticGroup = null;
        try {
            switch (this.locationType) {
                case 2: {
                    set = this.searchGroupsUnderOrg(string);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 3: {
                    object2 = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    set = object2.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 4: {
                    object = this.dpStoreConn.getGroupContainer(this.locationDN);
                    set = object.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 9: 
                case 10: {
                    aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    set = aMStaticGroup.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 11: {
                    aMStaticGroup = this.dpStoreConn.getDynamicGroup(this.locationDN);
                    set = aMStaticGroup.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                case 12: {
                    aMStaticGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    set = aMStaticGroup.searchGroups(string, null, 2);
                    if (!this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                    break;
                }
                default: {
                    if (AMModelBase.debug.warningEnabled()) {
                        AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroups invalid location " + this.locationDN);
                    }
                    break;
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroups", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMQuickSearchModelImpl.searchGroups", (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        } else {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                map.put(object, AMFormatUtils.DNToName(this, (String)object, false));
            }
        }
        return set;
    }

    private Set searchGroupsUnderOrg(String string) throws SSOException, AMException {
        Object object;
        Set set;
        HashSet hashSet = Collections.EMPTY_SET;
        boolean bl = false;
        boolean bl2 = false;
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
        if (this.isRootSuffix()) {
            set = this.getUserSettings(Setting.ROOT_NAVIGATION_MENU);
            boolean bl3 = bl = set != null && !set.contains("groups");
            if (!bl) {
                object = this.getUserSettings(Setting.ORGANIZATION_NAVIGATION_MENU);
                boolean bl4 = bl2 = object != null && !object.contains("groups");
            }
        }
        if (bl) {
            set = aMOrganization.getSubOrganizations(1);
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet();
                object = set.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    AMOrganization aMOrganization2 = this.dpStoreConn.getOrganization(string2);
                    Set set2 = aMOrganization2.searchGroups(string, null, 2);
                    if (set2 == null) continue;
                    hashSet.addAll(set2);
                }
            }
        } else if (bl2) {
            set = aMOrganization.getGroupContainers(1);
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet();
                object = set.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(string3);
                    Set set3 = aMGroupContainer.searchGroups(string, null, 2);
                    if (set3 == null) continue;
                    hashSet.addAll(set3);
                }
            }
        } else {
            hashSet = aMOrganization.searchGroups(string, null, 2);
        }
        return hashSet;
    }

    private Set removeHiddenGroups(Set set) {
        HashSet<String> hashSet = new HashSet<String>(set.size());
        String string = null;
        String string2 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = AMFormatUtils.DNToName(this, string, false);
            if (string2.equalsIgnoreCase("DomainAdministrators") || string2.equalsIgnoreCase("DomainHelpDeskAdministrators") || string2.equalsIgnoreCase("ServiceAdministrators") || string2.equalsIgnoreCase("ServiceHelpDeskAdministrators")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private Set processResults(AMSearchResults aMSearchResults, Map map, boolean bl, boolean bl2) {
        Set set = Collections.EMPTY_SET;
        if (aMSearchResults != null) {
            set = aMSearchResults.getSearchResults();
            AMAdminUtils.removeDNFromSet(set, this.locationDN);
            if (bl) {
                Map map2 = aMSearchResults.getResultAttributes();
                Iterator iterator = map2.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Map map3 = (Map)map2.get(string);
                    Iterator iterator2 = map3.keySet().iterator();
                    Set set2 = (Set)map3.get(iterator2.next());
                    map.put(string, set2.iterator().next());
                }
            } else {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    map.put(string, AMFormatUtils.DNToName(this, string, bl2));
                }
            }
            this.searchErrorMsg = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
        }
        return set;
    }

    private Set processResults(Set set, Map map) {
        if (set != null && !set.isEmpty()) {
            AMAdminUtils.removeDNFromSet(set, this.locationDN);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                map.put(string, AMFormatUtils.DNToName(this, string, false));
            }
        }
        return set;
    }

    public String getCloseButtonLabel() {
        return this.getLocalizedString("close.button");
    }

    public String getQuickSearchTableTitle() {
        return this.getLocalizedString("quickSearchTable.label");
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    public String getPromptSearchMessage() {
        return this.getLocalizedString("doSearch.message");
    }

    private void removeHiddenMenus(List list) {
        Set set = this.getSearchableObjects();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set.contains(string)) continue;
            iterator.remove();
        }
    }

    private Set getSearchableObjects() {
        Object object;
        Object object2;
        int n;
        HashSet<Object> hashSet = new HashSet<Object>();
        int n2 = n = this.isRootSuffix() ? 0 : 1;
        while (n2 < navigationMenuSettings.length) {
            object2 = navigationMenuSettings[n2];
            if (this.toIncludeSetting((Setting)object2)) {
                object = this.getUserSettings((Setting)object2);
                if (object == null || object.isEmpty()) {
                    object = this.getValidDisplayOptions((Setting)object2).values();
                }
                if (object != null) {
                    hashSet.addAll((Collection<Object>)object);
                }
            }
            ++n2;
        }
        object2 = mapSettingToAction.keySet().iterator();
        while (object2.hasNext()) {
            Setting setting;
            object = (String)object2.next();
            if (!hashSet.contains(object) || !this.canPerform(setting = (Setting)mapSettingToAction.get(object), "viewproperties")) continue;
            hashSet.add(object);
        }
        return this.mapSearchableOptionToAMobjectType(hashSet);
    }

    private boolean toIncludeSetting(Setting setting) {
        String string = setting.getName();
        boolean bl = true;
        if (string.equals("organizationalunitnavmenu")) {
            bl = this.showOrgUnits();
        } else if (string.equals("groupcontainernavmenu")) {
            bl = this.showGroupContainers();
        } else if (string.equals("peoplecontainernavmenu")) {
            bl = this.showPeopleContainers();
        }
        return bl;
    }

    private Set mapSearchableOptionToAMobjectType(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)mapSettingToAMObjectType.get(string);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public String getNoPermissionToSearchMessage() {
        return this.getLocalizedString("noPermissionToDoQuickSearch.message");
    }

    public boolean hasPermissionToViewProfile(String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 2: {
                    bl = this.canPerform(Setting.ACTION_ORGANIZATION, "viewproperties");
                    break;
                }
                case 3: {
                    bl = this.canPerform(Setting.ACTION_ORGANIZATIONAL_UNIT, "viewproperties");
                    break;
                }
                case 4: {
                    bl = this.canPerform(Setting.ACTION_GROUP_CONTAINER, "viewproperties");
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    bl = this.canPerform(Setting.ACTION_GROUP, "viewproperties");
                    break;
                }
                case 6: 
                case 8: {
                    bl = this.canPerform(Setting.ACTION_ROLE, "viewproperties");
                    break;
                }
                case 5: {
                    bl = this.canPerform(Setting.ACTION_PEOPLE_CONTAINER, "viewproperties");
                    break;
                }
                case 1: {
                    bl = this.canPerform(Setting.ACTION_USER, "viewproperties");
                    break;
                }
                default: {
                    AMModelBase.debug.error("AMQuickSearchModelImpl.hasPermissionToViewProfile: unsupported type - " + string);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("AMQuickSearchModelImpl.hasPermissionToViewProfile", (Throwable)numberFormatException);
        }
        return bl;
    }

    public String getSearchErrorMessage() {
        return this.searchErrorMsg;
    }

    static {
        mapSettingToAMObjectType.put("organizations", Integer.toString(2));
        mapSettingToAMObjectType.put("organizationalunits", Integer.toString(3));
        mapSettingToAMObjectType.put("groupcontainers", Integer.toString(4));
        mapSettingToAMObjectType.put("peoplecontainers", Integer.toString(5));
        mapSettingToAMObjectType.put("groups", Integer.toString(9));
        mapSettingToAMObjectType.put("users", Integer.toString(1));
        mapSettingToAMObjectType.put("roles", Integer.toString(6));
        mapSettingToAction.put("organizations", Setting.ACTION_ORGANIZATION);
        mapSettingToAction.put("organizationalunits", Setting.ACTION_ORGANIZATIONAL_UNIT);
        mapSettingToAction.put("groupcontainers", Setting.ACTION_GROUP_CONTAINER);
        mapSettingToAction.put("peoplecontainers", Setting.ACTION_PEOPLE_CONTAINER);
        mapSettingToAction.put("groups", Setting.ACTION_GROUP);
        mapSettingToAction.put("users", Setting.ACTION_USER);
        mapSettingToAction.put("roles", Setting.ACTION_ROLE);
    }
}

