/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AMOrgCustomDirCacher
implements AMAdminConstants {
    private static AMOrgCustomDirCacher instance = new AMOrgCustomDirCacher();
    private HashMap mapOrgDir = new HashMap(20);
    private Debug debug = Debug.getInstance((String)"amConsole");

    private AMOrgCustomDirCacher() {
    }

    public static AMOrgCustomDirCacher getInstance() {
        return instance;
    }

    public String getCustomDirName(HttpServletRequest httpServletRequest) throws AMConsoleException {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        SSOToken sSOToken = null;
        try {
            object = SSOTokenManager.getInstance();
            sSOToken = object.createSSOToken(httpServletRequest);
            string2 = sSOToken.getProperty("Organization");
            string3 = sSOToken.getProperty("iplanet-am-admin-console-custom-jsp-dir");
        }
        catch (SSOException sSOException) {
            if (this.debug.warningEnabled()) {
                this.debug.warning("AMOrgCustomDirCacher.getCustomDirName Organization DN not found in SSOToken");
            }
            throw new AMConsoleException(sSOException);
        }
        if (string3 == null || string3.length() < 1) {
            string = (String)this.mapOrgDir.get(string2);
            if (string == null && (string = this.getDirNameFromSvcSchema(sSOToken, string2)) != null) {
                object = this.mapOrgDir;
                synchronized (object) {
                    this.mapOrgDir.put(string2, string);
                }
                try {
                    sSOToken.setProperty("iplanet-am-admin-console-custom-jsp-dir", string);
                }
                catch (SSOException sSOException) {
                    throw new AMConsoleException(sSOException);
                }
            }
        } else {
            string = string3;
        }
        return string;
    }

    private String getDirNameFromSvcSchema(SSOToken sSOToken, String string) {
        Set set;
        AMTemplate aMTemplate;
        AMOrganization aMOrganization;
        AMStoreConnection aMStoreConnection;
        String string2 = null;
        try {
            aMStoreConnection = new AMStoreConnection(sSOToken);
            aMOrganization = aMStoreConnection.getOrganization(string);
            if (aMOrganization.orgTemplateExists("iPlanetAMAdminConsoleService") && (aMTemplate = aMOrganization.getTemplate("iPlanetAMAdminConsoleService", 302)) != null && (set = aMTemplate.getAttribute("iplanet-am-admin-console-custom-jsp-dir")) != null && !set.isEmpty()) {
                string2 = (String)set.iterator().next();
            }
        }
        catch (AMException aMException) {
            this.debug.error("AMOrgCustomDirCacher.getDirNameFromSvcSchema", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            this.debug.warning("AMOrgCustomDirCacher.getDirNameFromSvcSchema", (Throwable)sSOException);
        }
        try {
            if (string2 == null && (set = (aMTemplate = (aMOrganization = (aMStoreConnection = new ServiceSchemaManager("iPlanetAMAdminConsoleService", sSOToken)).getSchema(SchemaType.ORGANIZATION)).getAttributeSchema("iplanet-am-admin-console-custom-jsp-dir")).getDefaultValues()) != null && !set.isEmpty()) {
                string2 = (String)set.iterator().next();
            }
        }
        catch (SMSException sMSException) {
            this.debug.error("AMOrgCustomDirCacher.getDirNameFromSvcSchema", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            this.debug.warning("AMOrgCustomDirCacher.getDirNameFromSvcSchema", (Throwable)sSOException);
        }
        return string2;
    }

    public void clear() {
        HashMap hashMap = this.mapOrgDir;
        synchronized (hashMap) {
            this.mapOrgDir.clear();
        }
    }

    public void flushEntry(String string) {
        if (this.mapOrgDir.containsKey(string)) {
            HashMap hashMap = this.mapOrgDir;
            synchronized (hashMap) {
                this.mapOrgDir.remove(string);
            }
        }
    }
}

