/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.StringConstants;
import com.iplanet.am.console.base.model.AMAdminLog;
import com.iplanet.am.console.base.model.AMAdminTypes;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMAuthUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMConsoleListenerManager;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMI18NUtils;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.base.model.AMQueryParameters;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.settings.UserSettings;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.FileLookup;
import com.iplanet.am.util.FileLookupException;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.Constants;
import com.sun.identity.common.L10NMessage;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.security.EncryptAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class AMModelBase
implements AMModel,
AMQueryParameters,
StringConstants,
Constants {
    public static Debug debug = Debug.getInstance((String)"amConsole");
    protected AMAdminLog logger = null;
    protected ResourceBundle resBundle = null;
    protected SSOToken ssoToken = null;
    protected String userDN = null;
    protected AMUser dpUser = null;
    protected AMStoreConnection dpStoreConn = null;
    protected String locationDN = null;
    protected String profileDN = null;
    protected String startDN = null;
    protected int locationType = -1;
    protected Map mapUserInfo = null;
    private static Random random = new Random();
    private String modifiedMsg = null;
    private Locale locale = null;
    private String rbName = "amAdminModuleMsgs";
    private int userType = -1;
    private Map mapSvcSchemaMgrs = new HashMap(10);
    private boolean peopleContainerDisplay = false;
    private boolean groupContainerDisplay = false;
    private boolean orgUnitDisplay = false;
    private boolean adminGroupsEnabled = false;
    private boolean userMgtEnabled = false;
    private int groupConfiguration = 10;
    private boolean displayOptionsGlobalFlag = false;
    private static AMConsoleListenerManager listenerManager = AMConsoleListenerManager.getInstance();
    public static String ONLINE_HELP = File.separator + "online_help";
    private static final String DOC_DIR = SystemProperties.get((String)"com.iplanet.am.installdir") + File.separator + "public_html" + ONLINE_HELP;
    private static final String HELP_DOC_PROPERTY = "helptoc.doc";
    private static final String ONLINE_HELP_SERVER = "onlinehelp.server";
    private static final String ONLINE_HELP_DOC = "onlinehelp.doc";
    public static final String DOC_SUB_DIR = "docs";
    private Map entityTypes = null;
    private ServiceSchemaManager entrySpecificSvcMgr = null;
    protected static boolean isConsoleRemote;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMUserProfileViewBean;

    protected static void addMandatoryListener(String string) {
        listenerManager.addMandatoryListener(string);
    }

    public AMModelBase(HttpServletRequest httpServletRequest) {
        this.initialize(httpServletRequest, null);
    }

    public AMModelBase(HttpServletRequest httpServletRequest, String string) {
        this.initialize(httpServletRequest, string);
    }

    public AMModelBase(HttpServletRequest httpServletRequest, String string, Map map) {
        this.mapUserInfo = map;
        this.appendQueryParamToMap(httpServletRequest);
        this.initialize(httpServletRequest, string);
    }

    public AMModelBase(HttpServletRequest httpServletRequest, Map map) {
        this.mapUserInfo = map;
        this.appendQueryParamToMap(httpServletRequest);
        this.initialize(httpServletRequest, null);
    }

    private void appendQueryParamToMap(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("Location");
        if (string != null && string.length() > 0) {
            this.mapUserInfo.put("com-iplanet-am-console-location-dn", string);
        }
    }

    protected Set getAvailableServices(AMRole aMRole) throws AMException, SMSException, SSOException {
        String string;
        HashSet<String> hashSet = Collections.EMPTY_SET;
        String string2 = aMRole.getOrganizationDN();
        if (string2.equalsIgnoreCase(string = AMSystemConfig.rootSuffix) || AMAdminUtils.getParent(string2).equalsIgnoreCase(string) && !string.equalsIgnoreCase(AMSystemConfig.defaultOrg)) {
            Set set = this.dpStoreConn.getServiceNames();
            set.remove("DAI");
            set.remove("iPlanetAMPolicyService");
            set.remove("iPlanetAMEntrySpecificService");
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!this.hasOtherSvcsThanGlobal(aMRole, string3)) continue;
                hashSet.add(string3);
            }
        } else {
            hashSet = this.getServiceList(AMAdminUtils.getParent(aMRole.getOrganizationDN()));
        }
        return hashSet;
    }

    private boolean hasOtherSvcsThanGlobal(AMRole aMRole, String string) throws AMException, SMSException, SSOException {
        boolean bl = false;
        ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
        Set set = serviceSchemaManager.getSchemaTypes();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            SchemaType schemaType = (SchemaType)iterator.next();
            if (schemaType.equals((Object)SchemaType.DYNAMIC) || schemaType.equals((Object)SchemaType.POLICY) || schemaType.equals((Object)SchemaType.USER)) {
                bl = true;
            }
            if (aMRole.getRoleType() == 3 || !schemaType.equals((Object)SchemaType.ORGANIZATION)) continue;
            bl = true;
        }
        return bl;
    }

    protected Set getServiceList(String string) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMModelBase.getServiceList() using dn = " + string);
        }
        Set set = Collections.EMPTY_SET;
        int n = this.getObjectType(string);
        AMStoreConnection aMStoreConnection = null;
        if (this.userType == 3) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException securityException) {
                        debug.error("AMModelBase.getServiceList", (Throwable)securityException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        set = n == 2 ? aMStoreConnection.getOrganization(string).getRegisteredServiceNames() : (n == 3 ? aMStoreConnection.getOrganizationalUnit(string).getRegisteredServiceNames() : this.getServiceList(AMAdminUtils.getParent(string)));
        return set;
    }

    public int getObjectType(String string) throws AMException, SSOException {
        Set set;
        AMStoreConnection aMStoreConnection = null;
        if (this.userType != 1) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException securityException) {
                        debug.error("AMModelBase.getObjectType", (Throwable)securityException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        if (DN.isDN((String)string)) {
            return aMStoreConnection.getAMObjectType(string);
        }
        if (this.locationDN != null && DN.isDN((String)this.locationDN) && (set = this.getServiceList(this.locationDN)).contains(string)) {
            return 15;
        }
        throw new AMException("AMModelBase.Invalid object type", "0");
    }

    private String getUserDisplayAttribute() {
        Object object;
        debug.message("begin getUserDisplayAttribute()");
        String string = null;
        AMTemplate aMTemplate = this.getOrgTemplate();
        try {
            if (aMTemplate != null && aMTemplate.isExists()) {
                object = aMTemplate.getAttribute("iplanet-am-admin-console-user-search-key");
                if (object != null && !object.isEmpty()) {
                    string = (String)object.iterator().next();
                }
            } else {
                object = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                string = AMAdminUtils.getStringAttribute((ServiceSchemaManager)object, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-search-key");
            }
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getUserDisplayAttribute", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getUserDisplayAttribute", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.warning("AMModelBase.getUserDisplayAttribute", (Throwable)sMSException);
        }
        if (string == null || string.length() == 0) {
            debug.error("couldn't get the attr from the schema or template");
            string = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)debug);
        }
        try {
            ResourceBundle resourceBundle;
            object = this.getServiceSchemaManager("iPlanetAMUserService");
            String string2 = AMAdminUtils.geti18nKey((ServiceSchemaManager)object, SchemaType.USER, string);
            if (string2 != null && string2.length() > 0 && (resourceBundle = AMResBundleCacher.getBundle("amUser", this.locale)) != null) {
                return com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)debug);
            }
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getUserDisplayAttribute", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.warning("AMModelBase.getUserDisplayAttribute", (Throwable)sMSException);
        }
        return string;
    }

    private AMObject getAMObjectAsTopLevelAdmin(String string) throws AMException, SSOException {
        AMObject aMObject = null;
        AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (SecurityException securityException) {
                    debug.error("AMModelBase.getAMObjectAsTopLevelAdmin", (Throwable)securityException);
                    return null;
                }
            }
        });
        if (aMStoreConnection != null) {
            aMObject = AMAdminUtils.getAMObject(this, string, aMStoreConnection);
        }
        return aMObject;
    }

    protected AMObject getAMObject(String string) throws AMException, SSOException {
        return AMAdminUtils.getAMObject(this, string, this.dpStoreConn);
    }

    public void writeProfile(AMObject aMObject, Map map) throws AMConsoleException, SSOException {
        this.writeProfile(aMObject, map, false);
    }

    public void writeProfile(AMObject aMObject, Map map, boolean bl) throws AMConsoleException, SSOException {
        Object object;
        ArrayList<String> arrayList;
        block14: {
            if (debug.messageEnabled()) {
                debug.message("AMModelBase.writeProfile : " + aMObject.getDN());
                debug.message("data passed in " + map.keySet());
            }
            arrayList = new ArrayList<String>(map.size());
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (((String)object).startsWith("iPlanetEncryptedPassword")) {
                    object = ((String)object).substring("iPlanetEncryptedPassword".length());
                } else if (((String)object).startsWith("iPlanetPlainTextPassword")) {
                    object = ((String)object).substring("iPlanetPlainTextPassword".length());
                }
                hashSet.add(object);
            }
            object = null;
            try {
                object = aMObject.getAttributes(hashSet);
            }
            catch (AMException aMException) {
                if (!debug.warningEnabled()) break block14;
                debug.warning("AMAdminUtils.getAttrValues, ", (Throwable)aMException);
            }
        }
        if (object == null) {
            object = Collections.EMPTY_MAP;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            Set set = (Set)map.get(string2);
            boolean bl2 = false;
            boolean bl3 = false;
            if (string2.startsWith("iPlanetEncryptedPassword")) {
                bl2 = true;
                string2 = string2.substring("iPlanetEncryptedPassword".length());
            } else if (string2.startsWith("iPlanetPlainTextPassword")) {
                bl3 = true;
                string2 = string2.substring("iPlanetPlainTextPassword".length());
            }
            Set set2 = (Set)object.get(string2);
            if (set2.isEmpty() && set.isEmpty() || !bl && set.equals(set2)) continue;
            if (debug.messageEnabled()) {
                debug.message("setting new value for " + string2);
            }
            if ((string = this.writeAttrValues(aMObject, string2, set, set2, bl2, bl3)) == null || string.length() <= 0) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            throw new AMConsoleException(arrayList);
        }
    }

    private String writeAttrValues(AMObject aMObject, String string, Set set, Set set2, boolean bl, boolean bl2) throws SSOException {
        String string2 = null;
        if (bl) {
            set = this.encryptString(set);
        }
        try {
            HashMap<String, Set> hashMap = new HashMap<String, Set>(1);
            hashMap.put(string, set);
            aMObject.setAttributes(hashMap);
            aMObject.store();
            if (this.logger.isEnabled()) {
                if (this.modifiedMsg == null || this.modifiedMsg.length() == 0) {
                    this.modifiedMsg = "objectAttribute.changed";
                }
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(string);
                if (!bl && !bl2) {
                    stringBuffer.append(" " + set2 + "->" + set);
                }
                this.writeFormatLog(this.modifiedMsg, stringBuffer.toString(), aMObject.getDN());
            }
        }
        catch (AMException aMException) {
            if (debug.warningEnabled()) {
                debug.warning("error setting attribute " + string, (Throwable)aMException);
            }
            string2 = string + "-" + this.getErrorString((Exception)((Object)aMException));
        }
        return string2;
    }

    protected Set getUserManagementSchemaTypes(String string) {
        Set set = Collections.EMPTY_SET;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            set = AMAdminUtils.getUserManagementSchemaTypes(serviceSchemaManager, this.locationType);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getUserManagementSchemaTypes", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.warning("AMModelBase.getUserManagementSchemaTypes", (Throwable)sMSException);
        }
        return set;
    }

    protected Set getDeniedServices() {
        Set set = Collections.EMPTY_SET;
        AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
        try {
            set = aMServiceDisplayModelImpl.getDeniedServices(this.dpUser);
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getDeniedServices", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getDeniedServices", (Throwable)sSOException);
        }
        return set;
    }

    public boolean isServiceDenied(String string) {
        return this.getDeniedServices().contains(string);
    }

    protected Map getCustomSvcViewBeans() {
        HashMap<String, String> hashMap = null;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema("iplanet-am-console-service-view-bean");
            Set set = attributeSchema.getDefaultValues();
            if (set != null && !set.isEmpty()) {
                hashMap = new HashMap(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    int n = (string = string.trim()).indexOf(124);
                    if (n == -1 || n >= string.length() - 1) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    hashMap.put(string2, string3);
                }
            }
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getCustomSvcViewBeans", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.error("AMModelBase.getCustomSvcViewBeans", (Throwable)sMSException);
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        return hashMap;
    }

    public boolean isRoleType(String string) {
        boolean bl = false;
        if (string == null) {
            string = this.startDN;
        }
        try {
            int n = this.getObjectType(string);
            bl = n == 6 || n == 8;
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.isRoleType", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.isRoleType", (Throwable)sSOException);
        }
        return bl;
    }

    protected ServiceSchemaManager getServiceSchemaManager(String string, SSOToken sSOToken) throws SSOException, SMSException {
        ServiceSchemaManager serviceSchemaManager = (ServiceSchemaManager)this.mapSvcSchemaMgrs.get(string);
        if (serviceSchemaManager == null) {
            serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            this.mapSvcSchemaMgrs.put(string, serviceSchemaManager);
        }
        return serviceSchemaManager;
    }

    protected ServiceSchemaManager getServiceSchemaManager(String string) throws SSOException, SMSException {
        return this.getServiceSchemaManager(string, this.ssoToken);
    }

    protected AMTemplate getOrgTemplate() {
        try {
            String string = this.getOrganizationDN(this.locationDN);
            return this.getOrgTemplate(string);
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getOrgTemplate", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getOrgTemplate", (Throwable)sSOException);
        }
        return null;
    }

    protected AMTemplate getOrgTemplate(String string) {
        AMTemplate aMTemplate = null;
        try {
            int n = this.getObjectType(string);
            if (n == 2) {
                aMTemplate = this.getOrgTemplate(this.dpStoreConn.getOrganization(string));
            } else if (n == 3) {
                aMTemplate = this.getOrgTemplate(this.dpStoreConn.getOrganizationalUnit(string));
            }
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getOrgTemplate", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getOrgTemplate", (Throwable)sSOException);
        }
        return aMTemplate;
    }

    protected AMTemplate getOrgTemplate(AMObject aMObject) {
        AMTemplate aMTemplate = null;
        if (aMObject instanceof AMOrganization) {
            aMTemplate = this.getOrgTemplate((AMOrganization)aMObject);
        } else if (aMObject instanceof AMOrganizationalUnit) {
            aMTemplate = this.getOrgTemplate((AMOrganizationalUnit)aMObject);
        } else if (debug.warningEnabled()) {
            debug.warning("AMModelBase.getOrgTemplate, invalid object type " + aMObject.getDN());
        }
        return aMTemplate;
    }

    protected AMTemplate getOrgTemplate(AMOrganization aMOrganization) {
        AMTemplate aMTemplate = null;
        if (aMOrganization != null) {
            try {
                if (aMOrganization.orgTemplateExists("iPlanetAMAdminConsoleService")) {
                    aMTemplate = aMOrganization.getTemplate("iPlanetAMAdminConsoleService", 302);
                }
            }
            catch (AMException aMException) {
                debug.warning("AMModelBase.getOrgTemplate", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                debug.warning("AMModelBase.getOrgTemplate", (Throwable)sSOException);
            }
        }
        return aMTemplate;
    }

    protected AMTemplate getOrgTemplate(AMOrganizationalUnit aMOrganizationalUnit) {
        AMTemplate aMTemplate = null;
        if (aMOrganizationalUnit != null) {
            try {
                if (aMOrganizationalUnit.orgTemplateExists("iPlanetAMAdminConsoleService")) {
                    aMTemplate = aMOrganizationalUnit.getTemplate("iPlanetAMAdminConsoleService", 302);
                }
            }
            catch (AMException aMException) {
                debug.warning("AMModelBase.getOrgTemplate", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                debug.warning("AMModelBase.getOrgTemplate", (Throwable)sSOException);
            }
        }
        return aMTemplate;
    }

    protected AMTemplate getServiceTemplate(String string, SchemaType schemaType) throws AMException, SSOException {
        AMTemplate aMTemplate = null;
        switch (this.locationType) {
            case 2: {
                aMTemplate = this.getServiceTemplateInOrg(string, this.locationDN, schemaType);
                break;
            }
            case 3: {
                aMTemplate = this.getServiceTemplateInOrgUnit(string, this.locationDN, schemaType);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                AMRole aMRole = this.dpStoreConn.getRole(this.locationDN);
                aMTemplate = aMRole.getTemplate(string, 301);
            }
        }
        return aMTemplate;
    }

    private AMTemplate getServiceTemplateInOrg(String string, String string2, SchemaType schemaType) throws AMException, SSOException {
        AMTemplate aMTemplate = null;
        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
        if (schemaType.equals((Object)SchemaType.ORGANIZATION)) {
            if (aMOrganization.orgTemplateExists(string)) {
                aMTemplate = aMOrganization.getTemplate(string, 302);
            }
        } else {
            aMTemplate = aMOrganization.getTemplate(string, 301);
        }
        return aMTemplate;
    }

    private AMTemplate getServiceTemplateInOrgUnit(String string, String string2, SchemaType schemaType) throws AMException, SSOException {
        AMTemplate aMTemplate = null;
        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
        if (schemaType.equals((Object)SchemaType.ORGANIZATION)) {
            if (aMOrganizationalUnit.orgTemplateExists(string)) {
                aMTemplate = aMOrganizationalUnit.getTemplate(string, 302);
            }
        } else {
            aMTemplate = aMOrganizationalUnit.getTemplate(string, 301);
        }
        return aMTemplate;
    }

    private String getUserProfileViewBeanClassName(AMUser aMUser) {
        String string = null;
        try {
            String string2 = aMUser.getOrganizationDN();
            AMTemplate aMTemplate = this.getOrgTemplate(string2);
            if (aMTemplate != null) {
                debug.message("getting display class from template");
                string = this.isAdministrator() ? AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-profile-class") : AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-enduser-profile-class");
            } else {
                debug.message("getting display class from schema");
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string = this.isAdministrator() ? AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-profile-class") : AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-enduser-profile-class");
                }
            }
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getUserProfileViewBeanClassName", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getUserProfileViewBeanClassName", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.error("AMModelBase.getUserProfileViewBeanClassName", (Throwable)sMSException);
        }
        return string;
    }

    public Class getUserProfileViewBeanClass(String string) {
        debug.message("AMModelBase.getUserProfileViewBeanClass");
        Class clazz = null;
        String string2 = null;
        try {
            AMUser aMUser = this.dpUser;
            if (string != null && string.length() > 0) {
                aMUser = this.dpStoreConn.getUser(string);
            }
            if (aMUser != null) {
                string2 = this.getUserProfileViewBeanClassName(aMUser);
            }
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getUserProfileViewBeanClass", (Throwable)sSOException);
        }
        if (string2 == null || string2.length() == 0) {
            debug.warning("missing class name; use UMUserProfileViewBean");
            clazz = class$com$iplanet$am$console$user$UMUserProfileViewBean == null ? (class$com$iplanet$am$console$user$UMUserProfileViewBean = AMModelBase.class$("com.iplanet.am.console.user.UMUserProfileViewBean")) : class$com$iplanet$am$console$user$UMUserProfileViewBean;
        } else {
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                debug.error("couldn't get view bean", (Throwable)classNotFoundException);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("return class = " + clazz.toString());
        }
        return clazz;
    }

    protected void setSearchControlLimits(AMObject aMObject, AMSearchControl aMSearchControl) {
        int n = this.getGlobalSearchLimit();
        int n2 = this.getGlobalTimeout();
        AMTemplate aMTemplate = this.getOrgTemplate(aMObject);
        if (aMTemplate != null) {
            int n3 = this.getLimitValue(aMTemplate, "iplanet-am-admin-console-search-limit", n);
            int n4 = this.getLimitValue(aMTemplate, "iplanet-am-admin-console-search-timeout", n2);
            aMSearchControl.setMaxResults(n3);
            aMSearchControl.setTimeOut(n4);
        } else {
            aMSearchControl.setMaxResults(n);
            aMSearchControl.setTimeOut(n2);
        }
    }

    protected int getGlobalSearchLimit() {
        int n;
        block5: {
            n = 100;
            try {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                n = AMAdminUtils.getIntegerAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-search-limit");
                if (n < 0) {
                    n = 100;
                }
            }
            catch (SSOException sSOException) {
                if (debug.warningEnabled()) {
                    debug.warning("AMModelBase.getGlobalSearchLimit", (Throwable)sSOException);
                }
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("AMModelBase.getGlobalSearchLimit", (Throwable)sMSException);
            }
        }
        return n;
    }

    private int getGlobalTimeout() {
        int n;
        block5: {
            n = 5;
            try {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                n = AMAdminUtils.getIntegerAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-search-timeout");
                if (n < 0) {
                    n = 5;
                }
            }
            catch (SSOException sSOException) {
                if (debug.warningEnabled()) {
                    debug.warning("AMModelBase.getGlobalTimeout", (Throwable)sSOException);
                }
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("AMModelBase.getGlobalTimeout", (Throwable)sMSException);
            }
        }
        return n;
    }

    public int getPageSize() {
        return this.getLimitValue(this.getOrgTemplate(), "iplanet-am-admin-console-paging-size", this.getGlobalPageSize());
    }

    public int getGlobalPageSize() {
        int n = 25;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            n = AMAdminUtils.getIntegerAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-paging-size");
            if (n <= 0) {
                n = 25;
            }
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getGlobalPageSize", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.warning("AMModelBase.getGlobalPageSize", (Throwable)sMSException);
        }
        catch (NumberFormatException numberFormatException) {
            debug.warning("AMModelBase.getGlobalPageSize", (Throwable)numberFormatException);
        }
        return n;
    }

    public int getSearchLimit() {
        return this.getLimitValue(this.getOrgTemplate(), "iplanet-am-admin-console-search-limit", this.getGlobalSearchLimit());
    }

    private int getLimitValue(AMTemplate aMTemplate, String string, int n) {
        int n2;
        block7: {
            n2 = n;
            try {
                if (aMTemplate != null && (n2 = AMAdminUtils.getIntegerAttribute(aMTemplate, string)) < 0) {
                    n2 = n;
                }
            }
            catch (SSOException sSOException) {
                if (debug.warningEnabled()) {
                    debug.warning("AMModelBase.getLimitValue", (Throwable)sSOException);
                }
            }
            catch (AMException aMException) {
                if (debug.warningEnabled()) {
                    debug.warning("AMModelBase.getLimitValue", (Throwable)aMException);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("AMModelBase.getLimitValue", (Throwable)numberFormatException);
            }
        }
        return n2;
    }

    public String DNToName(String string) {
        return this.DNToName(string, false);
    }

    public String DNToName(String string, boolean bl) {
        return AMFormatUtils.DNToName(this, string, bl);
    }

    public List pathToDisplayString() {
        return this.pathToDisplayString(this.locationDN);
    }

    public List pathToDisplayString(String string) {
        return AMFormatUtils.pathToDisplayString(this, string);
    }

    public String getDisplayName(String string, boolean bl) {
        return AMFormatUtils.getDisplayName(this, string, bl);
    }

    public String getLocalizedStringForLocType(int n) {
        return AMI18NUtils.getLocalizedStringForLocType(this, n);
    }

    public String getLocalizedServiceName(String string) {
        String string2;
        block10: {
            string2 = string;
            try {
                String string3 = this.dpStoreConn.getI18NPropertiesFileName(string);
                if (string3 == null) {
                    string3 = "amAdminModuleMsgs";
                }
                ResourceBundle resourceBundle = AMResBundleCacher.getBundle(string3, this.locale);
                String string4 = this.getServiceNameI18nKey(string);
                if (string4 != null && string4.length() > 0) {
                    string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string4, (Debug)debug);
                }
            }
            catch (AMException aMException) {
                if (debug.warningEnabled()) {
                    debug.warning("using " + string + " for string, " + aMException.getMessage());
                }
            }
            catch (SSOException sSOException) {
                if (debug.warningEnabled()) {
                    debug.warning("using " + string + " for string, " + sSOException.getMessage());
                }
            }
            catch (SMSException sMSException) {
                if (debug.warningEnabled()) {
                    debug.warning("using " + string + " for string, " + sMSException.getMessage());
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (!debug.warningEnabled()) break block10;
                debug.warning("no ResourceBundle found for " + string);
            }
        }
        return string2;
    }

    protected String getServiceNameI18nKey(String string) throws SSOException, SMSException {
        String string2 = null;
        ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
        Set set = serviceSchemaManager.getSchemaTypes();
        if (!set.isEmpty()) {
            SchemaType schemaType = (SchemaType)set.iterator().next();
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
            if (serviceSchema != null) {
                string2 = serviceSchema.getI18NKey();
            } else if (debug.warningEnabled()) {
                debug.warning("AMModelBase.getServiceNameI18nKeythere is no subSchema defined for " + string);
            }
        }
        return string2;
    }

    protected String getL10NServiceName(String string) {
        return this.getLocalizedServiceName(string);
    }

    protected String getL10NAttributeName(ServiceSchemaManager serviceSchemaManager, String string) {
        String string2 = string;
        try {
            String string3 = serviceSchemaManager.getI18NFileName();
            if (string3 != null) {
                ResourceBundle resourceBundle = AMResBundleCacher.getBundle(string3, this.locale);
                string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
            }
        }
        catch (MissingResourceException missingResourceException) {
            debug.warning("AMModelBase.getL10NAttributeName", (Throwable)missingResourceException);
        }
        return string2;
    }

    public String getL10NAttributeName(String string, String string2) {
        String string3 = string2;
        try {
            String string4 = this.dpStoreConn.getI18NPropertiesFileName(string);
            if (string4 != null) {
                ResourceBundle resourceBundle = AMResBundleCacher.getBundle(string4, this.locale);
                string3 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)debug);
            }
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getL10NAttributeName", (Throwable)aMException);
        }
        catch (MissingResourceException missingResourceException) {
            debug.warning("AMModelBase.getL10NAttributeName", (Throwable)missingResourceException);
        }
        return string3;
    }

    public String getL10NAttributeName(String string, SchemaType schemaType, String string2) {
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
            Set set = serviceSchema.getAttributeSchemas();
            if (set != null && !set.isEmpty()) {
                Object object;
                String string3 = null;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (AttributeSchema)iterator.next();
                    if (!object.getName().equals(string2)) continue;
                    string3 = object.getI18NKey();
                    break;
                }
                if (string3 != null && (object = this.dpStoreConn.getI18NPropertiesFileName(string)) != null) {
                    ResourceBundle resourceBundle = AMResBundleCacher.getBundle((String)object, this.locale);
                    string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string3, (Debug)debug);
                }
            }
        }
        catch (SMSException sMSException) {
            debug.warning("AMModelBase.getL10NAttributeName", (Throwable)sMSException);
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getL10NAttributeName", (Throwable)aMException);
        }
        catch (MissingResourceException missingResourceException) {
            debug.warning("AMModelBase.getL10NAttributeName", (Throwable)missingResourceException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getL10NAttributeName", (Throwable)sSOException);
        }
        return string2;
    }

    public String getLocalizedString(String string) {
        ResourceBundle resourceBundle;
        String string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)this.resBundle, (String)string, (Debug)debug);
        if (string2.equals(string) && !this.rbName.equals("amAdminModuleMsgs") && (resourceBundle = AMResBundleCacher.getBundle("amAdminModuleMsgs", this.locale)) != null) {
            string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
        }
        return string2;
    }

    public String getLocalizedString(String string, List arrayList) {
        String string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)this.resBundle, (String)string, (Debug)debug);
        if (string2.equals(string)) {
            if (arrayList == null || arrayList.isEmpty()) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add("amAdminModuleMsgs");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && string2.equals(string)) {
                String string3 = (String)iterator.next();
                ResourceBundle resourceBundle = AMResBundleCacher.getBundle(string3, this.locale);
                if (resourceBundle == null) continue;
                string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
            }
        }
        return string2;
    }

    public ResourceBundle getResourceBundle() {
        return this.resBundle;
    }

    public ResourceBundle getSchemaResourceBundle(String string) {
        ResourceBundle resourceBundle = AMAdminUtils.getSchemaResourceBundle(this.dpStoreConn, this.getUserLocale(), string);
        if (resourceBundle == null) {
            debug.warning("Falling back to console resource file");
            resourceBundle = this.resBundle;
        }
        return resourceBundle;
    }

    protected Set getDateInUserLocale(Set set) {
        if (set == null || set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.length() == 0) continue;
            Date date = com.iplanet.am.util.Locale.parseNormalizedDateString((String)string);
            String string2 = com.iplanet.am.util.Locale.getDateString((Date)date, (Locale)this.locale);
            if (string2 != null) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string);
            if (!debug.warningEnabled()) continue;
            debug.warning("invalid date format" + string);
        }
        return hashSet;
    }

    protected Set getDateInDefaultLocale(Set set) throws AMConsoleException {
        if (set == null || set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.length() <= 0) continue;
            Date date = com.iplanet.am.util.Locale.parseDateString((String)string, (Locale)this.locale);
            String string2 = com.iplanet.am.util.Locale.getNormalizedDateString((Date)date);
            if (string2 != null) {
                hashSet.add(string2);
                continue;
            }
            throw new AMConsoleException(this.getLocalizedString("invalidDateFormat.message"));
        }
        return hashSet;
    }

    public String getMenuEntryName(String string) {
        return AMI18NUtils.getMenuEntryName(this, string);
    }

    public String getHTMLPageTitle() {
        return this.getLocalizedString("console.title");
    }

    public String getOfLabel() {
        return this.getLocalizedString("of.label");
    }

    public String getPagingLabel() {
        return this.getLocalizedString("paging.label");
    }

    public String getLastPageLabel() {
        return this.getLocalizedString("gotoLastPage.label");
    }

    public String getNextPageLabel() {
        return this.getLocalizedString("gotoNextPage.label");
    }

    public String getPreviousPageLabel() {
        return this.getLocalizedString("gotoPreviousPage.label");
    }

    public String getFirstPageLabel() {
        return this.getLocalizedString("gotoFirstPage.label");
    }

    public String getPageLabel() {
        return this.getLocalizedString("page.label");
    }

    public String getGoBtnLabel() {
        return this.getLocalizedString("go.button");
    }

    private String getUserStartDN(String string) {
        String string2;
        block9: {
            string2 = this.getUserStartDNAsSuperAdmin(string);
            if (string2 == null || string2.length() == 0) {
                if (this.getUserType() == 3) {
                    debug.message("using userDN for startDN");
                    string2 = this.userDN;
                } else {
                    debug.message("getting start dn from containers");
                    Set set = this.getTopLevelContainers();
                    if (set == null || set.isEmpty()) {
                        debug.message("top level constainer is empty");
                        string2 = this.dpUser.getDN();
                    } else {
                        string2 = (String)set.iterator().next();
                    }
                }
            }
            if (string2 == null || string2.length() == 0) {
                debug.warning("startDN was not set, using rootsuffix");
                string2 = AMSystemConfig.rootSuffix;
            }
            if (debug.messageEnabled()) {
                debug.message("startDN is set to : " + string2);
            }
            try {
                this.ssoToken.setProperty("com-iplanet-am-console-user-start-dn", string2);
            }
            catch (SSOException sSOException) {
                if (!debug.warningEnabled()) break block9;
                debug.warning("AMModelBase.getUserStartDN: startDN is not stored is SSOToken", (Throwable)sSOException);
            }
        }
        return string2;
    }

    private String getUserStartDNAsSuperAdmin(String string) {
        String string2 = null;
        try {
            String string3 = AMSystemConfig.superAdminDN;
            if (string3 != null && string.equalsIgnoreCase(string3)) {
                debug.message("userDN is superAdminDN, start = rootSuffix");
                string2 = AMSystemConfig.rootSuffix;
            } else {
                debug.message("getting start-dn from user profile");
                string2 = this.dpUser.getStringAttribute("iplanet-am-user-admin-start-dn");
            }
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getUserStartDNAsSuperAdmin", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getUserStartDNAsSuperAdmin", (Throwable)sSOException);
        }
        return string2;
    }

    protected Set getTopLevelContainers() {
        Set set = null;
        try {
            set = this.dpStoreConn.getTopLevelContainers();
            if (debug.messageEnabled()) {
                debug.message("topLevelContainers = " + set);
            }
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getTopLevelContainers", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getTopLevelContainers", (Throwable)aMException);
        }
        return set;
    }

    public String getStartDN() {
        return this.startDN;
    }

    public String getUserOrganization() {
        return AMAdminUtils.getUserOrganization(this.dpUser);
    }

    public String getLoggedInUserDN() {
        return this.userDN;
    }

    protected void getUserInfo() {
        this.setUserLocale();
        this.resBundle = AMResBundleCacher.getBundle(this.rbName, this.locale);
        if (this.getAMStoreConnection()) {
            this.logger = new AMAdminLog(this.ssoToken);
            this.dpUser = this.getAMUserOfCurrentUser();
            if (this.dpUser != null) {
                this.setUserType();
                this.initLocationDN(this.mapUserInfo);
                this.getLocationType();
            }
        }
    }

    public int getUserType() {
        return this.userType;
    }

    private void setUserType() {
        try {
            this.userType = new AMAdminTypes(this.ssoToken).getUserType();
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getUserType, failed to get user's type");
        }
    }

    public Locale getUserLocale() {
        return this.locale;
    }

    private void setUserLocale() {
        try {
            String string = this.ssoToken.getProperty("Locale");
            if (debug.messageEnabled()) {
                debug.message("AMModelBase.getUserLocale locale string = " + string);
            }
            this.locale = com.iplanet.am.util.Locale.getLocale((String)string);
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getUserLocale, missing locale, setting to default");
            this.locale = Locale.getDefault();
        }
    }

    private boolean getAMStoreConnection() {
        boolean bl = false;
        try {
            if (this.dpStoreConn == null) {
                this.dpStoreConn = new AMStoreConnection(this.ssoToken);
            }
            bl = true;
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getAMStoreConnection", (Throwable)sSOException);
        }
        return bl;
    }

    private AMUser getAMUserOfCurrentUser() {
        AMUser aMUser = null;
        try {
            this.userDN = this.ssoToken.getPrincipal().getName();
            aMUser = this.dpStoreConn.getUser(this.userDN);
            if (aMUser != null && !aMUser.isExists()) {
                aMUser = null;
            }
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getAMUserOfCurrentUser", (Throwable)sSOException);
        }
        return aMUser;
    }

    public boolean isAdministrator() {
        return this.dpUser != null && this.getUserType() != 3;
    }

    public boolean isTopLevelAdministrator() {
        return this.dpUser != null && this.getUserType() == 1;
    }

    public String getAuthenticatedOrgDN() {
        return AMAuthUtils.getAuthenticatedOrgDN(this.ssoToken);
    }

    private void readConsoleProfile() {
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
            this.peopleContainerDisplay = this.isAttributeSet(serviceSchema, "iplanet-am-admin-console-pc-display");
            this.groupContainerDisplay = this.isAttributeSet(serviceSchema, "iplanet-am-admin-console-gc-display");
            this.adminGroupsEnabled = this.isAttributeSet(serviceSchema, "iplanet-am-admin-console-compliance-admin-groups");
            this.userMgtEnabled = this.isAttributeSet(serviceSchema, "iplanet-am-admin-console-um-enabled");
            if (!AMSystemConfig.iPlanetCompliantDIT) {
                this.orgUnitDisplay = this.isAttributeSet(serviceSchema, "iplanet-am-admin-console-ou-display");
                this.getGroupConfigurationType(serviceSchema);
            }
        }
        catch (SMSException sMSException) {
            debug.error("AMModelBase.readConsoleProfile", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.readConsoleProfile", (Throwable)sSOException);
        }
    }

    private void getGroupConfigurationType(ServiceSchema serviceSchema) {
        String string = this.getDefaultAttrValue(serviceSchema, "iplanet-am-admin-console-group-type");
        this.groupConfiguration = string.equalsIgnoreCase("dynamic") ? 12 : 10;
    }

    private boolean isAttributeSet(ServiceSchema serviceSchema, String string) {
        String string2 = this.getDefaultAttrValue(serviceSchema, string);
        return string2 != null && string2.equals("true");
    }

    private String getDefaultAttrValue(ServiceSchema serviceSchema, String string) {
        String string2 = null;
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        Set set = attributeSchema.getDefaultValues();
        if (set != null && !set.isEmpty()) {
            string2 = (String)set.iterator().next();
        }
        return string2;
    }

    public boolean isUserMgtEnabled() {
        return this.userMgtEnabled;
    }

    public boolean showGroupContainers() {
        return this.groupContainerDisplay;
    }

    public boolean showPeopleContainers() {
        return this.peopleContainerDisplay;
    }

    public boolean showOrgUnits() {
        return this.orgUnitDisplay;
    }

    public boolean isAdminGroupsEnabled() {
        return this.adminGroupsEnabled;
    }

    protected int getGroupConfiguration() {
        return this.groupConfiguration;
    }

    protected void writeFormatLog(String string, Object[] objectArray) {
        if (this.logger.isEnabled()) {
            this.logger.doLog(MessageFormat.format(this.getLocalizedString(string), objectArray));
        }
    }

    protected void setModifiedMessage(String string) {
        this.modifiedMsg = string;
    }

    protected void writeFormatLog(String string, String string2, String string3) {
        if (this.logger.isEnabled()) {
            Object[] objectArray = new String[]{string2, string3};
            this.writeFormatLog(string, objectArray);
        }
    }

    public void debugError(String string) {
        debug.error(string);
    }

    public void debugError(String string, Exception exception) {
        debug.error(string, (Throwable)exception);
    }

    public boolean warningEnabled() {
        return debug.warningEnabled();
    }

    public void debugWarning(String string) {
        debug.warning(string);
    }

    public void debugWarning(String string, Exception exception) {
        debug.warning(string, (Throwable)exception);
    }

    public boolean messageEnabled() {
        return debug.messageEnabled();
    }

    public void debugMessage(String string) {
        debug.message(string);
    }

    public void debugMessage(String string, Exception exception) {
        debug.message(string, (Throwable)exception);
    }

    public String getUncaughtExceptionMsg() {
        return this.getLocalizedString("uncaughtException.message");
    }

    public String getErrorString(Exception exception) {
        ResourceBundle resourceBundle = AMResBundleCacher.getBundle("amProfile", this.locale);
        String string = null;
        String string2 = null;
        if (exception instanceof AMException) {
            AMException aMException = (AMException)((Object)exception);
            string = aMException.getErrorCode();
            string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
            Object[] objectArray = aMException.getMessageArgs();
            string2 = this.formatErrorMessage(string2, objectArray);
        } else if (exception instanceof SMSException) {
            SMSException sMSException = (SMSException)((Object)exception);
            string = Integer.toString(sMSException.getExceptionCode());
            string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
            Object[] objectArray = sMSException.getMessageArgs();
            string2 = this.formatErrorMessage(string2, objectArray);
        } else {
            string2 = exception instanceof L10NMessage ? ((L10NMessage)exception).getL10NMessage(this.locale) : exception.getMessage();
        }
        return string2;
    }

    private String formatErrorMessage(String string, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                try {
                    String string2 = (String)objectArray[n2];
                    if (this.getObjectType(string2) == 15) {
                        objectArray[n2] = this.getLocalizedServiceName(string2);
                    }
                }
                catch (AMException aMException) {
                }
                catch (SSOException sSOException) {
                    // empty catch block
                }
                ++n2;
            }
            string = MessageFormat.format(string, objectArray);
        }
        return string;
    }

    private void initialize(HttpServletRequest httpServletRequest, String string) {
        block3: {
            try {
                if (string != null) {
                    this.rbName = string;
                }
                this.ssoToken = AMAuthUtils.checkAuthentication(httpServletRequest);
                this.getUserInfo();
                this.readConsoleProfile();
            }
            catch (SSOException sSOException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMModelBase.initialize: cannot retrieve SSO token", (Throwable)sSOException);
            }
        }
    }

    private void initLocationDN(Map map) {
        this.initStartDN();
        this.locationDN = null;
        if (map != null) {
            this.locationDN = (String)map.get("com-iplanet-am-console-location-dn");
        }
        if (this.locationDN == null || this.locationDN.length() == 0) {
            this.locationDN = this.startDN;
        }
    }

    private void initStartDN() {
        block3: {
            try {
                this.startDN = this.ssoToken.getProperty("com-iplanet-am-console-user-start-dn");
                if (this.startDN == null || this.startDN.length() == 0) {
                    this.startDN = this.getUserStartDN(this.userDN);
                }
            }
            catch (SSOException sSOException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMModelBase.initStartDN: unable to get user's start DN from SSO token", (Throwable)sSOException);
            }
        }
    }

    protected int getLocationType() {
        this.locationType = this.getLocationType(this.locationDN);
        return this.locationType;
    }

    public int getLocationType(String string) {
        int n = -1;
        try {
            n = this.getObjectType(string);
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getLocationType, invalid SSO token", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            debug.error("AMModelBase.getLocationType, couldn't get object type, " + this.locationDN, (Throwable)aMException);
        }
        return n;
    }

    protected boolean showUsers() {
        boolean bl = true;
        try {
            String string = this.ssoToken.getProperty("iplanet-am-admin-console-show-users");
            if (string != null) {
                bl = string.equals("1");
            }
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.showUsers ", (Throwable)sSOException);
        }
        return bl;
    }

    public void setLocationDN(String string) {
        try {
            this.locationDN = string;
            this.getLocationType();
            this.ssoToken.setProperty("com-iplanet-am-console-location-dn", string);
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.setLocationDN ", (Throwable)sSOException);
        }
    }

    public String getLocationDN() {
        return this.locationDN;
    }

    public String getProfileDN() {
        return this.profileDN != null ? this.profileDN : "";
    }

    public void setProfileDN(String string) {
        this.profileDN = string != null ? string : "";
    }

    public boolean isRootSuffix() {
        DN dN = new DN(this.locationDN);
        DN dN2 = new DN(AMSystemConfig.rootSuffix);
        return dN.equals(dN2);
    }

    public String getDeploymentURI() {
        return AMSystemConfig.deploymentURI;
    }

    public String getClientType() {
        return AMI18NUtils.getClientType(this.ssoToken);
    }

    public String getRandomString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        byte[] byArray = new byte[5];
        random.nextBytes(byArray);
        stringBuffer.append(System.currentTimeMillis());
        stringBuffer.append(Base64.encode((byte[])byArray));
        return stringBuffer.toString().replace('/', '.');
    }

    public boolean getAutoGenerateCN() {
        boolean bl = false;
        Set set = this.getUserSettings(Setting.GENERATE_USER_CN);
        if (set != null && !set.isEmpty()) {
            bl = ((String)set.iterator().next()).equals("true");
        }
        return bl;
    }

    public boolean isViewDisplayOff(String string) {
        boolean bl = false;
        Set set = this.getUserSettings(Setting.DISABLE_INITIAL_SEARCH_IN_NAV_VIEW);
        if (set != null && !set.isEmpty()) {
            bl = set.contains(string.toLowerCase());
        }
        return bl;
    }

    public boolean isAutoSelectEnable() {
        boolean bl = true;
        Set set = this.getUserSettings(Setting.AUTO_SELECT_NAVIGATION_ITEMS);
        if (set != null && !set.isEmpty()) {
            bl = ((String)set.iterator().next()).equals("true");
        }
        return bl;
    }

    public Set getUserSettings(Setting setting) {
        Set set = Collections.EMPTY_SET;
        UserSettings userSettings = UserSettings.getUserSettings(this.ssoToken, this.dpUser);
        if (userSettings != null) {
            set = userSettings.getSetting(setting, this.displayOptionsGlobalFlag, null);
        }
        return set;
    }

    public Set encryptString(Set set) {
        String string = "";
        if (!set.isEmpty()) {
            string = (String)set.iterator().next();
        }
        HashSet<String> hashSet = new HashSet<String>(2);
        hashSet.add((String)AccessController.doPrivileged(new EncryptAction(string)));
        return hashSet;
    }

    public boolean fireBeforeDisplayModuleTabEvent(String string) {
        return listenerManager.notifyOnBeforeDisplayModuleTab(this, string);
    }

    protected void fireBeforeCreateObjectEvent(int n, AMObject aMObject, String string, Map map) throws AMConsoleException {
        listenerManager.notifyOnBeforeCreateObject(this, n, aMObject, string, map);
    }

    protected void fireAfterCreateObjectEvent(AMObject aMObject) {
        listenerManager.notifyOnAfterCreateObject(this, aMObject);
    }

    protected Set fireBeforeDeleteObjectsEvent(int n, Set set) throws AMConsoleException {
        HashSet<String> hashSet = new HashSet<String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            listenerManager.notifyOnBeforeDeleteObject(this, n, string);
            hashSet.add(string);
        }
        return hashSet;
    }

    protected void fireAfterDeleteObjectsEvent(int n, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            listenerManager.notifyOnAfterDeleteObject(this, n, string);
        }
    }

    protected void fireBeforeUpdateValuesEvent(int n, AMObject aMObject, Map map) throws AMConsoleException {
        listenerManager.notifyOnBeforeUpdateValues(this, n, aMObject, map);
    }

    protected void fireAfterUpdateValuesEvent(int n, AMObject aMObject) {
        listenerManager.notifyOnAfterUpdateValues(this, n, aMObject);
    }

    public void fireBeforeUpdateDefaultServiceValues(String string, Map map) throws AMConsoleException {
        listenerManager.notifyOnBeforeUpdateDefaultServiceValues(this, string, map);
    }

    public void fireAfterUpdateDefaultServiceValues(String string) {
        listenerManager.notifyOnAfterUpdateDefaultServiceValues(this, string);
    }

    protected void fireRetrieveAttributeValuesEvent(AMObject aMObject, int n, int n2, String string, SchemaType schemaType, Map map) {
        listenerManager.notifyOnRetrieveAttributeValues(this, aMObject, n, n2, string, schemaType, map);
    }

    public boolean isLibertyEnabled() {
        return this.getUserType() == 1 && FSServiceUtils.isLibertyEnabled();
    }

    public String getHelpDocURL() {
        return this.getHelpDocURL(this.resBundle);
    }

    protected String getHelpDocURL(ResourceBundle resourceBundle) {
        String string = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)HELP_DOC_PROPERTY, (Debug)debug);
        if (string.equals(HELP_DOC_PROPERTY)) {
            string = "contents.html";
        }
        try {
            if (isConsoleRemote) {
                this.ssoToken.setProperty("consoleHelpDocURL", string);
            } else {
                String string2 = this.ssoToken.getProperty("consoleHelpDocURL");
                if (string2 != null && string2.length() > 0) {
                    this.ssoToken.setProperty("consoleHelpDocURL", "");
                }
            }
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getHelpDocURL", (Throwable)sSOException);
        }
        return string;
    }

    public String getHelpAnchorTag() {
        return this.getHelpAnchorTag(this.resBundle, null);
    }

    protected String getHelpAnchorTag(String string) {
        return this.getHelpAnchorTag(this.resBundle, string);
    }

    protected String getHelpAnchorTag(ResourceBundle resourceBundle, String string) {
        String string2;
        String string3 = null;
        if (string == null) {
            string = ONLINE_HELP_DOC;
        }
        if (resourceBundle != null) {
            String string4;
            string2 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)debug);
            if (string2.equals(string)) {
                string2 = "contents.html";
            }
            if ((string4 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)ONLINE_HELP_SERVER, (Debug)debug)).equals(ONLINE_HELP_SERVER)) {
                string4 = this.getOnlineHelpServerURL();
            }
            string3 = string4 != null && string4.length() > 0 ? this.lookupRemoteHelpFile(string4, string2) : this.getHelpURL(string2);
        } else {
            string3 = this.getHelpURL("contents.html");
        }
        try {
            if (isConsoleRemote) {
                this.ssoToken.setProperty("consoleHelpAnchorTag", string3);
            } else {
                string2 = this.ssoToken.getProperty("consoleHelpAnchorTag");
                if (string2 != null && string2.length() > 0) {
                    this.ssoToken.setProperty("consoleHelpAnchorTag", "");
                }
            }
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getHelpAnchorTag", (Throwable)sSOException);
        }
        return string3;
    }

    private String getOnlineHelpServerURL() {
        String string = null;
        Set set = this.getHelpAttrValues();
        String string2 = this.getHelpDocURL();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && (string == null || string.length() == 0)) {
            String string3 = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            int n = stringTokenizer.countTokens();
            if (n <= 3) continue;
            stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.lastIndexOf(File.separator);
            if (n2 != -1) {
                string4 = string4.substring(n2 + 1);
            }
            if (!string4.equals(string2)) continue;
            stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            string = string.trim();
        }
        return string;
    }

    protected Set getHelpAttrValues() {
        Set set = null;
        try {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.getAuthenticatedOrgDN());
            AMTemplate aMTemplate = this.getOrgTemplate(aMOrganization);
            set = aMTemplate != null && aMTemplate.isExists() ? aMTemplate.getAttribute("iplanet-am-admin-console-online-help") : this.getSchemaHelpValues();
        }
        catch (AMException aMException) {
            debug.warning("initHelpLinks:error reading template", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("initHelpLinks:error reading template", (Throwable)sSOException);
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    private Set getSchemaHelpValues() {
        Set set = Collections.EMPTY_SET;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema("iplanet-am-admin-console-online-help");
            if (attributeSchema != null) {
                set = attributeSchema.getDefaultValues();
            }
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelImpl.getSchemaHelpValues", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.warning("AMModelImpl.getSchemaHelpValues", (Throwable)sMSException);
        }
        return set;
    }

    private String lookupRemoteHelpFile(String string, String string2) {
        String string3;
        block3: {
            string3 = null;
            String string4 = ONLINE_HELP + File.separator + DOC_SUB_DIR;
            try {
                string3 = FileLookup.getFirstExistingRemote((String)string, (String)string4, (String)this.getUserLocale().toString(), (String)string2);
                if (string3 == null || string3.length() < 1) {
                    string3 = FileLookup.getFirstExistingRemote((String)string, (String)string4, (String)"en_US", (String)string2);
                }
            }
            catch (FileLookupException fileLookupException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMModelImpl.lookupRemoteHelpFile", (Throwable)fileLookupException);
            }
        }
        return string3 == null ? this.getHelpURL(string2) : string3;
    }

    public String getHelpURL(String string) {
        return this.getHelpURL(string, this.resBundle);
    }

    protected String getHelpURL(String string, ResourceBundle resourceBundle) {
        String string2 = this.getUserLocale().toString();
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        String string3 = null;
        if (resourceBundle != null && ((string3 = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)ONLINE_HELP_SERVER, (Debug)debug)) == null || string3.length() == 0 || string3.equals(ONLINE_HELP_SERVER))) {
            string3 = this.getOnlineHelpServerURL();
        }
        String string4 = null;
        if (string3 != null && string3.length() > 0) {
            string4 = this.getHelpURLRemote(string3, string, string2);
            if (string4 == null) {
                string4 = this.getHelpURLRemote(string3, string, "en_US");
            }
        } else {
            string4 = this.getHelpURL(string, string2);
            if (string4 == null) {
                string4 = this.getHelpURL(string, "en_US");
            }
        }
        if (string4 == null) {
            string4 = this.getHelpURL("contents.html", "en_US");
        }
        return string4;
    }

    private String getHelpURLRemote(String string, String string2, String string3) {
        int n = string2.indexOf("#");
        String string4 = null;
        if (n != -1) {
            string4 = string2.substring(n);
            string2 = string2.substring(0, n);
        }
        String string5 = null;
        String string6 = ONLINE_HELP + File.separator + DOC_SUB_DIR;
        try {
            string5 = FileLookup.getFirstExistingRemote((String)string, (String)string6, (String)string3, (String)string2);
        }
        catch (FileLookupException fileLookupException) {
            debug.error("AMModelBase.getHelpURLRemote", (Throwable)fileLookupException);
        }
        if (string5 != null && string4 != null) {
            string5 = string5 + string4;
        }
        return string5;
    }

    public String getHelpURL(String string, String string2) {
        int n = string.indexOf("#");
        String string3 = null;
        if (n != -1) {
            string3 = string.substring(n);
            string = string.substring(0, n);
        }
        String string4 = null;
        try {
            File file = FileLookup.getFirstExisting((String)DOC_SUB_DIR, (String)string2, null, null, (String)string, (String)DOC_DIR, (boolean)false);
            if (file != null) {
                string4 = ONLINE_HELP + file.getPath().substring(DOC_DIR.length());
                string4 = string4.replace(File.separator.charAt(0), '/');
                if (debug.messageEnabled()) {
                    debug.message("help url = " + string4);
                }
            }
        }
        catch (FileLookupException fileLookupException) {
            debug.error("AMModelBase.getHelpURL", (Throwable)fileLookupException);
        }
        if (string4 != null && string3 != null) {
            string4 = string4 + string3;
        }
        return string4;
    }

    public String getSubViewTrackingAttributeName() {
        return this.getSubViewTrackingAttributeName(this.locationDN);
    }

    public String getSubViewTrackingAttributeName(String string) {
        String string2 = null;
        try {
            int n = this.getObjectType(string);
            switch (n) {
                case 2: {
                    string2 = "IS-IdentityOrgSubView";
                    break;
                }
                case 3: {
                    string2 = "IS-IdentityOrgUnitSubView";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string2 = "IS-IdentityRoleSubView";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string2 = "IS-IdentityGroupSubView";
                    break;
                }
                case 1: {
                    string2 = "IS-IdentityUserSubView";
                }
            }
        }
        catch (AMException aMException) {
            debug.error("AMModelBase.getSubViewTrackingAttributeName", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.error("AMModelBase.getSubViewTrackingAttributeName", (Throwable)sSOException);
        }
        return string2;
    }

    public String getInformationTitle() {
        return this.getLocalizedString("informationMessage.title");
    }

    public String getWarningTitle() {
        return this.getLocalizedString("warningMessage.title");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public String getPermissionDeniedTitle() {
        return this.getLocalizedString("permissionDenied.title");
    }

    public void setDisplayOptionsGlobalFlag(boolean bl) {
        this.displayOptionsGlobalFlag = bl;
    }

    public String getInvalidProfileObjectMessage() {
        return this.getLocalizedString("invalidProfile.message");
    }

    public String getInvalidGroupMessage() {
        return this.getLocalizedString("invalidGroupProfile.message");
    }

    public String getInvalidRoleMessage() {
        return this.getLocalizedString("invalidRoleProfile.message");
    }

    protected AMTemplate getServiceOrgTemplate(String string, String string2) {
        return this.getServiceTemplate(string, string2, 302);
    }

    protected AMTemplate getServiceTemplate(String string, String string2, int n) {
        AMTemplate aMTemplate = null;
        try {
            int n2 = this.getObjectType(string);
            switch (n2) {
                case 2: {
                    AMOrganization aMOrganization = (AMOrganization)this.getAMObjectAsTopLevelAdmin(string);
                    if (aMOrganization == null || n == 302 && !aMOrganization.orgTemplateExists(string2)) break;
                    aMTemplate = aMOrganization.getTemplate(string2, n);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = (AMOrganizationalUnit)this.getAMObjectAsTopLevelAdmin(string);
                    if (aMOrganizationalUnit == null || n == 302 && !aMOrganizationalUnit.orgTemplateExists(string2)) break;
                    aMTemplate = aMOrganizationalUnit.getTemplate(string2, n);
                }
            }
            if (aMTemplate != null && !aMTemplate.isExists()) {
                aMTemplate = null;
            }
        }
        catch (AMException aMException) {
            debug.error("couldn't get " + string2 + " template for " + string, (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.error("couldn't get " + string2 + " template for " + string, (Throwable)sSOException);
        }
        return aMTemplate;
    }

    protected Set getAttrValues(String string, String string2) {
        return this.getAttrValues(string, string2, this.locationDN);
    }

    protected Set getAttrValues(String string, String string2, String string3) {
        return this.getAttrValues(string, string2, string3, 302);
    }

    protected Set getAttrValues(String string, String string2, String string3, int n) {
        Set set = Collections.EMPTY_SET;
        try {
            String string4 = this.getOrganizationDN(string3);
            AMTemplate aMTemplate = this.getServiceTemplate(string4, string2, n);
            if (aMTemplate != null && aMTemplate.isExists()) {
                set = aMTemplate.getAttribute(string);
            } else {
                AttributeSchema attributeSchema;
                SchemaType schemaType = SchemaType.ORGANIZATION;
                if (n == 300) {
                    schemaType = SchemaType.POLICY;
                } else if (n == 301) {
                    schemaType = SchemaType.DYNAMIC;
                }
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string2);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
                if (serviceSchema != null && (attributeSchema = serviceSchema.getAttributeSchema(string)) != null) {
                    set = attributeSchema.getDefaultValues();
                }
            }
        }
        catch (SSOException sSOException) {
            if (debug.warningEnabled()) {
                debug.warning("AMModelBase.getAttrValues: attrName=" + string + ", serviceName=" + string2, (Throwable)sSOException);
            }
        }
        catch (AMException aMException) {
            debug.error("AMModelBase.getAttrValues: attrName=" + string + ", serviceName=" + string2, (Throwable)aMException);
        }
        catch (SMSException sMSException) {
            debug.error("AMModelBase.getAttrValues: attrName=" + string + ", serviceName=" + string2, (Throwable)sMSException);
        }
        return set;
    }

    public boolean canPerform(Setting setting, String string) {
        return this.canPerform(setting, string, null);
    }

    public String getAttrNameWidth() {
        return this.getLocalizedString("defaultAttrNameWidth");
    }

    protected Set getUserAttributeNames() {
        Object object;
        HashSet<String> hashSet = Collections.EMPTY_SET;
        Set set = null;
        ServiceSchema serviceSchema = null;
        try {
            object = this.getServiceSchemaManager("iPlanetAMUserService");
            if (object != null) {
                serviceSchema = object.getSchema(SchemaType.USER);
                set = serviceSchema.getAttributeSchemaNames();
            }
        }
        catch (SSOException sSOException) {
            debug.warning("UMUserNavModelImpl.getUserAttributeNames", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.warning("UMUserNavModelImpl.getUserAttributeNames", (Throwable)sMSException);
        }
        if (set != null && !set.isEmpty()) {
            hashSet = new HashSet<String>(set.size() * 2);
            object = set.iterator();
            while (object.hasNext()) {
                String string;
                String string2 = (String)object.next();
                AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
                if (attributeSchema == null || (string = attributeSchema.getI18NKey()) == null || string.length() <= 0) continue;
                hashSet.add(string2.toLowerCase());
            }
        }
        return hashSet;
    }

    private String getOrganizationDN(String string) throws AMException, SSOException {
        String string2 = null;
        AMObject aMObject = this.getAMObject(string);
        if (aMObject != null) {
            string2 = aMObject.getOrganizationDN();
        } else {
            AMEntity aMEntity = this.dpStoreConn.getEntity(string);
            if (aMEntity != null) {
                string2 = aMEntity.getOrganizationDN();
            }
        }
        return string2 != null ? string2 : "";
    }

    public boolean isEntityObject(String string) {
        String string2 = this.getEntityObjectName(string);
        return !string2.equalsIgnoreCase("user") && string2.length() > 0;
    }

    protected String getEntityObjectName(String string) {
        String string2 = "";
        AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (SecurityException securityException) {
                    debug.error("AMModelBase.isEntityObject", (Throwable)securityException);
                    return null;
                }
            }
        });
        try {
            string2 = aMStoreConnection.getAMObjectName(aMStoreConnection.getAMObjectType(string));
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getEntityObjectName", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getEntityObjectName", (Throwable)sSOException);
        }
        return string2;
    }

    public SSOToken getUserSSOToken() {
        return this.ssoToken;
    }

    public String getTableHeader(String string, int n) {
        String string2 = this.getLocalizedString("items.label");
        if (n == 1) {
            string2 = this.getLocalizedString("item.label");
        }
        Object[] objectArray = new String[]{string, n + "", string2};
        return MessageFormat.format(this.getLocalizedString("tableHeader.label"), objectArray);
    }

    public String getTrueLabel() {
        return this.getLocalizedString("true.label");
    }

    public String getFalseLabel() {
        return this.getLocalizedString("false.label");
    }

    protected Map getValidDisplayOptions(Setting setting) {
        String[] stringArray = setting.getValidValues();
        HashMap<String, String> hashMap = Collections.EMPTY_MAP;
        if (stringArray != null) {
            hashMap = new HashMap<String, String>(stringArray.length * 2);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (this.isMenuOptionAllowed(setting, string)) {
                    if (string.equals("[user_service_attribute_name]")) {
                        this.getUserServiceAttributeNames(hashMap);
                    } else if (string.equals("[user_assignable_services]")) {
                        this.getUserAssignableServices(hashMap);
                    } else if (string.equals("optionentities")) {
                        Set set = this.getEntityTypesMap().keySet();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            String string3 = this.getLocalizedEntityName(string2);
                            hashMap.put(string3, string2);
                        }
                    } else {
                        hashMap.put(Setting.getLocalizedOptionName(string, this), string.toLowerCase());
                    }
                }
                ++n;
            }
        }
        return hashMap;
    }

    private boolean isMenuOptionAllowed(Setting setting, String string) {
        boolean bl = true;
        if (string.equals("organizationalunits")) {
            bl = this.showOrgUnits();
        } else if (string.equals("peoplecontainers")) {
            bl = this.showPeopleContainers();
        } else if (string.equals("groupcontainers")) {
            bl = this.showGroupContainers();
        } else if (string.equals("policyadministrator")) {
            boolean bl2 = bl = !this.isUserMgtEnabled();
        }
        if (bl && (setting == Setting.ROOT_NAVIGATION_MENU || setting == Setting.ORGANIZATION_NAVIGATION_MENU || setting == Setting.ORGANIZATIONAL_UNIT_NAVIGATION_MENU)) {
            if (string.equals("users")) {
                bl = !this.showPeopleContainers();
            } else if (string.equals("groups")) {
                bl = !this.showGroupContainers();
            }
        }
        return bl;
    }

    private void getUserServiceAttributeNames(Map map) {
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMUserService");
            ResourceBundle resourceBundle = this.getSchemaResourceBundle("iPlanetAMUserService");
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
            Set set = serviceSchema.getAttributeSchemaNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
                String string2 = attributeSchema.getI18NKey();
                if (string2 == null || string2.length() <= 0) continue;
                map.put(com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)debug), string);
            }
        }
        catch (SMSException sMSException) {
            debug.error("AMModelBase.getUserServiceAttributeNames", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getUserServiceAttributeNames", (Throwable)sSOException);
        }
    }

    private void getUserAssignableServices(Map map) {
        try {
            Set set = this.dpStoreConn.getServiceNames();
            if (set != null && set.contains("iPlanetAMUserService")) {
                map.put(this.getLocalizedString("showUserProfile.label"), "iPlanetAMUserService".toLowerCase());
            }
        }
        catch (AMException aMException) {
            debug.error("UMDisplayOptionsModelImpl.getUserassignableServices", (Throwable)aMException);
        }
    }

    public String getLocalizedEntityName(String string) {
        Map map = this.getEntityTypesMap();
        AMEntityType aMEntityType = (AMEntityType)map.get(string);
        return this.getL10NServiceName(aMEntityType.getServiceName());
    }

    protected Set getEntityTypes() {
        Map map = this.getEntityTypesMap();
        return map.keySet();
    }

    public Map getEntityTypesMap() {
        if (this.entityTypes == null) {
            Set set = this.dpStoreConn.getEntityTypes();
            if (set != null && !set.isEmpty()) {
                this.entityTypes = new HashMap(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    AMEntityType aMEntityType = (AMEntityType)iterator.next();
                    String string = aMEntityType.getServiceName();
                    if (string == null || string.equals("iPlanetAMUserService")) continue;
                    this.entityTypes.put("amentity_" + aMEntityType.getName(), aMEntityType);
                }
            } else {
                this.entityTypes = Collections.EMPTY_MAP;
            }
        }
        return this.entityTypes;
    }

    public String getRequiredAltTag() {
        return this.getLocalizedString("requiredTag.label");
    }

    public boolean canPerform(Setting setting, String string, String string2) {
        boolean bl = true;
        UserSettings userSettings = UserSettings.getUserSettings(this.ssoToken, this.dpUser);
        if (userSettings != null) {
            bl = userSettings.canPerform(setting, string, string2);
        }
        return bl;
    }

    protected Set getAttributesToDisplay(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) {
        TreeSet<AttributeSchema> treeSet = Collections.EMPTY_SET;
        ServiceSchema serviceSchema = null;
        try {
            serviceSchema = serviceSchemaManager.getSchema(schemaType);
        }
        catch (SMSException sMSException) {
            debug.warning("error getting schema", (Throwable)sMSException);
        }
        if (serviceSchema == null) {
            return treeSet;
        }
        ServiceSchema serviceSchema2 = null;
        try {
            serviceSchema2 = serviceSchema.getSubSchema(string);
        }
        catch (SMSException sMSException) {
            debug.warning("error getting subschema", (Throwable)sMSException);
        }
        if (serviceSchema2 == null) {
            return treeSet;
        }
        Set set = serviceSchema2.getAttributeSchemaNames();
        if (set != null) {
            Collator collator = Collator.getInstance(this.getUserLocale());
            treeSet = new TreeSet<AttributeSchema>(new AMAttrSchemaComparator(collator));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                AttributeSchema attributeSchema = serviceSchema2.getAttributeSchema(string2);
                if (!this.isDisplayed(attributeSchema)) continue;
                treeSet.add(attributeSchema);
            }
        }
        return treeSet;
    }

    protected ServiceSchemaManager getEntrySpecificSvcSchemaMgr() {
        if (this.entrySpecificSvcMgr == null) {
            try {
                this.entrySpecificSvcMgr = this.getServiceSchemaManager("iPlanetAMEntrySpecificService");
            }
            catch (SSOException sSOException) {
                debug.warning("UMProfileModelImpl.getEntrySpecificSvcSchemaMgr", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                debug.warning("UMProfileModelImpl.getEntrySpecificSvcSchemaMgr", (Throwable)sMSException);
            }
        }
        return this.entrySpecificSvcMgr;
    }

    protected boolean isDisplayed(AttributeSchema attributeSchema) {
        boolean bl = true;
        if (attributeSchema == null || attributeSchema.getI18NKey() == null || attributeSchema.getI18NKey().length() == 0) {
            bl = false;
        }
        return bl;
    }

    protected String getSearchReturnAttribute(String string) {
        String string2 = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate(string);
            if (aMTemplate != null) {
                string2 = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-return-attribute");
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string2 = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-return-attribute");
                }
            }
        }
        catch (SMSException sMSException) {
            debug.warning("AMModelBase.getSearchReturnAttribute", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMModelBase.getSearchReturnAttribute", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getSearchReturnAttribute", (Throwable)aMException);
        }
        return string2;
    }

    private List getReturnAttrList(String string) {
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            arrayList = new ArrayList<String>(n);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected List getObjectDisplayList(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        List list = Collections.EMPTY_LIST;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("=");
            if (n != -1) {
                String string4 = string3.substring(0, n).trim();
                if (!string4.equals(string2)) continue;
                string3 = string3.substring(n + 1, string3.length());
                list = this.getReturnAttrList(string3);
                break;
            }
            if (n != -1 || !string2.equals("users")) continue;
            list = this.getReturnAttrList(string3);
            break;
        }
        return list;
    }

    public String getNoPrivilegeMessage() {
        return this.getLocalizedString("noPrivilege.title");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AMModelBase.addMandatoryListener("com.iplanet.am.console.base.model.AMAdminMenuListener");
        isConsoleRemote = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.console.remote"));
    }
}

