/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMMenuValidator;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.settings.Setting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AMMenuValidatorImpl
implements AMMenuValidator,
AMAdminConstants {
    private static AMMenuValidatorImpl validator = new AMMenuValidatorImpl();
    private static List displayOptionKeys = new ArrayList(13);
    private static Set displayOrganizationProfileOptionValues = new HashSet();
    private static Set displayGroupProfileOptionValues = new HashSet();
    private static Set displayRoleProfileOptionValues = new HashSet();
    private static Set displayPolicyProfileOptionValues = new HashSet();
    private static Set displayFederationNavOptionValues = new HashSet();
    private static Set displayEntityDescriptorProfileOptionValues = new HashSet();

    private AMMenuValidatorImpl() {
    }

    public static AMMenuValidator getInstance() {
        return validator;
    }

    public void validateRootSuffixMenuOptions(List list, AMModelBase aMModelBase) {
        this.removeHiddenMenus(Setting.ROOT_NAVIGATION_MENU, list, aMModelBase);
    }

    public void validateNavigationalMenuOptions(List list, int n, AMModelBase aMModelBase) {
        if (n > 1 && n < displayOptionKeys.size()) {
            Setting setting = (Setting)displayOptionKeys.get(n);
            if (setting != null) {
                this.removeHiddenMenus(setting, list, aMModelBase);
            }
        } else if (aMModelBase.warningEnabled()) {
            aMModelBase.debugWarning("AMMenuValidator.validateMenuOptions: invalid locationType, " + n);
        }
    }

    public void validateFederationNavigationalMenuOptions(List list, AMModelBase aMModelBase) {
        Set set = aMModelBase.getUserSettings(Setting.FEDERATION_NAVIGATION_MENU);
        if (set != null) {
            if (!set.isEmpty()) {
                Object object;
                HashSet<Object> hashSet = new HashSet<Object>(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (displayFederationNavOptionValues.contains(object = ((String)object).toLowerCase())) {
                        hashSet.add(object);
                        continue;
                    }
                    if (!aMModelBase.warningEnabled()) continue;
                    aMModelBase.debugWarning("AMMenuValidatorImpl.validateFederationNavigationalMenuOptions: invalid type " + (String)object);
                }
                object = list.iterator();
                while (object.hasNext()) {
                    if (hashSet.contains(object.next())) continue;
                    object.remove();
                }
            } else {
                list.clear();
            }
        }
    }

    public Set getUserProfileMenuOptions(AMModelBase aMModelBase) {
        HashSet<String> hashSet = null;
        Set set = aMModelBase.getUserSettings(Setting.USER_PROFILE_MENU);
        if (set != null) {
            if (!set.isEmpty()) {
                hashSet = new HashSet<String>(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    string = string.toLowerCase();
                    hashSet.add(string);
                }
            } else {
                hashSet = Collections.EMPTY_SET;
            }
        }
        return hashSet;
    }

    public Set getOrganizationProfileMenuOptions(AMModelBase aMModelBase) {
        HashSet<String> hashSet = null;
        Set set = aMModelBase.getUserSettings(Setting.ORGANIZATION_PROFILE_MENU);
        if (set != null) {
            if (!set.isEmpty()) {
                hashSet = new HashSet<String>(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (displayOrganizationProfileOptionValues.contains(string = string.toLowerCase())) {
                        hashSet.add(string);
                        continue;
                    }
                    aMModelBase.debugWarning("AMMenuValidatorImpl.getOrganizationProfileMenuOptions: invalid option " + string);
                }
            } else {
                hashSet = Collections.EMPTY_SET;
            }
        }
        return hashSet;
    }

    public Set getOrganizationalUnitProfileMenuOptions(AMModelBase aMModelBase) {
        HashSet<String> hashSet = null;
        Set set = aMModelBase.getUserSettings(Setting.ORGANIZATIONAL_UNIT_PROFILE_MENU);
        if (set != null) {
            if (!set.isEmpty()) {
                hashSet = new HashSet<String>(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (displayOrganizationProfileOptionValues.contains(string = string.toLowerCase())) {
                        hashSet.add(string);
                        continue;
                    }
                    aMModelBase.debugWarning("AMMenuValidatorImpl.getOrganizationProfileMenuOptions: invalid option " + string);
                }
            } else {
                hashSet = Collections.EMPTY_SET;
            }
        }
        return hashSet;
    }

    public Set getGroupProfileMenuOptions(AMModelBase aMModelBase) {
        HashSet<String> hashSet = null;
        Set set = aMModelBase.getUserSettings(Setting.GROUP_PROFILE_MENU);
        if (set != null) {
            if (!set.isEmpty()) {
                hashSet = new HashSet<String>(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (displayGroupProfileOptionValues.contains(string = string.toLowerCase())) {
                        hashSet.add(string);
                        continue;
                    }
                    if (!aMModelBase.warningEnabled()) continue;
                    aMModelBase.debugWarning("AMMenuValidatorImpl.getGroupProfileMenuOptions: invalid option " + string);
                }
            } else {
                hashSet = Collections.EMPTY_SET;
            }
        }
        return hashSet;
    }

    public Set getRoleProfileMenuOptions(AMModelBase aMModelBase) {
        HashSet<String> hashSet = null;
        Set set = aMModelBase.getUserSettings(Setting.ROLE_PROFILE_MENU);
        if (set != null) {
            if (!set.isEmpty()) {
                hashSet = new HashSet<String>(set.size() * 2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (displayRoleProfileOptionValues.contains(string = string.toLowerCase())) {
                        hashSet.add(string);
                        continue;
                    }
                    if (!aMModelBase.warningEnabled()) continue;
                    aMModelBase.debugWarning("AMMenuValidatorImpl.getRoleProfileMenuOptions: invalid option " + string);
                }
            } else {
                hashSet = Collections.EMPTY_SET;
            }
        }
        return hashSet;
    }

    public Set getPolicyProfileMenuOptions(AMModelBase aMModelBase) {
        Set set = null;
        Set set2 = aMModelBase.getUserSettings(Setting.POLICY_PROFILE_MENU);
        if (set2 != null) {
            set = !set2.isEmpty() ? this.getMatchingEntries(set2, displayPolicyProfileOptionValues, aMModelBase) : Collections.EMPTY_SET;
        }
        return set;
    }

    public Set getEntityDescriptorProfileMenuOptions(AMModelBase aMModelBase) {
        Set set = null;
        Set set2 = aMModelBase.getUserSettings(Setting.ENTITY_DESCRIPTOR_PROFILE_MENU);
        if (set2 != null) {
            set = !set2.isEmpty() ? this.getMatchingEntries(set2, displayEntityDescriptorProfileOptionValues, aMModelBase) : Collections.EMPTY_SET;
        }
        return set;
    }

    private Set getMatchingEntries(Set set, Set set2, AMModelBase aMModelBase) {
        HashSet<String> hashSet = new HashSet<String>(set.size() * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            string.toLowerCase();
            if (set2.contains(string)) {
                hashSet.add(string);
                continue;
            }
            if (!aMModelBase.warningEnabled()) continue;
            aMModelBase.debugWarning("AMMenuValidatorImpl.getMatchingEntries: invalid option " + string);
        }
        return hashSet;
    }

    private void removeHiddenMenus(Setting setting, List list, AMModelBase aMModelBase) {
        Set set = aMModelBase.getUserSettings(setting);
        if (set != null) {
            if (!set.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (set.contains(iterator.next())) continue;
                    iterator.remove();
                }
            } else {
                list.clear();
            }
        }
    }

    static {
        displayOptionKeys.add(Setting.ROOT_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.ROOT_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.ORGANIZATION_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.ORGANIZATIONAL_UNIT_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.GROUP_CONTAINER_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.PEOPLE_CONTAINER_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.ROLE_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.ROLE_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.ROLE_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.GROUP_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.GROUP_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.GROUP_NAVIGATION_MENU);
        displayOptionKeys.add(Setting.GROUP_NAVIGATION_MENU);
        displayOrganizationProfileOptionValues.add("general");
        displayOrganizationProfileOptionValues.add("displayoptions");
        displayOrganizationProfileOptionValues.add("permissions");
        displayGroupProfileOptionValues.add("general");
        displayGroupProfileOptionValues.add("members");
        displayRoleProfileOptionValues.add("general");
        displayRoleProfileOptionValues.add("users");
        displayRoleProfileOptionValues.add("services");
        displayRoleProfileOptionValues.add("displayoptions");
        displayRoleProfileOptionValues.add("permissions");
        displayPolicyProfileOptionValues.add("general");
        displayPolicyProfileOptionValues.add("rules");
        displayPolicyProfileOptionValues.add("subjects");
        displayPolicyProfileOptionValues.add("referrals");
        displayPolicyProfileOptionValues.add("conditions");
        displayFederationNavOptionValues.add("authenticationdomains");
        displayFederationNavOptionValues.add("entities");
        displayEntityDescriptorProfileOptionValues.add("general");
        displayEntityDescriptorProfileOptionValues.add("affiliates");
        displayEntityDescriptorProfileOptionValues.add("identityprovider");
        displayEntityDescriptorProfileOptionValues.add("serviceprovider");
    }
}

