/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMHelpMastheadModel;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.FileLookup;
import com.iplanet.am.util.FileLookupException;
import com.iplanet.am.util.Locale;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class AMHelpMastheadModelImpl
extends AMModelBase
implements AMHelpMastheadModel {
    private Object[] helpLinks = null;
    private boolean refreshSession = false;

    public AMHelpMastheadModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.initHelpLinks();
    }

    public String getPageTitle() {
        return this.getLocalizedString("onlineHelp.title");
    }

    public int getNumberOfDocuments() {
        if (this.helpLinks != null) {
            return this.helpLinks.length;
        }
        return 0;
    }

    public String getHelpLabel(int n) {
        String string;
        AMModelBase.debug.message("AMHelpMastheadModelImpl.getHelpLabel");
        if (n >= 0 && n < this.helpLinks.length && (string = (String)this.helpLinks[n]) != null && string.length() != 0) {
            String string2 = "";
            String string3 = "amAdminModuleMsgs";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            int n2 = stringTokenizer.countTokens();
            if (n2 > 0 && (string2 = stringTokenizer.nextToken().trim()).length() == 0) {
                AMModelBase.debug.message("no help label found, returning");
                return string2;
            }
            if (n2 > 2) {
                stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken().trim();
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("using " + string3 + " for bundle ");
            }
            ResourceBundle resourceBundle = null;
            if (string3.length() != 0 && (resourceBundle = AMResBundleCacher.getBundle(string3, this.getUserLocale())) == null) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("couldn't retrieve bundle for " + string3);
                }
                resourceBundle = this.resBundle;
            }
            return Locale.getString((ResourceBundle)resourceBundle, (String)string2.replace(' ', '_'), (Debug)AMModelBase.debug);
        }
        AMModelBase.debug.warning("AMHelpMastheadModelImpl:getHelpLabel no help label.");
        return "";
    }

    public String getHelpURL(int n) {
        StringTokenizer stringTokenizer;
        int n2;
        String string;
        StringBuffer stringBuffer = new StringBuffer(32);
        if (n >= 0 && n < this.helpLinks.length && (string = (String)this.helpLinks[n]) != null && string.length() != 0 && (n2 = (stringTokenizer = new StringTokenizer(string, "|")).countTokens()) > 1) {
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken().trim();
            if (n2 == 4) {
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3 != null && string3.length() != 0) {
                    try {
                        String string4 = FileLookup.getFirstExistingRemote((String)string3, (String)(AMModelBase.ONLINE_HELP + File.separator + "docs"), (String)this.getUserLocale().toString(), (String)string2);
                        if (string4 == null || string4.length() < 1) {
                            string4 = FileLookup.getFirstExistingRemote((String)string3, (String)(AMModelBase.ONLINE_HELP + File.separator + "docs"), (String)"en_US", (String)string2);
                        }
                        stringBuffer.append(string4);
                    }
                    catch (FileLookupException fileLookupException) {
                        AMModelBase.debug.error("AMMastheadModelImpl:filelookup failed", (Throwable)fileLookupException);
                    }
                }
            }
            if (stringBuffer.length() == 0 && string2 != null && string2.length() != 0) {
                stringBuffer.append(this.getHelpURL(string2));
            }
        }
        if (stringBuffer.length() == 0) {
            AMModelBase.debug.warning("AMHelpMastheadModelImpl:getHelpURL no help URL.");
        } else if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("AMMastheadModelImpl:document = " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String getNoHelpTitle() {
        return this.getLocalizedString("noOnlineHelp.title");
    }

    public String getNoHelpMessage() {
        return this.getLocalizedString("noOnlineHelp.message");
    }

    public String getVersionLabel() {
        return this.getLocalizedString("version.label");
    }

    public String getVersionFile() {
        return this.getHelpURL(this.getLocalizedString("versionFileName"));
    }

    private void initHelpLinks() {
        TreeSet treeSet = Collections.EMPTY_SET;
        try {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.getAuthenticatedOrgDN());
            AMTemplate aMTemplate = this.getOrgTemplate(aMOrganization);
            treeSet = aMTemplate != null ? new TreeSet(aMTemplate.getAttribute("iplanet-am-admin-console-online-help")) : new TreeSet(this.getSchemaHelpValues());
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("initHelpLinks:error reading template", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("initHelpLinks:error reading template", (Throwable)sSOException);
        }
        this.helpLinks = treeSet.toArray();
    }

    private Set getSchemaHelpValues() {
        Set set = Collections.EMPTY_SET;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema("iplanet-am-admin-console-online-help");
            if (attributeSchema != null) {
                set = attributeSchema.getDefaultValues();
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMHelpMastheadModelImpl.getSchemaHelpValues", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("AMHelpMastheadModelImpl.getSchemaHelpValues", (Throwable)sMSException);
        }
        return set;
    }

    private void refreshSession() {
        if (!this.refreshSession) {
            this.refreshSession = true;
            try {
                SessionID sessionID = new SessionID(this.ssoToken.getTokenID().toString());
                Session session = Session.getSession((SessionID)sessionID);
                session.refresh(false);
            }
            catch (SessionException sessionException) {
                AMModelBase.debug.error("AMHelpMastheadModelImpl.refreshSession", (Throwable)sessionException);
            }
        }
    }

    public String getSelectedTocURL() {
        String string = null;
        this.refreshSession();
        try {
            string = this.ssoToken.getProperty("consoleHelpDocURL");
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("AMHelpMastheadModelImpl.getSelectedURL", (Throwable)sSOException);
        }
        return string;
    }

    public String getSelectedURL() {
        String string = null;
        this.refreshSession();
        try {
            string = this.ssoToken.getProperty("consoleHelpAnchorTag");
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("AMHelpMastheadModelImpl.getSelectedURL", (Throwable)sSOException);
        }
        return string;
    }

    public String getHelpDocURL() {
        return "";
    }

    public String getHelpAnchorTag() {
        return "";
    }

    public String getTableOfContentsURL() {
        return this.getHelpURL(this.getLocalizedString("generic.help"));
    }
}

